/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.ksfl;

import com.kreative.dff.DFFResource;
import com.kreative.ksfl.KSFLUtilities;
import com.kreative.prc.PalmResource;
import com.kreative.rsrc.MacResource;

public class KSFLConverter {
    private KSFLConverter() {
    }

    public static DFFResource makeDFFResourceFromMacResource(MacResource r) {
        if (r == null) {
            return null;
        }
        DFFResource d = new DFFResource(KSFLUtilities.eccAdaptMacResType(r.type), (int)r.id, r.name, r.data);
        d.compressed = r.compressed;
        d.fixed = r.locked;
        d.fromrsrc = true;
        d.preload = r.preload;
        d.protect = r.protect;
        d.purgeable = r.purgeable;
        d.readonly = r.protect;
        d.system = r.sysheap;
        return d;
    }

    public static DFFResource makeDFFResourceFromPalmResource(PalmResource r) {
        if (r == null) {
            return null;
        }
        DFFResource d = new DFFResource(KSFLUtilities.eccAdaptPalmResType(r.type), r.id, r.data);
        d.fromrsrc = true;
        return d;
    }

    public static MacResource makeMacResourceFromPalmResource(PalmResource r) {
        if (r == null) {
            return null;
        }
        return new MacResource(r.type, r.id, r.data);
    }

    public static PalmResource makePalmResourceFromMacResource(MacResource r) {
        if (r == null) {
            return null;
        }
        return new PalmResource(r.type, r.id, r.data);
    }

    public static PalmResource makePalmResourceFromDFFResource(DFFResource d) {
        if (d == null) {
            return null;
        }
        long tmp = d.type & 0xFFFFFFFF00000000L;
        int type = tmp == 5575846802751488000L || tmp == 5575847073334427648L || tmp == 5576391417489522688L || tmp == 5792029811182403584L || tmp == 5787762275842523136L || tmp == 5787762546425462784L || tmp == 5290998524366815232L || tmp == 4716786273342193664L || tmp == 6011852641187921920L || tmp == 6226618048418152448L || tmp == 5579808343146364928L ? (int)(d.type & 0xFFFFFFFFL) : ((tmp = d.type & 0xFFFFFFFFFF000000L) == 5290992233934225408L || tmp == 4716786588737077248L || tmp == 6012153144547475456L || tmp == 6226618346633166848L || tmp == 5579808658373476352L ? (int)(d.type & 0xFFFFFFL) << 8 | 0x20 : (int)(d.type >>> 32));
        short id = d.id > Short.MAX_VALUE ? (short)Short.MAX_VALUE : (d.id < Short.MIN_VALUE ? (short)Short.MIN_VALUE : (short)d.id);
        return new PalmResource(type, id, d.data);
    }

    public static MacResource makeMacResourceFromDFFResource(DFFResource d) {
        if (d == null) {
            return null;
        }
        long tmp = d.type & 0xFFFFFFFF00000000L;
        int type = tmp == 5575846802751488000L || tmp == 5575847073334427648L || tmp == 5576391417489522688L || tmp == 5792029811182403584L || tmp == 5787762275842523136L || tmp == 5787762546425462784L || tmp == 5290998524366815232L || tmp == 4716786273342193664L || tmp == 6011852641187921920L || tmp == 6226618048418152448L || tmp == 5579808343146364928L ? (int)(d.type & 0xFFFFFFFFL) : ((tmp = d.type & 0xFFFFFFFFFF000000L) == 5290992233934225408L || tmp == 4716786588737077248L || tmp == 6012153144547475456L || tmp == 6226618346633166848L || tmp == 5579808658373476352L ? (int)(d.type & 0xFFFFFFL) << 8 | 0x20 : (int)(d.type >>> 32));
        short id = d.id > Short.MAX_VALUE ? (short)Short.MAX_VALUE : (d.id < Short.MIN_VALUE ? (short)Short.MIN_VALUE : (short)d.id);
        MacResource r = new MacResource(type, id, d.name, d.data);
        r.compressed = d.compressed;
        r.locked = d.fixed;
        r.preload = d.preload;
        r.protect = d.readonly || d.protect;
        r.purgeable = d.purgeable;
        r.sysheap = d.system;
        return r;
    }
}

