/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 11:51:42 GMT 2018
 */

package uk.ac.sanger.artemis.components;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.MockitoExtension.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import javax.swing.JFrame;
import javax.swing.JPasswordField;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.EntryFileDialog;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.MSPcrunchEntryInformation;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.util.ByteBuffer;
import uk.ac.sanger.artemis.util.DatabaseDocument;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;
import uk.ac.sanger.artemis.util.ZipFileDocument;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class EntryFileDialog_ESTest extends EntryFileDialog_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      EntryFileDialog entryFileDialog0 = new EntryFileDialog((JFrame) null, true);
      // Undeclared exception!
      try { 
        entryFileDialog0.saveEntry((Entry) null, true, false, false, 123);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.EntryFileDialog", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("", 511);
      DatabaseDocument databaseDocument0 = new DatabaseDocument("Uj1UlK`o|Lw", jPasswordField0, (String) null, "", true);
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      // Undeclared exception!
      try { 
        EntryFileDialog.getEntryFromFile((JFrame) null, databaseDocument0, blastEntryInformation0, true);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0);
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      // Undeclared exception!
      try { 
        EntryFileDialog.getEntryFromFile((JFrame) null, databaseDocument0, entryInformation0, false);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Flatten Gene Model");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "uscY Fdd,rI");
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      // Undeclared exception!
      try { 
        EntryFileDialog.getEntryFromFile((JFrame) null, zipFileDocument0, mSPcrunchEntryInformation0, false);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      EntryFileDialog entryFileDialog0 = new EntryFileDialog((JFrame) null, true);
      // Undeclared exception!
      try { 
        entryFileDialog0.saveEntry((Entry) null, true, true, true, 1);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.EntryFileDialog", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EntryFileDialog entryFileDialog0 = new EntryFileDialog((JFrame) null, true);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("<ZXSvZ;h|Xo6hWaHr");
      // Undeclared exception!
      try { 
        entryFileDialog0.saveEntry(entry0, false, false, false, (-1));
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      EntryFileDialog entryFileDialog0 = new EntryFileDialog((JFrame) null, true);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry((String) null);
      // Undeclared exception!
      try { 
        entryFileDialog0.saveEntry(entry0, false, false, false, (-1));
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("");
      ByteBuffer byteBuffer0 = new ByteBuffer();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0, "", "", byteBuffer0, "");
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      // Undeclared exception!
      try { 
        EntryFileDialog.getEntryFromFile((JFrame) null, databaseDocument0, simpleEntryInformation0, true);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      ByteBuffer byteBuffer0 = new ByteBuffer();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0, "", "", byteBuffer0, "");
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      // Undeclared exception!
      try { 
        EntryFileDialog.getEntryFromFile((JFrame) null, databaseDocument0, simpleEntryInformation0, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      EntryFileDialog entryFileDialog0 = new EntryFileDialog((JFrame) null, false);
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      // Undeclared exception!
      try { 
        entryFileDialog0.getEntry(mSPcrunchEntryInformation0, inputStreamProgressListener0, false);
        fail("Expecting exception: SecurityException");
      
      } catch(SecurityException e) {
         //
         // Permission Denied
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      EntryFileDialog entryFileDialog0 = new EntryFileDialog((JFrame) null, true);
      // Undeclared exception!
      try { 
        entryFileDialog0.saveEntry((Entry) null, true, true, false, 123);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.EntryFileDialog", e);
      }
  }
}
