//
// anyRemote
// a bluetooth remote for your PC.
//
// Copyright (C) 2012-2012 Mikhail Fedotov <anyremote@mail.ru>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

//
// Timers handling
//

#ifndef _TIMER_H_
#define _TIMER_H_ 1

#include "parse.h"
#include "hash.h"

typedef struct TC {

    char *macro;
    int	timeout;
    int	max_times;
    int	ticks;
    int	times;
    int status;
    
} timerCmd;

void        verifyTimerCfg  (int ticksInSec);
void        freeTimers      (HashTable* tms);
int         timerCommand    (int subtype, const char *id, const char* op, cmdParams* p);
HashTable*  getTimers       (void); 
void        forgetTimers    (void);

#endif
