# Print Arch Linux packages providing given sibling packages list.
# USAGE: dependencies_siblings_list_archlinux $dependencies_siblings
dependencies_siblings_list_archlinux() {
	local dependencies_siblings
	dependencies_siblings="$1"

	local dependency_sibling
	while read -r dependency_sibling; do
		dependencies_sibling_single_archlinux "$dependency_sibling"
	done <<- EOL
	$(printf '%s' "$dependencies_siblings")
	EOL
}

# Print Arch Linux package providing given single sibling package.
# USAGE: dependencies_sibling_single_archlinux $dependency_sibling
dependencies_sibling_single_archlinux() {
	local dependency_sibling
	dependency_sibling="$1"

	local package_id
	package_id=$(package_id "$dependency_sibling")
	printf '%s\n' "$package_id"
}

