/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.samples;

import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.core.Messages;
import com.nvidia.cuda.ide.build.project.DeclareCudaModulesProcess;
import com.nvidia.cuda.ide.build.project.IArchitectureObject;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import com.nvidia.cuda.ide.build.ui.ArchitecturesSelector;
import com.nvidia.cuda.ide.util.UiUtil;
import com.nvidia.cuda.ide.wizard.LinkerToggle;
import com.nvidia.cuda.ide.wizard.samples.ProjectSample;
import java.net.URI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public final class SampleImportPage
extends WizardNewProjectCreationPage
implements IArchitectureObject {
    protected final ArchitecturesSelector architectures = new ArchitecturesSelector();
    private boolean linker;
    private LinkerToggle linkerToggle;
    private int physical;
    private final ProjectSample sample;
    private int virtual;
    private String sourceLocation;
    private Text src;
    private boolean shouldBuild;

    private static boolean hasSM20(int physical) {
        Architecture[] architectureArray = Architecture.decode(physical);
        int n = architectureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Architecture architecture = architectureArray[n2];
            if (architecture.major >= 2) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public SampleImportPage(String projectName, ProjectSample sample, int defaultVirtual, int defaultPhysical) {
        super(Messages.SampleImportPage_ImportSample);
        this.sample = sample;
        this.physical = defaultPhysical;
        this.virtual = defaultVirtual;
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.linker = DeclareCudaModulesProcess.getDeviceLinkerDefault();
        this.sourceLocation = preferenceStore.getString("newproject.source.location");
        this.shouldBuild = preferenceStore.getBoolean("newproject.build");
        this.setInitialProjectName(projectName);
        this.setTitle(Messages.SampleImportPage_ImportCUDASample);
        this.setDescription(String.format("Import a CUDA SDK sample \"%s\" as a new Nsight project", sample.getName()));
    }

    public void createControl(Composite p) {
        super.createControl(p);
        Composite composite = (Composite)this.getControl();
        new Label(composite, 0).setLayoutData((Object)UiUtil.createLayoutData(1));
        int columns = Architecture.all().length + 1;
        Composite parent = new Composite(composite, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(768));
        Label srcFolderLabel = new Label(parent, 0);
        srcFolderLabel.setText(Messages.SampleImportPage_SourceFolder);
        this.src = new Text(parent, 2048);
        this.src.setLayoutData((Object)GridDataFactory.defaultsFor((Control)this.src).span(columns - 1, 1).create());
        this.src.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SampleImportPage.this.sourceFolderUpdated(SampleImportPage.this.src.getText());
            }
        });
        new Label(parent, 0);
        final Button doBuild = new Button(parent, 32);
        doBuild.setLayoutData((Object)GridDataFactory.defaultsFor((Control)doBuild).span(columns - 1, 1).create());
        doBuild.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SampleImportPage.this.shouldBuild = doBuild.getSelection();
            }
        });
        doBuild.setText(Messages.SampleImportPage_BuildAfterCreation);
        this.linkerToggle = new LinkerToggle(parent, columns, false);
        this.architectures.createControls(parent, columns, true);
        this.linkerToggle.setAllowedModes(this.sample.supportedLinkMode());
        Architecture spec = this.sample.getCudaSpecs();
        this.architectures.setMinArchitecture(spec);
        new Label(parent, 0).setLayoutData((Object)new GridData(4, 4, false, false, columns, 1));
        UiUtil.createDevicesInformationLabel(parent);
        this.src.setText(this.sourceLocation);
        doBuild.setSelection(this.shouldBuild);
        this.linkerToggle.setModule(this);
        this.architectures.setModule(this);
        this.validate();
    }

    protected void sourceFolderUpdated(String text) {
        this.sourceLocation = text;
        this.validate();
    }

    @Override
    public void disableArchitecture(Architecture architecture, boolean isPhysical) {
        if (isPhysical) {
            this.physical &= ~architecture.getBit();
        } else {
            this.virtual &= ~architecture.getBit();
        }
        this.validate();
    }

    @Override
    public void enableArchitecture(Architecture architecture, boolean isPhysical) {
        if (isPhysical) {
            this.physical |= architecture.getBit();
        } else {
            this.virtual |= architecture.getBit();
        }
        this.validate();
    }

    @Override
    public int getPhysicalArchitecturesForAllConfigurations() {
        return this.physical;
    }

    @Override
    public int getPhysicalArchitecturesForSomeConfigurations() {
        return 0;
    }

    @Override
    public int getVirtualArchitecturesForAllConfigurations() {
        return this.virtual;
    }

    @Override
    public int getVirtualArchitecturesForSomeConfigurations() {
        return 0;
    }

    @Override
    public Boolean isDeviceLinking() {
        if (this.sample.supportedLinkMode() == null) {
            return this.linker;
        }
        return this.sample.supportedLinkMode();
    }

    @Override
    public void setDeviceLinkingEnabled(boolean link) {
        this.linker = link;
    }

    private IFileStore getLocationFileStore() throws CoreException {
        URI uri = this.getLocationURI();
        if (uri != null) {
            return EFS.getStore((URI)uri);
        }
        URI root = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
        IFileStore fs = EFS.getStore((URI)root);
        return fs.getChild(this.getProjectName());
    }

    protected final boolean validatePage() {
        block4: {
            block5: {
                if (!super.validatePage()) {
                    return false;
                }
                IFileStore fs = this.getLocationFileStore();
                IFileInfo f = fs.fetchInfo();
                if (!f.exists()) break block4;
                if (f.isDirectory()) break block5;
                this.setErrorMessage(Messages.SampleImportPage_FileExists);
                return false;
            }
            try {
                this.setMessage(Messages.SampleImportPage_DirectoryExists, 2);
            }
            catch (CoreException e) {
                CUIPlugin.log((IStatus)e.getStatus());
            }
        }
        return true;
    }

    protected final void validate() {
        if (!this.validatePage()) {
            return;
        }
        if (this.getMessageType() == 2) {
            return;
        }
        IStatus status = this.validateCuda();
        this.setMessage(null);
        String error = null;
        switch (status.getSeverity()) {
            case 4: {
                error = status.getMessage();
                break;
            }
            case 0: {
                this.setMessage(null);
                break;
            }
            default: {
                this.setMessage(status.getMessage(), status.getSeverity() != 2 ? 1 : 2);
            }
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    private IStatus validateCuda() {
        Path path = new Path(this.sourceLocation);
        if (!path.isValidPath(this.sourceLocation)) {
            return new Status(4, "com.nvidia.cuda.ide.build", String.format("\"%s\" is not a valid path", this.sourceLocation));
        }
        if (this.isDeviceLinking().booleanValue() && !SampleImportPage.hasSM20(this.physical | this.virtual)) {
            return new Status(4, "com.nvidia.cuda.ide.build", Messages.CudaProjectSetupWizardPage_error_separate_compilation_requires_sm20);
        }
        if (this.physical == 0 && this.virtual == 0) {
            return new Status(2, "com.nvidia.cuda.ide.build", Messages.CudaProjectSetupWizardPage_info_default_versions);
        }
        return UiUtil.validateCompatibility(ICudaModule.Type.executable, this.physical, this.virtual, this.linker);
    }

    public String getSourceFolder() {
        return this.sourceLocation;
    }

    public boolean shouldBuild() {
        return this.shouldBuild;
    }
}

