/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.ui;

import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.project.ICudaProjectConfiguration;
import com.nvidia.cuda.ide.build.project.MultiConfiguration;
import com.nvidia.cuda.ide.build.project.MultiExecutable;
import com.nvidia.cuda.ide.build.ui.BasicModuleView;
import com.nvidia.cuda.ide.build.ui.ModuleFiles;
import com.nvidia.cuda.ide.build.ui.MultiModuleView;
import com.nvidia.cuda.ide.util.UiUtil;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class ProjectExecutableEditorPane
implements MultiModuleView.IExecutableFileList,
ICudaProjectConfiguration.IModuleListener {
    private Composite exeDetails;
    private final MultiConfiguration configuration;
    private ModuleFiles moduleFiles;

    public ProjectExecutableEditorPane(MultiConfiguration projectConfiguration) {
        this.configuration = projectConfiguration;
        projectConfiguration.addModuleListener(this);
    }

    @Override
    public void configurationReloaded() {
        this.moduleFiles.setModule(this.configuration.getExecutable());
        this.moduleFiles.refresh();
    }

    @Override
    public void createControl(Composite parent) {
        this.exeDetails = new Composite(parent, 0);
        GridLayout gl_exeDetails = new GridLayout(1, false);
        gl_exeDetails.marginHeight = 0;
        gl_exeDetails.marginWidth = 0;
        gl_exeDetails.verticalSpacing = 0;
        this.exeDetails.setLayout((Layout)gl_exeDetails);
        this.moduleFiles = new ModuleFiles(this.exeDetails);
        this.moduleFiles.setModule(this.configuration.getExecutable());
        new BasicModuleView(this.exeDetails, this.configuration, true).setLayoutData(new GridData(768));
    }

    @Override
    public Control getControl() {
        return this.exeDetails;
    }

    @Override
    public void moduleAdded() {
    }

    @Override
    public void modulePropertyChanged() {
        this.moduleFiles.refresh();
    }

    @Override
    public void moduleRemoved() {
    }

    @Override
    public void performDefaults() {
        MultiExecutable executable = this.configuration.getExecutable();
        this.includeAll(executable, executable.getExcludedFromAllConfigurations());
        this.includeAll(executable, executable.getExcludedFromSomeConfigurations());
        UiUtil.setModuleDefaults(executable);
    }

    public void includeAll(MultiExecutable executable, Collection<IFile> excluded) {
        try {
            for (IFile file : excluded) {
                executable.include(file);
            }
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
    }
}

