/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;

public abstract class AbstractRemoteProcessBuilder
implements IRemoteProcessBuilder {
    private List<String> fCommandArgs;
    private IFileStore fRemoteDir = null;
    private boolean fRedirectErrorStream = false;

    public AbstractRemoteProcessBuilder(List<String> command) {
        this.fCommandArgs = command;
    }

    public AbstractRemoteProcessBuilder(String ... command) {
        this(Arrays.asList(command));
    }

    @Override
    public List<String> command() {
        return this.fCommandArgs;
    }

    @Override
    public IRemoteProcessBuilder command(List<String> command) {
        this.fCommandArgs = command;
        return this;
    }

    @Override
    public IRemoteProcessBuilder command(String ... command) {
        this.fCommandArgs = Arrays.asList(command);
        return this;
    }

    @Override
    public IFileStore directory() {
        return this.fRemoteDir;
    }

    @Override
    public IRemoteProcessBuilder directory(IFileStore directory) {
        this.fRemoteDir = directory;
        return this;
    }

    @Override
    public abstract Map<String, String> environment();

    @Override
    public abstract int getSupportedFlags();

    @Override
    public boolean redirectErrorStream() {
        return this.fRedirectErrorStream;
    }

    @Override
    public IRemoteProcessBuilder redirectErrorStream(boolean redirectErrorStream) {
        this.fRedirectErrorStream = redirectErrorStream;
        return this;
    }

    @Override
    public IRemoteProcess start() throws IOException {
        return this.start(0);
    }

    @Override
    public abstract IRemoteProcess start(int var1) throws IOException;

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (String arg : this.command()) {
            res.append(arg);
            res.append(" ");
        }
        return res.toString();
    }
}

