/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.MetricManager;
import com.nvidia.viper.activity.CuptiActivityMetric;
import com.nvidia.viper.model.Metric;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.Disposable;

public class InstantaneousMetricManager
implements Disposable {
    private Map<Integer, Map<String, List<CuptiActivityMetric>>> deviceMetricMap = new HashMap<Integer, Map<String, List<CuptiActivityMetric>>>();
    private Map<Integer, Map<String, Map<Integer, List<CuptiActivityMetric>>>> deviceInstanceMetricMap = new HashMap<Integer, Map<String, Map<Integer, List<CuptiActivityMetric>>>>();

    public void dispose() {
        this.deviceMetricMap.clear();
        this.deviceInstanceMetricMap.clear();
        this.deviceMetricMap = null;
        this.deviceInstanceMetricMap = null;
    }

    public void reset() {
        this.deviceMetricMap.clear();
        this.deviceInstanceMetricMap.clear();
    }

    public void addMetric(CuptiActivityMetric metric) {
        Metric metricObject = MetricManager.getMetric(metric.id);
        if (metricObject == null) {
            return;
        }
        String metricName = metricObject.getName();
        metric.valueKindCode = metricObject.getValueKind().getCode();
        if (metric.isOverflow() || metric.isInvalid()) {
            return;
        }
        if (metric.instance == -1) {
            Map<Object, Object> metricMap = this.deviceMetricMap.containsKey(metric.deviceId) ? this.deviceMetricMap.get(metric.deviceId) : new HashMap();
            List metricsList = metricMap.containsKey(metricName) ? (List)metricMap.get(metricName) : new LinkedList();
            metricsList.add(metric);
            metricMap.put(metricName, metricsList);
            this.deviceMetricMap.put(metric.deviceId, metricMap);
        } else {
            Map<Object, Object> metricInstanceMap = this.deviceInstanceMetricMap.containsKey(metric.deviceId) ? this.deviceInstanceMetricMap.get(metric.deviceId) : new HashMap();
            Map instanceMap = metricInstanceMap.containsKey(metricName) ? (Map)metricInstanceMap.get(metricName) : new HashMap();
            List<CuptiActivityMetric> metricsList = instanceMap.containsKey(metric.instance) ? (List)instanceMap.get(metric.instance) : new LinkedList<CuptiActivityMetric>();
            metricsList.add(metric);
            instanceMap.put(metric.instance, metricsList);
            metricInstanceMap.put(metricName, instanceMap);
            this.deviceInstanceMetricMap.put(metric.deviceId, metricInstanceMap);
        }
    }

    public List<CuptiActivityMetric> getMetricsList(int deviceId, String metricName, int instance) {
        Map<Integer, List<CuptiActivityMetric>> instanceMap;
        Map<String, Map<Integer, List<CuptiActivityMetric>>> metricMap;
        if (instance > -1 && (metricMap = this.deviceInstanceMetricMap.get(deviceId)) != null && metricMap.containsKey(metricName) && (instanceMap = metricMap.get(metricName)) != null && instanceMap.containsKey(instance)) {
            return instanceMap.get(instance);
        }
        return null;
    }

    public double getAvgMetricValue(int deviceId, String metricName, int[] instance) {
        HashMap<Integer, List<CuptiActivityMetric>> portMetrcMap = new HashMap<Integer, List<CuptiActivityMetric>>();
        int numMetric = -1;
        int[] nArray = instance;
        int n = instance.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i == -1) break;
            List<CuptiActivityMetric> metricsList = this.getMetricsList(deviceId, metricName, i);
            if (metricsList == null || metricsList.isEmpty()) {
                return -1.0;
            }
            portMetrcMap.put(i, metricsList);
            if (numMetric == -1) {
                numMetric = metricsList.size();
            }
            ++n2;
        }
        double DIVIDER = 1000000.0;
        double totalBytes = 0.0;
        double totalTime = 0.0;
        int i = 0;
        while (i < numMetric) {
            double totalAcrossPort = 0.0;
            long prevTimestamp = 0L;
            long currentTimestamp = 0L;
            int[] nArray2 = instance;
            int n3 = instance.length;
            int n4 = 0;
            while (n4 < n3) {
                int port = nArray2[n4];
                if (port == -1) break;
                List metricsList = (List)portMetrcMap.get(port);
                if (metricsList != null && metricsList.size() > i) {
                    long metricValue = ((CuptiActivityMetric)metricsList.get(i)).getValue().longValue();
                    currentTimestamp = ((CuptiActivityMetric)metricsList.get((int)i)).timestamp;
                    prevTimestamp = i == 0 ? currentTimestamp : ((CuptiActivityMetric)metricsList.get((int)(i - 1))).timestamp;
                    double bytes = (double)(metricValue * (currentTimestamp - prevTimestamp)) / DIVIDER;
                    totalAcrossPort += bytes;
                }
                ++n4;
            }
            if (totalAcrossPort > 0.0) {
                totalBytes += totalAcrossPort;
                totalTime += (double)(currentTimestamp - prevTimestamp);
            }
            ++i;
        }
        double avg = totalBytes / totalTime;
        return avg * DIVIDER;
    }

    public long getMaxMetricValue(int deviceId, String metricName, int[] instance) {
        List<Long> valueList = this.getAggregateMetricValues(deviceId, metricName, instance);
        if (valueList == null) {
            return -1L;
        }
        long max = Collections.max(valueList, new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                return Long.compare(o1, o2);
            }
        });
        return max;
    }

    public long getMinMetricValue(int deviceId, String metricName, int[] instance) {
        List<Long> valueList = this.getAggregateMetricValues(deviceId, metricName, instance);
        if (valueList == null) {
            return -1L;
        }
        long min = Collections.min(valueList, new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                if (o1 == 0L) {
                    return 1;
                }
                if (o2 == 0L) {
                    return -1;
                }
                return Long.compare(o1, o2);
            }
        });
        return min;
    }

    public List<Long> getAggregateMetricValues(int deviceId, String metricName, int[] instance) {
        ArrayList<Long> valueList = null;
        int i = 0;
        while (i < instance.length) {
            List<CuptiActivityMetric> metricsList = this.getMetricsList(deviceId, metricName, instance[i]);
            if (metricsList != null && !metricsList.isEmpty()) {
                if (valueList == null) {
                    valueList = new ArrayList<Long>();
                }
                valueList.add(0, 0L);
                int j = 1;
                while (j < metricsList.size()) {
                    if (j < valueList.size()) {
                        long current = (Long)valueList.get(j);
                        valueList.set(j, current + metricsList.get(j).getValue().longValue());
                    } else {
                        valueList.add(j, metricsList.get(j).getValue().longValue());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return valueList;
    }

    public boolean isMetricAvailable(String name) {
        for (Map<String, Map<Integer, List<CuptiActivityMetric>>> metricMap : this.deviceInstanceMetricMap.values()) {
            if (metricMap == null || !metricMap.containsKey(name)) continue;
            return true;
        }
        return false;
    }

    public double getAvgBandwidth(int deviceId, String metricName) {
        Map<String, Map<Integer, List<CuptiActivityMetric>>> metricMap = this.deviceInstanceMetricMap.get(deviceId);
        if (metricMap != null && metricMap.containsKey(metricName)) {
            Map<Integer, List<CuptiActivityMetric>> instanceMap = metricMap.get(metricName);
            double DIVIDER = 1000000.0;
            double totalBytes = 0.0;
            double maxTotalTime = 0.0;
            for (Map.Entry<Integer, List<CuptiActivityMetric>> entry : instanceMap.entrySet()) {
                if (entry.getKey() <= -1) continue;
                List<CuptiActivityMetric> metricsList = entry.getValue();
                double totalTimeForPort = 0.0;
                double totalBytesForPort = 0.0;
                long currentTimestamp = 0L;
                long prevTimestamp = 0L;
                int i = 0;
                while (i < metricsList.size()) {
                    long metricValue = metricsList.get(i).getValue().longValue();
                    currentTimestamp = metricsList.get((int)i).timestamp;
                    long l = prevTimestamp = i == 0 ? currentTimestamp : metricsList.get((int)(i - 1)).timestamp;
                    if (metricValue > 0L) {
                        double bytes = (double)(metricValue * (currentTimestamp - prevTimestamp)) / DIVIDER;
                        totalBytesForPort += bytes;
                        totalTimeForPort += (double)(currentTimestamp - prevTimestamp);
                    }
                    ++i;
                }
                if (!(totalBytesForPort > 0.0)) continue;
                totalBytes += totalBytesForPort;
                if (!(totalTimeForPort > maxTotalTime)) continue;
                maxTotalTime = totalTimeForPort;
            }
            double avg = totalBytes / maxTotalTime;
            return avg * DIVIDER;
        }
        return -1.0;
    }

    public long getAggregateMetricValues(int deviceId, String metricName) {
        long value = -1L;
        Map<String, Map<Integer, List<CuptiActivityMetric>>> metricMap = this.deviceInstanceMetricMap.get(deviceId);
        if (metricMap != null && metricMap.containsKey(metricName)) {
            Map<Integer, List<CuptiActivityMetric>> instanceMap = metricMap.get(metricName);
            for (Map.Entry<Integer, List<CuptiActivityMetric>> entry : instanceMap.entrySet()) {
                if (entry.getKey() <= -1) continue;
                List<CuptiActivityMetric> list = entry.getValue();
                for (CuptiActivityMetric metric : list) {
                    if (value == -1L) {
                        value = metric.longValue;
                        continue;
                    }
                    value += metric.longValue;
                }
            }
        }
        return value;
    }
}

