/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.CommitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponentStateManager;
import org.eclipse.egit.ui.internal.push.PushOperationUI;
import org.eclipse.egit.ui.internal.push.PushWizard;
import org.eclipse.egit.ui.internal.push.SimpleConfigurePushDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class CommitJob
extends Job {
    private CommitOperation commitOperation;
    private Repository repository;
    private boolean openCommitEditor;
    private boolean pushUpstream;

    public CommitJob(Repository repository, CommitOperation commitOperation) {
        super(UIText.CommitAction_CommittingChanges);
        this.repository = repository;
        this.commitOperation = commitOperation;
    }

    public CommitJob setOpenCommitEditor(boolean openCommitEditor) {
        this.openCommitEditor = openCommitEditor;
        return this;
    }

    public CommitJob setPushUpstream(boolean pushUpstream) {
        this.pushUpstream = pushUpstream;
        return this;
    }

    protected IStatus run(IProgressMonitor monitor) {
        RevCommit commit = null;
        try {
            try {
                this.commitOperation.execute(monitor);
                commit = this.commitOperation.getCommit();
                CommitMessageComponentStateManager.deleteState(this.repository);
                RepositoryMapping mapping = RepositoryMapping.findRepositoryMapping((Repository)this.repository);
                if (mapping != null) {
                    mapping.fireRepositoryChanged();
                }
            }
            catch (CoreException e) {
                if (e.getCause() instanceof JGitInternalException) {
                    IStatus iStatus = Activator.createErrorStatus(e.getLocalizedMessage(), e.getCause());
                    GitLightweightDecorator.refresh();
                    return iStatus;
                }
                IStatus iStatus = Activator.createErrorStatus(UIText.CommitAction_CommittingFailed, e);
                GitLightweightDecorator.refresh();
                return iStatus;
            }
        }
        finally {
            GitLightweightDecorator.refresh();
        }
        if (commit != null) {
            if (this.openCommitEditor) {
                this.openCommitEditor(commit);
            }
            if (this.pushUpstream) {
                this.pushUpstream();
            }
        }
        return Status.OK_STATUS;
    }

    private void openCommitEditor(final RevCommit newCommit) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                CommitEditor.openQuiet(new RepositoryCommit(CommitJob.this.repository, newCommit));
            }
        });
    }

    private void pushUpstream() {
        RemoteConfig config = SimpleConfigurePushDialog.getConfiguredRemote(this.repository);
        if (config == null) {
            final Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        WizardDialog wizardDialog = new WizardDialog(display.getActiveShell(), (IWizard)new PushWizard(CommitJob.this.repository));
                        wizardDialog.setHelpAvailable(true);
                        wizardDialog.open();
                    }
                    catch (URISyntaxException e) {
                        Activator.handleError(NLS.bind((String)UIText.CommitUI_pushFailedMessage, (Object)e), e, true);
                    }
                }
            });
        } else {
            PushOperationUI op = new PushOperationUI(this.repository, config.getName(), false);
            op.start();
        }
    }

    public boolean belongsTo(Object family) {
        if (family.equals(JobFamilies.COMMIT)) {
            return true;
        }
        return super.belongsTo(family);
    }
}

