/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model.state;

import com.nvidia.cuda.ide.debug.mi.AbstractMITableInfo;
import com.nvidia.cuda.ide.debug.mi.DeviceInfo;
import com.nvidia.cuda.ide.debug.mi.LaunchTraceInfo;
import com.nvidia.cuda.ide.debug.mi.vo.KernelInfo;
import com.nvidia.cuda.ide.debug.mi.vo.LaneInfo;
import com.nvidia.cuda.ide.debug.mi.vo.SMInfo;
import com.nvidia.cuda.ide.debug.mi.vo.UnCoalescedBlockInfo;
import com.nvidia.cuda.ide.debug.mi.vo.UncoalescedThreadInfo;
import com.nvidia.cuda.ide.debug.mi.vo.UncoalescedWarpInfo;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.state.ICudaQueries;
import com.nvidia.cuda.ide.debug.service.CudaCommandFactory;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.command.MIControlDMContext;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;

public final class MIQueries
implements ICudaQueries {
    private final CommandCache cache;
    private final CudaCommandFactory commandFactory;
    private final DsfSession session;
    private final DsfServicesTracker tracker;

    public MIQueries(CommandCache cache, CudaCommandFactory commandFactory, DsfSession session, DsfServicesTracker tracker) {
        this.tracker = tracker;
        this.session = session;
        this.cache = cache;
        this.commandFactory = commandFactory;
    }

    @Override
    public DsfExecutor getExecutor() {
        return this.session.getExecutor();
    }

    @Override
    public String getSessionId() {
        return this.session.getId();
    }

    @Override
    public void queryBlocks(IDMContext dmc, long kernelId, DataRequestMonitor<UnCoalescedBlockInfo[]> rm) {
        MIControlDMContext ctx = (MIControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, MIControlDMContext.class);
        this.cache.execute(this.commandFactory.createMICudaInfoBlocks(ctx, kernelId), new MICollectionRequestMonitor((Executor)this.getExecutor(), rm));
    }

    @Override
    public void queryKernels(IDMContext dmc, DataRequestMonitor<KernelInfo[]> rm) {
        MIControlDMContext ctx = (MIControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, MIControlDMContext.class);
        this.cache.execute(this.commandFactory.createMICudaInfoKernels(ctx), new MICollectionRequestMonitor((Executor)this.getExecutor(), rm));
    }

    @Override
    public void queryLanes(IDMContext dmc, short deviceId, short sm, short warpId, DataRequestMonitor<LaneInfo[]> rm) {
        MIControlDMContext ctx = (MIControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, MIControlDMContext.class);
        this.cache.execute(this.commandFactory.createMICudaInfoLanes(ctx, deviceId, sm, warpId), new MICollectionRequestMonitor((Executor)this.getExecutor(), rm));
    }

    @Override
    public synchronized void queryThreads(IDMContext dmc, long kernelId, CudaCoord blockIdx, DataRequestMonitor<UncoalescedThreadInfo[]> rm) {
        IMIContainerDMContext ctx = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIContainerDMContext.class);
        this.cache.execute(this.commandFactory.createMICudaInfoThreads((IDMContext)ctx, kernelId, blockIdx), new MICollectionRequestMonitor((Executor)this.getExecutor(), rm));
    }

    @Override
    public synchronized void queryThreads(IDMContext dmc, short deviceId, short sm, short warp, short lane, DataRequestMonitor<UncoalescedThreadInfo[]> rm) {
        MIControlDMContext ctx = (MIControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, MIControlDMContext.class);
        this.cache.execute(this.commandFactory.createMICudaInfoThreads(ctx, deviceId, sm, warp, lane), new MICollectionRequestMonitor((Executor)this.getExecutor(), rm));
    }

    @Override
    public void queryWarps(IDMContext dmc, short deviceId, short sm, DataRequestMonitor<UncoalescedWarpInfo[]> rm) {
        MIControlDMContext ctx = (MIControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, MIControlDMContext.class);
        this.cache.execute(this.commandFactory.createMICudaInfoWarps(ctx, deviceId, sm), new MICollectionRequestMonitor((Executor)this.getExecutor(), rm));
    }

    @Override
    public void queryDevices(IDMContext dmc, DataRequestMonitor<DeviceInfo[]> rm) {
        MIControlDMContext ctx = (MIControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, MIControlDMContext.class);
        this.cache.execute(this.commandFactory.createMICudaInfoDevices(ctx), new MICollectionRequestMonitor((Executor)this.getExecutor(), rm));
    }

    @Override
    public void querySMs(IDMContext dmc, short deviceId, DataRequestMonitor<SMInfo[]> rm) {
        MIControlDMContext ctx = (MIControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, MIControlDMContext.class);
        this.cache.execute(this.commandFactory.createMICudaInfoSMs(ctx, deviceId), new MICollectionRequestMonitor((Executor)this.getExecutor(), rm));
    }

    @Override
    public <T> T getService(Class<T> clazz) {
        return (T)this.tracker.getService(clazz);
    }

    @Override
    public boolean isSuspended(IDMContext context) {
        IRunControl runControl = (IRunControl)this.tracker.getService(IRunControl.class);
        return runControl.isSuspended((IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IRunControl.IExecutionDMContext.class));
    }

    @Override
    public void queryCdpTrace(IDMContext dmc, long kernelId, DataRequestMonitor<LaunchTraceInfo[]> rm) {
        MIControlDMContext ctx = (MIControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, MIControlDMContext.class);
        this.cache.execute(this.commandFactory.createMICudaInfoLaunchTrace(ctx, kernelId), new MICollectionRequestMonitor((Executor)this.getExecutor(), rm));
    }

    private static final class MICollectionRequestMonitor<K>
    extends DataRequestMonitor<AbstractMITableInfo<K>> {
        private final DataRequestMonitor<K[]> rm;

        public MICollectionRequestMonitor(Executor executor, DataRequestMonitor<K[]> rm) {
            super(executor, rm);
            this.rm = rm;
        }

        protected void handleSuccess() {
            this.rm.setData(((AbstractMITableInfo)((Object)this.getData())).getEntries());
            this.rm.done();
        }
    }
}

