/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import com.ibm.icu.util.ULocale;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IAdvancedQuery;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.ConnectionPropertyHandler;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaAdvancedQuery;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaObject;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaQuery;
import org.eclipse.datatools.connectivity.oda.consumer.nls.Messages;

public class OdaConnection
extends OdaObject
implements IConnection {
    private static final String MSG_LINE_SEPARATOR = " )\t";
    private int m_errorNumber;
    private String m_errorMessage;
    private static Hashtable sm_clsLdrOpenedConnCountMap;
    private static int sm_maxOpenConnections;
    private int m_numOfOpenedStatements;
    private Hashtable m_dsMetaDataCollection;
    private OdaDataSetMetaData m_defaultDSMetaData;
    private Locale m_locale;
    private Object m_driverAppContext;
    private Object m_connAppContext;
    private ConnectionPropertyHandler m_propertyHandler;

    static {
        sm_maxOpenConnections = 0;
    }

    protected OdaConnection(IConnection connection, boolean switchContextClassloader, ClassLoader driverClassLoader, ClassLoader originalClassLoader) {
        super(connection, switchContextClassloader, driverClassLoader, originalClassLoader);
        String context = "OdaConnection.OdaConnection( " + connection + ")\t";
        this.logMethodCalled(context);
        this.clearDriverError();
        this.m_numOfOpenedStatements = 0;
        this.logMethodExitWithReturn(context, this);
    }

    static void setMaxConnections(int maxOpenConnections) {
        sm_maxOpenConnections = maxOpenConnections;
    }

    private Hashtable getDSMetaDataCollection() {
        if (this.m_dsMetaDataCollection == null) {
            this.m_dsMetaDataCollection = new Hashtable();
        }
        return this.m_dsMetaDataCollection;
    }

    private IConnection getConnection() {
        return (IConnection)this.getObject();
    }

    @Override
    protected void handleError(OdaException exception) throws OdaException {
        super.handleError(exception);
        int errorNumber = exception.getErrorCode();
        String errorMessage = exception.toString();
        this.setDriverError(errorNumber, errorMessage);
        throw exception;
    }

    void setDriverError(int errorNumber, String errorMessage) {
        this.m_errorNumber = errorNumber;
        this.m_errorMessage = errorMessage;
    }

    public int getDriverErrorNumber() {
        return this.m_errorNumber;
    }

    public String getDriverErrorMessage() {
        return this.m_errorMessage;
    }

    public void clearDriverError() {
        this.m_errorNumber = 0;
        this.m_errorMessage = "";
    }

    boolean canSupportMoreOpenedStatements() throws OdaException {
        int maxStatements = this.getMaxQueries();
        return maxStatements == 0 || this.m_numOfOpenedStatements < maxStatements;
    }

    public int getMaxQueries() throws OdaException {
        this.logMethodCalled("OdaConnection.getMaxQueries()\t");
        try {
            this.setContextClassloader();
            int ret = this.getConnection().getMaxQueries();
            this.logMethodExitWithReturn("OdaConnection.getMaxQueries()\t", ret);
            int n = ret;
            return n;
        }
        catch (UnsupportedOperationException uoException) {
            int n = this.handleUnsupportedOpAndRetZero(uoException, "IConnection.getMaxQueries()");
            return n;
        }
        catch (RuntimeException rtException) {
            int n = this.handleErrorAndReturnNegOne(rtException);
            return n;
        }
        catch (OdaException odaException) {
            int n = this.handleErrorAndReturnNegOne(odaException);
            return n;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    void addOpenStatement(OdaQuery statement) {
        if (statement.isPreparedSuccessfully()) {
            ++this.m_numOfOpenedStatements;
        }
    }

    void removeOpenStatement(OdaQuery statement) {
        if (statement.isPreparedSuccessfully()) {
            --this.m_numOfOpenedStatements;
        }
    }

    Locale getLocale() {
        return this.m_locale;
    }

    void setDriverAppContext(Object context) {
        this.m_driverAppContext = context;
    }

    private Object getDriverAppContext() {
        return this.m_driverAppContext;
    }

    /*
     * Loose catch block
     */
    public void open(Properties connProperties) throws OdaException {
        String context;
        block16: {
            OdaException propHandlerException;
            block15: {
                context = "OdaConnection.open( " + connProperties + MSG_LINE_SEPARATOR;
                this.logMethodCalled(context);
                if (this.getAppContext() == null) {
                    this.setAppContext(this.getDriverAppContext());
                }
                propHandlerException = null;
                this.setContextClassloader();
                if (!this.checkIsOpen()) break block15;
                this.log(context, "The ODA connection is already open; skip call to the IConnection.open method.");
                this.logMethodExit(context);
                this.resetContextClassloader();
                return;
            }
            try {
                if (sm_maxOpenConnections != 0 && this.getOpenedConnCount() >= sm_maxOpenConnections) {
                    throw this.newOdaException(Messages.helper_maxConcurrentConnectionsReached);
                }
                Properties effectiveConnProps = null;
                try {
                    effectiveConnProps = this.getEffectiveProperties(connProperties);
                }
                catch (OdaException ex) {
                    propHandlerException = ex;
                    effectiveConnProps = connProperties;
                }
                this.getConnection().open(effectiveConnProps);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IConnection.open( Properties connProperties )");
                this.resetContextClassloader();
                break block16;
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                break block16;
            }
            catch (OdaException odaException) {
                if (propHandlerException != null) {
                    odaException.setNextException(propHandlerException);
                }
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
                break block16;
            }
            {
                finally {
                    this.resetContextClassloader();
                }
            }
            this.resetContextClassloader();
        }
        this.incrOpenedConnCount();
        this.logMethodExit(context);
    }

    Object getAppContext() {
        return this.m_connAppContext;
    }

    /*
     * Loose catch block
     */
    public void setAppContext(Object context) throws OdaException {
        block10: {
            String contextObjInfo = context == null ? "null" : context.getClass().getName();
            this.logMethodCalled("OdaConnection.setAppContext()\t");
            if (this.m_connAppContext == context) {
                this.log("OdaConnection.setAppContext()\t", "Same pass-thru application context object: " + contextObjInfo);
                this.logMethodExit("OdaConnection.setAppContext()\t");
                return;
            }
            this.processConsumerAppContext(context);
            try {
                this.setContextClassloader();
                this.log("OdaConnection.setAppContext()\t", "Passing thru application context to underlying ODA connection: " + contextObjInfo);
                this.getConnection().setAppContext(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.logUnsupportedOp(uoException, "IConnection.setAppContext");
                this.resetContextClassloader();
                break block10;
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                break block10;
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
                break block10;
            }
            {
                finally {
                    this.resetContextClassloader();
                }
            }
            this.resetContextClassloader();
        }
        this.m_connAppContext = context;
        this.logMethodExit("OdaConnection.setAppContext()\t");
    }

    public void close() throws OdaException {
        this.logMethodCalled("OdaConnection.close()\t");
        try {
            this.setContextClassloader();
            if (!this.checkIsOpen()) {
                this.log("OdaConnection.close()\t", "The ODA connection is not open; skip call to the IConnection.close method.");
                this.logMethodExit("OdaConnection.close()\t");
                return;
            }
            try {
                this.getConnection().close();
                this.clearDriverError();
                this.m_numOfOpenedStatements = 0;
                this.decrOpenedConnCount();
                this.logMethodExit("OdaConnection.close()\t");
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IConnection.close()");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    private int getOpenedConnCount() {
        Hashtable counts = this.getClsLdrOpenedConnMap();
        Object value = counts.get(this.getConnection().getClass().getClassLoader());
        int i = value == null ? 0 : (Integer)value;
        return i;
    }

    private void incrOpenedConnCount() {
        this.incrOrDecrOpenedConnectionCountMap(true);
    }

    private void decrOpenedConnCount() {
        this.incrOrDecrOpenedConnectionCountMap(false);
    }

    private void incrOrDecrOpenedConnectionCountMap(boolean increment) {
        int i;
        ClassLoader driverClassLoader;
        Hashtable counts = this.getClsLdrOpenedConnMap();
        Object value = counts.get(driverClassLoader = this.getConnection().getClass().getClassLoader());
        int n = i = value == null ? 0 : (Integer)value;
        if (increment) {
            ++i;
        } else if (i > 0) {
            --i;
        }
        Integer newValue = new Integer(i);
        counts.put(driverClassLoader, newValue);
    }

    private Hashtable getClsLdrOpenedConnMap() {
        if (sm_clsLdrOpenedConnCountMap == null) {
            sm_clsLdrOpenedConnCountMap = new Hashtable();
        }
        return sm_clsLdrOpenedConnCountMap;
    }

    public boolean isOpen() throws OdaException {
        this.logMethodCalled("OdaConnection.isOpen()\t");
        try {
            this.setContextClassloader();
            boolean ret = this.checkIsOpen();
            this.logMethodExitWithReturn("OdaConnection.isOpen()\t", ret);
            boolean bl = ret;
            return bl;
        }
        catch (UnsupportedOperationException uoException) {
            boolean bl = this.handleUnsupportedOpAndRetFalse(uoException, "IConnection.isOpen()");
            return bl;
        }
        catch (RuntimeException rtException) {
            boolean bl = this.handleErrorAndReturnFalse(rtException);
            return bl;
        }
        catch (OdaException odaException) {
            boolean bl = this.handleErrorAndReturnFalse(odaException);
            return bl;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    private boolean checkIsOpen() throws OdaException {
        return this.getConnection().isOpen();
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        String context = "OdaConnection.getMetaData( " + dataSetType + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            OdaDataSetMetaData odaDSMetaData = this.doGetMetaData(dataSetType);
            if (odaDSMetaData == null) {
                throw new UnsupportedOperationException();
            }
            this.logMethodExitWithReturn(context, odaDSMetaData);
            OdaDataSetMetaData odaDataSetMetaData = odaDSMetaData;
            return odaDataSetMetaData;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IConnection.getMetaData( String dataSetType )");
            return null;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            return null;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            return null;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    OdaDataSetMetaData doGetMetaData(String dataSetType) throws OdaException {
        IDataSetMetaData metadata;
        if (dataSetType == null) {
            if (this.m_defaultDSMetaData != null) {
                return this.m_defaultDSMetaData;
            }
        } else if (this.getDSMetaDataCollection().containsKey(dataSetType)) {
            OdaDataSetMetaData ret = (OdaDataSetMetaData)this.getDSMetaDataCollection().get(dataSetType);
            return ret;
        }
        if ((metadata = this.getConnection().getMetaData(dataSetType)) == null) {
            return null;
        }
        OdaDataSetMetaData odaDSMetaData = new OdaDataSetMetaData(metadata, this, this.switchContextClassloader(), this.getDriverClassLoader());
        if (dataSetType == null) {
            this.m_defaultDSMetaData = odaDSMetaData;
        } else {
            this.getDSMetaDataCollection().put(dataSetType, odaDSMetaData);
        }
        return odaDSMetaData;
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        String context = "OdaConnection.newQuery( " + dataSetType + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            if (!this.checkIsOpen()) {
                throw this.newOdaException(Messages.helper_connectionIsInactive);
            }
            if (!this.canSupportMoreOpenedStatements()) {
                throw this.newOdaException(Messages.helper_maxConcurrentStatementsReached);
            }
            IQuery statement = this.getConnection().newQuery(dataSetType);
            if (statement == null) {
                this.logMethodExit(context);
                throw new UnsupportedOperationException();
            }
            OdaQuery ret = statement instanceof IAdvancedQuery ? this.newAdvancedQueryHelper((IAdvancedQuery)statement, dataSetType) : this.newQueryHelper(statement, dataSetType);
            this.logMethodExitWithReturn(context, ret);
            OdaQuery odaQuery = ret;
            return odaQuery;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IConnection.newQuery( String )");
            return null;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            return null;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            return null;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    protected OdaQuery newQueryHelper(IQuery statement, String dataSetType) {
        return new OdaQuery(statement, this, dataSetType, this.switchContextClassloader(), this.getDriverClassLoader());
    }

    protected OdaAdvancedQuery newAdvancedQueryHelper(IAdvancedQuery advancedQuery, String dataSetType) {
        return new OdaAdvancedQuery(advancedQuery, this, dataSetType, this.switchContextClassloader(), this.getDriverClassLoader());
    }

    /*
     * Loose catch block
     */
    public void commit() throws OdaException {
        this.logMethodCalled("OdaConnection.commit()\t");
        try {
            try {
                this.setContextClassloader();
                this.getConnection().commit();
                this.logMethodExit("OdaConnection.commit()\t");
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IConnection.commit()");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    public void rollback() throws OdaException {
        this.logMethodCalled("OdaConnection.rollback()\t");
        try {
            try {
                this.setContextClassloader();
                this.getConnection().rollback();
                this.logMethodExit("OdaConnection.rollback()\t");
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IConnection.rollback()");
                this.resetContextClassloader();
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                this.resetContextClassloader();
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
            }
        }
        finally {
            this.resetContextClassloader();
        }
    }

    public void setLocale(String localeString) throws Throwable {
        String context = "OdaConnection.setLocale( " + localeString + MSG_LINE_SEPARATOR;
        this.logMethodCalled(context);
        if (localeString == null || localeString.length() != 5) {
            this.m_locale = Locale.getDefault();
        } else {
            String language = localeString.substring(0, 2);
            String country = localeString.substring(3, 5);
            this.m_locale = new Locale(language, country);
        }
        try {
            Class[] parameterTypes = new Class[]{this.m_locale.getClass()};
            Object[] arguments = new Object[]{this.m_locale};
            this.findAndInvokeMethod("setLocale", parameterTypes, arguments);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getTargetException();
            if (cause instanceof RuntimeException) {
                this.handleError((RuntimeException)cause);
                return;
            }
            if (cause instanceof OdaException) {
                this.handleError((OdaException)cause);
                return;
            }
            throw cause;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        this.logMethodExit(context);
    }

    /*
     * Exception decompiling
     */
    public void setLocale(ULocale locale) throws OdaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processConsumerAppContext(Object context) {
        this.m_propertyHandler = new ConnectionPropertyHandler(context);
        try {
            if (this.m_propertyHandler.getAppLocale() != null) {
                this.setLocale(this.m_propertyHandler.getAppLocale());
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (OdaException odaException) {}
    }

    protected ConnectionPropertyHandler getPropertyHandler() {
        if (this.m_propertyHandler == null) {
            this.m_propertyHandler = new ConnectionPropertyHandler(null);
        }
        return this.m_propertyHandler;
    }

    private Properties getEffectiveProperties(Properties candidateProperties) throws OdaException {
        return this.getPropertyHandler().getEffectiveProperties(candidateProperties);
    }
}

