/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSetWithOneMoreDummyAggr;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.MergedAggregationResultSet;
import org.eclipse.birt.data.engine.olap.impl.query.AddingNestAggregations;
import org.eclipse.birt.data.engine.olap.impl.query.IPreparedCubeOperation;
import org.eclipse.birt.data.engine.olap.query.view.AggregationRegisterTable;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.util.CubeAggrDefn;
import org.eclipse.birt.data.engine.olap.util.CubeNestAggrDefn;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.mozilla.javascript.Scriptable;

public class PreparedAddingNestAggregations
implements IPreparedCubeOperation {
    private AddingNestAggregations cubeOperation;
    private CubeNestAggrDefn[] aggrDefns;
    private CalculatedMember[] newMembers;
    private List<AggregationDefinition> ads;

    public PreparedAddingNestAggregations() throws DataException {
    }

    public PreparedAddingNestAggregations(AddingNestAggregations cubeOperation) throws DataException {
        assert (cubeOperation != null);
        this.cubeOperation = cubeOperation;
    }

    @Override
    public void prepare(Scriptable scope, ScriptContext cx, AggregationRegisterTable manager, IBinding[] basedBindings, ICubeQueryDefinition cubeQueryDefn) throws DataException {
        this.aggrDefns = OlapExpressionUtil.getAggrDefnsByNestBinding(Arrays.asList(this.cubeOperation.getNewBindings()), basedBindings);
        this.newMembers = CubeQueryDefinitionUtil.addCalculatedMembers(this.aggrDefns, manager, scope, cx);
        this.ads = new ArrayList<AggregationDefinition>();
        int i = 0;
        while (i < this.aggrDefns.length) {
            AggregationDefinition[] aggrs = CubeQueryDefinitionUtil.createAggregationDefinitons(new CalculatedMember[]{this.newMembers[i]}, cubeQueryDefn, scope, cx);
            this.ads.add(aggrs[0]);
            ++i;
        }
    }

    public void prepare(Scriptable scope, ScriptContext cx, AggregationRegisterTable manager, CubeNestAggrDefn[] aggrDefns, List<AggregationDefinition> aggregationList) throws DataException {
        this.aggrDefns = aggrDefns;
        this.newMembers = CubeQueryDefinitionUtil.addCalculatedMembers(aggrDefns, manager, scope, cx);
        this.ads = aggregationList;
    }

    @Override
    public IAggregationResultSet[] execute(IAggregationResultSet[] sources, Scriptable scope, ScriptContext cx, StopSign stopSign) throws IOException, BirtException {
        ArrayList<IAggregationResultSet> currentSources = new ArrayList<IAggregationResultSet>(Arrays.asList(sources));
        int index = 0;
        CubeNestAggrDefn[] cubeNestAggrDefnArray = this.aggrDefns;
        int n = this.aggrDefns.length;
        int n2 = 0;
        while (n2 < n) {
            CubeNestAggrDefn cnaf = cubeNestAggrDefnArray[n2];
            if (stopSign.isStopped()) break;
            List referencedBindings = ExpressionCompilerUtil.extractColumnExpression(cnaf.getBasedExpression(), "data");
            if (referencedBindings == null || referencedBindings.isEmpty()) {
                throw new DataException("data.engine.aggregation.InvalidBindingExpression");
            }
            String firstReference = (String)referencedBindings.get(0);
            IAggregationResultSet newArs = null;
            boolean matchedAggrOns = true;
            int i = 0;
            while (i < sources.length && !stopSign.isStopped()) {
                IAggregationResultSet ars = sources[i];
                if (!PreparedAddingNestAggregations.isResultForRunningAggregation(ars) && ars.getAggregationIndex(firstReference) >= 0) {
                    AggregationResultSetWithOneMoreDummyAggr based = new AggregationResultSetWithOneMoreDummyAggr(ars, cnaf.getName(), cnaf.getBasedExpression(), scope, cx);
                    matchedAggrOns = PreparedAddingNestAggregations.checkAggregateOns(this.ads.get(index), based);
                    if (matchedAggrOns) {
                        newArs = AggregationHelper.execute(based, new AggregationDefinition[]{this.ads.get(index)}, stopSign)[0];
                        break;
                    }
                }
                ++i;
            }
            if (!matchedAggrOns) {
                throw new DataException("data.olap.InvalidNestAggregationOn", new Object[]{cnaf.getName()});
            }
            if (newArs == null) {
                throw new DataException("data.engine.aggregation.InvalidBindingExpression");
            }
            boolean merged = false;
            if (!PreparedAddingNestAggregations.isResultForRunningAggregation(newArs)) {
                int i2 = 0;
                while (i2 < currentSources.size() && !stopSign.isStopped()) {
                    IAggregationResultSet ars = (IAggregationResultSet)currentSources.get(i2);
                    if (!PreparedAddingNestAggregations.isResultForRunningAggregation(ars) && ars.getAggregationCount() > 0 && Arrays.deepEquals(ars.getAllLevels(), newArs.getAllLevels())) {
                        ars = new MergedAggregationResultSet(ars, newArs);
                        currentSources.set(i2, ars);
                        merged = true;
                        break;
                    }
                    ++i2;
                }
            }
            if (!merged) {
                currentSources.add(newArs);
            }
            ++index;
            ++n2;
        }
        return currentSources.toArray(new IAggregationResultSet[0]);
    }

    @Override
    public ICubeOperation getCubeOperation() {
        return this.cubeOperation;
    }

    @Override
    public List<AggregationDefinition> getAggregationDefintions() {
        return this.ads;
    }

    @Override
    public CubeAggrDefn[] getNewCubeAggrDefns() {
        return this.aggrDefns;
    }

    private static boolean isResultForRunningAggregation(IAggregationResultSet ars) throws DataException {
        AggregationFunctionDefinition[] afds;
        AggregationDefinition ad = ars.getAggregationDefinition();
        if (ad != null && (afds = ad.getAggregationFunctions()) != null && afds.length == 1) {
            String functionName = afds[0].getFunctionName();
            IAggrFunction af = AggregationManager.getInstance().getAggregation(functionName);
            return af != null && af.getType() == 1;
        }
        return false;
    }

    private static boolean checkAggregateOns(AggregationDefinition ad, IAggregationResultSet based) throws DataException {
        if (ad.getLevels() == null) {
            return true;
        }
        DimLevel[] dimLevelArray = ad.getLevels();
        int n = dimLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            DimLevel dl = dimLevelArray[n2];
            if (based.getLevelIndex(dl) < 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

