/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.jni;

import com.nvidia.viper.model.OpenMPSummary;

public class OpenMPAggregate
implements Comparable<OpenMPAggregate> {
    private String name;
    private long inclusiveTime;
    private long calls;
    private OpenMPSummary summary;

    public OpenMPAggregate(OpenMPSummary sum, String ompName) {
        this.setName(ompName);
        this.summary = sum;
    }

    public void incrementInclusiveTime(long time) {
        this.setInclusiveTime(this.getInclusiveTime() + time);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getInclusiveTime() {
        return this.inclusiveTime;
    }

    public void setInclusiveTime(long inclusiveTime) {
        this.inclusiveTime = inclusiveTime;
    }

    public long getCalls() {
        return this.calls;
    }

    public void setCalls(long calls) {
        this.calls = calls;
    }

    @Override
    public int compareTo(OpenMPAggregate o) {
        long difference = this.inclusiveTime - o.inclusiveTime;
        if (difference > 0L) {
            return 1;
        }
        if (difference < 0L) {
            return -1;
        }
        return 0;
    }

    public long getTotalTime() {
        return this.summary.getTotalTime();
    }
}

