/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSDecoratorConfiguration;
import org.eclipse.team.internal.ccvs.ui.CVSTeamStateDescription;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.ui.synchronize.TeamStateDescription;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public class CVSDecoration {
    public static final int MODEL = 1000;
    private String prefix;
    private String suffix;
    private ImageDescriptor overlay;
    private Color bkgColor;
    private Color fgColor;
    private Font font;
    private int resourceType = 1;
    private boolean watchEditEnabled = false;
    private boolean isDirty = false;
    private boolean isIgnored = false;
    private boolean isAdded = false;
    private boolean isNewResource = false;
    private boolean hasRemote = false;
    private boolean readOnly = false;
    private boolean needsMerge = false;
    private boolean virtualFolder = false;
    private String tag;
    private String revision;
    private String repository;
    private ICVSRepositoryLocation location;
    private String keywordSubstitution;
    private int stateFlags;
    private String fileFormatter;
    private String folderFormatter;
    private String projectFormatter;
    private static ImageDescriptor dirty = new CachedImageDescriptor(TeamUIPlugin.getImageDescriptor((String)"ovr/dirty_ov.gif"));
    private static ImageDescriptor checkedIn = new CachedImageDescriptor(TeamUIPlugin.getImageDescriptor((String)"ovr/version_controlled.gif"));
    private static ImageDescriptor noRemoteDir;
    private static ImageDescriptor added;
    private static ImageDescriptor merged;
    private static ImageDescriptor newResource;
    private static ImageDescriptor edited;
    private Preferences preferences;

    static {
        added = new CachedImageDescriptor(TeamUIPlugin.getImageDescriptor((String)"ovr/version_controlled.gif"));
        merged = new CachedImageDescriptor(CVSUIPlugin.getPlugin().getImageDescriptor("ovr16/merged_ov.gif"));
        newResource = new CachedImageDescriptor(CVSUIPlugin.getPlugin().getImageDescriptor("ovr16/question_ov.gif"));
        edited = new CachedImageDescriptor(CVSUIPlugin.getPlugin().getImageDescriptor("ovr16/edited_ov.gif"));
        noRemoteDir = new CachedImageDescriptor(CVSUIPlugin.getPlugin().getImageDescriptor("ovr16/no_remotedir_ov.gif"));
    }

    public CVSDecoration() {
        IPreferenceStore store = this.getStore();
        Preferences prefs = new Preferences();
        prefs.setValue("pref_show_overlaydirty", store.getBoolean("pref_show_overlaydirty"));
        prefs.setValue("pref_show_added", store.getBoolean("pref_show_added"));
        prefs.setValue("pref_show_hasremote", store.getBoolean("pref_show_hasremote"));
        prefs.setValue("pref_show_newresource", store.getBoolean("pref_show_newresource"));
        prefs.setValue("pref_calculate_dirty", store.getBoolean("pref_calculate_dirty"));
        prefs.setValue("pref_dirty_flag", store.getString("pref_dirty_flag"));
        prefs.setValue("pref_added_flag", store.getString("pref_added_flag"));
        prefs.setValue("pref_use_font_decorators", store.getString("pref_use_font_decorators"));
        this.initialize(prefs, store.getString("pref_filetext_decoration"), store.getString("pref_foldertext_decoration"), store.getString("pref_projecttext_decoration"));
    }

    public CVSDecoration(Preferences preferences, String fileFormater, String folderFormatter, String projectFormatter) {
        this.initialize(preferences, fileFormater, folderFormatter, projectFormatter);
    }

    private IPreferenceStore getStore() {
        return CVSUIPlugin.getPlugin().getPreferenceStore();
    }

    private void initialize(Preferences preferences, String fileFormater, String folderFormatter, String projectFormatter) {
        this.preferences = preferences;
        this.fileFormatter = CVSDecoration.updateOldDirtyFlag(fileFormater);
        this.folderFormatter = CVSDecoration.updateOldDirtyFlag(folderFormatter);
        this.projectFormatter = CVSDecoration.updateOldDirtyFlag(projectFormatter);
    }

    public static String updateOldDirtyFlag(String param) {
        return param.replaceAll("dirty_flag", "outgoing_change_flag");
    }

    public void addPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void addSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setForegroundColor(Color fgColor) {
        this.fgColor = fgColor;
    }

    public void setBackgroundColor(Color bkgColor) {
        this.bkgColor = bkgColor;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getBackgroundColor() {
        return this.bkgColor;
    }

    public Color getForegroundColor() {
        return this.fgColor;
    }

    public Font getFont() {
        return this.font;
    }

    public ImageDescriptor getOverlay() {
        return this.overlay;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setResourceType(int type) {
        this.resourceType = type;
    }

    public void apply(IDecoration decoration) {
        Font f;
        Color fc;
        Color bc;
        ImageDescriptor overlay;
        String prefix;
        this.compute();
        String suffix = this.getSuffix();
        if (suffix != null) {
            decoration.addSuffix(suffix);
        }
        if ((prefix = this.getPrefix()) != null) {
            decoration.addPrefix(prefix);
        }
        if ((overlay = this.getOverlay()) != null) {
            decoration.addOverlay(overlay);
        }
        if ((bc = this.getBackgroundColor()) != null) {
            decoration.setBackgroundColor(bc);
        }
        if ((fc = this.getForegroundColor()) != null) {
            decoration.setForegroundColor(fc);
        }
        if ((f = this.getFont()) != null) {
            decoration.setFont(f);
        }
    }

    public void compute() {
        this.computeText();
        this.overlay = this.computeImage();
        this.computeColorsAndFonts();
    }

    private void computeText() {
        if (this.isIgnored()) {
            return;
        }
        HashMap<String, String> bindings = new HashMap<String, String>();
        if (this.isDirty()) {
            bindings.put("outgoing_change_flag", this.preferences.getString("pref_dirty_flag"));
        }
        if (this.isAdded()) {
            bindings.put("added_flag", this.preferences.getString("pref_added_flag"));
        } else if (this.isHasRemote()) {
            bindings.put("revision", this.getRevision());
            bindings.put("tag", this.getTag());
        }
        bindings.put("keyword", this.getKeywordSubstitution());
        if ((this.resourceType == 2 || this.resourceType == 4) && this.location != null) {
            bindings.put("host", this.location.getHost());
            bindings.put("method", this.location.getMethod().getName());
            bindings.put("user", this.location.getUsername());
            bindings.put("root", this.location.getRootDirectory());
            bindings.put("repository", this.repository);
            RepositoryManager repositoryManager = CVSUIPlugin.getPlugin().getRepositoryManager();
            RepositoryRoot root = repositoryManager.getRepositoryRootFor(this.location);
            CVSUIPlugin.getPlugin().getRepositoryManager();
            String label = root.getName();
            if (label == null) {
                label = this.location.getLocation(true);
            }
            bindings.put("label", label);
        }
        CVSDecoratorConfiguration.decorate(this, this.getTextFormatter(), bindings);
    }

    private ImageDescriptor computeImage() {
        if (this.preferences.getBoolean("pref_show_newresource") && this.isNewResource()) {
            return newResource;
        }
        if (this.preferences.getBoolean("pref_show_overlaydirty") && this.isDirty()) {
            return dirty;
        }
        if (this.preferences.getBoolean("pref_show_added") && this.isAdded()) {
            return added;
        }
        if (this.isWatchEditEnabled() && this.resourceType == 1 && !this.isReadOnly() && this.isHasRemote()) {
            return edited;
        }
        if (this.needsMerge) {
            return merged;
        }
        if (this.preferences.getBoolean("pref_show_hasremote") && this.isHasRemote()) {
            if ((this.resourceType == 2 || this.resourceType == 4) && this.isVirtualFolder()) {
                return noRemoteDir;
            }
            return checkedIn;
        }
        return null;
    }

    private void computeColorsAndFonts() {
        if (!this.preferences.getBoolean("pref_use_font_decorators")) {
            return;
        }
        ITheme current = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        if (this.isIgnored()) {
            this.setBackgroundColor(current.getColorRegistry().get("org.eclipse.team.cvs.ui.fontsandcolors.ignored_resource_background_color"));
            this.setForegroundColor(current.getColorRegistry().get("org.eclipse.team.cvs.ui.fontsandcolors.ignored_resource_foreground_color"));
            this.setFont(current.getFontRegistry().get("org.eclipse.team.cvs.ui.fontsandcolors.ignored_resource_font"));
        } else if (this.isDirty()) {
            this.setBackgroundColor(current.getColorRegistry().get("org.eclipse.team.cvs.ui.fontsandcolors.outgoing_change_background_color"));
            this.setForegroundColor(current.getColorRegistry().get("org.eclipse.team.cvs.ui.fontsandcolors.outgoing_change_foreground_color"));
            this.setFont(current.getFontRegistry().get("org.eclipse.team.cvs.ui.fontsandcolors.outgoing_change_font"));
        }
    }

    private String getTextFormatter() {
        switch (this.resourceType) {
            case 1: {
                return this.fileFormatter;
            }
            case 2: {
                return this.folderFormatter;
            }
            case 4: {
                return this.projectFormatter;
            }
            case 1000: {
                return this.folderFormatter;
            }
        }
        return "no format specified";
    }

    public boolean isAdded() {
        return this.isAdded;
    }

    public void setAdded(boolean isAdded) {
        this.isAdded = isAdded;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public boolean isIgnored() {
        return this.isIgnored;
    }

    public void setIgnored(boolean isIgnored) {
        this.isIgnored = isIgnored;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean isWatchEditEnabled() {
        return this.watchEditEnabled;
    }

    public void setWatchEditEnabled(boolean watchEditEnabled) {
        this.watchEditEnabled = watchEditEnabled;
    }

    public boolean isNewResource() {
        return this.isNewResource;
    }

    public void setNewResource(boolean isNewResource) {
        this.isNewResource = isNewResource;
    }

    public void setLocation(ICVSRepositoryLocation location) {
        this.location = location;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getKeywordSubstitution() {
        return this.keywordSubstitution;
    }

    public void setKeywordSubstitution(String keywordSubstitution) {
        this.keywordSubstitution = keywordSubstitution;
    }

    public void setNeedsMerge(boolean needsMerge) {
        this.needsMerge = needsMerge;
    }

    public boolean isHasRemote() {
        return this.hasRemote;
    }

    public void setHasRemote(boolean hasRemote) {
        this.hasRemote = hasRemote;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isVirtualFolder() {
        return this.virtualFolder;
    }

    public void setVirtualFolder(boolean virtualFolder) {
        this.virtualFolder = virtualFolder;
    }

    public void setStateFlags(int stateFlags) {
        this.stateFlags = stateFlags;
        if ((stateFlags & 0x100) != 0) {
            this.setDirty(true);
        }
    }

    public TeamStateDescription asTeamStateDescription(String[] properties) {
        CVSTeamStateDescription desc = new CVSTeamStateDescription(this.stateFlags);
        ImageDescriptor o = this.computeImage();
        if (o != null && this.isRequestedProperty(properties, "resourceState")) {
            desc.setProperty("resourceState", o);
        }
        if (this.tag != null && this.isRequestedProperty(properties, "tag")) {
            desc.setProperty("tag", this.tag);
        }
        return desc;
    }

    private boolean isRequestedProperty(String[] properties, String property) {
        if (properties == null) {
            return true;
        }
        int i = 0;
        while (i < properties.length) {
            String string = properties[i];
            if (string.equals(property)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static class CachedImageDescriptor
    extends ImageDescriptor {
        ImageDescriptor descriptor;
        ImageData data;

        public CachedImageDescriptor(ImageDescriptor descriptor) {
            Assert.isNotNull((Object)descriptor);
            this.descriptor = descriptor;
        }

        public ImageData getImageData() {
            if (this.data == null) {
                this.data = this.descriptor.getImageData();
            }
            return this.data;
        }
    }
}

