/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.internal.core.model.ext.SourceRange;
import org.eclipse.cdt.internal.ui.actions.StructureSelectEnclosingAction;
import org.eclipse.cdt.internal.ui.actions.StructureSelectionAction;
import org.eclipse.cdt.internal.ui.editor.SelectionHistory;
import org.eclipse.ui.texteditor.ITextEditor;

public class StructureSelectNextAction
extends StructureSelectionAction {
    public static final String PREFIX = "StructureSelectNext.";

    public StructureSelectNextAction(ResourceBundle bundle, ITextEditor editor, SelectionHistory history) {
        super(bundle, PREFIX, editor, history);
    }

    @Override
    public ISourceRange doExpand(IASTTranslationUnit ast, SourceRange current) {
        ISourceRange newSourceRange = this.expandToNext(ast, current);
        if (newSourceRange == null) {
            newSourceRange = StructureSelectEnclosingAction.expandToEnclosing(ast, current);
        }
        if (newSourceRange != null) {
            this.history.remember((ISourceRange)current);
        }
        return newSourceRange;
    }

    private ISourceRange expandToNext(IASTTranslationUnit ast, SourceRange current) {
        IASTNode enclosingNode = ast.getNodeSelector(null).findEnclosingNode(current.getStartPos(), current.getLength());
        if (this.samePosition(enclosingNode, current)) {
            enclosingNode = enclosingNode.getParent();
        }
        if (enclosingNode == null) {
            return null;
        }
        int selectionEnd = current.getStartPos() + current.getLength();
        int lastSelectedChildIndex = -1;
        IASTNode[] children = enclosingNode.getChildren();
        int i = 0;
        while (i < children.length) {
            IASTNode node = children[i];
            if (this.nodeContains(node, selectionEnd)) {
                lastSelectedChildIndex = i;
                break;
            }
            ++i;
        }
        if (lastSelectedChildIndex != -1 && lastSelectedChildIndex + 1 < children.length) {
            IASTNode nextNode = children[lastSelectedChildIndex + 1];
            int endingOffset = nextNode.getFileLocation().getNodeOffset() + nextNode.getFileLocation().getNodeLength();
            return new SourceRange(current.getStartPos(), endingOffset - current.getStartPos());
        }
        return null;
    }
}

