var Cu = Components.utils;
var Ci = Components.interfaces;
var Cc = Components.classes;
var Cr = Components.results;

var jumlib = {};
Components.utils.import("resource://mozmill/modules/jum.js", jumlib);

Cu.import("resource://unity/unity-window-helper.js");

var topsrcDir;

function setupModule(module) {
    var localFile = Components.classes["@mozilla.org/file/local;1"]
        .createInstance(Components.interfaces.nsILocalFile);
    localFile.initWithPath(module.__file__);
    topsrcDir = localFile.parent.parent.path;

    module.controller = mozmill.getBrowserController();
}

function testRaiseCallback() {
    controller.open(topsrcDir + '/html-tests/big-test/big-test.html');
    controller.waitForPageLoad();

    var current = controller.tabs.activeTab;
    var windowHelper = new UnityWindowHelper(new XPCNativeWrapper(controller.tabs.activeTab.defaultView));

    controller.tabs.selectTabIndex(controller.tabs.length - 1);
    jumlib.assertNotEquals(current, controller.tabs.activeTab);

    windowHelper.makeRaiseCallback()(1, { isNull: function() {return true;} }, null);
    jumlib.assertEquals(current, controller.tabs.activeTab);
}

function testCloseCallback() {
    controller.open(topsrcDir + '/html-tests/big-test/big-test.html');
    controller.waitForPageLoad();

    var current = controller.tabs.activeTab;
    var windowHelper = new UnityWindowHelper(new XPCNativeWrapper(controller.tabs.activeTab.defaultView));

    windowHelper.makeCloseCallback()();
    jumlib.assertNotEquals(current, controller.tabs.activeTab);
}
