﻿//---------------------------------------------------------------------
// <copyright file="SqlSpatialServices.Generated.cs" company="Microsoft">
//      Copyright (c) Microsoft Corporation.  All rights reserved.
// </copyright>
//
// @owner       willa
// @backupOwner [....]
//--------------------------------------------------------------------------
// This file is automatically generated and should not be changed directly.
//
// See %SDXROOT%\ndp\fx\test\DataEntity\CheckinTests\Metadata\MetadataUnitTests.sln
// for the spatial functions unit test that generates this file.
//
// See %SDXROOT%\ddsuites\src\fx\DataEntity\Spatial\Functions
// for the template for this file.
//
//--------------------------------------------------------------------------

using System.Data.Common.Utils;
using System.Data.Spatial;
using System.Diagnostics;
using System.Reflection;
using System.Runtime.Serialization;

namespace System.Data.SqlClient
{
    internal sealed partial class SqlSpatialServices : DbSpatialServices
    {        
        public override System.Data.Spatial.DbGeography GeographyFromText(string geographyText)
        {
            object sqlGeographyText = ConvertToSqlString(geographyText, "geographyText");
            object result = smi_SqlGeography_Parse.Value.Invoke(null, new object[] { sqlGeographyText });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyFromText(string geographyText, int srid)
        {
            object sqlGeographyText = ConvertToSqlChars(geographyText, "geographyText");
            object result = smi_SqlGeography_STGeomFromText.Value.Invoke(null, new object[] { sqlGeographyText, srid });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyPointFromText(string pointText, int srid)
        {
            object sqlPointText = ConvertToSqlChars(pointText, "pointText");
            object result = smi_SqlGeography_STPointFromText.Value.Invoke(null, new object[] { sqlPointText, srid });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyLineFromText(string lineText, int srid)
        {
            object sqlLineText = ConvertToSqlChars(lineText, "lineText");
            object result = smi_SqlGeography_STLineFromText.Value.Invoke(null, new object[] { sqlLineText, srid });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyPolygonFromText(string polygonText, int srid)
        {
            object sqlPolygonText = ConvertToSqlChars(polygonText, "polygonText");
            object result = smi_SqlGeography_STPolyFromText.Value.Invoke(null, new object[] { sqlPolygonText, srid });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyMultiPointFromText(string multiPointText, int srid)
        {
            object sqlMultiPointText = ConvertToSqlChars(multiPointText, "multiPointText");
            object result = smi_SqlGeography_STMPointFromText.Value.Invoke(null, new object[] { sqlMultiPointText, srid });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyMultiLineFromText(string multiLineText, int srid)
        {
            object sqlMultiLineText = ConvertToSqlChars(multiLineText, "multiLineText");
            object result = smi_SqlGeography_STMLineFromText.Value.Invoke(null, new object[] { sqlMultiLineText, srid });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyMultiPolygonFromText(string multiPolygonText, int srid)
        {
            object sqlMultiPolygonText = ConvertToSqlChars(multiPolygonText, "multiPolygonText");
            object result = smi_SqlGeography_STMPolyFromText.Value.Invoke(null, new object[] { sqlMultiPolygonText, srid });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyCollectionFromText(string geographyCollectionText, int srid)
        {
            object sqlGeographyCollectionText = ConvertToSqlChars(geographyCollectionText, "geographyCollectionText");
            object result = smi_SqlGeography_STGeomCollFromText.Value.Invoke(null, new object[] { sqlGeographyCollectionText, srid });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyFromBinary(byte[] geographyBytes, int srid)
        {
            object sqlGeographyBytes = ConvertToSqlBytes(geographyBytes, "geographyBytes");
            object result = smi_SqlGeography_STGeomFromWKB.Value.Invoke(null, new object[] { sqlGeographyBytes, srid });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyFromBinary(byte[] geographyBytes)
        {
            object sqlGeographyBytes = ConvertToSqlBytes(geographyBytes, "geographyBytes");
            object result = smi_SqlGeography_STGeomFromWKB.Value.Invoke(null, new object[] { sqlGeographyBytes, 4326 });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyPointFromBinary(byte[] pointBytes, int srid)
        {
            object sqlPointBytes = ConvertToSqlBytes(pointBytes, "pointBytes");
            object result = smi_SqlGeography_STPointFromWKB.Value.Invoke(null, new object[] { sqlPointBytes, srid });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyLineFromBinary(byte[] lineBytes, int srid)
        {
            object sqlLineBytes = ConvertToSqlBytes(lineBytes, "lineBytes");
            object result = smi_SqlGeography_STLineFromWKB.Value.Invoke(null, new object[] { sqlLineBytes, srid });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyPolygonFromBinary(byte[] polygonBytes, int srid)
        {
            object sqlPolygonBytes = ConvertToSqlBytes(polygonBytes, "polygonBytes");
            object result = smi_SqlGeography_STPolyFromWKB.Value.Invoke(null, new object[] { sqlPolygonBytes, srid });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyMultiPointFromBinary(byte[] multiPointBytes, int srid)
        {
            object sqlMultiPointBytes = ConvertToSqlBytes(multiPointBytes, "multiPointBytes");
            object result = smi_SqlGeography_STMPointFromWKB.Value.Invoke(null, new object[] { sqlMultiPointBytes, srid });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyMultiLineFromBinary(byte[] multiLineBytes, int srid)
        {
            object sqlMultiLineBytes = ConvertToSqlBytes(multiLineBytes, "multiLineBytes");
            object result = smi_SqlGeography_STMLineFromWKB.Value.Invoke(null, new object[] { sqlMultiLineBytes, srid });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyMultiPolygonFromBinary(byte[] multiPolygonBytes, int srid)
        {
            object sqlMultiPolygonBytes = ConvertToSqlBytes(multiPolygonBytes, "multiPolygonBytes");
            object result = smi_SqlGeography_STMPolyFromWKB.Value.Invoke(null, new object[] { sqlMultiPolygonBytes, srid });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyCollectionFromBinary(byte[] geographyCollectionBytes, int srid)
        {
            object sqlGeographyCollectionBytes = ConvertToSqlBytes(geographyCollectionBytes, "geographyCollectionBytes");
            object result = smi_SqlGeography_STGeomCollFromWKB.Value.Invoke(null, new object[] { sqlGeographyCollectionBytes, srid });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyFromGml(string geographyGml)
        {
            object sqlGeographyGml = ConvertToSqlXml(geographyGml, "geographyGml");
            object result = smi_SqlGeography_GeomFromGml.Value.Invoke(null, new object[] { sqlGeographyGml, 4326 });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GeographyFromGml(string geographyGml, int srid)
        {
            object sqlGeographyGml = ConvertToSqlXml(geographyGml, "geographyGml");
            object result = smi_SqlGeography_GeomFromGml.Value.Invoke(null, new object[] { sqlGeographyGml, srid });
            return this.GeographyFromProviderValue(result);
        }

        public override int GetCoordinateSystemId(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = ipi_SqlGeography_STSrid.Value.GetValue(sqlGeographyValue, null);
            return ConvertSqlInt32ToInt(result);
        }

        public override string GetSpatialTypeName(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = imi_SqlGeography_STGeometryType.Value.Invoke(sqlGeographyValue, new object[] {  });
            return ConvertSqlStringToString(result);
        }

        public override int GetDimension(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = imi_SqlGeography_STDimension.Value.Invoke(sqlGeographyValue, new object[] {  });
            return ConvertSqlInt32ToInt(result);
        }

        public override byte[] AsBinary(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = imi_SqlGeography_STAsBinary.Value.Invoke(sqlGeographyValue, new object[] {  });
            return ConvertSqlBytesToBinary(result);
        }

        public override string AsGml(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = imi_SqlGeography_AsGml.Value.Invoke(sqlGeographyValue, new object[] {  });
            return ConvertSqlXmlToString(result);
        }

        public override string AsText(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = imi_SqlGeography_STAsText.Value.Invoke(sqlGeographyValue, new object[] {  });
            return ConvertSqlCharsToString(result);
        }

        public override bool GetIsEmpty(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = imi_SqlGeography_STIsEmpty.Value.Invoke(sqlGeographyValue, new object[] {  });
            return ConvertSqlBooleanToBoolean(result);
        }

        public override bool SpatialEquals(System.Data.Spatial.DbGeography geographyValue1, System.Data.Spatial.DbGeography geographyValue2)
        {
            geographyValue1.CheckNull("geographyValue1");
            object sqlGeographyValue1 = ConvertToSqlValue(geographyValue1, "geographyValue1");
            object sqlGeographyValue2 = ConvertToSqlValue(geographyValue2, "geographyValue2");
            object result = imi_SqlGeography_STEquals.Value.Invoke(sqlGeographyValue1, new object[] { sqlGeographyValue2 });
            return ConvertSqlBooleanToBoolean(result);
        }

        public override bool Disjoint(System.Data.Spatial.DbGeography geographyValue1, System.Data.Spatial.DbGeography geographyValue2)
        {
            geographyValue1.CheckNull("geographyValue1");
            object sqlGeographyValue1 = ConvertToSqlValue(geographyValue1, "geographyValue1");
            object sqlGeographyValue2 = ConvertToSqlValue(geographyValue2, "geographyValue2");
            object result = imi_SqlGeography_STDisjoint.Value.Invoke(sqlGeographyValue1, new object[] { sqlGeographyValue2 });
            return ConvertSqlBooleanToBoolean(result);
        }

        public override bool Intersects(System.Data.Spatial.DbGeography geographyValue1, System.Data.Spatial.DbGeography geographyValue2)
        {
            geographyValue1.CheckNull("geographyValue1");
            object sqlGeographyValue1 = ConvertToSqlValue(geographyValue1, "geographyValue1");
            object sqlGeographyValue2 = ConvertToSqlValue(geographyValue2, "geographyValue2");
            object result = imi_SqlGeography_STIntersects.Value.Invoke(sqlGeographyValue1, new object[] { sqlGeographyValue2 });
            return ConvertSqlBooleanToBoolean(result);
        }

        public override System.Data.Spatial.DbGeography Buffer(System.Data.Spatial.DbGeography geographyValue, double distance)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = imi_SqlGeography_STBuffer.Value.Invoke(sqlGeographyValue, new object[] { distance });
            return this.GeographyFromProviderValue(result);
        }

        public override double Distance(System.Data.Spatial.DbGeography geographyValue1, System.Data.Spatial.DbGeography geographyValue2)
        {
            geographyValue1.CheckNull("geographyValue1");
            object sqlGeographyValue1 = ConvertToSqlValue(geographyValue1, "geographyValue1");
            object sqlGeographyValue2 = ConvertToSqlValue(geographyValue2, "geographyValue2");
            object result = imi_SqlGeography_STDistance.Value.Invoke(sqlGeographyValue1, new object[] { sqlGeographyValue2 });
            return ConvertSqlDoubleToDouble(result);
        }

        public override System.Data.Spatial.DbGeography Intersection(System.Data.Spatial.DbGeography geographyValue1, System.Data.Spatial.DbGeography geographyValue2)
        {
            geographyValue1.CheckNull("geographyValue1");
            object sqlGeographyValue1 = ConvertToSqlValue(geographyValue1, "geographyValue1");
            object sqlGeographyValue2 = ConvertToSqlValue(geographyValue2, "geographyValue2");
            object result = imi_SqlGeography_STIntersection.Value.Invoke(sqlGeographyValue1, new object[] { sqlGeographyValue2 });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography Union(System.Data.Spatial.DbGeography geographyValue1, System.Data.Spatial.DbGeography geographyValue2)
        {
            geographyValue1.CheckNull("geographyValue1");
            object sqlGeographyValue1 = ConvertToSqlValue(geographyValue1, "geographyValue1");
            object sqlGeographyValue2 = ConvertToSqlValue(geographyValue2, "geographyValue2");
            object result = imi_SqlGeography_STUnion.Value.Invoke(sqlGeographyValue1, new object[] { sqlGeographyValue2 });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography Difference(System.Data.Spatial.DbGeography geometryValue1, System.Data.Spatial.DbGeography geometryValue2)
        {
            geometryValue1.CheckNull("geometryValue1");
            object sqlGeometryValue1 = ConvertToSqlValue(geometryValue1, "geometryValue1");
            object sqlGeometryValue2 = ConvertToSqlValue(geometryValue2, "geometryValue2");
            object result = imi_SqlGeography_STDifference.Value.Invoke(sqlGeometryValue1, new object[] { sqlGeometryValue2 });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography SymmetricDifference(System.Data.Spatial.DbGeography geometryValue1, System.Data.Spatial.DbGeography geometryValue2)
        {
            geometryValue1.CheckNull("geometryValue1");
            object sqlGeometryValue1 = ConvertToSqlValue(geometryValue1, "geometryValue1");
            object sqlGeometryValue2 = ConvertToSqlValue(geometryValue2, "geometryValue2");
            object result = imi_SqlGeography_STSymDifference.Value.Invoke(sqlGeometryValue1, new object[] { sqlGeometryValue2 });
            return this.GeographyFromProviderValue(result);
        }

        public override int? GetElementCount(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = imi_SqlGeography_STNumGeometries.Value.Invoke(sqlGeographyValue, new object[] {  });
            return ConvertSqlInt32ToNullableInt(result);
        }

        public override System.Data.Spatial.DbGeography ElementAt(System.Data.Spatial.DbGeography geographyValue, int nValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = imi_SqlGeography_STGeometryN.Value.Invoke(sqlGeographyValue, new object[] { nValue });
            return this.GeographyFromProviderValue(result);
        }

        public override double? GetLatitude(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = ipi_SqlGeography_Lat.Value.GetValue(sqlGeographyValue, null);
            return ConvertSqlDoubleToNullableDouble(result);
        }

        public override double? GetLongitude(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = ipi_SqlGeography_Long.Value.GetValue(sqlGeographyValue, null);
            return ConvertSqlDoubleToNullableDouble(result);
        }

        public override double? GetElevation(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = ipi_SqlGeography_Z.Value.GetValue(sqlGeographyValue, null);
            return ConvertSqlDoubleToNullableDouble(result);
        }

        public override double? GetMeasure(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = ipi_SqlGeography_M.Value.GetValue(sqlGeographyValue, null);
            return ConvertSqlDoubleToNullableDouble(result);
        }

        public override double? GetLength(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = imi_SqlGeography_STLength.Value.Invoke(sqlGeographyValue, new object[] {  });
            return ConvertSqlDoubleToNullableDouble(result);
        }

        public override System.Data.Spatial.DbGeography GetStartPoint(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = imi_SqlGeography_STStartPoint.Value.Invoke(sqlGeographyValue, new object[] {  });
            return this.GeographyFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeography GetEndPoint(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = imi_SqlGeography_STEndPoint.Value.Invoke(sqlGeographyValue, new object[] {  });
            return this.GeographyFromProviderValue(result);
        }

        public override bool? GetIsClosed(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = imi_SqlGeography_STIsClosed.Value.Invoke(sqlGeographyValue, new object[] {  });
            return ConvertSqlBooleanToNullableBoolean(result);
        }

        public override int? GetPointCount(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = imi_SqlGeography_STNumPoints.Value.Invoke(sqlGeographyValue, new object[] {  });
            return ConvertSqlInt32ToNullableInt(result);
        }

        public override System.Data.Spatial.DbGeography PointAt(System.Data.Spatial.DbGeography geographyValue, int nValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = imi_SqlGeography_STPointN.Value.Invoke(sqlGeographyValue, new object[] { nValue });
            return this.GeographyFromProviderValue(result);
        }

        public override double? GetArea(System.Data.Spatial.DbGeography geographyValue)
        {
            geographyValue.CheckNull("geographyValue");
            object sqlGeographyValue = ConvertToSqlValue(geographyValue, "geographyValue");
            object result = imi_SqlGeography_STArea.Value.Invoke(sqlGeographyValue, new object[] {  });
            return ConvertSqlDoubleToNullableDouble(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryFromText(string geometryText)
        {
            object sqlGeometryText = ConvertToSqlString(geometryText, "geometryText");
            object result = smi_SqlGeometry_Parse.Value.Invoke(null, new object[] { sqlGeometryText });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryFromText(string geometryText, int srid)
        {
            object sqlGeometryText = ConvertToSqlChars(geometryText, "geometryText");
            object result = smi_SqlGeometry_STGeomFromText.Value.Invoke(null, new object[] { sqlGeometryText, srid });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryPointFromText(string pointText, int srid)
        {
            object sqlPointText = ConvertToSqlChars(pointText, "pointText");
            object result = smi_SqlGeometry_STPointFromText.Value.Invoke(null, new object[] { sqlPointText, srid });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryLineFromText(string lineText, int srid)
        {
            object sqlLineText = ConvertToSqlChars(lineText, "lineText");
            object result = smi_SqlGeometry_STLineFromText.Value.Invoke(null, new object[] { sqlLineText, srid });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryPolygonFromText(string polygonText, int srid)
        {
            object sqlPolygonText = ConvertToSqlChars(polygonText, "polygonText");
            object result = smi_SqlGeometry_STPolyFromText.Value.Invoke(null, new object[] { sqlPolygonText, srid });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryMultiPointFromText(string multiPointText, int srid)
        {
            object sqlMultiPointText = ConvertToSqlChars(multiPointText, "multiPointText");
            object result = smi_SqlGeometry_STMPointFromText.Value.Invoke(null, new object[] { sqlMultiPointText, srid });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryMultiLineFromText(string multiLineText, int srid)
        {
            object sqlMultiLineText = ConvertToSqlChars(multiLineText, "multiLineText");
            object result = smi_SqlGeometry_STMLineFromText.Value.Invoke(null, new object[] { sqlMultiLineText, srid });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryMultiPolygonFromText(string multiPolygonText, int srid)
        {
            object sqlMultiPolygonText = ConvertToSqlChars(multiPolygonText, "multiPolygonText");
            object result = smi_SqlGeometry_STMPolyFromText.Value.Invoke(null, new object[] { sqlMultiPolygonText, srid });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryCollectionFromText(string geometryCollectionText, int srid)
        {
            object sqlGeometryCollectionText = ConvertToSqlChars(geometryCollectionText, "geometryCollectionText");
            object result = smi_SqlGeometry_STGeomCollFromText.Value.Invoke(null, new object[] { sqlGeometryCollectionText, srid });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryFromBinary(byte[] geometryBytes)
        {
            object sqlGeometryBytes = ConvertToSqlBytes(geometryBytes, "geometryBytes");
            object result = smi_SqlGeometry_STGeomFromWKB.Value.Invoke(null, new object[] { sqlGeometryBytes, 0 });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryFromBinary(byte[] geometryBytes, int srid)
        {
            object sqlGeometryBytes = ConvertToSqlBytes(geometryBytes, "geometryBytes");
            object result = smi_SqlGeometry_STGeomFromWKB.Value.Invoke(null, new object[] { sqlGeometryBytes, srid });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryPointFromBinary(byte[] pointBytes, int srid)
        {
            object sqlPointBytes = ConvertToSqlBytes(pointBytes, "pointBytes");
            object result = smi_SqlGeometry_STPointFromWKB.Value.Invoke(null, new object[] { sqlPointBytes, srid });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryLineFromBinary(byte[] lineBytes, int srid)
        {
            object sqlLineBytes = ConvertToSqlBytes(lineBytes, "lineBytes");
            object result = smi_SqlGeometry_STLineFromWKB.Value.Invoke(null, new object[] { sqlLineBytes, srid });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryPolygonFromBinary(byte[] polygonBytes, int srid)
        {
            object sqlPolygonBytes = ConvertToSqlBytes(polygonBytes, "polygonBytes");
            object result = smi_SqlGeometry_STPolyFromWKB.Value.Invoke(null, new object[] { sqlPolygonBytes, srid });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryMultiPointFromBinary(byte[] multiPointBytes, int srid)
        {
            object sqlMultiPointBytes = ConvertToSqlBytes(multiPointBytes, "multiPointBytes");
            object result = smi_SqlGeometry_STMPointFromWKB.Value.Invoke(null, new object[] { sqlMultiPointBytes, srid });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryMultiLineFromBinary(byte[] multiLineBytes, int srid)
        {
            object sqlMultiLineBytes = ConvertToSqlBytes(multiLineBytes, "multiLineBytes");
            object result = smi_SqlGeometry_STMLineFromWKB.Value.Invoke(null, new object[] { sqlMultiLineBytes, srid });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryMultiPolygonFromBinary(byte[] multiPolygonBytes, int srid)
        {
            object sqlMultiPolygonBytes = ConvertToSqlBytes(multiPolygonBytes, "multiPolygonBytes");
            object result = smi_SqlGeometry_STMPolyFromWKB.Value.Invoke(null, new object[] { sqlMultiPolygonBytes, srid });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryCollectionFromBinary(byte[] geometryCollectionBytes, int srid)
        {
            object sqlGeometryCollectionBytes = ConvertToSqlBytes(geometryCollectionBytes, "geometryCollectionBytes");
            object result = smi_SqlGeometry_STGeomCollFromWKB.Value.Invoke(null, new object[] { sqlGeometryCollectionBytes, srid });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryFromGml(string geometryGml)
        {
            object sqlGeometryGml = ConvertToSqlXml(geometryGml, "geometryGml");
            object result = smi_SqlGeometry_GeomFromGml.Value.Invoke(null, new object[] { sqlGeometryGml, 0 });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GeometryFromGml(string geometryGml, int srid)
        {
            object sqlGeometryGml = ConvertToSqlXml(geometryGml, "geometryGml");
            object result = smi_SqlGeometry_GeomFromGml.Value.Invoke(null, new object[] { sqlGeometryGml, srid });
            return this.GeometryFromProviderValue(result);
        }

        public override int GetCoordinateSystemId(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = ipi_SqlGeometry_STSrid.Value.GetValue(sqlGeometryValue, null);
            return ConvertSqlInt32ToInt(result);
        }

        public override string GetSpatialTypeName(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STGeometryType.Value.Invoke(sqlGeometryValue, new object[] {  });
            return ConvertSqlStringToString(result);
        }

        public override int GetDimension(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STDimension.Value.Invoke(sqlGeometryValue, new object[] {  });
            return ConvertSqlInt32ToInt(result);
        }

        public override System.Data.Spatial.DbGeometry GetEnvelope(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STEnvelope.Value.Invoke(sqlGeometryValue, new object[] {  });
            return this.GeometryFromProviderValue(result);
        }

        public override byte[] AsBinary(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STAsBinary.Value.Invoke(sqlGeometryValue, new object[] {  });
            return ConvertSqlBytesToBinary(result);
        }

        public override string AsGml(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_AsGml.Value.Invoke(sqlGeometryValue, new object[] {  });
            return ConvertSqlXmlToString(result);
        }

        public override string AsText(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STAsText.Value.Invoke(sqlGeometryValue, new object[] {  });
            return ConvertSqlCharsToString(result);
        }

        public override bool GetIsEmpty(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STIsEmpty.Value.Invoke(sqlGeometryValue, new object[] {  });
            return ConvertSqlBooleanToBoolean(result);
        }

        public override bool GetIsSimple(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STIsSimple.Value.Invoke(sqlGeometryValue, new object[] {  });
            return ConvertSqlBooleanToBoolean(result);
        }

        public override System.Data.Spatial.DbGeometry GetBoundary(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STBoundary.Value.Invoke(sqlGeometryValue, new object[] {  });
            return this.GeometryFromProviderValue(result);
        }

        public override bool GetIsValid(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STIsValid.Value.Invoke(sqlGeometryValue, new object[] {  });
            return ConvertSqlBooleanToBoolean(result);
        }

        public override bool SpatialEquals(System.Data.Spatial.DbGeometry geometryValue1, System.Data.Spatial.DbGeometry geometryValue2)
        {
            geometryValue1.CheckNull("geometryValue1");
            object sqlGeometryValue1 = ConvertToSqlValue(geometryValue1, "geometryValue1");
            object sqlGeometryValue2 = ConvertToSqlValue(geometryValue2, "geometryValue2");
            object result = imi_SqlGeometry_STEquals.Value.Invoke(sqlGeometryValue1, new object[] { sqlGeometryValue2 });
            return ConvertSqlBooleanToBoolean(result);
        }

        public override bool Disjoint(System.Data.Spatial.DbGeometry geometryValue1, System.Data.Spatial.DbGeometry geometryValue2)
        {
            geometryValue1.CheckNull("geometryValue1");
            object sqlGeometryValue1 = ConvertToSqlValue(geometryValue1, "geometryValue1");
            object sqlGeometryValue2 = ConvertToSqlValue(geometryValue2, "geometryValue2");
            object result = imi_SqlGeometry_STDisjoint.Value.Invoke(sqlGeometryValue1, new object[] { sqlGeometryValue2 });
            return ConvertSqlBooleanToBoolean(result);
        }

        public override bool Intersects(System.Data.Spatial.DbGeometry geometryValue1, System.Data.Spatial.DbGeometry geometryValue2)
        {
            geometryValue1.CheckNull("geometryValue1");
            object sqlGeometryValue1 = ConvertToSqlValue(geometryValue1, "geometryValue1");
            object sqlGeometryValue2 = ConvertToSqlValue(geometryValue2, "geometryValue2");
            object result = imi_SqlGeometry_STIntersects.Value.Invoke(sqlGeometryValue1, new object[] { sqlGeometryValue2 });
            return ConvertSqlBooleanToBoolean(result);
        }

        public override bool Touches(System.Data.Spatial.DbGeometry geometryValue1, System.Data.Spatial.DbGeometry geometryValue2)
        {
            geometryValue1.CheckNull("geometryValue1");
            object sqlGeometryValue1 = ConvertToSqlValue(geometryValue1, "geometryValue1");
            object sqlGeometryValue2 = ConvertToSqlValue(geometryValue2, "geometryValue2");
            object result = imi_SqlGeometry_STTouches.Value.Invoke(sqlGeometryValue1, new object[] { sqlGeometryValue2 });
            return ConvertSqlBooleanToBoolean(result);
        }

        public override bool Crosses(System.Data.Spatial.DbGeometry geometryValue1, System.Data.Spatial.DbGeometry geometryValue2)
        {
            geometryValue1.CheckNull("geometryValue1");
            object sqlGeometryValue1 = ConvertToSqlValue(geometryValue1, "geometryValue1");
            object sqlGeometryValue2 = ConvertToSqlValue(geometryValue2, "geometryValue2");
            object result = imi_SqlGeometry_STCrosses.Value.Invoke(sqlGeometryValue1, new object[] { sqlGeometryValue2 });
            return ConvertSqlBooleanToBoolean(result);
        }

        public override bool Within(System.Data.Spatial.DbGeometry geometryValue1, System.Data.Spatial.DbGeometry geometryValue2)
        {
            geometryValue1.CheckNull("geometryValue1");
            object sqlGeometryValue1 = ConvertToSqlValue(geometryValue1, "geometryValue1");
            object sqlGeometryValue2 = ConvertToSqlValue(geometryValue2, "geometryValue2");
            object result = imi_SqlGeometry_STWithin.Value.Invoke(sqlGeometryValue1, new object[] { sqlGeometryValue2 });
            return ConvertSqlBooleanToBoolean(result);
        }

        public override bool Contains(System.Data.Spatial.DbGeometry geometryValue1, System.Data.Spatial.DbGeometry geometryValue2)
        {
            geometryValue1.CheckNull("geometryValue1");
            object sqlGeometryValue1 = ConvertToSqlValue(geometryValue1, "geometryValue1");
            object sqlGeometryValue2 = ConvertToSqlValue(geometryValue2, "geometryValue2");
            object result = imi_SqlGeometry_STContains.Value.Invoke(sqlGeometryValue1, new object[] { sqlGeometryValue2 });
            return ConvertSqlBooleanToBoolean(result);
        }

        public override bool Overlaps(System.Data.Spatial.DbGeometry geometryValue1, System.Data.Spatial.DbGeometry geometryValue2)
        {
            geometryValue1.CheckNull("geometryValue1");
            object sqlGeometryValue1 = ConvertToSqlValue(geometryValue1, "geometryValue1");
            object sqlGeometryValue2 = ConvertToSqlValue(geometryValue2, "geometryValue2");
            object result = imi_SqlGeometry_STOverlaps.Value.Invoke(sqlGeometryValue1, new object[] { sqlGeometryValue2 });
            return ConvertSqlBooleanToBoolean(result);
        }

        public override bool Relate(System.Data.Spatial.DbGeometry geometryValue1, System.Data.Spatial.DbGeometry geometryValue2, string matrix)
        {
            geometryValue1.CheckNull("geometryValue1");
            object sqlGeometryValue1 = ConvertToSqlValue(geometryValue1, "geometryValue1");
            object sqlGeometryValue2 = ConvertToSqlValue(geometryValue2, "geometryValue2");
            object result = imi_SqlGeometry_STRelate.Value.Invoke(sqlGeometryValue1, new object[] { sqlGeometryValue2, matrix });
            return ConvertSqlBooleanToBoolean(result);
        }

        public override System.Data.Spatial.DbGeometry Buffer(System.Data.Spatial.DbGeometry geometryValue, double distance)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STBuffer.Value.Invoke(sqlGeometryValue, new object[] { distance });
            return this.GeometryFromProviderValue(result);
        }

        public override double Distance(System.Data.Spatial.DbGeometry geometryValue1, System.Data.Spatial.DbGeometry geometryValue2)
        {
            geometryValue1.CheckNull("geometryValue1");
            object sqlGeometryValue1 = ConvertToSqlValue(geometryValue1, "geometryValue1");
            object sqlGeometryValue2 = ConvertToSqlValue(geometryValue2, "geometryValue2");
            object result = imi_SqlGeometry_STDistance.Value.Invoke(sqlGeometryValue1, new object[] { sqlGeometryValue2 });
            return ConvertSqlDoubleToDouble(result);
        }

        public override System.Data.Spatial.DbGeometry GetConvexHull(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STConvexHull.Value.Invoke(sqlGeometryValue, new object[] {  });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry Intersection(System.Data.Spatial.DbGeometry geometryValue1, System.Data.Spatial.DbGeometry geometryValue2)
        {
            geometryValue1.CheckNull("geometryValue1");
            object sqlGeometryValue1 = ConvertToSqlValue(geometryValue1, "geometryValue1");
            object sqlGeometryValue2 = ConvertToSqlValue(geometryValue2, "geometryValue2");
            object result = imi_SqlGeometry_STIntersection.Value.Invoke(sqlGeometryValue1, new object[] { sqlGeometryValue2 });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry Union(System.Data.Spatial.DbGeometry geometryValue1, System.Data.Spatial.DbGeometry geometryValue2)
        {
            geometryValue1.CheckNull("geometryValue1");
            object sqlGeometryValue1 = ConvertToSqlValue(geometryValue1, "geometryValue1");
            object sqlGeometryValue2 = ConvertToSqlValue(geometryValue2, "geometryValue2");
            object result = imi_SqlGeometry_STUnion.Value.Invoke(sqlGeometryValue1, new object[] { sqlGeometryValue2 });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry Difference(System.Data.Spatial.DbGeometry geometryValue1, System.Data.Spatial.DbGeometry geometryValue2)
        {
            geometryValue1.CheckNull("geometryValue1");
            object sqlGeometryValue1 = ConvertToSqlValue(geometryValue1, "geometryValue1");
            object sqlGeometryValue2 = ConvertToSqlValue(geometryValue2, "geometryValue2");
            object result = imi_SqlGeometry_STDifference.Value.Invoke(sqlGeometryValue1, new object[] { sqlGeometryValue2 });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry SymmetricDifference(System.Data.Spatial.DbGeometry geometryValue1, System.Data.Spatial.DbGeometry geometryValue2)
        {
            geometryValue1.CheckNull("geometryValue1");
            object sqlGeometryValue1 = ConvertToSqlValue(geometryValue1, "geometryValue1");
            object sqlGeometryValue2 = ConvertToSqlValue(geometryValue2, "geometryValue2");
            object result = imi_SqlGeometry_STSymDifference.Value.Invoke(sqlGeometryValue1, new object[] { sqlGeometryValue2 });
            return this.GeometryFromProviderValue(result);
        }

        public override int? GetElementCount(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STNumGeometries.Value.Invoke(sqlGeometryValue, new object[] {  });
            return ConvertSqlInt32ToNullableInt(result);
        }

        public override System.Data.Spatial.DbGeometry ElementAt(System.Data.Spatial.DbGeometry geometryValue, int nValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STGeometryN.Value.Invoke(sqlGeometryValue, new object[] { nValue });
            return this.GeometryFromProviderValue(result);
        }

        public override double? GetXCoordinate(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = ipi_SqlGeometry_STX.Value.GetValue(sqlGeometryValue, null);
            return ConvertSqlDoubleToNullableDouble(result);
        }

        public override double? GetYCoordinate(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = ipi_SqlGeometry_STY.Value.GetValue(sqlGeometryValue, null);
            return ConvertSqlDoubleToNullableDouble(result);
        }

        public override double? GetElevation(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = ipi_SqlGeometry_Z.Value.GetValue(sqlGeometryValue, null);
            return ConvertSqlDoubleToNullableDouble(result);
        }

        public override double? GetMeasure(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = ipi_SqlGeometry_M.Value.GetValue(sqlGeometryValue, null);
            return ConvertSqlDoubleToNullableDouble(result);
        }

        public override double? GetLength(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STLength.Value.Invoke(sqlGeometryValue, new object[] {  });
            return ConvertSqlDoubleToNullableDouble(result);
        }

        public override System.Data.Spatial.DbGeometry GetStartPoint(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STStartPoint.Value.Invoke(sqlGeometryValue, new object[] {  });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GetEndPoint(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STEndPoint.Value.Invoke(sqlGeometryValue, new object[] {  });
            return this.GeometryFromProviderValue(result);
        }

        public override bool? GetIsClosed(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STIsClosed.Value.Invoke(sqlGeometryValue, new object[] {  });
            return ConvertSqlBooleanToNullableBoolean(result);
        }

        public override bool? GetIsRing(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STIsRing.Value.Invoke(sqlGeometryValue, new object[] {  });
            return ConvertSqlBooleanToNullableBoolean(result);
        }

        public override int? GetPointCount(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STNumPoints.Value.Invoke(sqlGeometryValue, new object[] {  });
            return ConvertSqlInt32ToNullableInt(result);
        }

        public override System.Data.Spatial.DbGeometry PointAt(System.Data.Spatial.DbGeometry geometryValue, int nValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STPointN.Value.Invoke(sqlGeometryValue, new object[] { nValue });
            return this.GeometryFromProviderValue(result);
        }

        public override double? GetArea(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STArea.Value.Invoke(sqlGeometryValue, new object[] {  });
            return ConvertSqlDoubleToNullableDouble(result);
        }

        public override System.Data.Spatial.DbGeometry GetCentroid(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STCentroid.Value.Invoke(sqlGeometryValue, new object[] {  });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GetPointOnSurface(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STPointOnSurface.Value.Invoke(sqlGeometryValue, new object[] {  });
            return this.GeometryFromProviderValue(result);
        }

        public override System.Data.Spatial.DbGeometry GetExteriorRing(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STExteriorRing.Value.Invoke(sqlGeometryValue, new object[] {  });
            return this.GeometryFromProviderValue(result);
        }

        public override int? GetInteriorRingCount(System.Data.Spatial.DbGeometry geometryValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STNumInteriorRing.Value.Invoke(sqlGeometryValue, new object[] {  });
            return ConvertSqlInt32ToNullableInt(result);
        }

        public override System.Data.Spatial.DbGeometry InteriorRingAt(System.Data.Spatial.DbGeometry geometryValue, int nValue)
        {
            geometryValue.CheckNull("geometryValue");
            object sqlGeometryValue = ConvertToSqlValue(geometryValue, "geometryValue");
            object result = imi_SqlGeometry_STInteriorRingN.Value.Invoke(sqlGeometryValue, new object[] { nValue });
            return this.GeometryFromProviderValue(result);
        }

        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_Parse;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_STGeomFromText;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_STPointFromText;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_STLineFromText;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_STPolyFromText;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_STMPointFromText;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_STMLineFromText;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_STMPolyFromText;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_STGeomCollFromText;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_STGeomFromWKB;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_STPointFromWKB;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_STLineFromWKB;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_STPolyFromWKB;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_STMPointFromWKB;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_STMLineFromWKB;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_STMPolyFromWKB;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_STGeomCollFromWKB;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeography_GeomFromGml;
        [NonSerialized]
        private Singleton<PropertyInfo> ipi_SqlGeography_STSrid;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STGeometryType;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STDimension;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STAsBinary;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_AsGml;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STAsText;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STIsEmpty;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STEquals;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STDisjoint;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STIntersects;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STBuffer;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STDistance;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STIntersection;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STUnion;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STDifference;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STSymDifference;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STNumGeometries;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STGeometryN;
        [NonSerialized]
        private Singleton<PropertyInfo> ipi_SqlGeography_Lat;
        [NonSerialized]
        private Singleton<PropertyInfo> ipi_SqlGeography_Long;
        [NonSerialized]
        private Singleton<PropertyInfo> ipi_SqlGeography_Z;
        [NonSerialized]
        private Singleton<PropertyInfo> ipi_SqlGeography_M;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STLength;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STStartPoint;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STEndPoint;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STIsClosed;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STNumPoints;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STPointN;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeography_STArea;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_Parse;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_STGeomFromText;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_STPointFromText;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_STLineFromText;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_STPolyFromText;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_STMPointFromText;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_STMLineFromText;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_STMPolyFromText;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_STGeomCollFromText;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_STGeomFromWKB;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_STPointFromWKB;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_STLineFromWKB;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_STPolyFromWKB;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_STMPointFromWKB;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_STMLineFromWKB;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_STMPolyFromWKB;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_STGeomCollFromWKB;
        [NonSerialized]
        private Singleton<MethodInfo> smi_SqlGeometry_GeomFromGml;
        [NonSerialized]
        private Singleton<PropertyInfo> ipi_SqlGeometry_STSrid;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STGeometryType;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STDimension;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STEnvelope;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STAsBinary;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_AsGml;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STAsText;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STIsEmpty;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STIsSimple;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STBoundary;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STIsValid;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STEquals;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STDisjoint;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STIntersects;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STTouches;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STCrosses;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STWithin;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STContains;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STOverlaps;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STRelate;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STBuffer;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STDistance;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STConvexHull;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STIntersection;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STUnion;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STDifference;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STSymDifference;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STNumGeometries;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STGeometryN;
        [NonSerialized]
        private Singleton<PropertyInfo> ipi_SqlGeometry_STX;
        [NonSerialized]
        private Singleton<PropertyInfo> ipi_SqlGeometry_STY;
        [NonSerialized]
        private Singleton<PropertyInfo> ipi_SqlGeometry_Z;
        [NonSerialized]
        private Singleton<PropertyInfo> ipi_SqlGeometry_M;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STLength;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STStartPoint;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STEndPoint;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STIsClosed;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STIsRing;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STNumPoints;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STPointN;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STArea;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STCentroid;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STPointOnSurface;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STExteriorRing;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STNumInteriorRing;
        [NonSerialized]
        private Singleton<MethodInfo> imi_SqlGeometry_STInteriorRingN;

        private void InitializeMemberInfo()
        {
            this.smi_SqlGeography_Parse              = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("Parse", SqlTypes.SqlStringType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member Parse"); return result; });
            this.smi_SqlGeography_STGeomFromText     = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("STGeomFromText", SqlTypes.SqlCharsType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STGeomFromText"); return result; });
            this.smi_SqlGeography_STPointFromText    = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("STPointFromText", SqlTypes.SqlCharsType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STPointFromText"); return result; });
            this.smi_SqlGeography_STLineFromText     = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("STLineFromText", SqlTypes.SqlCharsType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STLineFromText"); return result; });
            this.smi_SqlGeography_STPolyFromText     = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("STPolyFromText", SqlTypes.SqlCharsType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STPolyFromText"); return result; });
            this.smi_SqlGeography_STMPointFromText   = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("STMPointFromText", SqlTypes.SqlCharsType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STMPointFromText"); return result; });
            this.smi_SqlGeography_STMLineFromText    = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("STMLineFromText", SqlTypes.SqlCharsType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STMLineFromText"); return result; });
            this.smi_SqlGeography_STMPolyFromText    = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("STMPolyFromText", SqlTypes.SqlCharsType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STMPolyFromText"); return result; });
            this.smi_SqlGeography_STGeomCollFromText = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("STGeomCollFromText", SqlTypes.SqlCharsType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STGeomCollFromText"); return result; });
            this.smi_SqlGeography_STGeomFromWKB      = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("STGeomFromWKB", SqlTypes.SqlBytesType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STGeomFromWKB"); return result; });
            this.smi_SqlGeography_STPointFromWKB     = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("STPointFromWKB", SqlTypes.SqlBytesType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STPointFromWKB"); return result; });
            this.smi_SqlGeography_STLineFromWKB      = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("STLineFromWKB", SqlTypes.SqlBytesType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STLineFromWKB"); return result; });
            this.smi_SqlGeography_STPolyFromWKB      = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("STPolyFromWKB", SqlTypes.SqlBytesType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STPolyFromWKB"); return result; });
            this.smi_SqlGeography_STMPointFromWKB    = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("STMPointFromWKB", SqlTypes.SqlBytesType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STMPointFromWKB"); return result; });
            this.smi_SqlGeography_STMLineFromWKB     = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("STMLineFromWKB", SqlTypes.SqlBytesType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STMLineFromWKB"); return result; });
            this.smi_SqlGeography_STMPolyFromWKB     = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("STMPolyFromWKB", SqlTypes.SqlBytesType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STMPolyFromWKB"); return result; });
            this.smi_SqlGeography_STGeomCollFromWKB  = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("STGeomCollFromWKB", SqlTypes.SqlBytesType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STGeomCollFromWKB"); return result; });
            this.smi_SqlGeography_GeomFromGml        = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyStaticMethod("GeomFromGml", SqlTypes.SqlXmlType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member GeomFromGml"); return result; });
            this.ipi_SqlGeography_STSrid             = new Singleton<PropertyInfo>(() => { PropertyInfo result = FindSqlGeographyProperty("STSrid"); Debug.Assert(result != null, "Could not retrieve PropertyInfo for SqlGeography member STSrid"); return result; });
            this.imi_SqlGeography_STGeometryType     = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STGeometryType"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STGeometryType"); return result; });
            this.imi_SqlGeography_STDimension        = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STDimension"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STDimension"); return result; });
            this.imi_SqlGeography_STAsBinary         = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STAsBinary"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STAsBinary"); return result; });
            this.imi_SqlGeography_AsGml              = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("AsGml"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member AsGml"); return result; });
            this.imi_SqlGeography_STAsText           = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STAsText"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STAsText"); return result; });
            this.imi_SqlGeography_STIsEmpty          = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STIsEmpty"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STIsEmpty"); return result; });
            this.imi_SqlGeography_STEquals           = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STEquals", SqlTypes.SqlGeographyType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STEquals"); return result; });
            this.imi_SqlGeography_STDisjoint         = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STDisjoint", SqlTypes.SqlGeographyType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STDisjoint"); return result; });
            this.imi_SqlGeography_STIntersects       = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STIntersects", SqlTypes.SqlGeographyType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STIntersects"); return result; });
            this.imi_SqlGeography_STBuffer           = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STBuffer", typeof(double)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STBuffer"); return result; });
            this.imi_SqlGeography_STDistance         = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STDistance", SqlTypes.SqlGeographyType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STDistance"); return result; });
            this.imi_SqlGeography_STIntersection     = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STIntersection", SqlTypes.SqlGeographyType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STIntersection"); return result; });
            this.imi_SqlGeography_STUnion            = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STUnion", SqlTypes.SqlGeographyType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STUnion"); return result; });
            this.imi_SqlGeography_STDifference       = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STDifference", SqlTypes.SqlGeographyType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STDifference"); return result; });
            this.imi_SqlGeography_STSymDifference    = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STSymDifference", SqlTypes.SqlGeographyType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STSymDifference"); return result; });
            this.imi_SqlGeography_STNumGeometries    = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STNumGeometries"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STNumGeometries"); return result; });
            this.imi_SqlGeography_STGeometryN        = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STGeometryN", typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STGeometryN"); return result; });
            this.ipi_SqlGeography_Lat                = new Singleton<PropertyInfo>(() => { PropertyInfo result = FindSqlGeographyProperty("Lat"); Debug.Assert(result != null, "Could not retrieve PropertyInfo for SqlGeography member Lat"); return result; });
            this.ipi_SqlGeography_Long               = new Singleton<PropertyInfo>(() => { PropertyInfo result = FindSqlGeographyProperty("Long"); Debug.Assert(result != null, "Could not retrieve PropertyInfo for SqlGeography member Long"); return result; });
            this.ipi_SqlGeography_Z                  = new Singleton<PropertyInfo>(() => { PropertyInfo result = FindSqlGeographyProperty("Z"); Debug.Assert(result != null, "Could not retrieve PropertyInfo for SqlGeography member Z"); return result; });
            this.ipi_SqlGeography_M                  = new Singleton<PropertyInfo>(() => { PropertyInfo result = FindSqlGeographyProperty("M"); Debug.Assert(result != null, "Could not retrieve PropertyInfo for SqlGeography member M"); return result; });
            this.imi_SqlGeography_STLength           = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STLength"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STLength"); return result; });
            this.imi_SqlGeography_STStartPoint       = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STStartPoint"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STStartPoint"); return result; });
            this.imi_SqlGeography_STEndPoint         = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STEndPoint"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STEndPoint"); return result; });
            this.imi_SqlGeography_STIsClosed         = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STIsClosed"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STIsClosed"); return result; });
            this.imi_SqlGeography_STNumPoints        = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STNumPoints"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STNumPoints"); return result; });
            this.imi_SqlGeography_STPointN           = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STPointN", typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STPointN"); return result; });
            this.imi_SqlGeography_STArea             = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeographyMethod("STArea"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeography member STArea"); return result; });
            this.smi_SqlGeometry_Parse              = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("Parse", SqlTypes.SqlStringType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member Parse"); return result; });
            this.smi_SqlGeometry_STGeomFromText     = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("STGeomFromText", SqlTypes.SqlCharsType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STGeomFromText"); return result; });
            this.smi_SqlGeometry_STPointFromText    = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("STPointFromText", SqlTypes.SqlCharsType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STPointFromText"); return result; });
            this.smi_SqlGeometry_STLineFromText     = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("STLineFromText", SqlTypes.SqlCharsType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STLineFromText"); return result; });
            this.smi_SqlGeometry_STPolyFromText     = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("STPolyFromText", SqlTypes.SqlCharsType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STPolyFromText"); return result; });
            this.smi_SqlGeometry_STMPointFromText   = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("STMPointFromText", SqlTypes.SqlCharsType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STMPointFromText"); return result; });
            this.smi_SqlGeometry_STMLineFromText    = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("STMLineFromText", SqlTypes.SqlCharsType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STMLineFromText"); return result; });
            this.smi_SqlGeometry_STMPolyFromText    = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("STMPolyFromText", SqlTypes.SqlCharsType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STMPolyFromText"); return result; });
            this.smi_SqlGeometry_STGeomCollFromText = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("STGeomCollFromText", SqlTypes.SqlCharsType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STGeomCollFromText"); return result; });
            this.smi_SqlGeometry_STGeomFromWKB      = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("STGeomFromWKB", SqlTypes.SqlBytesType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STGeomFromWKB"); return result; });
            this.smi_SqlGeometry_STPointFromWKB     = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("STPointFromWKB", SqlTypes.SqlBytesType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STPointFromWKB"); return result; });
            this.smi_SqlGeometry_STLineFromWKB      = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("STLineFromWKB", SqlTypes.SqlBytesType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STLineFromWKB"); return result; });
            this.smi_SqlGeometry_STPolyFromWKB      = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("STPolyFromWKB", SqlTypes.SqlBytesType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STPolyFromWKB"); return result; });
            this.smi_SqlGeometry_STMPointFromWKB    = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("STMPointFromWKB", SqlTypes.SqlBytesType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STMPointFromWKB"); return result; });
            this.smi_SqlGeometry_STMLineFromWKB     = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("STMLineFromWKB", SqlTypes.SqlBytesType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STMLineFromWKB"); return result; });
            this.smi_SqlGeometry_STMPolyFromWKB     = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("STMPolyFromWKB", SqlTypes.SqlBytesType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STMPolyFromWKB"); return result; });
            this.smi_SqlGeometry_STGeomCollFromWKB  = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("STGeomCollFromWKB", SqlTypes.SqlBytesType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STGeomCollFromWKB"); return result; });
            this.smi_SqlGeometry_GeomFromGml        = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryStaticMethod("GeomFromGml", SqlTypes.SqlXmlType, typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member GeomFromGml"); return result; });
            this.ipi_SqlGeometry_STSrid             = new Singleton<PropertyInfo>(() => { PropertyInfo result = FindSqlGeometryProperty("STSrid"); Debug.Assert(result != null, "Could not retrieve PropertyInfo for SqlGeometry member STSrid"); return result; });
            this.imi_SqlGeometry_STGeometryType     = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STGeometryType"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STGeometryType"); return result; });
            this.imi_SqlGeometry_STDimension        = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STDimension"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STDimension"); return result; });
            this.imi_SqlGeometry_STEnvelope         = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STEnvelope"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STEnvelope"); return result; });
            this.imi_SqlGeometry_STAsBinary         = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STAsBinary"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STAsBinary"); return result; });
            this.imi_SqlGeometry_AsGml              = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("AsGml"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member AsGml"); return result; });
            this.imi_SqlGeometry_STAsText           = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STAsText"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STAsText"); return result; });
            this.imi_SqlGeometry_STIsEmpty          = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STIsEmpty"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STIsEmpty"); return result; });
            this.imi_SqlGeometry_STIsSimple         = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STIsSimple"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STIsSimple"); return result; });
            this.imi_SqlGeometry_STBoundary         = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STBoundary"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STBoundary"); return result; });
            this.imi_SqlGeometry_STIsValid          = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STIsValid"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STIsValid"); return result; });
            this.imi_SqlGeometry_STEquals           = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STEquals", SqlTypes.SqlGeometryType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STEquals"); return result; });
            this.imi_SqlGeometry_STDisjoint         = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STDisjoint", SqlTypes.SqlGeometryType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STDisjoint"); return result; });
            this.imi_SqlGeometry_STIntersects       = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STIntersects", SqlTypes.SqlGeometryType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STIntersects"); return result; });
            this.imi_SqlGeometry_STTouches          = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STTouches", SqlTypes.SqlGeometryType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STTouches"); return result; });
            this.imi_SqlGeometry_STCrosses          = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STCrosses", SqlTypes.SqlGeometryType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STCrosses"); return result; });
            this.imi_SqlGeometry_STWithin           = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STWithin", SqlTypes.SqlGeometryType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STWithin"); return result; });
            this.imi_SqlGeometry_STContains         = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STContains", SqlTypes.SqlGeometryType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STContains"); return result; });
            this.imi_SqlGeometry_STOverlaps         = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STOverlaps", SqlTypes.SqlGeometryType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STOverlaps"); return result; });
            this.imi_SqlGeometry_STRelate           = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STRelate", SqlTypes.SqlGeometryType, typeof(string)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STRelate"); return result; });
            this.imi_SqlGeometry_STBuffer           = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STBuffer", typeof(double)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STBuffer"); return result; });
            this.imi_SqlGeometry_STDistance         = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STDistance", SqlTypes.SqlGeometryType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STDistance"); return result; });
            this.imi_SqlGeometry_STConvexHull       = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STConvexHull"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STConvexHull"); return result; });
            this.imi_SqlGeometry_STIntersection     = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STIntersection", SqlTypes.SqlGeometryType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STIntersection"); return result; });
            this.imi_SqlGeometry_STUnion            = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STUnion", SqlTypes.SqlGeometryType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STUnion"); return result; });
            this.imi_SqlGeometry_STDifference       = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STDifference", SqlTypes.SqlGeometryType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STDifference"); return result; });
            this.imi_SqlGeometry_STSymDifference    = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STSymDifference", SqlTypes.SqlGeometryType); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STSymDifference"); return result; });
            this.imi_SqlGeometry_STNumGeometries    = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STNumGeometries"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STNumGeometries"); return result; });
            this.imi_SqlGeometry_STGeometryN        = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STGeometryN", typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STGeometryN"); return result; });
            this.ipi_SqlGeometry_STX                = new Singleton<PropertyInfo>(() => { PropertyInfo result = FindSqlGeometryProperty("STX"); Debug.Assert(result != null, "Could not retrieve PropertyInfo for SqlGeometry member STX"); return result; });
            this.ipi_SqlGeometry_STY                = new Singleton<PropertyInfo>(() => { PropertyInfo result = FindSqlGeometryProperty("STY"); Debug.Assert(result != null, "Could not retrieve PropertyInfo for SqlGeometry member STY"); return result; });
            this.ipi_SqlGeometry_Z                  = new Singleton<PropertyInfo>(() => { PropertyInfo result = FindSqlGeometryProperty("Z"); Debug.Assert(result != null, "Could not retrieve PropertyInfo for SqlGeometry member Z"); return result; });
            this.ipi_SqlGeometry_M                  = new Singleton<PropertyInfo>(() => { PropertyInfo result = FindSqlGeometryProperty("M"); Debug.Assert(result != null, "Could not retrieve PropertyInfo for SqlGeometry member M"); return result; });
            this.imi_SqlGeometry_STLength           = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STLength"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STLength"); return result; });
            this.imi_SqlGeometry_STStartPoint       = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STStartPoint"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STStartPoint"); return result; });
            this.imi_SqlGeometry_STEndPoint         = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STEndPoint"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STEndPoint"); return result; });
            this.imi_SqlGeometry_STIsClosed         = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STIsClosed"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STIsClosed"); return result; });
            this.imi_SqlGeometry_STIsRing           = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STIsRing"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STIsRing"); return result; });
            this.imi_SqlGeometry_STNumPoints        = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STNumPoints"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STNumPoints"); return result; });
            this.imi_SqlGeometry_STPointN           = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STPointN", typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STPointN"); return result; });
            this.imi_SqlGeometry_STArea             = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STArea"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STArea"); return result; });
            this.imi_SqlGeometry_STCentroid         = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STCentroid"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STCentroid"); return result; });
            this.imi_SqlGeometry_STPointOnSurface   = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STPointOnSurface"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STPointOnSurface"); return result; });
            this.imi_SqlGeometry_STExteriorRing     = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STExteriorRing"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STExteriorRing"); return result; });
            this.imi_SqlGeometry_STNumInteriorRing  = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STNumInteriorRing"); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STNumInteriorRing"); return result; });
            this.imi_SqlGeometry_STInteriorRingN    = new Singleton<MethodInfo>(() => { MethodInfo result = FindSqlGeometryMethod("STInteriorRingN", typeof(int)); Debug.Assert(result != null, "Could not retrieve MethodInfo for SqlGeometry member STInteriorRingN"); return result; });
        }

        private void InitializeMemberInfo(SqlSpatialServices from)
        {
            this.smi_SqlGeography_Parse              = from.smi_SqlGeography_Parse;
            this.smi_SqlGeography_STGeomFromText     = from.smi_SqlGeography_STGeomFromText;
            this.smi_SqlGeography_STPointFromText    = from.smi_SqlGeography_STPointFromText;
            this.smi_SqlGeography_STLineFromText     = from.smi_SqlGeography_STLineFromText;
            this.smi_SqlGeography_STPolyFromText     = from.smi_SqlGeography_STPolyFromText;
            this.smi_SqlGeography_STMPointFromText   = from.smi_SqlGeography_STMPointFromText;
            this.smi_SqlGeography_STMLineFromText    = from.smi_SqlGeography_STMLineFromText;
            this.smi_SqlGeography_STMPolyFromText    = from.smi_SqlGeography_STMPolyFromText;
            this.smi_SqlGeography_STGeomCollFromText = from.smi_SqlGeography_STGeomCollFromText;
            this.smi_SqlGeography_STGeomFromWKB      = from.smi_SqlGeography_STGeomFromWKB;
            this.smi_SqlGeography_STPointFromWKB     = from.smi_SqlGeography_STPointFromWKB;
            this.smi_SqlGeography_STLineFromWKB      = from.smi_SqlGeography_STLineFromWKB;
            this.smi_SqlGeography_STPolyFromWKB      = from.smi_SqlGeography_STPolyFromWKB;
            this.smi_SqlGeography_STMPointFromWKB    = from.smi_SqlGeography_STMPointFromWKB;
            this.smi_SqlGeography_STMLineFromWKB     = from.smi_SqlGeography_STMLineFromWKB;
            this.smi_SqlGeography_STMPolyFromWKB     = from.smi_SqlGeography_STMPolyFromWKB;
            this.smi_SqlGeography_STGeomCollFromWKB  = from.smi_SqlGeography_STGeomCollFromWKB;
            this.smi_SqlGeography_GeomFromGml        = from.smi_SqlGeography_GeomFromGml;
            this.ipi_SqlGeography_STSrid             = from.ipi_SqlGeography_STSrid;
            this.imi_SqlGeography_STGeometryType     = from.imi_SqlGeography_STGeometryType;
            this.imi_SqlGeography_STDimension        = from.imi_SqlGeography_STDimension;
            this.imi_SqlGeography_STAsBinary         = from.imi_SqlGeography_STAsBinary;
            this.imi_SqlGeography_AsGml              = from.imi_SqlGeography_AsGml;
            this.imi_SqlGeography_STAsText           = from.imi_SqlGeography_STAsText;
            this.imi_SqlGeography_STIsEmpty          = from.imi_SqlGeography_STIsEmpty;
            this.imi_SqlGeography_STEquals           = from.imi_SqlGeography_STEquals;
            this.imi_SqlGeography_STDisjoint         = from.imi_SqlGeography_STDisjoint;
            this.imi_SqlGeography_STIntersects       = from.imi_SqlGeography_STIntersects;
            this.imi_SqlGeography_STBuffer           = from.imi_SqlGeography_STBuffer;
            this.imi_SqlGeography_STDistance         = from.imi_SqlGeography_STDistance;
            this.imi_SqlGeography_STIntersection     = from.imi_SqlGeography_STIntersection;
            this.imi_SqlGeography_STUnion            = from.imi_SqlGeography_STUnion;
            this.imi_SqlGeography_STDifference       = from.imi_SqlGeography_STDifference;
            this.imi_SqlGeography_STSymDifference    = from.imi_SqlGeography_STSymDifference;
            this.imi_SqlGeography_STNumGeometries    = from.imi_SqlGeography_STNumGeometries;
            this.imi_SqlGeography_STGeometryN        = from.imi_SqlGeography_STGeometryN;
            this.ipi_SqlGeography_Lat                = from.ipi_SqlGeography_Lat;
            this.ipi_SqlGeography_Long               = from.ipi_SqlGeography_Long;
            this.ipi_SqlGeography_Z                  = from.ipi_SqlGeography_Z;
            this.ipi_SqlGeography_M                  = from.ipi_SqlGeography_M;
            this.imi_SqlGeography_STLength           = from.imi_SqlGeography_STLength;
            this.imi_SqlGeography_STStartPoint       = from.imi_SqlGeography_STStartPoint;
            this.imi_SqlGeography_STEndPoint         = from.imi_SqlGeography_STEndPoint;
            this.imi_SqlGeography_STIsClosed         = from.imi_SqlGeography_STIsClosed;
            this.imi_SqlGeography_STNumPoints        = from.imi_SqlGeography_STNumPoints;
            this.imi_SqlGeography_STPointN           = from.imi_SqlGeography_STPointN;
            this.imi_SqlGeography_STArea             = from.imi_SqlGeography_STArea;
            this.smi_SqlGeometry_Parse              = from.smi_SqlGeometry_Parse;
            this.smi_SqlGeometry_STGeomFromText     = from.smi_SqlGeometry_STGeomFromText;
            this.smi_SqlGeometry_STPointFromText    = from.smi_SqlGeometry_STPointFromText;
            this.smi_SqlGeometry_STLineFromText     = from.smi_SqlGeometry_STLineFromText;
            this.smi_SqlGeometry_STPolyFromText     = from.smi_SqlGeometry_STPolyFromText;
            this.smi_SqlGeometry_STMPointFromText   = from.smi_SqlGeometry_STMPointFromText;
            this.smi_SqlGeometry_STMLineFromText    = from.smi_SqlGeometry_STMLineFromText;
            this.smi_SqlGeometry_STMPolyFromText    = from.smi_SqlGeometry_STMPolyFromText;
            this.smi_SqlGeometry_STGeomCollFromText = from.smi_SqlGeometry_STGeomCollFromText;
            this.smi_SqlGeometry_STGeomFromWKB      = from.smi_SqlGeometry_STGeomFromWKB;
            this.smi_SqlGeometry_STPointFromWKB     = from.smi_SqlGeometry_STPointFromWKB;
            this.smi_SqlGeometry_STLineFromWKB      = from.smi_SqlGeometry_STLineFromWKB;
            this.smi_SqlGeometry_STPolyFromWKB      = from.smi_SqlGeometry_STPolyFromWKB;
            this.smi_SqlGeometry_STMPointFromWKB    = from.smi_SqlGeometry_STMPointFromWKB;
            this.smi_SqlGeometry_STMLineFromWKB     = from.smi_SqlGeometry_STMLineFromWKB;
            this.smi_SqlGeometry_STMPolyFromWKB     = from.smi_SqlGeometry_STMPolyFromWKB;
            this.smi_SqlGeometry_STGeomCollFromWKB  = from.smi_SqlGeometry_STGeomCollFromWKB;
            this.smi_SqlGeometry_GeomFromGml        = from.smi_SqlGeometry_GeomFromGml;
            this.ipi_SqlGeometry_STSrid             = from.ipi_SqlGeometry_STSrid;
            this.imi_SqlGeometry_STGeometryType     = from.imi_SqlGeometry_STGeometryType;
            this.imi_SqlGeometry_STDimension        = from.imi_SqlGeometry_STDimension;
            this.imi_SqlGeometry_STEnvelope         = from.imi_SqlGeometry_STEnvelope;
            this.imi_SqlGeometry_STAsBinary         = from.imi_SqlGeometry_STAsBinary;
            this.imi_SqlGeometry_AsGml              = from.imi_SqlGeometry_AsGml;
            this.imi_SqlGeometry_STAsText           = from.imi_SqlGeometry_STAsText;
            this.imi_SqlGeometry_STIsEmpty          = from.imi_SqlGeometry_STIsEmpty;
            this.imi_SqlGeometry_STIsSimple         = from.imi_SqlGeometry_STIsSimple;
            this.imi_SqlGeometry_STBoundary         = from.imi_SqlGeometry_STBoundary;
            this.imi_SqlGeometry_STIsValid          = from.imi_SqlGeometry_STIsValid;
            this.imi_SqlGeometry_STEquals           = from.imi_SqlGeometry_STEquals;
            this.imi_SqlGeometry_STDisjoint         = from.imi_SqlGeometry_STDisjoint;
            this.imi_SqlGeometry_STIntersects       = from.imi_SqlGeometry_STIntersects;
            this.imi_SqlGeometry_STTouches          = from.imi_SqlGeometry_STTouches;
            this.imi_SqlGeometry_STCrosses          = from.imi_SqlGeometry_STCrosses;
            this.imi_SqlGeometry_STWithin           = from.imi_SqlGeometry_STWithin;
            this.imi_SqlGeometry_STContains         = from.imi_SqlGeometry_STContains;
            this.imi_SqlGeometry_STOverlaps         = from.imi_SqlGeometry_STOverlaps;
            this.imi_SqlGeometry_STRelate           = from.imi_SqlGeometry_STRelate;
            this.imi_SqlGeometry_STBuffer           = from.imi_SqlGeometry_STBuffer;
            this.imi_SqlGeometry_STDistance         = from.imi_SqlGeometry_STDistance;
            this.imi_SqlGeometry_STConvexHull       = from.imi_SqlGeometry_STConvexHull;
            this.imi_SqlGeometry_STIntersection     = from.imi_SqlGeometry_STIntersection;
            this.imi_SqlGeometry_STUnion            = from.imi_SqlGeometry_STUnion;
            this.imi_SqlGeometry_STDifference       = from.imi_SqlGeometry_STDifference;
            this.imi_SqlGeometry_STSymDifference    = from.imi_SqlGeometry_STSymDifference;
            this.imi_SqlGeometry_STNumGeometries    = from.imi_SqlGeometry_STNumGeometries;
            this.imi_SqlGeometry_STGeometryN        = from.imi_SqlGeometry_STGeometryN;
            this.ipi_SqlGeometry_STX                = from.ipi_SqlGeometry_STX;
            this.ipi_SqlGeometry_STY                = from.ipi_SqlGeometry_STY;
            this.ipi_SqlGeometry_Z                  = from.ipi_SqlGeometry_Z;
            this.ipi_SqlGeometry_M                  = from.ipi_SqlGeometry_M;
            this.imi_SqlGeometry_STLength           = from.imi_SqlGeometry_STLength;
            this.imi_SqlGeometry_STStartPoint       = from.imi_SqlGeometry_STStartPoint;
            this.imi_SqlGeometry_STEndPoint         = from.imi_SqlGeometry_STEndPoint;
            this.imi_SqlGeometry_STIsClosed         = from.imi_SqlGeometry_STIsClosed;
            this.imi_SqlGeometry_STIsRing           = from.imi_SqlGeometry_STIsRing;
            this.imi_SqlGeometry_STNumPoints        = from.imi_SqlGeometry_STNumPoints;
            this.imi_SqlGeometry_STPointN           = from.imi_SqlGeometry_STPointN;
            this.imi_SqlGeometry_STArea             = from.imi_SqlGeometry_STArea;
            this.imi_SqlGeometry_STCentroid         = from.imi_SqlGeometry_STCentroid;
            this.imi_SqlGeometry_STPointOnSurface   = from.imi_SqlGeometry_STPointOnSurface;
            this.imi_SqlGeometry_STExteriorRing     = from.imi_SqlGeometry_STExteriorRing;
            this.imi_SqlGeometry_STNumInteriorRing  = from.imi_SqlGeometry_STNumInteriorRing;
            this.imi_SqlGeometry_STInteriorRingN    = from.imi_SqlGeometry_STInteriorRingN;
        }

    }
}
