/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jhotdraw.figures.ElbowHandle;
import org.jhotdraw.figures.ElbowTextLocator;
import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.figures.PolyLineFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.ChangeConnectionEndHandle;
import org.jhotdraw.standard.ChangeConnectionStartHandle;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.NullHandle;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Geom;

public class ElbowConnection
extends LineConnection {
    private static final long serialVersionUID = 2193968743082078559L;
    private int elbowConnectionSerializedDataVersion = 1;

    public void updateConnection() {
        super.updateConnection();
        this.updatePoints();
    }

    public void layoutConnection() {
    }

    public HandleEnumeration handles() {
        int n;
        List list = CollectionsFactory.current().createList(this.fPoints.size() * 2);
        list.add(new ChangeConnectionStartHandle(this));
        for (n = 1; n < this.fPoints.size() - 1; ++n) {
            list.add(new NullHandle(this, PolyLineFigure.locator(n)));
        }
        list.add(new ChangeConnectionEndHandle(this));
        for (n = 0; n < this.fPoints.size() - 1; ++n) {
            list.add(new ElbowHandle(this, n));
        }
        return new HandleEnumerator(list);
    }

    public Locator connectedTextLocator(Figure figure) {
        return new ElbowTextLocator();
    }

    protected void updatePoints() {
        this.willChange();
        Point point = this.startPoint();
        Point point2 = this.endPoint();
        this.fPoints.clear();
        this.fPoints.add(point);
        if (point.x == point2.x || point.y == point2.y) {
            this.fPoints.add(point2);
        } else {
            Rectangle rectangle = this.getStartConnector().owner().displayBox();
            Rectangle rectangle2 = this.getEndConnector().owner().displayBox();
            int n = Geom.direction(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2, rectangle2.x + rectangle2.width / 2, rectangle2.y + rectangle2.height / 2);
            if (n == 1 || n == 2) {
                this.fPoints.add(new Point(point.x, (point.y + point2.y) / 2));
                this.fPoints.add(new Point(point2.x, (point.y + point2.y) / 2));
            } else {
                this.fPoints.add(new Point((point.x + point2.x) / 2, point.y));
                this.fPoints.add(new Point((point.x + point2.x) / 2, point2.y));
            }
            this.fPoints.add(point2);
        }
        this.changed();
    }
}

