/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.SliderUI;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TextAreaCreationTool;
import org.jhotdraw.draw.TextCreationTool;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.gui.JAttributeSlider;
import org.jhotdraw.gui.JAttributeTextField;
import org.jhotdraw.gui.JFontChooser;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.gui.event.FigureAttributeEditorHandler;
import org.jhotdraw.gui.event.SelectionComponentDisplayer;
import org.jhotdraw.gui.event.SelectionComponentRepainter;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.gui.plaf.palette.PaletteFormattedTextFieldUI;
import org.jhotdraw.gui.plaf.palette.PaletteSliderUI;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.text.FontFormatter;
import org.jhotdraw.text.JavaNumberFormatter;
import org.jhotdraw.util.ResourceBundleUtil;

public class FontToolBar
extends AbstractToolBar {
    private SelectionComponentDisplayer displayer;

    public FontToolBar() {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.setName(resourceBundleUtil.getString("font.toolbar"));
        JFontChooser.loadAllFonts();
        this.setDisclosureStateCount(3);
    }

    @Override
    public void setEditor(DrawingEditor drawingEditor) {
        DrawingEditor drawingEditor2 = this.getEditor();
        if (this.displayer != null) {
            this.displayer.dispose();
            this.displayer = null;
        }
        super.setEditor(drawingEditor);
        if (drawingEditor != null) {
            this.displayer = new SelectionComponentDisplayer(this.editor, this){

                @Override
                public void updateVisibility() {
                    boolean bl = this.editor != null && this.editor.getActiveView() != null && (this.isVisibleIfCreationTool && (this.editor.getTool() instanceof TextCreationTool || this.editor.getTool() instanceof TextAreaCreationTool) || this.containsTextHolderFigure(this.editor.getActiveView().getSelectedFigures()));
                    JComponent jComponent = this.getComponent();
                    if (jComponent == null) {
                        this.dispose();
                        return;
                    }
                    jComponent.setVisible(bl);
                    if (bl) {
                        jComponent.setPreferredSize(null);
                    } else {
                        jComponent.setPreferredSize(new Dimension(0, 0));
                    }
                    jComponent.revalidate();
                }

                private boolean containsTextHolderFigure(Collection<Figure> collection) {
                    for (Figure figure : collection) {
                        if (figure instanceof TextHolderFigure) {
                            return true;
                        }
                        if (!(figure instanceof CompositeFigure) || !this.containsTextHolderFigure(((CompositeFigure)figure).getChildren())) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
    }

    @Override
    protected JComponent createDisclosedComponent(int n) {
        JPanel jPanel = null;
        switch (n) {
            case 1: {
                jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                JPanel jPanel2 = new JPanel(new GridBagLayout());
                JPanel jPanel3 = new JPanel(new GridBagLayout());
                JPanel jPanel4 = new JPanel(new GridBagLayout());
                jPanel2.setOpaque(false);
                jPanel3.setOpaque(false);
                jPanel4.setOpaque(false);
                ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout gridBagLayout = new GridBagLayout();
                jPanel.setLayout(gridBagLayout);
                JAttributeTextField jAttributeTextField = new JAttributeTextField();
                jAttributeTextField.setColumns(2);
                jAttributeTextField.setToolTipText(resourceBundleUtil.getString("attribute.font.toolTipText"));
                jAttributeTextField.setHorizontalAlignment(4);
                jAttributeTextField.putClientProperty("Palette.Component.segmentPosition", "first");
                jAttributeTextField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(jAttributeTextField));
                jAttributeTextField.setHorizontalAlignment(10);
                jAttributeTextField.setFormatterFactory(FontFormatter.createFormatterFactory());
                this.disposables.add(new FigureAttributeEditorHandler(SVGAttributeKeys.FONT_FACE, jAttributeTextField, this.editor));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.anchor = 23;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.fill = 2;
                jPanel.add(jAttributeTextField, gridBagConstraints);
                JButton jButton = ButtonFactory.createFontButton(this.editor, SVGAttributeKeys.FONT_FACE, resourceBundleUtil, this.disposables);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                jPanel.add((Component)jButton, gridBagConstraints);
                JAttributeTextField jAttributeTextField2 = new JAttributeTextField();
                jAttributeTextField2.setColumns(1);
                jAttributeTextField2.setToolTipText(resourceBundleUtil.getString("attribute.fontSize.toolTipText"));
                jAttributeTextField2.setHorizontalAlignment(4);
                jAttributeTextField2.putClientProperty("Palette.Component.segmentPosition", "first");
                jAttributeTextField2.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(jAttributeTextField2));
                jAttributeTextField2.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 1000.0, 1.0));
                jAttributeTextField2.setHorizontalAlignment(10);
                this.disposables.add(new FigureAttributeEditorHandler(SVGAttributeKeys.FONT_SIZE, jAttributeTextField2, this.editor));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                gridBagConstraints.anchor = 23;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                jPanel3.add(jAttributeTextField2, gridBagConstraints);
                JPopupButton jPopupButton = new JPopupButton();
                JAttributeSlider jAttributeSlider = new JAttributeSlider(1, 0, 100, 12);
                jPopupButton.add(jAttributeSlider);
                resourceBundleUtil.configureToolBarButton(jPopupButton, "attribute.fontSize");
                jPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton));
                jPopupButton.setPopupAnchor(4);
                this.disposables.add(new SelectionComponentRepainter(this.editor, jPopupButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 23;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                jPanel3.add((Component)jPopupButton, gridBagConstraints);
                jAttributeSlider.setUI((SliderUI)PaletteSliderUI.createUI(jAttributeSlider));
                jAttributeSlider.setScaleFactor(1.0);
                this.disposables.add(new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.FONT_SIZE, jAttributeSlider, this.editor));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 23;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                jPanel.add((Component)jPanel3, gridBagConstraints);
                jButton = ButtonFactory.createFontStyleBoldButton(this.editor, resourceBundleUtil, this.disposables);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                jButton.putClientProperty("Palette.Component.segmentPosition", "first");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                jPanel.add((Component)jButton, gridBagConstraints);
                jButton = ButtonFactory.createFontStyleItalicButton(this.editor, resourceBundleUtil, this.disposables);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                jButton.putClientProperty("Palette.Component.segmentPosition", "middle");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                jPanel.add((Component)jButton, gridBagConstraints);
                jButton = ButtonFactory.createFontStyleUnderlineButton(this.editor, resourceBundleUtil, this.disposables);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                jButton.putClientProperty("Palette.Component.segmentPosition", "last");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                gridBagConstraints.anchor = 17;
                jPanel.add((Component)jButton, gridBagConstraints);
                break;
            }
            case 2: {
                jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                JPanel jPanel5 = new JPanel(new GridBagLayout());
                JPanel jPanel6 = new JPanel(new GridBagLayout());
                JPanel jPanel7 = new JPanel(new GridBagLayout());
                jPanel5.setOpaque(false);
                jPanel6.setOpaque(false);
                jPanel7.setOpaque(false);
                ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout gridBagLayout = new GridBagLayout();
                jPanel.setLayout(gridBagLayout);
                JAttributeTextField jAttributeTextField = new JAttributeTextField();
                jAttributeTextField.setColumns(10);
                jAttributeTextField.setToolTipText(resourceBundleUtil.getString("attribute.font.toolTipText"));
                jAttributeTextField.setHorizontalAlignment(4);
                jAttributeTextField.putClientProperty("Palette.Component.segmentPosition", "first");
                jAttributeTextField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(jAttributeTextField));
                jAttributeTextField.setHorizontalAlignment(10);
                jAttributeTextField.setFormatterFactory(FontFormatter.createFormatterFactory());
                this.disposables.add(new FigureAttributeEditorHandler(SVGAttributeKeys.FONT_FACE, jAttributeTextField, this.editor));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.anchor = 23;
                gridBagConstraints.gridwidth = 3;
                gridBagConstraints.fill = 2;
                jPanel.add(jAttributeTextField, gridBagConstraints);
                JButton jButton = ButtonFactory.createFontButton(this.editor, SVGAttributeKeys.FONT_FACE, resourceBundleUtil, this.disposables);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                jPanel.add((Component)jButton, gridBagConstraints);
                JAttributeTextField jAttributeTextField3 = new JAttributeTextField();
                jAttributeTextField3.setColumns(1);
                jAttributeTextField3.setToolTipText(resourceBundleUtil.getString("attribute.fontSize.toolTipText"));
                jAttributeTextField3.setHorizontalAlignment(4);
                jAttributeTextField3.putClientProperty("Palette.Component.segmentPosition", "first");
                jAttributeTextField3.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(jAttributeTextField3));
                jAttributeTextField3.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 1000.0, 1.0));
                jAttributeTextField3.setHorizontalAlignment(10);
                this.disposables.add(new FigureAttributeEditorHandler(SVGAttributeKeys.FONT_SIZE, jAttributeTextField3, this.editor));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                gridBagConstraints.anchor = 23;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                jPanel6.add(jAttributeTextField3, gridBagConstraints);
                JPopupButton jPopupButton = new JPopupButton();
                JAttributeSlider jAttributeSlider = new JAttributeSlider(1, 0, 100, 12);
                jPopupButton.add(jAttributeSlider);
                resourceBundleUtil.configureToolBarButton(jPopupButton, "attribute.fontSize");
                jPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton));
                jPopupButton.setPopupAnchor(4);
                this.disposables.add(new SelectionComponentRepainter(this.editor, jPopupButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 23;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                jPanel6.add((Component)jPopupButton, gridBagConstraints);
                jAttributeSlider.setUI((SliderUI)PaletteSliderUI.createUI(jAttributeSlider));
                jAttributeSlider.setScaleFactor(1.0);
                this.disposables.add(new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.FONT_SIZE, jAttributeSlider, this.editor));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 23;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                jPanel.add((Component)jPanel6, gridBagConstraints);
                jButton = ButtonFactory.createFontStyleBoldButton(this.editor, resourceBundleUtil, this.disposables);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                jButton.putClientProperty("Palette.Component.segmentPosition", "first");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                jPanel.add((Component)jButton, gridBagConstraints);
                jButton = ButtonFactory.createFontStyleItalicButton(this.editor, resourceBundleUtil, this.disposables);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                jButton.putClientProperty("Palette.Component.segmentPosition", "middle");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                jPanel.add((Component)jButton, gridBagConstraints);
                jButton = ButtonFactory.createFontStyleUnderlineButton(this.editor, resourceBundleUtil, this.disposables);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                jButton.putClientProperty("Palette.Component.segmentPosition", "last");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                gridBagConstraints.anchor = 17;
                jPanel.add((Component)jButton, gridBagConstraints);
            }
        }
        return jPanel;
    }

    @Override
    protected String getID() {
        return "font";
    }

    @Override
    protected int getDefaultDisclosureState() {
        return 1;
    }

    private void initComponents() {
    }
}

