/*
 * stat.c
 *
 * Copyright (C) 1993 Alain Knaff
 */

#define _LARGEFILE64_SOURCE
#define _GNU_SOURCE

#include "sysincludes.h"

#include <sys/syscall.h>

#define STAT(x) x ## stat
#define STATTYPE struct stat

#ifdef HAVE___XSTAT
# ifdef solaris
#  define fSTAT _fxstat(ver, fd, buf)
# else
#  define fSTAT __fxstat(ver, fd, buf)
# endif
#else
# define fSTAT fstat(fd, buf)
#endif

#include "stat_tmpl.c"

#undef STAT
#undef STATTYPE
#undef fSTAT


#ifdef HAVE_STAT64

# define STATTYPE struct stat64
# define STAT(x) x##stat64

# ifdef HAVE___XSTAT64
#  define fSTAT __fxstat64(ver,fd,buf)
# else
#  define fSTAT fstat64(fd, buf)
# endif

# include "stat_tmpl.c"

#undef STAT
#undef STATTYPE
#undef fSTAT

#endif


#ifdef HAVE___XSTAT

int __xstat(int vers, __const char *name, struct stat *buf)
{
     _zlibc_init();     
     return zlibc_xstat(vers, name, buf);
}

int __lxstat (int vers, const char *name, struct stat *buf)
{
  _zlibc_init();
  return zlibc_lxstat(vers, name, buf);
}

#  ifdef HAVE___XSTAT64

int __xstat64(int vers, const char *name, struct stat64 *buf)
{
  _zlibc_init();
  return  zlibc_xstat64(vers, name, buf);
}

int __lxstat64 (int vers, const char *name, struct stat64 *buf)
{
  _zlibc_init();
  return zlibc_lxstat64(vers, name, buf);
}

#  endif


#else /* no xstat */


int stat(__const char *name, struct stat *buf)
{
    _zlibc_init();
    return zlibc_stat(name, buf);
}

int lstat(__const char *name, struct stat *buf)
{
    _zlibc_init();
    return zlibc_lstat(name, buf);
}
#endif


# ifdef HAVE_STAT64

int stat64(__const char *name, struct stat64 *buf)
{
    _zlibc_init();
    return zlibc_xstat64(_STAT_VER, name, buf);
}
int lstat64(__const char *name, struct stat64 *buf)
{
    _zlibc_init();
    return zlibc_lxstat64(_STAT_VER,name, buf);
}
# endif

