/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.StringTokenizer;

class Text
extends DiagramItem {
    String text;
    StringBuffer buffer;

    Text() {
        this.y = 0;
        this.x = 0;
        this.buffer = new StringBuffer();
        this.text = this.buffer.toString().concat("_");
    }

    Text(StringTokenizer stringTokenizer) throws Exception {
        if (stringTokenizer.countTokens() < 1) {
            throw new IllegalArgumentException();
        }
        this.x = new Integer(stringTokenizer.nextToken());
        this.y = new Integer(stringTokenizer.nextToken());
        this.text = stringTokenizer.nextToken("\n\r").trim();
    }

    @Override
    void create() {
        super.create();
        this.diagram.editor.controls.disable();
        this.diagram.editor.showStatus(KansBoom.t_press);
        ++KansBoom.textcounter;
    }

    @Override
    public void yield() {
        super.yield();
        this.diagram.editor.controls.enable();
        this.text = this.buffer.toString();
    }

    @Override
    String describe() {
        return "text," + this.x + "," + this.y + "," + this.text;
    }

    @Override
    String specify_text() {
        return this.text;
    }

    @Override
    int specify_text_x() {
        return this.x;
    }

    @Override
    int specify_text_y() {
        return this.y;
    }

    @Override
    int specify_line_x1() {
        return -1;
    }

    @Override
    int specify_line_y1() {
        return -1;
    }

    @Override
    int specify_line_x2() {
        return -1;
    }

    @Override
    int specify_line_y2() {
        return -1;
    }

    @Override
    void draw(Graphics graphics) {
        if (!KansBoom.original) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = KansBoom.ysize / KansBoom.ygrid;
            int n2 = KansBoom.xsize / KansBoom.ygrid;
            if (this.state == 1 || this.state == 2) {
                graphics2D.setColor(KansBoom.drawcolor);
                graphics2D.setStroke(new BasicStroke(1.0f));
                if (KansBoom.textalign) {
                    for (int i = 0; i < KansBoom.ysize; i += n) {
                        graphics2D.drawLine(0, i, KansBoom.xsize, i);
                    }
                } else {
                    for (int i = 0; i < KansBoom.xsize; i += n2) {
                        graphics2D.drawLine(i, 0, i, KansBoom.ysize);
                    }
                }
                graphics2D.setFont(KansBoom.zoomfont);
            } else {
                graphics2D.setFont(KansBoom.penfont);
            }
            if (this.state != 2 && KansBoom.ygrid < 50 && KansBoom.ygrid > 1) {
                if (KansBoom.textalign) {
                    this.y = n * Math.round(this.y / n);
                    if (this.y < n) {
                        this.y = n;
                    }
                    if (this.y > KansBoom.ysize - n) {
                        this.y = KansBoom.ysize - n;
                    }
                } else {
                    this.x = n2 * Math.round(this.x / n2);
                    if (this.x < n2) {
                        this.x = n2;
                    }
                    if (this.x > KansBoom.xsize - n2) {
                        this.x = KansBoom.xsize - n2;
                    }
                }
            }
            graphics2D.setColor(KansBoom.textcolor);
            graphics2D.setStroke(new BasicStroke(KansBoom.thickness));
            graphics2D.drawString(this.text, this.x, this.y);
            graphics2D.setColor(KansBoom.drawcolor);
        } else {
            graphics.drawString(this.text, this.x, this.y);
        }
    }

    @Override
    double distance(int n, int n2) {
        FontMetrics fontMetrics = this.diagram.editor.display.getGraphics().getFontMetrics();
        int n3 = this.y - fontMetrics.getAscent() / 2;
        if (n < this.x) {
            return Misc.distance(this.x, n3, n, n2);
        }
        int n4 = this.x + fontMetrics.stringWidth(this.text);
        if (n > n4) {
            return Misc.distance(n4, n3, n, n2);
        }
        return Math.abs(n2 - n3);
    }

    @Override
    public boolean down(int n, int n2) {
        switch (this.state) {
            case 1: {
                this.x = n;
                this.y = n2;
                return true;
            }
            case 2: {
                return super.down(n, n2);
            }
        }
        return false;
    }

    @Override
    public boolean up(int n, int n2) {
        switch (this.state) {
            case 1: {
                this.x = n;
                this.y = n2;
                return true;
            }
            case 2: {
                return super.up(n, n2);
            }
        }
        return false;
    }

    @Override
    public boolean drag(int n, int n2) {
        switch (this.state) {
            case 1: {
                this.x = n;
                this.y = n2;
                return true;
            }
            case 2: {
                return super.drag(n, n2);
            }
        }
        return false;
    }

    @Override
    public boolean key(int n) {
        char[] cArray = new char[1];
        switch (this.state) {
            case 1: {
                switch (n) {
                    case 10: 
                    case 13: {
                        this.yield();
                        if (this.text.equals("")) {
                            this.diagram.removeElement(this);
                            this.destroy();
                            this.diagram.editor.showStatus("String was empty");
                        } else {
                            this.diagram.editor.showStatus("");
                        }
                        return true;
                    }
                    case 8: 
                    case 127: {
                        int n2 = this.buffer.length();
                        if (n2 <= 0) break;
                        this.buffer.setLength(n2 - 1);
                        break;
                    }
                    default: {
                        this.buffer.append((char)n);
                    }
                }
                this.text = this.buffer.toString().concat("_");
                return true;
            }
        }
        return false;
    }
}

