/**
 * Rectangle.java
 *
 * Created on Jul 10, 2006
 */
package maths;

/**
 * Cette classe implemente un rectangle <code>(x1, y1, x2, y2)</code>. Un point
 * <code>(x, y)</code> y appartient si <code>x1 <= x <= x2</code> et <code>y1 <= y <= y2</code>. 
 *
 * @author Nicolae
 */
public class Rectangle extends DefaultSet {

	private double x1;
	private double y1;
	private double x2;
	private double y2;
	
	/**
	 * Cache le constructor standard.
	 */
	private Rectangle() {}
		
	/**
	 * Constructor qui initialise les coefficients.
	 *
	 * @param a coefficient.
	 * @param b coefficient.
	 * @param c coefficient.
	 */
	public Rectangle(double x1, double y1, double x2, double y2) {
		this.x1 = x1;
		this.y1 = y1;
		this.x2 = x2;
		this.y2 = y2;
	}
	
	/* (non-Javadoc)
	 * @see maths.DefaultSet#contains(double, double)
	 */
	public boolean contains(double re, double im) {
		return x1 <= re && re <= x2 && y1 <= im && im <= y2;
	}

}
