/*
 * Copyright (C) 2019 Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU  Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/&gt;.
 *
 */

#ifndef STATUSNOTIFIERSTORAGEARROW_H
#define STATUSNOTIFIERSTORAGEARROW_H

#include <QToolButton>
#include <QGSettings>
#include <QDrag>
#include "statusnotifierwidget.h"
#include "statusnotifierbuttonabstract.h"

#define UKUI_PANEL_SETTINGS              "org.ukui.panel.settings"
#define SHOW_STATUSNOTIFIER_BUTTON       "statusnotifierbutton"
#define PANEL_POSITION_KEY  "panelposition"
#define ORG_UKUI_STYLE  "org.ukui.style"
#define STYLE_NAME "styleName"

class StatusNotifierWidget;

class StatusNotifierStorageArrow : public StatusNotifierButtonAbstract
{
    Q_OBJECT
public:
    StatusNotifierStorageArrow(IUKUIPanelPlugin* plugin, QWidget *parent = nullptr);
    ~StatusNotifierStorageArrow();
    QString getTypeName() override {return QString("StorageArrow");}
protected:
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void dropEvent(QDropEvent *event);
    void dragEnterEvent(QDragEnterEvent *event);
    void dragLeaveEvent(QDragLeaveEvent *event);
    void resizeEvent(QResizeEvent *event);
    void paintEvent(QPaintEvent *event);
private:
    void setArrowIcon();
    void systemThemeChanges();
    void setHoverBtnProperty();
    void setPressBtnProperty();

private:
    QGSettings *m_gsettings = nullptr;
    QWidget *m_parent;
    int m_panelPosition;
    IUKUIPanelPlugin* m_plugin;
    QGSettings *m_themeSettings = nullptr;
    const qreal m_blackHoverBtnAlphaF = 0.1;  //深色主题下按钮悬停和按下透明度
    const qreal m_blackPressBtnAlphaF = 0.05;
    const qreal m_lightHoverBtnAlphaF = 0.05;  //浅色主题下按钮悬停和按下透明度
    const qreal m_lightPressBtnAlphaF = 0.1;
signals:
    void addButton(StatusNotifierButtonAbstract *from, StatusNotifierButtonAbstract *to);
    void switchButtons(StatusNotifierButtonAbstract *from, StatusNotifierButtonAbstract *to);
};

#endif // STATUSNOTIFIERSTORAGEARROW_H
