/*
 * Determine topology information from the database
 */
#include "basil_alps.h"
#include "basil_mysql.h"
#include "basil_torus.h"

static const char *cabling_type(enum cabling_type tc)
{
	static const char *cabling_classes[] = {
	[CABLING_CLASS0]  = "Class 0",
	[CABLING_CLASS1]  = "Class 1",
	[CABLING_CLASS2]  = "Class 2",
	[CABLING_CLASS3]  = "Class 3",
	[CABLING_UNKNOWN] = "UNKNOWN CABLING TYPE"
	};

	return cabling_classes[tc];
}

static const char *asic_type(enum asic_type at)
{
	static const char *asic_types[] = {
	[ASIC_XT_SEASTAR] = "SeaStar",
	[ASIC_XE_GEMINI]  = "Gemini"
	};

	return asic_types[at];
}

int main(int ac, char **av)
{
	struct torus_info *ti;
	MYSQL *handle;

	handle = cray_connect_sdb();
	if (handle == NULL)
		errx(1, "can not connect to XTAdmin database on the SDB");

	ti = cray_torus_from_database(handle);
	if (ti == NULL)
		errx(1, "can not obtain torus information from processor table");

	if (ti->cabs == 1)
		printf("This is a %s single-cabinet %s system.\n",
		       cabling_type(ti->cabling), asic_type(ti->network));
	else
		printf("This is a %s %s system with %u row%s of %u cabinet%s%s.\n",
		       cabling_type(ti->cabling), asic_type(ti->network),
		       ti->rows, ti->rows == 1 ? "" : "s",
		       ti->cabs, ti->cabs == 1 ? "" : "s",
		       ti->rows > 1 ? " each" : "");
	
	if (is_gemini(ti))
		ti->y_max = 2 * ti->y_max + 1;
	/*
	 * A 2D torus appears as an 1 x Y x Z type of torus (no X dimension).
	 * This is the case with
	 * - SeaStar XT Class 0 torus with just one chassis;
	 * - XT5m system (no X cabling);
	 * - X6m system (likewise).
	 */
	printf("It has a %dD Torus of %u x %u x %u.\n",
		ti->dimension == TORUS_3D ? 3 : 2,
		ti->x_max + 1, ti->y_max + 1, ti->z_max + 1);

	mysql_close(handle);
	free(ti);

	return EXIT_SUCCESS;
}
