// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv64 -target-feature +v \
// RUN:   -target-feature +zvfhmin -disable-O0-optnone  \
// RUN:   -emit-llvm %s -o - | opt -S -passes=mem2reg | \
// RUN:   FileCheck --check-prefix=CHECK-ZVFHMIN %s

#include <riscv_vector.h>

// CHECK-ZVFHMIN-LABEL: @test_vfncvt_f_f_w_f16m1(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.vfncvt.f.f.w.nxv4f16.nxv4f32.i64(<vscale x 4 x half> poison, <vscale x 4 x float> [[SRC:%.*]], i64 7, i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_vfncvt_f_f_w_f16m1(vfloat32m2_t src, size_t vl) {
  return __riscv_vfncvt_f(src, vl);
}


// CHECK-ZVFHMIN-LABEL: @test_vfwcvt_f_f_v_f16m1(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x float> @llvm.riscv.vfwcvt.f.f.v.nxv4f32.nxv4f16.i64(<vscale x 4 x float> poison, <vscale x 4 x half> [[SRC:%.*]], i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
vfloat32m2_t test_vfwcvt_f_f_v_f16m1(vfloat16m1_t src, size_t vl) {
  return __riscv_vfwcvt_f(src, vl);
}

// CHECK-ZVFHMIN-LABEL: @test_vle16_v_f16m1(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.vle.nxv4f16.i64(<vscale x 4 x half> poison, ptr [[BASE:%.*]], i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_vle16_v_f16m1(const _Float16 *base, size_t vl) {
  return __riscv_vle16_v_f16m1(base, vl);
}

// CHECK-ZVFHMIN-LABEL: @test_vse16_v_f16m1(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    call void @llvm.riscv.vse.nxv4f16.i64(<vscale x 4 x half> [[VALUE:%.*]], ptr [[BASE:%.*]], i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    ret void
//
void test_vse16_v_f16m1(_Float16 *base, vfloat16m1_t value, size_t vl) {
  return __riscv_vse16_v_f16m1(base, value, vl);
}

// CHECK-ZVFHMIN-LABEL: @test_vlse16_v_f16m1(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.vlse.nxv4f16.i64(<vscale x 4 x half> poison, ptr [[BASE:%.*]], i64 [[BSTRIDE:%.*]], i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_vlse16_v_f16m1(const _Float16 *base, ptrdiff_t bstride, size_t vl) {
  return __riscv_vlse16_v_f16m1(base, bstride, vl);
}

// CHECK-ZVFHMIN-LABEL: @test_vsse16_v_f16m1(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    call void @llvm.riscv.vsse.nxv4f16.i64(<vscale x 4 x half> [[VALUE:%.*]], ptr [[BASE:%.*]], i64 [[BSTRIDE:%.*]], i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    ret void
//
void test_vsse16_v_f16m1(_Float16 *base, ptrdiff_t bstride, vfloat16m1_t value, size_t vl) {
  return __riscv_vsse16_v_f16m1(base, bstride, value, vl);
}

// CHECK-ZVFHMIN-LABEL: @test_vluxei32_v_f16m1(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.vluxei.nxv4f16.nxv4i32.i64(<vscale x 4 x half> poison, ptr [[BASE:%.*]], <vscale x 4 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_vluxei32_v_f16m1(const _Float16 *base, vuint32m2_t bindex, size_t vl) {
  return __riscv_vluxei32_v_f16m1(base, bindex, vl);
}

// CHECK-ZVFHMIN-LABEL: @test_vsuxei32_v_f16m1(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    call void @llvm.riscv.vsuxei.nxv4f16.nxv4i32.i64(<vscale x 4 x half> [[VALUE:%.*]], ptr [[BASE:%.*]], <vscale x 4 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    ret void
//
void test_vsuxei32_v_f16m1(_Float16 *base, vuint32m2_t bindex, vfloat16m1_t value, size_t vl) {
  return __riscv_vsuxei32_v_f16m1(base, bindex, value, vl);
}

// CHECK-ZVFHMIN-LABEL: @test_vloxei32_v_f16m1(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.vloxei.nxv4f16.nxv4i32.i64(<vscale x 4 x half> poison, ptr [[BASE:%.*]], <vscale x 4 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_vloxei32_v_f16m1(const _Float16 *base, vuint32m2_t bindex, size_t vl) {
  return __riscv_vloxei32_v_f16m1(base, bindex, vl);
}

// CHECK-ZVFHMIN-LABEL: @test_vsoxei32_v_f16m1(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    call void @llvm.riscv.vsoxei.nxv4f16.nxv4i32.i64(<vscale x 4 x half> [[VALUE:%.*]], ptr [[BASE:%.*]], <vscale x 4 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    ret void
//
void test_vsoxei32_v_f16m1(_Float16 *base, vuint32m2_t bindex, vfloat16m1_t value, size_t vl) {
  return __riscv_vsoxei32_v_f16m1(base, bindex, value, vl);
}

// CHECK-ZVFHMIN-LABEL: @test_vle16ff_v_f16m1(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = call { <vscale x 4 x half>, i64 } @llvm.riscv.vleff.nxv4f16.i64(<vscale x 4 x half> poison, ptr [[BASE:%.*]], i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    [[TMP1:%.*]] = extractvalue { <vscale x 4 x half>, i64 } [[TMP0]], 0
// CHECK-ZVFHMIN-NEXT:    [[TMP2:%.*]] = extractvalue { <vscale x 4 x half>, i64 } [[TMP0]], 1
// CHECK-ZVFHMIN-NEXT:    store i64 [[TMP2]], ptr [[NEW_VL:%.*]], align 8
// CHECK-ZVFHMIN-NEXT:    ret <vscale x 4 x half> [[TMP1]]
//
vfloat16m1_t test_vle16ff_v_f16m1(const _Float16 *base, size_t *new_vl, size_t vl) {
  return __riscv_vle16ff_v_f16m1(base, new_vl, vl);
}

// CHECK-ZVFHMIN-LABEL: @test_vlseg2e16_v_f16m1x2(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = call { <vscale x 4 x half>, <vscale x 4 x half> } @llvm.riscv.vlseg2.nxv4f16.i64(<vscale x 4 x half> poison, <vscale x 4 x half> poison, ptr [[BASE:%.*]], i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    ret { <vscale x 4 x half>, <vscale x 4 x half> } [[TMP0]]
//
vfloat16m1x2_t test_vlseg2e16_v_f16m1x2(const _Float16 *base, size_t vl) {
  return __riscv_vlseg2e16_v_f16m1x2(base, vl);
}

// CHECK-ZVFHMIN-LABEL: @test_vlseg2e16ff_v_f16m1x2(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = call { <vscale x 4 x half>, <vscale x 4 x half>, i64 } @llvm.riscv.vlseg2ff.nxv4f16.i64(<vscale x 4 x half> poison, <vscale x 4 x half> poison, ptr [[BASE:%.*]], i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    [[TMP1:%.*]] = extractvalue { <vscale x 4 x half>, <vscale x 4 x half>, i64 } [[TMP0]], 0
// CHECK-ZVFHMIN-NEXT:    [[TMP2:%.*]] = insertvalue { <vscale x 4 x half>, <vscale x 4 x half> } poison, <vscale x 4 x half> [[TMP1]], 0
// CHECK-ZVFHMIN-NEXT:    [[TMP3:%.*]] = extractvalue { <vscale x 4 x half>, <vscale x 4 x half>, i64 } [[TMP0]], 1
// CHECK-ZVFHMIN-NEXT:    [[TMP4:%.*]] = insertvalue { <vscale x 4 x half>, <vscale x 4 x half> } [[TMP2]], <vscale x 4 x half> [[TMP3]], 1
// CHECK-ZVFHMIN-NEXT:    [[TMP5:%.*]] = extractvalue { <vscale x 4 x half>, <vscale x 4 x half>, i64 } [[TMP0]], 2
// CHECK-ZVFHMIN-NEXT:    store i64 [[TMP5]], ptr [[NEW_VL:%.*]], align 8
// CHECK-ZVFHMIN-NEXT:    ret { <vscale x 4 x half>, <vscale x 4 x half> } [[TMP4]]
//
vfloat16m1x2_t test_vlseg2e16ff_v_f16m1x2(const _Float16 *base, size_t *new_vl, size_t vl) {
  return __riscv_vlseg2e16ff_v_f16m1x2(base, new_vl, vl);
}

// CHECK-ZVFHMIN-LABEL: @test_vlsseg2e16_v_f16m1x2(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = call { <vscale x 4 x half>, <vscale x 4 x half> } @llvm.riscv.vlsseg2.nxv4f16.i64(<vscale x 4 x half> poison, <vscale x 4 x half> poison, ptr [[BASE:%.*]], i64 [[BSTRIDE:%.*]], i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    ret { <vscale x 4 x half>, <vscale x 4 x half> } [[TMP0]]
//
vfloat16m1x2_t test_vlsseg2e16_v_f16m1x2(const _Float16 *base, ptrdiff_t bstride, size_t vl) {
  return __riscv_vlsseg2e16_v_f16m1x2(base, bstride, vl);
}

// CHECK-ZVFHMIN-LABEL: @test_vluxseg2ei32_v_f16m1x2(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = call { <vscale x 4 x half>, <vscale x 4 x half> } @llvm.riscv.vluxseg2.nxv4f16.nxv4i32.i64(<vscale x 4 x half> poison, <vscale x 4 x half> poison, ptr [[BASE:%.*]], <vscale x 4 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    ret { <vscale x 4 x half>, <vscale x 4 x half> } [[TMP0]]
//
vfloat16m1x2_t test_vluxseg2ei32_v_f16m1x2(const _Float16 *base, vuint32m2_t bindex, size_t vl) {
  return __riscv_vluxseg2ei32_v_f16m1x2(base, bindex, vl);
}

// CHECK-ZVFHMIN-LABEL: @test_vloxseg2ei32_v_f16m1x2(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = call { <vscale x 4 x half>, <vscale x 4 x half> } @llvm.riscv.vloxseg2.nxv4f16.nxv4i32.i64(<vscale x 4 x half> poison, <vscale x 4 x half> poison, ptr [[BASE:%.*]], <vscale x 4 x i32> [[BINDEX:%.*]], i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    ret { <vscale x 4 x half>, <vscale x 4 x half> } [[TMP0]]
//
vfloat16m1x2_t test_vloxseg2ei32_v_f16m1x2(const _Float16 *base, vuint32m2_t bindex, size_t vl) {
  return __riscv_vloxseg2ei32_v_f16m1x2(base, bindex, vl);
}

// CHECK-ZVFHMIN-LABEL: @test_vmerge_vvm_f16m1(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.vmerge.nxv4f16.nxv4f16.i64(<vscale x 4 x half> poison, <vscale x 4 x half> [[OP1:%.*]], <vscale x 4 x half> [[OP2:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_vmerge_vvm_f16m1(vfloat16m1_t op1, vfloat16m1_t op2, vbool16_t mask, size_t vl) {
  return __riscv_vmerge(op1, op2, mask, vl);
}

// CHECK-ZVFHMIN-LABEL: @test_vmv_v_v_f16m1(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.vmv.v.v.nxv4f16.i64(<vscale x 4 x half> poison, <vscale x 4 x half> [[SRC:%.*]], i64 [[VL:%.*]])
// CHECK-ZVFHMIN-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_vmv_v_v_f16m1(vfloat16m1_t src, size_t vl) {
  return __riscv_vmv_v(src, vl);
}

// CHECK-ZVFHMIN-LABEL: @test_vreinterpret_v_f16m1_i16m1(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x half> [[SRC:%.*]] to <vscale x 4 x i16>
// CHECK-ZVFHMIN-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vint16m1_t test_vreinterpret_v_f16m1_i16m1(vfloat16m1_t src) {
  return __riscv_vreinterpret_v_f16m1_i16m1(src);
}

// CHECK-ZVFHMIN-LABEL: @test_vreinterpret_v_f16m1_u16m1(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x half> [[SRC:%.*]] to <vscale x 4 x i16>
// CHECK-ZVFHMIN-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_vreinterpret_v_f16m1_u16m1(vfloat16m1_t src) {
  return __riscv_vreinterpret_v_f16m1_u16m1(src);
}

// CHECK-ZVFHMIN-LABEL: @test_vreinterpret_v_i16m1_f16m1(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i16> [[SRC:%.*]] to <vscale x 4 x half>
// CHECK-ZVFHMIN-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_vreinterpret_v_i16m1_f16m1(vint16m1_t src) {
  return __riscv_vreinterpret_v_i16m1_f16m1(src);
}

// CHECK-ZVFHMIN-LABEL: @test_vreinterpret_v_u16m1_f16m1(
// CHECK-ZVFHMIN-NEXT:  entry:
// CHECK-ZVFHMIN-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i16> [[SRC:%.*]] to <vscale x 4 x half>
// CHECK-ZVFHMIN-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_vreinterpret_v_u16m1_f16m1(vuint16m1_t src) {
  return __riscv_vreinterpret_v_u16m1_f16m1(src);
}
