// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{ffi, Caps, Object, Pad, PadDirection, PadPresence};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GstPadTemplate")]
    pub struct PadTemplate(Object<ffi::GstPadTemplate, ffi::GstPadTemplateClass>) @extends Object;

    match fn {
        type_ => || ffi::gst_pad_template_get_type(),
    }
}

impl PadTemplate {
    #[doc(alias = "gst_pad_template_new")]
    pub fn new(
        name_template: &str,
        direction: PadDirection,
        presence: PadPresence,
        caps: &Caps,
    ) -> Result<PadTemplate, glib::BoolError> {
        assert_initialized_main_thread!();
        unsafe {
            Option::<_>::from_glib_none(ffi::gst_pad_template_new(
                name_template.to_glib_none().0,
                direction.into_glib(),
                presence.into_glib(),
                caps.to_glib_none().0,
            ))
            .ok_or_else(|| glib::bool_error!("Failed to create pad template"))
        }
    }

    #[doc(alias = "gst_pad_template_new_with_gtype")]
    #[doc(alias = "new_with_gtype")]
    pub fn with_gtype(
        name_template: &str,
        direction: PadDirection,
        presence: PadPresence,
        caps: &Caps,
        pad_type: glib::types::Type,
    ) -> Result<PadTemplate, glib::BoolError> {
        assert_initialized_main_thread!();
        unsafe {
            Option::<_>::from_glib_none(ffi::gst_pad_template_new_with_gtype(
                name_template.to_glib_none().0,
                direction.into_glib(),
                presence.into_glib(),
                caps.to_glib_none().0,
                pad_type.into_glib(),
            ))
            .ok_or_else(|| glib::bool_error!("Failed to create pad template"))
        }
    }

    #[doc(alias = "gst_pad_template_pad_created")]
    pub fn pad_created(&self, pad: &impl IsA<Pad>) {
        unsafe {
            ffi::gst_pad_template_pad_created(self.to_glib_none().0, pad.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "pad-created")]
    pub fn connect_pad_created<F: Fn(&Self, &Pad) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn pad_created_trampoline<
            F: Fn(&PadTemplate, &Pad) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstPadTemplate,
            pad: *mut ffi::GstPad,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(pad))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"pad-created\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    pad_created_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

unsafe impl Send for PadTemplate {}
unsafe impl Sync for PadTemplate {}
