/* Copyright  (C) 2010-2017 The RetroArch team
 *
 * ---------------------------------------------------------------------------------------
 * The following license statement only applies to this file (vector_3.c).
 * ---------------------------------------------------------------------------------------
 *
 * Permission is hereby granted, free of charge,
 * to any person obtaining a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <stdint.h>
#include <math.h>

#include <gfx/math/vector_3.h>

float vec3_dot(const float *a, const float *b) 
{
	return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
}

void vec3_cross(float* dst, const float *a, const float *b) 
{
   dst[0] = a[1]*b[2] - a[2]*b[1];
   dst[1] = a[2]*b[0] - a[0]*b[2];
   dst[2] = a[0]*b[1] - a[1]*b[0];
}

float vec3_length(const float *a)
{
	float length_sq     = vec3_dot(a,a);
	float length        = sqrtf(length_sq);
	return length;
}

void vec3_add(float *dst, const float *src)
{
   unsigned i;
   unsigned n = 3;

   for (i = 0; i < n; i++)
      dst[i] += src[i];
}

void vec3_subtract(float *dst, const float *src)
{
   unsigned i;
   unsigned n = 3;

   for (i = 0; i < n; i++)
      dst[i] -= src[i];
}

void vec3_scale(float *dst, const float scale)
{
   unsigned i;
   unsigned n = 3;

   for (i = 0; i < n; i++)
      dst[i] *= scale;
}

void vec3_copy(float *dst, const float *src)
{
   unsigned i;
   unsigned n = 3;

   for (i = 0; i < n; i++)
      dst[i] = src[i];
}

void vec3_normalize(float *dst)
{
	float length = vec3_length(dst);
	vec3_scale(dst,1.0f/length);
}
