#! /bin/sh

# Test representation of a table with URLs

TMP_DIR="${TMPDIR}"

test -z "${LIB_DIR}" && LIB_DIR=lib

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pm)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

TMP_DB_MAIN="${TMP_DIR}/test4fk.db"
TMP_DB_META="${TMP_DIR}/restful.db"
TMP_DB_MAIN_ABS=$(cd $(dirname ${TMP_DB_MAIN}); pwd)/test4fk.db

sqlite3 ${TMP_DB_MAIN} < tests/inputs/samples-r92.sql

sqlite3 ${TMP_DB_META} < sql/metatables.sql
sqlite3 ${TMP_DB_META} < tests/inputs/samples-metadata-r92.sql
sqlite3 ${TMP_DB_META} <<END
    insert into description (id, dbtable, dbcolumn, coltype, fk_target)
        values (134, 'lithology_img', 'caption', 'filename', 122);
END
sqlite3 ${TMP_DB_META} "update description set dbname = '${TMP_DB_MAIN_ABS}'"

export TMP_DB_MAIN

(
perl <<'END'
#! /usr/bin/env perl

# Test package that computes default database settings:

use strict;
use warnings;
use utf8;
use Data::Dumper;
use Digest::MD5 qw(md5_hex);

use lib 'lib';
use Database;

binmode( STDOUT, "utf8" );

$Data::Dumper::Sortkeys = 1;
$Data::Dumper::Indent   = 1;

my $db_settings = {
    content_db => {
        DB => $ENV{TMP_DB_MAIN},
        engine => 'SQLite'            
    }
};

my $db = Database->new( $db_settings );
$db->connect();

my $handle;
open( $handle, 'tests/inputs/small-diamond.png' );
$db->_insert_record( { image => 'diamond.png',
                       format => 'PNG',
                       uuid => 'aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaaa' },
                     'lithology_img',
                     { handles => { image => $handle } } );
close $handle;

my $record;

( $record ) = @{$db->get_records( 'lithology_img', 1 )};
$record->{image} = md5_hex( $record->{image} );
print Dumper $record;

open( $handle, 'tests/inputs/small-diamond.png' );
$db->_update_record( { image => 'diamond.png',
                       caption => 'real-name-of-the-image.png' },
                     1,
                     'lithology_img',
                     { handles => { image => $handle } } );
close $handle;

( $record ) = @{$db->get_records( 'lithology_img', 1 )};
$record->{image} = md5_hex( $record->{image} );
print Dumper $record;
END
)

# Temporary directory will be deleted by the trap.
