% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{stri_join}
\alias{stri_join}
\alias{stri_c}
\alias{stri_paste}
\title{Concatenate Character Vectors}
\usage{
stri_join(..., sep = "", collapse = NULL, ignore_null = FALSE)

stri_c(..., sep = "", collapse = NULL, ignore_null = FALSE)

stri_paste(..., sep = "", collapse = NULL, ignore_null = FALSE)
}
\arguments{
\item{...}{character vectors (or objects coercible to character vectors)
whose corresponding elements are to be concatenated}

\item{sep}{a single string; separates terms}

\item{collapse}{a single string or \code{NULL}; an optional
results separator}

\item{ignore_null}{a single logical value; if \code{TRUE}, then empty
vectors provided via \code{...} are silently ignored}
}
\value{
Returns a character vector.
}
\description{
These are the \pkg{stringi}'s equivalents of the built-in
\code{\link{paste}} function.
\code{stri_c} and \code{stri_paste} are aliases for \code{stri_join}.
}
\details{
Vectorized over each atomic vector in `\code{...}`.

Unless \code{collapse} is \code{NULL}, the result will be a single string.
Otherwise, you get a character vector of length equal
to the length of the longest argument.

If any of the arguments in `\code{...}` is a vector of length 0
(not to be confused with vectors of empty strings)
and \code{ignore_null} is \code{FALSE}, then
you will get a 0-length character vector in result.

If \code{collapse} or \code{sep} has length greater than 1,
then only the first string will be used.

In case where there are missing values in any of the input vectors,
\code{NA} is set to the corresponding element.
Note that this behavior is different from \code{\link{paste}},
which treats missing values as ordinary strings like \code{'NA'}.
Moreover, as usual in \pkg{stringi}, the resulting strings are
always in UTF-8.
}
\examples{
stri_join(1:13, letters)
stri_join(1:13, letters, sep=',')
stri_join(1:13, letters, collapse='; ')
stri_join(1:13, letters, sep=',', collapse='; ')
stri_join(c('abc', '123', 'xyz'),'###', 1:6, sep=',')
stri_join(c('abc', '123', 'xyz'),'###', 1:6, sep=',', collapse='; ')

}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Other join: 
\code{\link{\%s+\%}()},
\code{\link{stri_dup}()},
\code{\link{stri_flatten}()},
\code{\link{stri_join_list}()}
}
\concept{join}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
