% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_migrate.R
\name{collection_migrate}
\alias{collection_migrate}
\title{Migrate documents to another collection}
\usage{
collection_migrate(conn, name, target.collection, split.key,
  forward.timeout = NULL, async = NULL, raw = FALSE,
  callopts = list())
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{name}{(character) The name of the core to be created. Required}

\item{target.collection}{(character) Required. The name of the target collection
to which documents will be migrated}

\item{split.key}{(character) Required. The routing key prefix. For example, if
uniqueKey is a!123, then you would use split.key=a!}

\item{forward.timeout}{(integer) The timeout (seconds), until which write requests
made to the source collection for the given \code{split.key} will be forwarded to the
target shard. Default: 60}

\item{async}{(character) Request ID to track this action which will be processed
asynchronously}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{callopts}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Migrate documents to another collection
}
\examples{
\dontrun{
(conn <- SolrClient$new())

# create collection
if (!conn$collection_exists("migrate_from")) {
  conn$collection_create(name = "migrate_from")
  # OR: bin/solr create -c migrate_from
}

# create another collection
if (!conn$collection_exists("migrate_to")) {
  conn$collection_create(name = "migrate_to")
  # OR bin/solr create -c migrate_to
}

# add some documents
file <- system.file("examples", "books.csv", package = "solrium")
x <- read.csv(file, stringsAsFactors = FALSE)
conn$add(x, "migrate_from")

# migrate some documents from one collection to the other
## FIXME - not sure if this is actually working....
# conn$collection_migrate("migrate_from", "migrate_to", split.key = "05535")
}
}
