% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{quo_squash}
\alias{quo_squash}
\title{Squash a quosure}
\usage{
quo_squash(quo, warn = FALSE)
}
\arguments{
\item{quo}{A quosure or expression.}

\item{warn}{Whether to warn if the quosure contains other quosures
(those will be collapsed). This is useful when you use
\code{quo_squash()} in order to make a non-tidyeval API compatible
with quosures. In that case, getting rid of the nested quosures
is likely to cause subtle bugs and it is good practice to warn
the user about it.}
}
\description{
\code{quo_squash()} flattens all nested quosures within an expression.
For example it transforms \verb{^foo(^bar(), ^baz)} to the bare
expression \code{foo(bar(), baz)}.

This operation is safe if the squashed quosure is used for
labelling or printing (see \code{\link[=quo_label]{quo_label()}} or \code{\link[=quo_name]{quo_name()}}). However
if the squashed quosure is evaluated, all expressions of the
flattened quosures are resolved in a single environment. This is a
source of bugs so it is good practice to set \code{warn} to \code{TRUE} to
let the user know about the lossy squashing.
}
\section{Life cycle}{


This function replaces \code{quo_expr()} which was deprecated in
rlang 0.2.0. \code{quo_expr()} was a misnomer because it implied that it
was a mere expression acccessor for quosures whereas it was really
a lossy operation that squashed all nested quosures.
}

\examples{
# Quosures can contain nested quosures:
quo <- quo(wrapper(!!quo(wrappee)))
quo

# quo_squash() flattens all the quosures and returns a simple expression:
quo_squash(quo)
}
