% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{PyClass}
\alias{PyClass}
\title{Create a python class}
\usage{
PyClass(classname, defs = list(), inherit = NULL)
}
\arguments{
\item{classname}{Name of the class. The class name is useful for S3 method
dispatch.}

\item{defs}{A named list of class definitions - functions, attributes, etc.}

\item{inherit}{A list of Python class objects. Usually these objects have
the \code{python.builtin.type} S3 class.}
}
\description{
Create a python class
}
\examples{
\dontrun{
Hi <- PyClass("Hi", list(
  name = NULL,
  `__init__` = function(self, name) {
    self$name <- name
    NULL
  },
  say_hi = function(self) {
    paste0("Hi ", self$name)
  }
))

a <- Hi("World")
}

}
