% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Query.R
\docType{class}
\name{Query-class}
\alias{Query-class}
\alias{Query}
\title{Query an RDF model}
\description{
The Query class is used to execute a query on a Model object using the default query
language SPARQL. For more information, please refer to \url{https://librdf.org/rasqal/} for details on
supported query languages.
}
\details{
A Query is executed using the executeQuery method, which returns a QueryResults object that
can be iterated over the query solution sequence.
}
\section{Slots}{

\describe{
\item{\code{librdf_query}}{A redland query object}

\item{\code{librdf_world}}{A redland world object}
}}

\section{Methods}{

\itemize{
\item{\code{\link{Query-initialize}}}{: Initialize a Query object.}
\item{\code{\link{executeQuery}}}{: Execute a query.}
\item{\code{\link{setQueryResultLimit}}}{: Set limit on returned query results.}
\item{\code{\link{getQueryResultLimit}}}{: Get the query result limit.}
\item{\code{\link{getResults}}}{: Return all query results.}
\item{\code{\link{writeResults}}}{: Write query results to a file.}
\item{\code{\link{freeParser}}}{: Free memory used by a librdf query.}
}
}

\examples{
world <- new("World")
storage <- new("Storage", world, "hashes", name="", options="hash-type='memory'")
model <- new("Model", world, storage, options="")
stmt <- new("Statement", world=world, 
  subject="https://cn.dataone.org/cn/v1/resolve/urn:uuid:274a0c5c-3082-4562-bbd3-2b1288768cac",
  predicate="http://www.w3.org/ns/prov#hadPlan",
  object="https://cn.dataone.org/cn/v1/resolve/urn:uuid:01305f45-f22b-40c8-8d27-00357d01e4a5")
status <- addStatement(model, stmt)
stmt <- new("Statement", world=world, 
           subject="https://orcid.org/0000-0002-2192-403X",
           predicate="http://www.w3.org/ns/prov#Agent",
           object="slaughter", 
           objectType="literal", 
           datatype_uri="http://www.w3.org/2001/XMLSchema#string")
status <- addStatement(model, stmt)
queryString <- 
    paste("PREFIX orcid: <https://orcid.org/>",
          "PREFIX dataone: <https://cn.dataone.org/cn/v1/resolve/>",
          "PREFIX prov: <http://www.w3.org/ns/prov#>",
          "SELECT ?a ?c WHERE { ?a prov:Agent ?c . }", sep=" ")
query <- new("Query", world, queryString, base_uri=NULL, query_language="sparql", query_uri=NULL)
# Return all results as a string
results <- getResults(query, model, "rdfxml")

}
\references{
www.example.com
}
\seealso{
\code{\link{redland}}{: redland package}
}
\keyword{classes}
