% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/system.R
\name{ps_system_cpu_times}
\alias{ps_system_cpu_times}
\title{System CPU times.}
\usage{
ps_system_cpu_times()
}
\value{
Named list
}
\description{
Every attribute represents the seconds the CPU has spent in the given
mode. The attributes availability varies depending on the platform:
\itemize{
\item \code{user}: time spent by normal processes executing in user mode;
on Linux this also includes guest time.
\item \code{system}: time spent by processes executing in kernel mode.
\item \code{idle}: time spent doing nothing.
}
}
\details{
Platform-specific fields:
\itemize{
\item \code{nice} (UNIX): time spent by niced (prioritized) processes executing
in user mode; on Linux this also includes guest_nice time.
\item \code{iowait} (Linux): time spent waiting for I/O to complete. This is not
accounted in idle time counter.
\item \code{irq} (Linux): time spent for servicing hardware interrupts.
\item \code{softirq} (Linux): time spent for servicing software interrupts.
\item \code{steal} (Linux 2.6.11+): time spent by other operating systems
running in a virtualized environment.
\item \code{guest} (Linux 2.6.24+): time spent running a virtual CPU for guest
operating systems under the control of the Linux kernel.
\item \code{guest_nice} (Linux 3.2.0+): time spent running a niced guest
(virtual CPU for guest operating systems under the control of the
Linux kernel).
}
}
\examples{
\dontshow{if (ps::ps_is_supported()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ps_system_cpu_times()
\dontshow{\}) # examplesIf}
}
