% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.glmnet.R
\name{print.glmnet}
\alias{print.glmnet}
\alias{print.relaxed}
\alias{print.bigGlm}
\title{print a glmnet object}
\usage{
\method{print}{glmnet}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{fitted glmnet object}

\item{digits}{significant digits in printout}

\item{\dots}{additional print arguments}
}
\value{
The matrix above is silently returned
}
\description{
Print a summary of the glmnet path at each step along the path.
}
\details{
The call that produced the object \code{x} is printed, followed by a
three-column matrix with columns \code{Df}, \code{\%Dev} and \code{Lambda}.
The \code{Df} column is the number of nonzero coefficients (Df is a
reasonable name only for lasso fits). \code{\%Dev} is the percent deviance
explained (relative to the null deviance).  In the case of a 'relaxed' fit,
an additional column is inserted, \code{\%Dev R} which gives the percent
deviance explained by the relaxed model. For a "bigGlm" model, a simpler
summary is printed.
}
\examples{

x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
fit1 = glmnet(x, y)
print(fit1)
}
\references{
Friedman, J., Hastie, T. and Tibshirani, R. (2008). Regularization Paths for Generalized Linear Models via Coordinate Descent
}
\seealso{
\code{glmnet}, \code{predict} and \code{coef} methods.
}
\keyword{models}
\keyword{regression}
