% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-quasirandom.R
\name{geom_quasirandom}
\alias{geom_quasirandom}
\title{Points, jittered to reduce overplotting using the vipor package}
\usage{
geom_quasirandom(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  ...,
  method = "quasirandom",
  width = NULL,
  varwidth = FALSE,
  bandwidth = 0.5,
  nbins = NULL,
  dodge.width = NULL,
  groupOnX = NULL,
  orientation = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}} or
\code{\link[ggplot2]{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{...}{other arguments passed to \link[ggplot2:layer]{ggplot2::layer} \code{params} argument.}

\item{method}{Method used for distributing points.
Options are \code{"quasirandom"} (default), \code{"pseudorandom"}, \code{"smiley"}, \code{"maxout"}, \code{"frowney"}, \code{"minout"}, \code{"tukey"}, \code{"tukeyDense"}.
See \code{\link[vipor:offsetX]{vipor::offsetSingleGroup()}} for the details of each method.}

\item{width}{Maximum amount of spread (default: 0.4)}

\item{varwidth}{Vary the width by the relative size of each group. (default: \code{FALSE})}

\item{bandwidth}{the bandwidth adjustment to use when calculating density
Smaller numbers (< 1) produce a tighter "fit". (default: 0.5)}

\item{nbins}{the number of bins used when calculating density
(has little effect with quasirandom/random distribution)}

\item{dodge.width}{Amount by which points from different aesthetic groups
will be dodged. This requires that one of the aesthetics is a factor.
To disable dodging between groups, set this to NULL. (default: 0)}

\item{groupOnX}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}} See \code{orientation}.}

\item{orientation}{The orientation (i.e., which axis to group on) is inferred from the data.
This can be overridden by setting \code{orientation} to either \code{"x"} or \code{"y"}.}

\item{na.rm}{if \code{FALSE} (default), missing values are removed with a warning.
If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\description{
The quasirandom geom is a convenient means to offset points within categories
to reduce overplotting. Uses the vipor package.
}
\examples{
  # Generate fake data
  distro <- data.frame(
    'variable'=rep(c('runif','rnorm'),each=100),
    'value'=c(runif(100, min=-3, max=3), rnorm(100))
  )
  ggplot2::ggplot(distro, ggplot2::aes(variable, value)) + 
  geom_quasirandom(width=0.1)
}
\seealso{
\code{\link[vipor:offsetX]{vipor::offsetSingleGroup()}} how spacing is determined,
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}} for regular, unjittered points,
\code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}} for jittered points,
\code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}} for another way of looking at the conditional
distribution of a variable
}
