%                               -*- Mode: Rd -*- 
% perturb.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:03:54 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Thu Dec 04 13:17:30 2008
% Update Count    : 31
% Status          : Unknown, Use with caution!
% 
\encoding{latin1}
\name{perturb}
\alias{perturb}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Perturbs a network}

\description{Randomly insert/delete/turn arrows to obtain another network.
}

\usage{
perturb(nw,data,prior,degree=size(nw),trylist=vector("list",size(nw)),
        nocalc=FALSE,timetrace=TRUE) 
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{nw}{an object of class \code{network}, from which arrows are added/removed/turned.}
  \item{data}{a data frame used for learning the network, see
    \code{\link{network}}.} 
  \item{prior}{a list containing parameter priors, generated by
    \code{\link{jointprior}}.} 
  \item{degree}{an integer, which gives the number of attempts to randomly
    insert/remove/turn an arrow.}
  \item{trylist}{a list used internally for reusing learning of nodes,
    see \code{\link{maketrylist}}.} 
  \item{nocalc}{a logical. If \code{TRUE} no learning procedure is called, see eg. \code{\link{rnetwork}}.}
  \item{timetrace}{a logical. If \code{TRUE}, prints some timing
    information on the screen.} 
}

\details{
  Given the initial network, a new network is constructed by randomly
  choosing an action: remove, turn, add. After the action is chosen, we
  choose randomly among all possibilities of that action. If there are
  no possibilites, the unchanged network is returned.}

\value{A list with two elements that may be accessed using
  \code{\link{getnetwork}} and \code{\link{gettrylist}}. The elements are
  \item{nw}{an object of class \code{\link{network}} with the generated network.}
  \item{trylist}{an updated list used internally for reusing learning
    of nodes, see \code{\link{maketrylist}}.}
}

% \references{
%   Further information about \bold{deal} can be found at:\cr
%   \url{http://www.math.aau.dk/~dethlef/novo/deal}.
% }

\author{
  Susanne Gammelgaard Bottcher, \cr
  Claus Dethlefsen \email{rpackage.deal@gmail.com}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\examples{
set.seed(200)
data(rats)
fit       <- network(rats)
fit.prior <- jointprior(fit)
fit       <- getnetwork(learn(fit,rats,fit.prior))
fit.new   <- getnetwork(perturb(fit,rats,fit.prior,degree=10))

data(ksl)
ksl.nw    <- network(ksl)
ksl.rand  <- getnetwork(perturb(ksl.nw,nocalc=TRUE,degree=10))
plot(ksl.rand)
}

\keyword{iplot}
