% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macros.R
\name{cmd_path_search}
\alias{cmd_path_search}
\title{Macro for constructing target path validators}
\usage{
cmd_path_search(
  environment_var = NULL,
  option_name = NULL,
  default_path = NULL,
  utils = NULL
)
}
\arguments{
\item{environment_var}{name of R environment variable defining target path. Can be set in .Renviron.}

\item{option_name}{name of user-configurable option (called by getOption) which will hold path to target}

\item{default_path}{default install path of target. Can contain shell
specials like "~" which will be expanded at runtime (as opposed to build time of the search function).}

\item{utils}{optional character vector containing names of valid utils inside
target path, used to populate error checking for valid install.}
}
\value{
function that returns a valid path to tool or optional utility.

The returned path_search function takes as input a path or util. where path
is a user override path for the supported tool. If the user-defined path is
invalid, this will always throw an error and not search the defined defaults.

util must be found within the target path, but does not have to be present in
the original "utils" call. The user will be warned if this is the case. If
\code{util} is set to \code{TRUE} will return all paths to utilities without checking
the install. This can be used for writing user-facing install checkers.
}
\description{
A common pattern in designing shell interfaces is to ask the user to give an
absolute path to the target shell utility. It is common to pass this
information from the user to R by using either R environment variables
defined in .Renviron, using options (set with option(), and got with
getOption()), having the user explicitly pass the path in the function call,
or failing this, using a default install path.
}
\details{
Another common use-case involves software packages with many tools packaged
in a single directory, and the user may want to call one or many utilities
within this common structure.

For example, the software "coolpackage" is installed in "~/coolpackage", and
has two programs: "tool1", and "tool2" found in "~/coolpackage/tool1" and
~/coolpackage/tool2", respectively.

To design an interface to coolpackage, this function can automate checking
and validation for not only the package, but for each desired utility in the
package.

The hierarchy of path usage is: user-defined > option_name > environment_var > default_path
}
\examples{
if (.Platform$OS.type == "unix") {
bin_checker <- cmd_path_search(default_path = "/bin", utils = c("ls", "pwd"))
# returns path to bin
bin_checker()
# returns path to bin/ls
bin_checker(util = "ls")
}
}
