% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansiex.R
\name{ansi_nchar}
\alias{ansi_nchar}
\title{Count number of characters in an ANSI colored string}
\usage{
ansi_nchar(x, type = c("chars", "bytes", "width", "graphemes", "codepoints"))
}
\arguments{
\item{x}{Character vector, potentially ANSI styled, or a vector to be
coerced to character. If it converted to UTF-8.}

\item{type}{Whether to count graphemes (characters), code points,
bytes, or calculate the display width of the string.}
}
\value{
Numeric vector, the length of the strings in the character
vector.
}
\description{
This is a color-aware counterpart of \code{\link[=utf8_nchar]{utf8_nchar()}}. By default it
counts Unicode grapheme clusters, instead of code points.
}
\examples{
str <- paste(
  col_red("red"),
  "default",
  col_green("green")
)

cat(str, "\n")
nchar(str)
ansi_nchar(str)
nchar(ansi_strip(str))
}
\seealso{
Other ANSI string operations: 
\code{\link{ansi_align}()},
\code{\link{ansi_columns}()},
\code{\link{ansi_strsplit}()},
\code{\link{ansi_strtrim}()},
\code{\link{ansi_strwrap}()},
\code{\link{ansi_substring}()},
\code{\link{ansi_substr}()},
\code{\link{ansi_toupper}()},
\code{\link{ansi_trimws}()}
}
\concept{ANSI string operations}
