% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessor-generics.r
\name{destiny generics}
\alias{destiny generics}
\alias{eigenvalues}
\alias{eigenvalues<-}
\alias{eigenvectors}
\alias{eigenvectors<-}
\alias{sigmas}
\alias{sigmas<-}
\alias{dataset}
\alias{dataset<-}
\alias{distance}
\alias{distance<-}
\alias{optimal_sigma}
\title{destiny generics}
\usage{
eigenvalues(object)

eigenvalues(object) <- value

eigenvectors(object)

eigenvectors(object) <- value

sigmas(object)

sigmas(object) <- value

dataset(object)

dataset(object) <- value

distance(object)

distance(object) <- value

optimal_sigma(object)
}
\arguments{
\item{object}{Object from which to extract or to which to assign a value}

\item{value}{Value to assign within an object}
}
\value{
\code{eigenvalues} retrieves the numeric eigenvalues

\code{eigenvectors} retrieves the eigenvectors matrix

\code{sigmas} retrieves the \code{\link{Sigmas}} from an object utilizing it as kernel width

\code{dataset} retrieves the data the object was created from

\code{distance} retrieves the distance metric used to create the object, e.g. \code{euclidean}

\code{optimal_sigma} retrieves the numeric value of the optimal sigma or local sigmas
}
\description{
destiny provides several generic methods and implements them for the \code{\link{DiffusionMap}} and \code{\link{Sigmas}} classes.
}
\examples{
data(guo_norm)
dm <- DiffusionMap(guo_norm)
eigenvalues(dm)
eigenvectors(dm)
sigmas(dm)
optimal_sigma(dm)
dataset(dm)
distance(dm)

}
\seealso{
\link{DiffusionMap methods} and \link{Sigmas} class for implementations
}
