/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "plugin.h"

#include "pluginsinterfaces.h"

Plugin::Plugin() :
  m_plugin(NULL),
  m_type(Basic),
  m_isLoaded(false)
{
}

Plugin::~Plugin()
{
}

bool Plugin::load()
{
  if(m_plugin->load())
  {
    QChatBasicPlugin* plug = instanceBasic();

    if(plug)
    {
      plug->load();
      m_isLoaded = true;
      return 1;
    }
    else
      m_plugin->unload();
  }

  return 0;
}

bool Plugin::unload()
{
  QChatBasicPlugin* plug = instanceBasic();

  if(plug)
  {
    plug->unload();
    delete plug;

    m_plugin->unload();
    m_isLoaded = false;
    return 1;
  }

  return 0;
}

QObject* Plugin::instance()
{
  return m_plugin->instance();
}

QChatWidgetPlugin* Plugin::instanceWgt()
{
  return qobject_cast<QChatWidgetPlugin*>(m_plugin->instance());
}

QChatBasicPlugin* Plugin::instanceBasic()
{
  QChatBasicPlugin* pl = qobject_cast<QChatBasicPlugin*>(m_plugin->instance());

  if(!pl)
    pl = qobject_cast<QChatWidgetPlugin*>(m_plugin->instance());

  return pl;
}
