# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    from .. import models as _models


class AadConfiguration(_serialization.Model):
    """AadConfiguration represents the Azure Active Directory Integration properties.

    All required parameters must be populated in order to send to server.

    :ivar admin_group_object_ids: The list of Azure Active Directory group object IDs that will
     have an administrative role on the Kubernetes cluster. Required.
    :vartype admin_group_object_ids: list[str]
    """

    _validation = {
        "admin_group_object_ids": {"required": True, "min_items": 1},
    }

    _attribute_map = {
        "admin_group_object_ids": {"key": "adminGroupObjectIds", "type": "[str]"},
    }

    def __init__(self, *, admin_group_object_ids: List[str], **kwargs: Any) -> None:
        """
        :keyword admin_group_object_ids: The list of Azure Active Directory group object IDs that will
         have an administrative role on the Kubernetes cluster. Required.
        :paramtype admin_group_object_ids: list[str]
        """
        super().__init__(**kwargs)
        self.admin_group_object_ids = admin_group_object_ids


class AdministrativeCredentials(_serialization.Model):
    """AdministrativeCredentials represents the admin credentials for the device requiring
    password-based authentication.

    All required parameters must be populated in order to send to server.

    :ivar password: The password of the administrator of the device used during initialization.
     Required.
    :vartype password: str
    :ivar username: The username of the administrator of the device used during initialization.
     Required.
    :vartype username: str
    """

    _validation = {
        "password": {"required": True, "min_length": 1},
        "username": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "password": {"key": "password", "type": "str"},
        "username": {"key": "username", "type": "str"},
    }

    def __init__(self, *, password: str, username: str, **kwargs: Any) -> None:
        """
        :keyword password: The password of the administrator of the device used during initialization.
         Required.
        :paramtype password: str
        :keyword username: The username of the administrator of the device used during initialization.
         Required.
        :paramtype username: str
        """
        super().__init__(**kwargs)
        self.password = password
        self.username = username


class AdministratorConfiguration(_serialization.Model):
    """AdministratorConfiguration represents the administrative credentials that will be applied to
    the control plane and agent pool nodes in Kubernetes clusters.

    :ivar admin_username: The user name for the administrator that will be applied to the operating
     systems that run Kubernetes nodes. If not supplied, a user name will be chosen by the service.
    :vartype admin_username: str
    :ivar ssh_public_keys: The SSH configuration for the operating systems that run the nodes in
     the Kubernetes cluster. In some cases, specification of public keys may be required to produce
     a working environment.
    :vartype ssh_public_keys: list[~azure.mgmt.networkcloud.models.SshPublicKey]
    """

    _attribute_map = {
        "admin_username": {"key": "adminUsername", "type": "str"},
        "ssh_public_keys": {"key": "sshPublicKeys", "type": "[SshPublicKey]"},
    }

    def __init__(
        self,
        *,
        admin_username: Optional[str] = None,
        ssh_public_keys: Optional[List["_models.SshPublicKey"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword admin_username: The user name for the administrator that will be applied to the
         operating systems that run Kubernetes nodes. If not supplied, a user name will be chosen by the
         service.
        :paramtype admin_username: str
        :keyword ssh_public_keys: The SSH configuration for the operating systems that run the nodes in
         the Kubernetes cluster. In some cases, specification of public keys may be required to produce
         a working environment.
        :paramtype ssh_public_keys: list[~azure.mgmt.networkcloud.models.SshPublicKey]
        """
        super().__init__(**kwargs)
        self.admin_username = admin_username
        self.ssh_public_keys = ssh_public_keys


class AdministratorConfigurationPatch(_serialization.Model):
    """AdministratorConfigurationPatch represents the patching capabilities for the administrator
    configuration.

    :ivar ssh_public_keys: SshPublicKey represents the public key used to authenticate with a
     resource through SSH.
    :vartype ssh_public_keys: list[~azure.mgmt.networkcloud.models.SshPublicKey]
    """

    _attribute_map = {
        "ssh_public_keys": {"key": "sshPublicKeys", "type": "[SshPublicKey]"},
    }

    def __init__(self, *, ssh_public_keys: Optional[List["_models.SshPublicKey"]] = None, **kwargs: Any) -> None:
        """
        :keyword ssh_public_keys: SshPublicKey represents the public key used to authenticate with a
         resource through SSH.
        :paramtype ssh_public_keys: list[~azure.mgmt.networkcloud.models.SshPublicKey]
        """
        super().__init__(**kwargs)
        self.ssh_public_keys = ssh_public_keys


class AgentOptions(_serialization.Model):
    """AgentOptions are configurations that will be applied to each agent in an agent pool.

    All required parameters must be populated in order to send to server.

    :ivar hugepages_count: The number of hugepages to allocate. Required.
    :vartype hugepages_count: int
    :ivar hugepages_size: The size of the hugepages to allocate. Known values are: "2M" and "1G".
    :vartype hugepages_size: str or ~azure.mgmt.networkcloud.models.HugepagesSize
    """

    _validation = {
        "hugepages_count": {"required": True},
    }

    _attribute_map = {
        "hugepages_count": {"key": "hugepagesCount", "type": "int"},
        "hugepages_size": {"key": "hugepagesSize", "type": "str"},
    }

    def __init__(
        self, *, hugepages_count: int, hugepages_size: Union[str, "_models.HugepagesSize"] = "2M", **kwargs: Any
    ) -> None:
        """
        :keyword hugepages_count: The number of hugepages to allocate. Required.
        :paramtype hugepages_count: int
        :keyword hugepages_size: The size of the hugepages to allocate. Known values are: "2M" and
         "1G".
        :paramtype hugepages_size: str or ~azure.mgmt.networkcloud.models.HugepagesSize
        """
        super().__init__(**kwargs)
        self.hugepages_count = hugepages_count
        self.hugepages_size = hugepages_size


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class AgentPool(TrackedResource):
    """AgentPool represents the agent pool of Kubernetes cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location of the cluster associated with the resource.
    :vartype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar administrator_configuration: The administrator credentials to be used for the nodes in
     this agent pool.
    :vartype administrator_configuration:
     ~azure.mgmt.networkcloud.models.AdministratorConfiguration
    :ivar agent_options: The configurations that will be applied to each agent in this agent pool.
    :vartype agent_options: ~azure.mgmt.networkcloud.models.AgentOptions
    :ivar attached_network_configuration: The configuration of networks being attached to the agent
     pool for use by the workloads that run on this Kubernetes cluster.
    :vartype attached_network_configuration:
     ~azure.mgmt.networkcloud.models.AttachedNetworkConfiguration
    :ivar availability_zones: The list of availability zones of the Network Cloud cluster used for
     the provisioning of nodes in this agent pool. If not specified, all availability zones will be
     used.
    :vartype availability_zones: list[str]
    :ivar count: The number of virtual machines that use this configuration. Required.
    :vartype count: int
    :ivar detailed_status: The current status of the agent pool. Known values are: "Available",
     "Error", and "Provisioning".
    :vartype detailed_status: str or ~azure.mgmt.networkcloud.models.AgentPoolDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar kubernetes_version: The Kubernetes version running in this agent pool.
    :vartype kubernetes_version: str
    :ivar labels: The labels applied to the nodes in this agent pool.
    :vartype labels: list[~azure.mgmt.networkcloud.models.KubernetesLabel]
    :ivar mode: The selection of how this agent pool is utilized, either as a system pool or a user
     pool. System pools run the features and critical services for the Kubernetes Cluster, while
     user pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one
     system node pool with at least one node. Required. Known values are: "System", "User", and
     "NotApplicable".
    :vartype mode: str or ~azure.mgmt.networkcloud.models.AgentPoolMode
    :ivar provisioning_state: The provisioning state of the agent pool. Known values are:
     "Accepted", "Canceled", "Deleting", "Failed", "InProgress", "Succeeded", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.networkcloud.models.AgentPoolProvisioningState
    :ivar taints: The taints applied to the nodes in this agent pool.
    :vartype taints: list[~azure.mgmt.networkcloud.models.KubernetesLabel]
    :ivar upgrade_settings: The configuration of the agent pool.
    :vartype upgrade_settings: ~azure.mgmt.networkcloud.models.AgentPoolUpgradeSettings
    :ivar vm_sku_name: The name of the VM SKU that determines the size of resources allocated for
     node VMs. Required.
    :vartype vm_sku_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "count": {"required": True},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "kubernetes_version": {"readonly": True},
        "mode": {"required": True},
        "provisioning_state": {"readonly": True},
        "vm_sku_name": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "administrator_configuration": {
            "key": "properties.administratorConfiguration",
            "type": "AdministratorConfiguration",
        },
        "agent_options": {"key": "properties.agentOptions", "type": "AgentOptions"},
        "attached_network_configuration": {
            "key": "properties.attachedNetworkConfiguration",
            "type": "AttachedNetworkConfiguration",
        },
        "availability_zones": {"key": "properties.availabilityZones", "type": "[str]"},
        "count": {"key": "properties.count", "type": "int"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "kubernetes_version": {"key": "properties.kubernetesVersion", "type": "str"},
        "labels": {"key": "properties.labels", "type": "[KubernetesLabel]"},
        "mode": {"key": "properties.mode", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "taints": {"key": "properties.taints", "type": "[KubernetesLabel]"},
        "upgrade_settings": {"key": "properties.upgradeSettings", "type": "AgentPoolUpgradeSettings"},
        "vm_sku_name": {"key": "properties.vmSkuName", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        count: int,
        mode: Union[str, "_models.AgentPoolMode"],
        vm_sku_name: str,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        administrator_configuration: Optional["_models.AdministratorConfiguration"] = None,
        agent_options: Optional["_models.AgentOptions"] = None,
        attached_network_configuration: Optional["_models.AttachedNetworkConfiguration"] = None,
        availability_zones: Optional[List[str]] = None,
        labels: Optional[List["_models.KubernetesLabel"]] = None,
        taints: Optional[List["_models.KubernetesLabel"]] = None,
        upgrade_settings: Optional["_models.AgentPoolUpgradeSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location of the cluster associated with the resource.
        :paramtype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
        :keyword administrator_configuration: The administrator credentials to be used for the nodes in
         this agent pool.
        :paramtype administrator_configuration:
         ~azure.mgmt.networkcloud.models.AdministratorConfiguration
        :keyword agent_options: The configurations that will be applied to each agent in this agent
         pool.
        :paramtype agent_options: ~azure.mgmt.networkcloud.models.AgentOptions
        :keyword attached_network_configuration: The configuration of networks being attached to the
         agent pool for use by the workloads that run on this Kubernetes cluster.
        :paramtype attached_network_configuration:
         ~azure.mgmt.networkcloud.models.AttachedNetworkConfiguration
        :keyword availability_zones: The list of availability zones of the Network Cloud cluster used
         for the provisioning of nodes in this agent pool. If not specified, all availability zones will
         be used.
        :paramtype availability_zones: list[str]
        :keyword count: The number of virtual machines that use this configuration. Required.
        :paramtype count: int
        :keyword labels: The labels applied to the nodes in this agent pool.
        :paramtype labels: list[~azure.mgmt.networkcloud.models.KubernetesLabel]
        :keyword mode: The selection of how this agent pool is utilized, either as a system pool or a
         user pool. System pools run the features and critical services for the Kubernetes Cluster,
         while user pools are dedicated to user workloads. Every Kubernetes cluster must contain at
         least one system node pool with at least one node. Required. Known values are: "System",
         "User", and "NotApplicable".
        :paramtype mode: str or ~azure.mgmt.networkcloud.models.AgentPoolMode
        :keyword taints: The taints applied to the nodes in this agent pool.
        :paramtype taints: list[~azure.mgmt.networkcloud.models.KubernetesLabel]
        :keyword upgrade_settings: The configuration of the agent pool.
        :paramtype upgrade_settings: ~azure.mgmt.networkcloud.models.AgentPoolUpgradeSettings
        :keyword vm_sku_name: The name of the VM SKU that determines the size of resources allocated
         for node VMs. Required.
        :paramtype vm_sku_name: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.administrator_configuration = administrator_configuration
        self.agent_options = agent_options
        self.attached_network_configuration = attached_network_configuration
        self.availability_zones = availability_zones
        self.count = count
        self.detailed_status = None
        self.detailed_status_message = None
        self.kubernetes_version = None
        self.labels = labels
        self.mode = mode
        self.provisioning_state = None
        self.taints = taints
        self.upgrade_settings = upgrade_settings
        self.vm_sku_name = vm_sku_name


class AgentPoolConfiguration(_serialization.Model):
    """AgentPoolConfiguration specifies the configuration of a pool of nodes.

    All required parameters must be populated in order to send to server.

    :ivar administrator_configuration: The administrator credentials to be used for the nodes in
     this agent pool.
    :vartype administrator_configuration:
     ~azure.mgmt.networkcloud.models.AdministratorConfiguration
    :ivar agent_options: The configurations that will be applied to each agent in this agent pool.
    :vartype agent_options: ~azure.mgmt.networkcloud.models.AgentOptions
    :ivar attached_network_configuration: The configuration of networks being attached to the agent
     pool for use by the workloads that run on this Kubernetes cluster.
    :vartype attached_network_configuration:
     ~azure.mgmt.networkcloud.models.AttachedNetworkConfiguration
    :ivar availability_zones: The list of availability zones of the Network Cloud cluster used for
     the provisioning of nodes in this agent pool. If not specified, all availability zones will be
     used.
    :vartype availability_zones: list[str]
    :ivar count: The number of virtual machines that use this configuration. Required.
    :vartype count: int
    :ivar labels: The labels applied to the nodes in this agent pool.
    :vartype labels: list[~azure.mgmt.networkcloud.models.KubernetesLabel]
    :ivar mode: The selection of how this agent pool is utilized, either as a system pool or a user
     pool. System pools run the features and critical services for the Kubernetes Cluster, while
     user pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one
     system node pool with at least one node. Required. Known values are: "System", "User", and
     "NotApplicable".
    :vartype mode: str or ~azure.mgmt.networkcloud.models.AgentPoolMode
    :ivar taints: The taints applied to the nodes in this agent pool.
    :vartype taints: list[~azure.mgmt.networkcloud.models.KubernetesLabel]
    :ivar upgrade_settings: The configuration of the agent pool.
    :vartype upgrade_settings: ~azure.mgmt.networkcloud.models.AgentPoolUpgradeSettings
    :ivar vm_sku_name: The name of the VM SKU that determines the size of resources allocated for
     node VMs. Required.
    :vartype vm_sku_name: str
    """

    _validation = {
        "count": {"required": True},
        "mode": {"required": True},
        "vm_sku_name": {"required": True},
    }

    _attribute_map = {
        "administrator_configuration": {"key": "administratorConfiguration", "type": "AdministratorConfiguration"},
        "agent_options": {"key": "agentOptions", "type": "AgentOptions"},
        "attached_network_configuration": {
            "key": "attachedNetworkConfiguration",
            "type": "AttachedNetworkConfiguration",
        },
        "availability_zones": {"key": "availabilityZones", "type": "[str]"},
        "count": {"key": "count", "type": "int"},
        "labels": {"key": "labels", "type": "[KubernetesLabel]"},
        "mode": {"key": "mode", "type": "str"},
        "taints": {"key": "taints", "type": "[KubernetesLabel]"},
        "upgrade_settings": {"key": "upgradeSettings", "type": "AgentPoolUpgradeSettings"},
        "vm_sku_name": {"key": "vmSkuName", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: int,
        mode: Union[str, "_models.AgentPoolMode"],
        vm_sku_name: str,
        administrator_configuration: Optional["_models.AdministratorConfiguration"] = None,
        agent_options: Optional["_models.AgentOptions"] = None,
        attached_network_configuration: Optional["_models.AttachedNetworkConfiguration"] = None,
        availability_zones: Optional[List[str]] = None,
        labels: Optional[List["_models.KubernetesLabel"]] = None,
        taints: Optional[List["_models.KubernetesLabel"]] = None,
        upgrade_settings: Optional["_models.AgentPoolUpgradeSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword administrator_configuration: The administrator credentials to be used for the nodes in
         this agent pool.
        :paramtype administrator_configuration:
         ~azure.mgmt.networkcloud.models.AdministratorConfiguration
        :keyword agent_options: The configurations that will be applied to each agent in this agent
         pool.
        :paramtype agent_options: ~azure.mgmt.networkcloud.models.AgentOptions
        :keyword attached_network_configuration: The configuration of networks being attached to the
         agent pool for use by the workloads that run on this Kubernetes cluster.
        :paramtype attached_network_configuration:
         ~azure.mgmt.networkcloud.models.AttachedNetworkConfiguration
        :keyword availability_zones: The list of availability zones of the Network Cloud cluster used
         for the provisioning of nodes in this agent pool. If not specified, all availability zones will
         be used.
        :paramtype availability_zones: list[str]
        :keyword count: The number of virtual machines that use this configuration. Required.
        :paramtype count: int
        :keyword labels: The labels applied to the nodes in this agent pool.
        :paramtype labels: list[~azure.mgmt.networkcloud.models.KubernetesLabel]
        :keyword mode: The selection of how this agent pool is utilized, either as a system pool or a
         user pool. System pools run the features and critical services for the Kubernetes Cluster,
         while user pools are dedicated to user workloads. Every Kubernetes cluster must contain at
         least one system node pool with at least one node. Required. Known values are: "System",
         "User", and "NotApplicable".
        :paramtype mode: str or ~azure.mgmt.networkcloud.models.AgentPoolMode
        :keyword taints: The taints applied to the nodes in this agent pool.
        :paramtype taints: list[~azure.mgmt.networkcloud.models.KubernetesLabel]
        :keyword upgrade_settings: The configuration of the agent pool.
        :paramtype upgrade_settings: ~azure.mgmt.networkcloud.models.AgentPoolUpgradeSettings
        :keyword vm_sku_name: The name of the VM SKU that determines the size of resources allocated
         for node VMs. Required.
        :paramtype vm_sku_name: str
        """
        super().__init__(**kwargs)
        self.administrator_configuration = administrator_configuration
        self.agent_options = agent_options
        self.attached_network_configuration = attached_network_configuration
        self.availability_zones = availability_zones
        self.count = count
        self.labels = labels
        self.mode = mode
        self.taints = taints
        self.upgrade_settings = upgrade_settings
        self.vm_sku_name = vm_sku_name


class AgentPoolList(_serialization.Model):
    """AgentPoolList represents a list of Kubernetes cluster agent pools.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of agent pools.
    :vartype value: list[~azure.mgmt.networkcloud.models.AgentPool]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[AgentPool]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.AgentPool"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of agent pools.
        :paramtype value: list[~azure.mgmt.networkcloud.models.AgentPool]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class AgentPoolPatchParameters(_serialization.Model):
    """AgentPoolPatchParameters represents the body of the request to patch the Kubernetes cluster
    agent pool.

    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    :ivar administrator_configuration: The configuration of administrator credentials for the
     control plane nodes.
    :vartype administrator_configuration:
     ~azure.mgmt.networkcloud.models.NodePoolAdministratorConfigurationPatch
    :ivar count: The number of virtual machines that use this configuration.
    :vartype count: int
    :ivar upgrade_settings: The configuration of the agent pool.
    :vartype upgrade_settings: ~azure.mgmt.networkcloud.models.AgentPoolUpgradeSettings
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "administrator_configuration": {
            "key": "properties.administratorConfiguration",
            "type": "NodePoolAdministratorConfigurationPatch",
        },
        "count": {"key": "properties.count", "type": "int"},
        "upgrade_settings": {"key": "properties.upgradeSettings", "type": "AgentPoolUpgradeSettings"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        administrator_configuration: Optional["_models.NodePoolAdministratorConfigurationPatch"] = None,
        count: Optional[int] = None,
        upgrade_settings: Optional["_models.AgentPoolUpgradeSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        :keyword administrator_configuration: The configuration of administrator credentials for the
         control plane nodes.
        :paramtype administrator_configuration:
         ~azure.mgmt.networkcloud.models.NodePoolAdministratorConfigurationPatch
        :keyword count: The number of virtual machines that use this configuration.
        :paramtype count: int
        :keyword upgrade_settings: The configuration of the agent pool.
        :paramtype upgrade_settings: ~azure.mgmt.networkcloud.models.AgentPoolUpgradeSettings
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.administrator_configuration = administrator_configuration
        self.count = count
        self.upgrade_settings = upgrade_settings


class AgentPoolUpgradeSettings(_serialization.Model):
    """AgentPoolUpgradeSettings specifies the upgrade settings for an agent pool.

    :ivar drain_timeout: The maximum time in seconds that is allowed for a node drain to complete
     before proceeding with the upgrade of the agent pool. If not specified during creation, a value
     of 1800 seconds is used.
    :vartype drain_timeout: int
    :ivar max_surge: The maximum number or percentage of nodes that are surged during upgrade. This
     can either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is
     specified, it is the percentage of the total agent pool size at the time of the upgrade. For
     percentages, fractional nodes are rounded up. If not specified during creation, a value of 1 is
     used. One of MaxSurge and MaxUnavailable must be greater than 0.
    :vartype max_surge: str
    :ivar max_unavailable: The maximum number or percentage of nodes that can be unavailable during
     upgrade. This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a
     percentage is specified, it is the percentage of the total agent pool size at the time of the
     upgrade. For percentages, fractional nodes are rounded up. If not specified during creation, a
     value of 0 is used. One of MaxSurge and MaxUnavailable must be greater than 0.
    :vartype max_unavailable: str
    """

    _validation = {
        "drain_timeout": {"maximum": 86400, "minimum": 60},
    }

    _attribute_map = {
        "drain_timeout": {"key": "drainTimeout", "type": "int"},
        "max_surge": {"key": "maxSurge", "type": "str"},
        "max_unavailable": {"key": "maxUnavailable", "type": "str"},
    }

    def __init__(
        self,
        *,
        drain_timeout: Optional[int] = None,
        max_surge: Optional[str] = None,
        max_unavailable: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword drain_timeout: The maximum time in seconds that is allowed for a node drain to
         complete before proceeding with the upgrade of the agent pool. If not specified during
         creation, a value of 1800 seconds is used.
        :paramtype drain_timeout: int
        :keyword max_surge: The maximum number or percentage of nodes that are surged during upgrade.
         This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage
         is specified, it is the percentage of the total agent pool size at the time of the upgrade. For
         percentages, fractional nodes are rounded up. If not specified during creation, a value of 1 is
         used. One of MaxSurge and MaxUnavailable must be greater than 0.
        :paramtype max_surge: str
        :keyword max_unavailable: The maximum number or percentage of nodes that can be unavailable
         during upgrade. This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%').
         If a percentage is specified, it is the percentage of the total agent pool size at the time of
         the upgrade. For percentages, fractional nodes are rounded up. If not specified during
         creation, a value of 0 is used. One of MaxSurge and MaxUnavailable must be greater than 0.
        :paramtype max_unavailable: str
        """
        super().__init__(**kwargs)
        self.drain_timeout = drain_timeout
        self.max_surge = max_surge
        self.max_unavailable = max_unavailable


class AttachedNetworkConfiguration(_serialization.Model):
    """AttachedNetworkConfiguration represents the set of workload networks to attach to a resource.

    :ivar l2_networks: The list of Layer 2 Networks and related configuration for attachment.
    :vartype l2_networks: list[~azure.mgmt.networkcloud.models.L2NetworkAttachmentConfiguration]
    :ivar l3_networks: The list of Layer 3 Networks and related configuration for attachment.
    :vartype l3_networks: list[~azure.mgmt.networkcloud.models.L3NetworkAttachmentConfiguration]
    :ivar trunked_networks: The list of Trunked Networks and related configuration for attachment.
    :vartype trunked_networks:
     list[~azure.mgmt.networkcloud.models.TrunkedNetworkAttachmentConfiguration]
    """

    _attribute_map = {
        "l2_networks": {"key": "l2Networks", "type": "[L2NetworkAttachmentConfiguration]"},
        "l3_networks": {"key": "l3Networks", "type": "[L3NetworkAttachmentConfiguration]"},
        "trunked_networks": {"key": "trunkedNetworks", "type": "[TrunkedNetworkAttachmentConfiguration]"},
    }

    def __init__(
        self,
        *,
        l2_networks: Optional[List["_models.L2NetworkAttachmentConfiguration"]] = None,
        l3_networks: Optional[List["_models.L3NetworkAttachmentConfiguration"]] = None,
        trunked_networks: Optional[List["_models.TrunkedNetworkAttachmentConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword l2_networks: The list of Layer 2 Networks and related configuration for attachment.
        :paramtype l2_networks: list[~azure.mgmt.networkcloud.models.L2NetworkAttachmentConfiguration]
        :keyword l3_networks: The list of Layer 3 Networks and related configuration for attachment.
        :paramtype l3_networks: list[~azure.mgmt.networkcloud.models.L3NetworkAttachmentConfiguration]
        :keyword trunked_networks: The list of Trunked Networks and related configuration for
         attachment.
        :paramtype trunked_networks:
         list[~azure.mgmt.networkcloud.models.TrunkedNetworkAttachmentConfiguration]
        """
        super().__init__(**kwargs)
        self.l2_networks = l2_networks
        self.l3_networks = l3_networks
        self.trunked_networks = trunked_networks


class AvailableUpgrade(_serialization.Model):
    """AvailableUpgrade represents an upgrade available for a Kubernetes cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar availability_lifecycle: The version lifecycle indicator. Known values are: "Preview" and
     "GenerallyAvailable".
    :vartype availability_lifecycle: str or ~azure.mgmt.networkcloud.models.AvailabilityLifecycle
    :ivar version: The version available for upgrading.
    :vartype version: str
    """

    _validation = {
        "availability_lifecycle": {"readonly": True},
        "version": {"readonly": True},
    }

    _attribute_map = {
        "availability_lifecycle": {"key": "availabilityLifecycle", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.availability_lifecycle = None
        self.version = None


class BareMetalMachine(TrackedResource):
    """BareMetalMachine represents the physical machine in the rack.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location of the cluster associated with the resource.
     Required.
    :vartype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar associated_resource_ids: The list of resource IDs for the other Microsoft.NetworkCloud
     resources that have attached this network.
    :vartype associated_resource_ids: list[str]
    :ivar bmc_connection_string: The connection string for the baseboard management controller
     including IP address and protocol. Required.
    :vartype bmc_connection_string: str
    :ivar bmc_credentials: The credentials of the baseboard management controller on this bare
     metal machine. Required.
    :vartype bmc_credentials: ~azure.mgmt.networkcloud.models.AdministrativeCredentials
    :ivar bmc_mac_address: The MAC address of the BMC device. Required.
    :vartype bmc_mac_address: str
    :ivar boot_mac_address: The MAC address of a NIC connected to the PXE network. Required.
    :vartype boot_mac_address: str
    :ivar cluster_id: The resource ID of the cluster this bare metal machine is associated with.
    :vartype cluster_id: str
    :ivar cordon_status: The cordon status of the bare metal machine. Known values are: "Cordoned"
     and "Uncordoned".
    :vartype cordon_status: str or ~azure.mgmt.networkcloud.models.BareMetalMachineCordonStatus
    :ivar detailed_status: The more detailed status of the bare metal machine. Known values are:
     "Preparing", "Error", "Available", "Provisioning", "Provisioned", and "Deprovisioning".
    :vartype detailed_status: str or ~azure.mgmt.networkcloud.models.BareMetalMachineDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar hardware_inventory: The hardware inventory, including information acquired from the
     model/sku information and from the ironic inspector.
    :vartype hardware_inventory: ~azure.mgmt.networkcloud.models.HardwareInventory
    :ivar hardware_validation_status: The details of the latest hardware validation performed for
     this bare metal machine.
    :vartype hardware_validation_status: ~azure.mgmt.networkcloud.models.HardwareValidationStatus
    :ivar hybrid_aks_clusters_associated_ids: Field Deprecated. These fields will be empty/omitted.
     The list of the resource IDs for the HybridAksClusters that have nodes hosted on this bare
     metal machine.
    :vartype hybrid_aks_clusters_associated_ids: list[str]
    :ivar kubernetes_node_name: The name of this machine represented by the host object in the
     Cluster's Kubernetes control plane.
    :vartype kubernetes_node_name: str
    :ivar kubernetes_version: The version of Kubernetes running on this machine.
    :vartype kubernetes_version: str
    :ivar machine_cluster_version: The cluster version that has been applied to this machine during
     deployment or a version update.
    :vartype machine_cluster_version: str
    :ivar machine_details: The custom details provided by the customer. Required.
    :vartype machine_details: str
    :ivar machine_name: The OS-level hostname assigned to this machine. Required.
    :vartype machine_name: str
    :ivar machine_roles: The list of roles that are assigned to the cluster node running on this
     machine.
    :vartype machine_roles: list[str]
    :ivar machine_sku_id: The unique internal identifier of the bare metal machine SKU. Required.
    :vartype machine_sku_id: str
    :ivar oam_ipv4_address: The IPv4 address that is assigned to the bare metal machine during the
     cluster deployment.
    :vartype oam_ipv4_address: str
    :ivar oam_ipv6_address: The IPv6 address that is assigned to the bare metal machine during the
     cluster deployment.
    :vartype oam_ipv6_address: str
    :ivar os_image: The image that is currently provisioned to the OS disk.
    :vartype os_image: str
    :ivar power_state: The power state derived from the baseboard management controller. Known
     values are: "On" and "Off".
    :vartype power_state: str or ~azure.mgmt.networkcloud.models.BareMetalMachinePowerState
    :ivar provisioning_state: The provisioning state of the bare metal machine. Known values are:
     "Succeeded", "Failed", "Canceled", "Provisioning", and "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.networkcloud.models.BareMetalMachineProvisioningState
    :ivar rack_id: The resource ID of the rack where this bare metal machine resides. Required.
    :vartype rack_id: str
    :ivar rack_slot: The rack slot in which this bare metal machine is located, ordered from the
     bottom up i.e. the lowest slot is 1. Required.
    :vartype rack_slot: int
    :ivar ready_state: The indicator of whether the bare metal machine is ready to receive
     workloads. Known values are: "True" and "False".
    :vartype ready_state: str or ~azure.mgmt.networkcloud.models.BareMetalMachineReadyState
    :ivar runtime_protection_status: The runtime protection status of the bare metal machine.
    :vartype runtime_protection_status: ~azure.mgmt.networkcloud.models.RuntimeProtectionStatus
    :ivar secret_rotation_status: The list of statuses that represent secret rotation activity.
    :vartype secret_rotation_status: list[~azure.mgmt.networkcloud.models.SecretRotationStatus]
    :ivar serial_number: The serial number of the bare metal machine. Required.
    :vartype serial_number: str
    :ivar service_tag: The discovered value of the machine's service tag.
    :vartype service_tag: str
    :ivar virtual_machines_associated_ids: Field Deprecated. These fields will be empty/omitted.
     The list of the resource IDs for the VirtualMachines that are hosted on this bare metal
     machine.
    :vartype virtual_machines_associated_ids: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "extended_location": {"required": True},
        "associated_resource_ids": {"readonly": True},
        "bmc_connection_string": {"required": True},
        "bmc_credentials": {"required": True},
        "bmc_mac_address": {"required": True, "pattern": r"^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$"},
        "boot_mac_address": {"required": True, "pattern": r"^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$"},
        "cluster_id": {"readonly": True},
        "cordon_status": {"readonly": True},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "hardware_inventory": {"readonly": True},
        "hardware_validation_status": {"readonly": True},
        "hybrid_aks_clusters_associated_ids": {"readonly": True},
        "kubernetes_node_name": {"readonly": True},
        "kubernetes_version": {"readonly": True},
        "machine_details": {"required": True, "max_length": 256},
        "machine_name": {"required": True, "pattern": r"^([a-zA-Z0-9][a-zA-Z0-9]{0,62}[a-zA-Z0-9])$"},
        "machine_roles": {"readonly": True},
        "machine_sku_id": {"required": True},
        "oam_ipv4_address": {"readonly": True},
        "oam_ipv6_address": {"readonly": True},
        "os_image": {"readonly": True},
        "power_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "rack_id": {"required": True},
        "rack_slot": {"required": True, "maximum": 256, "minimum": 1},
        "ready_state": {"readonly": True},
        "runtime_protection_status": {"readonly": True},
        "secret_rotation_status": {"readonly": True},
        "serial_number": {"required": True, "max_length": 64, "min_length": 1},
        "service_tag": {"readonly": True},
        "virtual_machines_associated_ids": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "associated_resource_ids": {"key": "properties.associatedResourceIds", "type": "[str]"},
        "bmc_connection_string": {"key": "properties.bmcConnectionString", "type": "str"},
        "bmc_credentials": {"key": "properties.bmcCredentials", "type": "AdministrativeCredentials"},
        "bmc_mac_address": {"key": "properties.bmcMacAddress", "type": "str"},
        "boot_mac_address": {"key": "properties.bootMacAddress", "type": "str"},
        "cluster_id": {"key": "properties.clusterId", "type": "str"},
        "cordon_status": {"key": "properties.cordonStatus", "type": "str"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "hardware_inventory": {"key": "properties.hardwareInventory", "type": "HardwareInventory"},
        "hardware_validation_status": {
            "key": "properties.hardwareValidationStatus",
            "type": "HardwareValidationStatus",
        },
        "hybrid_aks_clusters_associated_ids": {"key": "properties.hybridAksClustersAssociatedIds", "type": "[str]"},
        "kubernetes_node_name": {"key": "properties.kubernetesNodeName", "type": "str"},
        "kubernetes_version": {"key": "properties.kubernetesVersion", "type": "str"},
        "machine_cluster_version": {"key": "properties.machineClusterVersion", "type": "str"},
        "machine_details": {"key": "properties.machineDetails", "type": "str"},
        "machine_name": {"key": "properties.machineName", "type": "str"},
        "machine_roles": {"key": "properties.machineRoles", "type": "[str]"},
        "machine_sku_id": {"key": "properties.machineSkuId", "type": "str"},
        "oam_ipv4_address": {"key": "properties.oamIpv4Address", "type": "str"},
        "oam_ipv6_address": {"key": "properties.oamIpv6Address", "type": "str"},
        "os_image": {"key": "properties.osImage", "type": "str"},
        "power_state": {"key": "properties.powerState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "rack_id": {"key": "properties.rackId", "type": "str"},
        "rack_slot": {"key": "properties.rackSlot", "type": "int"},
        "ready_state": {"key": "properties.readyState", "type": "str"},
        "runtime_protection_status": {"key": "properties.runtimeProtectionStatus", "type": "RuntimeProtectionStatus"},
        "secret_rotation_status": {"key": "properties.secretRotationStatus", "type": "[SecretRotationStatus]"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "service_tag": {"key": "properties.serviceTag", "type": "str"},
        "virtual_machines_associated_ids": {"key": "properties.virtualMachinesAssociatedIds", "type": "[str]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        bmc_connection_string: str,
        bmc_credentials: "_models.AdministrativeCredentials",
        bmc_mac_address: str,
        boot_mac_address: str,
        machine_details: str,
        machine_name: str,
        machine_sku_id: str,
        rack_id: str,
        rack_slot: int,
        serial_number: str,
        tags: Optional[Dict[str, str]] = None,
        machine_cluster_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location of the cluster associated with the resource.
         Required.
        :paramtype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
        :keyword bmc_connection_string: The connection string for the baseboard management controller
         including IP address and protocol. Required.
        :paramtype bmc_connection_string: str
        :keyword bmc_credentials: The credentials of the baseboard management controller on this bare
         metal machine. Required.
        :paramtype bmc_credentials: ~azure.mgmt.networkcloud.models.AdministrativeCredentials
        :keyword bmc_mac_address: The MAC address of the BMC device. Required.
        :paramtype bmc_mac_address: str
        :keyword boot_mac_address: The MAC address of a NIC connected to the PXE network. Required.
        :paramtype boot_mac_address: str
        :keyword machine_cluster_version: The cluster version that has been applied to this machine
         during deployment or a version update.
        :paramtype machine_cluster_version: str
        :keyword machine_details: The custom details provided by the customer. Required.
        :paramtype machine_details: str
        :keyword machine_name: The OS-level hostname assigned to this machine. Required.
        :paramtype machine_name: str
        :keyword machine_sku_id: The unique internal identifier of the bare metal machine SKU.
         Required.
        :paramtype machine_sku_id: str
        :keyword rack_id: The resource ID of the rack where this bare metal machine resides. Required.
        :paramtype rack_id: str
        :keyword rack_slot: The rack slot in which this bare metal machine is located, ordered from the
         bottom up i.e. the lowest slot is 1. Required.
        :paramtype rack_slot: int
        :keyword serial_number: The serial number of the bare metal machine. Required.
        :paramtype serial_number: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.associated_resource_ids = None
        self.bmc_connection_string = bmc_connection_string
        self.bmc_credentials = bmc_credentials
        self.bmc_mac_address = bmc_mac_address
        self.boot_mac_address = boot_mac_address
        self.cluster_id = None
        self.cordon_status = None
        self.detailed_status = None
        self.detailed_status_message = None
        self.hardware_inventory = None
        self.hardware_validation_status = None
        self.hybrid_aks_clusters_associated_ids = None
        self.kubernetes_node_name = None
        self.kubernetes_version = None
        self.machine_cluster_version = machine_cluster_version
        self.machine_details = machine_details
        self.machine_name = machine_name
        self.machine_roles = None
        self.machine_sku_id = machine_sku_id
        self.oam_ipv4_address = None
        self.oam_ipv6_address = None
        self.os_image = None
        self.power_state = None
        self.provisioning_state = None
        self.rack_id = rack_id
        self.rack_slot = rack_slot
        self.ready_state = None
        self.runtime_protection_status = None
        self.secret_rotation_status = None
        self.serial_number = serial_number
        self.service_tag = None
        self.virtual_machines_associated_ids = None


class BareMetalMachineCommandSpecification(_serialization.Model):
    """BareMetalMachineCommandSpecification represents the command and optional arguments to exercise
    against the bare metal machine.

    All required parameters must be populated in order to send to server.

    :ivar arguments: The list of string arguments that will be passed to the script in order as
     separate arguments.
    :vartype arguments: list[str]
    :ivar command: The command to execute against the bare metal machine. Required.
    :vartype command: str
    """

    _validation = {
        "command": {"required": True},
    }

    _attribute_map = {
        "arguments": {"key": "arguments", "type": "[str]"},
        "command": {"key": "command", "type": "str"},
    }

    def __init__(self, *, command: str, arguments: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword arguments: The list of string arguments that will be passed to the script in order as
         separate arguments.
        :paramtype arguments: list[str]
        :keyword command: The command to execute against the bare metal machine. Required.
        :paramtype command: str
        """
        super().__init__(**kwargs)
        self.arguments = arguments
        self.command = command


class BareMetalMachineConfigurationData(_serialization.Model):
    """BareMetalMachineConfigurationData represents configuration for the bare metal machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar bmc_connection_string: The connection string for the baseboard management controller
     including IP address and protocol.
    :vartype bmc_connection_string: str
    :ivar bmc_credentials: The credentials of the baseboard management controller on this bare
     metal machine. Required.
    :vartype bmc_credentials: ~azure.mgmt.networkcloud.models.AdministrativeCredentials
    :ivar bmc_mac_address: The MAC address of the BMC for this machine. Required.
    :vartype bmc_mac_address: str
    :ivar boot_mac_address: The MAC address associated with the PXE NIC card. Required.
    :vartype boot_mac_address: str
    :ivar machine_details: The free-form additional information about the machine, e.g. an asset
     tag.
    :vartype machine_details: str
    :ivar machine_name: The user-provided name for the bare metal machine created from this
     specification.
     If not provided, the machine name will be generated programmatically.
    :vartype machine_name: str
    :ivar rack_slot: The slot the physical machine is in the rack based on the BOM configuration.
     Required.
    :vartype rack_slot: int
    :ivar serial_number: The serial number of the machine. Hardware suppliers may use an alternate
     value. For example, service tag. Required.
    :vartype serial_number: str
    """

    _validation = {
        "bmc_connection_string": {"readonly": True},
        "bmc_credentials": {"required": True},
        "bmc_mac_address": {"required": True, "pattern": r"^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$"},
        "boot_mac_address": {"required": True, "pattern": r"^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$"},
        "machine_details": {"max_length": 256},
        "machine_name": {"pattern": r"^([a-zA-Z0-9][a-zA-Z0-9]{0,62}[a-zA-Z0-9])$"},
        "rack_slot": {"required": True, "maximum": 256, "minimum": 1},
        "serial_number": {"required": True, "max_length": 64},
    }

    _attribute_map = {
        "bmc_connection_string": {"key": "bmcConnectionString", "type": "str"},
        "bmc_credentials": {"key": "bmcCredentials", "type": "AdministrativeCredentials"},
        "bmc_mac_address": {"key": "bmcMacAddress", "type": "str"},
        "boot_mac_address": {"key": "bootMacAddress", "type": "str"},
        "machine_details": {"key": "machineDetails", "type": "str"},
        "machine_name": {"key": "machineName", "type": "str"},
        "rack_slot": {"key": "rackSlot", "type": "int"},
        "serial_number": {"key": "serialNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        bmc_credentials: "_models.AdministrativeCredentials",
        bmc_mac_address: str,
        boot_mac_address: str,
        rack_slot: int,
        serial_number: str,
        machine_details: Optional[str] = None,
        machine_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bmc_credentials: The credentials of the baseboard management controller on this bare
         metal machine. Required.
        :paramtype bmc_credentials: ~azure.mgmt.networkcloud.models.AdministrativeCredentials
        :keyword bmc_mac_address: The MAC address of the BMC for this machine. Required.
        :paramtype bmc_mac_address: str
        :keyword boot_mac_address: The MAC address associated with the PXE NIC card. Required.
        :paramtype boot_mac_address: str
        :keyword machine_details: The free-form additional information about the machine, e.g. an asset
         tag.
        :paramtype machine_details: str
        :keyword machine_name: The user-provided name for the bare metal machine created from this
         specification.
         If not provided, the machine name will be generated programmatically.
        :paramtype machine_name: str
        :keyword rack_slot: The slot the physical machine is in the rack based on the BOM
         configuration. Required.
        :paramtype rack_slot: int
        :keyword serial_number: The serial number of the machine. Hardware suppliers may use an
         alternate value. For example, service tag. Required.
        :paramtype serial_number: str
        """
        super().__init__(**kwargs)
        self.bmc_connection_string = None
        self.bmc_credentials = bmc_credentials
        self.bmc_mac_address = bmc_mac_address
        self.boot_mac_address = boot_mac_address
        self.machine_details = machine_details
        self.machine_name = machine_name
        self.rack_slot = rack_slot
        self.serial_number = serial_number


class BareMetalMachineCordonParameters(_serialization.Model):
    """BareMetalMachineCordonParameters represents the body of the request to evacuate workloads from
    node on a bare metal machine.

    :ivar evacuate: The indicator of whether to evacuate the node workload when the bare metal
     machine is cordoned. Known values are: "True" and "False".
    :vartype evacuate: str or ~azure.mgmt.networkcloud.models.BareMetalMachineEvacuate
    """

    _attribute_map = {
        "evacuate": {"key": "evacuate", "type": "str"},
    }

    def __init__(self, *, evacuate: Union[str, "_models.BareMetalMachineEvacuate"] = "False", **kwargs: Any) -> None:
        """
        :keyword evacuate: The indicator of whether to evacuate the node workload when the bare metal
         machine is cordoned. Known values are: "True" and "False".
        :paramtype evacuate: str or ~azure.mgmt.networkcloud.models.BareMetalMachineEvacuate
        """
        super().__init__(**kwargs)
        self.evacuate = evacuate


class BareMetalMachineKeySet(TrackedResource):
    """BareMetalMachineKeySet represents the bare metal machine key set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location of the cluster associated with the resource.
     Required.
    :vartype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar azure_group_id: The object ID of Azure Active Directory group that all users in the list
     must be in for access to be granted. Users that are not in the group will not have access.
     Required.
    :vartype azure_group_id: str
    :ivar detailed_status: The more detailed status of the key set. Known values are: "AllActive",
     "SomeInvalid", "AllInvalid", and "Validating".
    :vartype detailed_status: str or
     ~azure.mgmt.networkcloud.models.BareMetalMachineKeySetDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar expiration: The date and time after which the users in this key set will be removed from
     the bare metal machines. Required.
    :vartype expiration: ~datetime.datetime
    :ivar jump_hosts_allowed: The list of IP addresses of jump hosts with management network access
     from which a login will be allowed for the users. Required.
    :vartype jump_hosts_allowed: list[str]
    :ivar last_validation: The last time this key set was validated.
    :vartype last_validation: ~datetime.datetime
    :ivar os_group_name: The name of the group that users will be assigned to on the operating
     system of the machines.
    :vartype os_group_name: str
    :ivar privilege_level: The access level allowed for the users in this key set. Required. Known
     values are: "Standard" and "Superuser".
    :vartype privilege_level: str or
     ~azure.mgmt.networkcloud.models.BareMetalMachineKeySetPrivilegeLevel
    :ivar provisioning_state: The provisioning state of the bare metal machine key set. Known
     values are: "Succeeded", "Failed", "Canceled", "Accepted", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.networkcloud.models.BareMetalMachineKeySetProvisioningState
    :ivar user_list: The unique list of permitted users. Required.
    :vartype user_list: list[~azure.mgmt.networkcloud.models.KeySetUser]
    :ivar user_list_status: The status evaluation of each user.
    :vartype user_list_status: list[~azure.mgmt.networkcloud.models.KeySetUserStatus]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "extended_location": {"required": True},
        "azure_group_id": {"required": True},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "expiration": {"required": True},
        "jump_hosts_allowed": {"required": True},
        "last_validation": {"readonly": True},
        "os_group_name": {"max_length": 32, "pattern": r"^([A-Za-z]([A-Za-z0-9]*))$"},
        "privilege_level": {"required": True},
        "provisioning_state": {"readonly": True},
        "user_list": {"required": True},
        "user_list_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "azure_group_id": {"key": "properties.azureGroupId", "type": "str"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "expiration": {"key": "properties.expiration", "type": "iso-8601"},
        "jump_hosts_allowed": {"key": "properties.jumpHostsAllowed", "type": "[str]"},
        "last_validation": {"key": "properties.lastValidation", "type": "iso-8601"},
        "os_group_name": {"key": "properties.osGroupName", "type": "str"},
        "privilege_level": {"key": "properties.privilegeLevel", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "user_list": {"key": "properties.userList", "type": "[KeySetUser]"},
        "user_list_status": {"key": "properties.userListStatus", "type": "[KeySetUserStatus]"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        azure_group_id: str,
        expiration: datetime.datetime,
        jump_hosts_allowed: List[str],
        privilege_level: Union[str, "_models.BareMetalMachineKeySetPrivilegeLevel"],
        user_list: List["_models.KeySetUser"],
        tags: Optional[Dict[str, str]] = None,
        os_group_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location of the cluster associated with the resource.
         Required.
        :paramtype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
        :keyword azure_group_id: The object ID of Azure Active Directory group that all users in the
         list must be in for access to be granted. Users that are not in the group will not have access.
         Required.
        :paramtype azure_group_id: str
        :keyword expiration: The date and time after which the users in this key set will be removed
         from the bare metal machines. Required.
        :paramtype expiration: ~datetime.datetime
        :keyword jump_hosts_allowed: The list of IP addresses of jump hosts with management network
         access from which a login will be allowed for the users. Required.
        :paramtype jump_hosts_allowed: list[str]
        :keyword os_group_name: The name of the group that users will be assigned to on the operating
         system of the machines.
        :paramtype os_group_name: str
        :keyword privilege_level: The access level allowed for the users in this key set. Required.
         Known values are: "Standard" and "Superuser".
        :paramtype privilege_level: str or
         ~azure.mgmt.networkcloud.models.BareMetalMachineKeySetPrivilegeLevel
        :keyword user_list: The unique list of permitted users. Required.
        :paramtype user_list: list[~azure.mgmt.networkcloud.models.KeySetUser]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.azure_group_id = azure_group_id
        self.detailed_status = None
        self.detailed_status_message = None
        self.expiration = expiration
        self.jump_hosts_allowed = jump_hosts_allowed
        self.last_validation = None
        self.os_group_name = os_group_name
        self.privilege_level = privilege_level
        self.provisioning_state = None
        self.user_list = user_list
        self.user_list_status = None


class BareMetalMachineKeySetList(_serialization.Model):
    """BareMetalMachineKeySetList represents a list of bare metal machine key sets.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of bare metal machine key sets.
    :vartype value: list[~azure.mgmt.networkcloud.models.BareMetalMachineKeySet]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[BareMetalMachineKeySet]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.BareMetalMachineKeySet"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of bare metal machine key sets.
        :paramtype value: list[~azure.mgmt.networkcloud.models.BareMetalMachineKeySet]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class BareMetalMachineKeySetPatchParameters(_serialization.Model):
    """BareMetalMachineKeySetPatchParameters represents the body of the request to patch the bare
    metal machine key set.

    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    :ivar expiration: The date and time after which the users in this key set will be removed from
     the bare metal machines.
    :vartype expiration: ~datetime.datetime
    :ivar jump_hosts_allowed: The list of IP addresses of jump hosts with management network access
     from which a login will be allowed for the users.
    :vartype jump_hosts_allowed: list[str]
    :ivar user_list: The unique list of permitted users.
    :vartype user_list: list[~azure.mgmt.networkcloud.models.KeySetUser]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "expiration": {"key": "properties.expiration", "type": "iso-8601"},
        "jump_hosts_allowed": {"key": "properties.jumpHostsAllowed", "type": "[str]"},
        "user_list": {"key": "properties.userList", "type": "[KeySetUser]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        expiration: Optional[datetime.datetime] = None,
        jump_hosts_allowed: Optional[List[str]] = None,
        user_list: Optional[List["_models.KeySetUser"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        :keyword expiration: The date and time after which the users in this key set will be removed
         from the bare metal machines.
        :paramtype expiration: ~datetime.datetime
        :keyword jump_hosts_allowed: The list of IP addresses of jump hosts with management network
         access from which a login will be allowed for the users.
        :paramtype jump_hosts_allowed: list[str]
        :keyword user_list: The unique list of permitted users.
        :paramtype user_list: list[~azure.mgmt.networkcloud.models.KeySetUser]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.expiration = expiration
        self.jump_hosts_allowed = jump_hosts_allowed
        self.user_list = user_list


class BareMetalMachineList(_serialization.Model):
    """BareMetalMachineList represents a list of bare metal machines.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of bare metal machines.
    :vartype value: list[~azure.mgmt.networkcloud.models.BareMetalMachine]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[BareMetalMachine]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.BareMetalMachine"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of bare metal machines.
        :paramtype value: list[~azure.mgmt.networkcloud.models.BareMetalMachine]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class BareMetalMachinePatchParameters(_serialization.Model):
    """BareMetalMachinePatchParameters represents the body of the request to patch bare metal machine
    properties.

    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    :ivar machine_details: The details provided by the customer during the creation of rack
     manifests
     that allows for custom data to be associated with this machine.
    :vartype machine_details: str
    """

    _validation = {
        "machine_details": {"max_length": 256},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "machine_details": {"key": "properties.machineDetails", "type": "str"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, machine_details: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        :keyword machine_details: The details provided by the customer during the creation of rack
         manifests
         that allows for custom data to be associated with this machine.
        :paramtype machine_details: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.machine_details = machine_details


class BareMetalMachinePowerOffParameters(_serialization.Model):
    """BareMetalMachinePowerOffParameters represents the body of the request to power off bare metal
    machine.

    :ivar skip_shutdown: The indicator of whether to skip the graceful OS shutdown and power off
     the bare metal machine immediately. Known values are: "True" and "False".
    :vartype skip_shutdown: str or ~azure.mgmt.networkcloud.models.BareMetalMachineSkipShutdown
    """

    _attribute_map = {
        "skip_shutdown": {"key": "skipShutdown", "type": "str"},
    }

    def __init__(
        self, *, skip_shutdown: Union[str, "_models.BareMetalMachineSkipShutdown"] = "False", **kwargs: Any
    ) -> None:
        """
        :keyword skip_shutdown: The indicator of whether to skip the graceful OS shutdown and power off
         the bare metal machine immediately. Known values are: "True" and "False".
        :paramtype skip_shutdown: str or ~azure.mgmt.networkcloud.models.BareMetalMachineSkipShutdown
        """
        super().__init__(**kwargs)
        self.skip_shutdown = skip_shutdown


class BareMetalMachineReplaceParameters(_serialization.Model):
    """BareMetalMachineReplaceParameters represents the body of the request to physically swap a bare
    metal machine for another.

    :ivar bmc_credentials: The credentials of the baseboard management controller on this bare
     metal machine.
    :vartype bmc_credentials: ~azure.mgmt.networkcloud.models.AdministrativeCredentials
    :ivar bmc_mac_address: The MAC address of the BMC device.
    :vartype bmc_mac_address: str
    :ivar boot_mac_address: The MAC address of a NIC connected to the PXE network.
    :vartype boot_mac_address: str
    :ivar machine_name: The OS-level hostname assigned to this machine.
    :vartype machine_name: str
    :ivar serial_number: The serial number of the bare metal machine.
    :vartype serial_number: str
    """

    _validation = {
        "bmc_mac_address": {"pattern": r"^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$"},
        "boot_mac_address": {"pattern": r"^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$"},
        "machine_name": {"pattern": r"^([a-zA-Z0-9][a-zA-Z0-9]{0,62}[a-zA-Z0-9])$"},
        "serial_number": {"max_length": 64, "min_length": 1},
    }

    _attribute_map = {
        "bmc_credentials": {"key": "bmcCredentials", "type": "AdministrativeCredentials"},
        "bmc_mac_address": {"key": "bmcMacAddress", "type": "str"},
        "boot_mac_address": {"key": "bootMacAddress", "type": "str"},
        "machine_name": {"key": "machineName", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        bmc_credentials: Optional["_models.AdministrativeCredentials"] = None,
        bmc_mac_address: Optional[str] = None,
        boot_mac_address: Optional[str] = None,
        machine_name: Optional[str] = None,
        serial_number: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bmc_credentials: The credentials of the baseboard management controller on this bare
         metal machine.
        :paramtype bmc_credentials: ~azure.mgmt.networkcloud.models.AdministrativeCredentials
        :keyword bmc_mac_address: The MAC address of the BMC device.
        :paramtype bmc_mac_address: str
        :keyword boot_mac_address: The MAC address of a NIC connected to the PXE network.
        :paramtype boot_mac_address: str
        :keyword machine_name: The OS-level hostname assigned to this machine.
        :paramtype machine_name: str
        :keyword serial_number: The serial number of the bare metal machine.
        :paramtype serial_number: str
        """
        super().__init__(**kwargs)
        self.bmc_credentials = bmc_credentials
        self.bmc_mac_address = bmc_mac_address
        self.boot_mac_address = boot_mac_address
        self.machine_name = machine_name
        self.serial_number = serial_number


class BareMetalMachineRunCommandParameters(_serialization.Model):
    """BareMetalMachineRunCommandParameters represents the body of the request to execute a script on
    the bare metal machine.

    All required parameters must be populated in order to send to server.

    :ivar arguments: The list of string arguments that will be passed to the script in order as
     separate arguments.
    :vartype arguments: list[str]
    :ivar limit_time_seconds: The maximum time the script is allowed to run.
     If the execution time exceeds the maximum, the script will be stopped, any output produced
     until then will be captured, and the exit code matching a timeout will be returned (252).
     Required.
    :vartype limit_time_seconds: int
    :ivar script: The base64 encoded script to execute on the bare metal machine. Required.
    :vartype script: str
    """

    _validation = {
        "limit_time_seconds": {"required": True, "maximum": 14400, "minimum": 60},
        "script": {"required": True},
    }

    _attribute_map = {
        "arguments": {"key": "arguments", "type": "[str]"},
        "limit_time_seconds": {"key": "limitTimeSeconds", "type": "int"},
        "script": {"key": "script", "type": "str"},
    }

    def __init__(
        self, *, limit_time_seconds: int, script: str, arguments: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword arguments: The list of string arguments that will be passed to the script in order as
         separate arguments.
        :paramtype arguments: list[str]
        :keyword limit_time_seconds: The maximum time the script is allowed to run.
         If the execution time exceeds the maximum, the script will be stopped, any output produced
         until then will be captured, and the exit code matching a timeout will be returned (252).
         Required.
        :paramtype limit_time_seconds: int
        :keyword script: The base64 encoded script to execute on the bare metal machine. Required.
        :paramtype script: str
        """
        super().__init__(**kwargs)
        self.arguments = arguments
        self.limit_time_seconds = limit_time_seconds
        self.script = script


class BareMetalMachineRunDataExtractsParameters(_serialization.Model):  # pylint: disable=name-too-long
    """BareMetalMachineRunDataExtractsParameters represents the body of request containing list of
    curated data extraction commands to run on the bare metal machine.

    All required parameters must be populated in order to send to server.

    :ivar commands: The list of curated data extraction commands to be executed directly against
     the target machine. Required.
    :vartype commands: list[~azure.mgmt.networkcloud.models.BareMetalMachineCommandSpecification]
    :ivar limit_time_seconds: The maximum time the commands are allowed to run.
     If the execution time exceeds the maximum, the script will be stopped, any output produced
     until then will be captured, and the exit code matching a timeout will be returned (252).
     Required.
    :vartype limit_time_seconds: int
    """

    _validation = {
        "commands": {"required": True, "min_items": 1},
        "limit_time_seconds": {"required": True, "maximum": 14400, "minimum": 60},
    }

    _attribute_map = {
        "commands": {"key": "commands", "type": "[BareMetalMachineCommandSpecification]"},
        "limit_time_seconds": {"key": "limitTimeSeconds", "type": "int"},
    }

    def __init__(
        self, *, commands: List["_models.BareMetalMachineCommandSpecification"], limit_time_seconds: int, **kwargs: Any
    ) -> None:
        """
        :keyword commands: The list of curated data extraction commands to be executed directly against
         the target machine. Required.
        :paramtype commands: list[~azure.mgmt.networkcloud.models.BareMetalMachineCommandSpecification]
        :keyword limit_time_seconds: The maximum time the commands are allowed to run.
         If the execution time exceeds the maximum, the script will be stopped, any output produced
         until then will be captured, and the exit code matching a timeout will be returned (252).
         Required.
        :paramtype limit_time_seconds: int
        """
        super().__init__(**kwargs)
        self.commands = commands
        self.limit_time_seconds = limit_time_seconds


class BareMetalMachineRunReadCommandsParameters(_serialization.Model):  # pylint: disable=name-too-long
    """BareMetalMachineRunReadCommandsParameters represents the body of request containing list of
    read-only commands to run on the bare metal machine.

    All required parameters must be populated in order to send to server.

    :ivar commands: The list of read-only commands to be executed directly against the target
     machine. Required.
    :vartype commands: list[~azure.mgmt.networkcloud.models.BareMetalMachineCommandSpecification]
    :ivar limit_time_seconds: The maximum time the commands are allowed to run.
     If the execution time exceeds the maximum, the script will be stopped, any output produced
     until then will be captured, and the exit code matching a timeout will be returned (252).
     Required.
    :vartype limit_time_seconds: int
    """

    _validation = {
        "commands": {"required": True, "min_items": 1},
        "limit_time_seconds": {"required": True, "maximum": 14400, "minimum": 60},
    }

    _attribute_map = {
        "commands": {"key": "commands", "type": "[BareMetalMachineCommandSpecification]"},
        "limit_time_seconds": {"key": "limitTimeSeconds", "type": "int"},
    }

    def __init__(
        self, *, commands: List["_models.BareMetalMachineCommandSpecification"], limit_time_seconds: int, **kwargs: Any
    ) -> None:
        """
        :keyword commands: The list of read-only commands to be executed directly against the target
         machine. Required.
        :paramtype commands: list[~azure.mgmt.networkcloud.models.BareMetalMachineCommandSpecification]
        :keyword limit_time_seconds: The maximum time the commands are allowed to run.
         If the execution time exceeds the maximum, the script will be stopped, any output produced
         until then will be captured, and the exit code matching a timeout will be returned (252).
         Required.
        :paramtype limit_time_seconds: int
        """
        super().__init__(**kwargs)
        self.commands = commands
        self.limit_time_seconds = limit_time_seconds


class BgpAdvertisement(_serialization.Model):
    """BgpAdvertisement represents the association of IP address pools to the communities and peers.

    All required parameters must be populated in order to send to server.

    :ivar advertise_to_fabric: The indicator of if this advertisement is also made to the network
     fabric associated with the Network Cloud Cluster. This field is ignored if fabricPeeringEnabled
     is set to False. Known values are: "True" and "False".
    :vartype advertise_to_fabric: str or ~azure.mgmt.networkcloud.models.AdvertiseToFabric
    :ivar communities: The names of the BGP communities to be associated with the announcement,
     utilizing a BGP community string in 1234:1234 format.
    :vartype communities: list[str]
    :ivar ip_address_pools: The names of the IP address pools associated with this announcement.
     Required.
    :vartype ip_address_pools: list[str]
    :ivar peers: The names of the BGP peers to limit this advertisement to. If no values are
     specified, all BGP peers will receive this advertisement.
    :vartype peers: list[str]
    """

    _validation = {
        "ip_address_pools": {"required": True},
    }

    _attribute_map = {
        "advertise_to_fabric": {"key": "advertiseToFabric", "type": "str"},
        "communities": {"key": "communities", "type": "[str]"},
        "ip_address_pools": {"key": "ipAddressPools", "type": "[str]"},
        "peers": {"key": "peers", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        ip_address_pools: List[str],
        advertise_to_fabric: Union[str, "_models.AdvertiseToFabric"] = "True",
        communities: Optional[List[str]] = None,
        peers: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword advertise_to_fabric: The indicator of if this advertisement is also made to the
         network fabric associated with the Network Cloud Cluster. This field is ignored if
         fabricPeeringEnabled is set to False. Known values are: "True" and "False".
        :paramtype advertise_to_fabric: str or ~azure.mgmt.networkcloud.models.AdvertiseToFabric
        :keyword communities: The names of the BGP communities to be associated with the announcement,
         utilizing a BGP community string in 1234:1234 format.
        :paramtype communities: list[str]
        :keyword ip_address_pools: The names of the IP address pools associated with this announcement.
         Required.
        :paramtype ip_address_pools: list[str]
        :keyword peers: The names of the BGP peers to limit this advertisement to. If no values are
         specified, all BGP peers will receive this advertisement.
        :paramtype peers: list[str]
        """
        super().__init__(**kwargs)
        self.advertise_to_fabric = advertise_to_fabric
        self.communities = communities
        self.ip_address_pools = ip_address_pools
        self.peers = peers


class BgpServiceLoadBalancerConfiguration(_serialization.Model):
    """BgpServiceLoadBalancerConfiguration represents the configuration of a BGP service load
    balancer.

    :ivar bgp_advertisements: The association of IP address pools to the communities and peers,
     allowing for announcement of IPs.
    :vartype bgp_advertisements: list[~azure.mgmt.networkcloud.models.BgpAdvertisement]
    :ivar bgp_peers: The list of additional BgpPeer entities that the Kubernetes cluster will peer
     with. All peering must be explicitly defined.
    :vartype bgp_peers: list[~azure.mgmt.networkcloud.models.ServiceLoadBalancerBgpPeer]
    :ivar fabric_peering_enabled: The indicator to specify if the load balancer peers with the
     network fabric. Known values are: "True" and "False".
    :vartype fabric_peering_enabled: str or ~azure.mgmt.networkcloud.models.FabricPeeringEnabled
    :ivar ip_address_pools: The list of pools of IP addresses that can be allocated to load
     balancer services.
    :vartype ip_address_pools: list[~azure.mgmt.networkcloud.models.IpAddressPool]
    """

    _attribute_map = {
        "bgp_advertisements": {"key": "bgpAdvertisements", "type": "[BgpAdvertisement]"},
        "bgp_peers": {"key": "bgpPeers", "type": "[ServiceLoadBalancerBgpPeer]"},
        "fabric_peering_enabled": {"key": "fabricPeeringEnabled", "type": "str"},
        "ip_address_pools": {"key": "ipAddressPools", "type": "[IpAddressPool]"},
    }

    def __init__(
        self,
        *,
        bgp_advertisements: Optional[List["_models.BgpAdvertisement"]] = None,
        bgp_peers: Optional[List["_models.ServiceLoadBalancerBgpPeer"]] = None,
        fabric_peering_enabled: Union[str, "_models.FabricPeeringEnabled"] = "True",
        ip_address_pools: Optional[List["_models.IpAddressPool"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bgp_advertisements: The association of IP address pools to the communities and peers,
         allowing for announcement of IPs.
        :paramtype bgp_advertisements: list[~azure.mgmt.networkcloud.models.BgpAdvertisement]
        :keyword bgp_peers: The list of additional BgpPeer entities that the Kubernetes cluster will
         peer with. All peering must be explicitly defined.
        :paramtype bgp_peers: list[~azure.mgmt.networkcloud.models.ServiceLoadBalancerBgpPeer]
        :keyword fabric_peering_enabled: The indicator to specify if the load balancer peers with the
         network fabric. Known values are: "True" and "False".
        :paramtype fabric_peering_enabled: str or ~azure.mgmt.networkcloud.models.FabricPeeringEnabled
        :keyword ip_address_pools: The list of pools of IP addresses that can be allocated to load
         balancer services.
        :paramtype ip_address_pools: list[~azure.mgmt.networkcloud.models.IpAddressPool]
        """
        super().__init__(**kwargs)
        self.bgp_advertisements = bgp_advertisements
        self.bgp_peers = bgp_peers
        self.fabric_peering_enabled = fabric_peering_enabled
        self.ip_address_pools = ip_address_pools


class BmcKeySet(TrackedResource):
    """BmcKeySet represents the baseboard management controller key set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location of the cluster associated with the resource.
     Required.
    :vartype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar azure_group_id: The object ID of Azure Active Directory group that all users in the list
     must be in for access to be granted. Users that are not in the group will not have access.
     Required.
    :vartype azure_group_id: str
    :ivar detailed_status: The more detailed status of the key set. Known values are: "AllActive",
     "SomeInvalid", "AllInvalid", and "Validating".
    :vartype detailed_status: str or ~azure.mgmt.networkcloud.models.BmcKeySetDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar expiration: The date and time after which the users in this key set will be removed from
     the baseboard management controllers. Required.
    :vartype expiration: ~datetime.datetime
    :ivar last_validation: The last time this key set was validated.
    :vartype last_validation: ~datetime.datetime
    :ivar privilege_level: The access level allowed for the users in this key set. Required. Known
     values are: "ReadOnly" and "Administrator".
    :vartype privilege_level: str or ~azure.mgmt.networkcloud.models.BmcKeySetPrivilegeLevel
    :ivar provisioning_state: The provisioning state of the baseboard management controller key
     set. Known values are: "Succeeded", "Failed", "Canceled", "Accepted", and "Provisioning".
    :vartype provisioning_state: str or ~azure.mgmt.networkcloud.models.BmcKeySetProvisioningState
    :ivar user_list: The unique list of permitted users. Required.
    :vartype user_list: list[~azure.mgmt.networkcloud.models.KeySetUser]
    :ivar user_list_status: The status evaluation of each user.
    :vartype user_list_status: list[~azure.mgmt.networkcloud.models.KeySetUserStatus]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "extended_location": {"required": True},
        "azure_group_id": {"required": True},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "expiration": {"required": True},
        "last_validation": {"readonly": True},
        "privilege_level": {"required": True},
        "provisioning_state": {"readonly": True},
        "user_list": {"required": True},
        "user_list_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "azure_group_id": {"key": "properties.azureGroupId", "type": "str"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "expiration": {"key": "properties.expiration", "type": "iso-8601"},
        "last_validation": {"key": "properties.lastValidation", "type": "iso-8601"},
        "privilege_level": {"key": "properties.privilegeLevel", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "user_list": {"key": "properties.userList", "type": "[KeySetUser]"},
        "user_list_status": {"key": "properties.userListStatus", "type": "[KeySetUserStatus]"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        azure_group_id: str,
        expiration: datetime.datetime,
        privilege_level: Union[str, "_models.BmcKeySetPrivilegeLevel"],
        user_list: List["_models.KeySetUser"],
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location of the cluster associated with the resource.
         Required.
        :paramtype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
        :keyword azure_group_id: The object ID of Azure Active Directory group that all users in the
         list must be in for access to be granted. Users that are not in the group will not have access.
         Required.
        :paramtype azure_group_id: str
        :keyword expiration: The date and time after which the users in this key set will be removed
         from the baseboard management controllers. Required.
        :paramtype expiration: ~datetime.datetime
        :keyword privilege_level: The access level allowed for the users in this key set. Required.
         Known values are: "ReadOnly" and "Administrator".
        :paramtype privilege_level: str or ~azure.mgmt.networkcloud.models.BmcKeySetPrivilegeLevel
        :keyword user_list: The unique list of permitted users. Required.
        :paramtype user_list: list[~azure.mgmt.networkcloud.models.KeySetUser]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.azure_group_id = azure_group_id
        self.detailed_status = None
        self.detailed_status_message = None
        self.expiration = expiration
        self.last_validation = None
        self.privilege_level = privilege_level
        self.provisioning_state = None
        self.user_list = user_list
        self.user_list_status = None


class BmcKeySetList(_serialization.Model):
    """BmcKeySetList represents a list of baseboard management controller key sets.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of baseboard management controller key sets.
    :vartype value: list[~azure.mgmt.networkcloud.models.BmcKeySet]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[BmcKeySet]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.BmcKeySet"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of baseboard management controller key sets.
        :paramtype value: list[~azure.mgmt.networkcloud.models.BmcKeySet]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class BmcKeySetPatchParameters(_serialization.Model):
    """BmcKeySetPatchParameters represents the body of the request to patch the baseboard management
    controller key set.

    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    :ivar expiration: The date and time after which the users in this key set will be removed from
     the baseboard management controllers.
    :vartype expiration: ~datetime.datetime
    :ivar user_list: The unique list of permitted users.
    :vartype user_list: list[~azure.mgmt.networkcloud.models.KeySetUser]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "expiration": {"key": "properties.expiration", "type": "iso-8601"},
        "user_list": {"key": "properties.userList", "type": "[KeySetUser]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        expiration: Optional[datetime.datetime] = None,
        user_list: Optional[List["_models.KeySetUser"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        :keyword expiration: The date and time after which the users in this key set will be removed
         from the baseboard management controllers.
        :paramtype expiration: ~datetime.datetime
        :keyword user_list: The unique list of permitted users.
        :paramtype user_list: list[~azure.mgmt.networkcloud.models.KeySetUser]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.expiration = expiration
        self.user_list = user_list


class CloudServicesNetwork(TrackedResource):
    """Upon creation, the additional services that are provided by the platform will be allocated and
    represented in the status of this resource. All resources associated with this cloud services
    network will be part
    of the same layer 2 (L2) isolation domain. At least one service network must be created but may
    be reused across many
    virtual machines and/or Hybrid AKS clusters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location of the cluster associated with the resource.
     Required.
    :vartype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar additional_egress_endpoints: The list of egress endpoints. This allows for connection
     from a Hybrid AKS cluster to the specified endpoint.
    :vartype additional_egress_endpoints: list[~azure.mgmt.networkcloud.models.EgressEndpoint]
    :ivar associated_resource_ids: The list of resource IDs for the other Microsoft.NetworkCloud
     resources that have attached this network.
    :vartype associated_resource_ids: list[str]
    :ivar cluster_id: The resource ID of the Network Cloud cluster this cloud services network is
     associated with.
    :vartype cluster_id: str
    :ivar detailed_status: The more detailed status of the cloud services network. Known values
     are: "Error", "Available", and "Provisioning".
    :vartype detailed_status: str or
     ~azure.mgmt.networkcloud.models.CloudServicesNetworkDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar enable_default_egress_endpoints: The indicator of whether the platform default endpoints
     are allowed for the egress traffic. Known values are: "True" and "False".
    :vartype enable_default_egress_endpoints: str or
     ~azure.mgmt.networkcloud.models.CloudServicesNetworkEnableDefaultEgressEndpoints
    :ivar enabled_egress_endpoints: The full list of additional and default egress endpoints that
     are currently enabled.
    :vartype enabled_egress_endpoints: list[~azure.mgmt.networkcloud.models.EgressEndpoint]
    :ivar hybrid_aks_clusters_associated_ids: Field Deprecated. These fields will be empty/omitted.
     The list of Hybrid AKS cluster resource IDs that are associated with this cloud services
     network.
    :vartype hybrid_aks_clusters_associated_ids: list[str]
    :ivar interface_name: The name of the interface that will be present in the virtual machine to
     represent this network.
    :vartype interface_name: str
    :ivar provisioning_state: The provisioning state of the cloud services network. Known values
     are: "Succeeded", "Failed", "Canceled", "Provisioning", and "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.networkcloud.models.CloudServicesNetworkProvisioningState
    :ivar virtual_machines_associated_ids: Field Deprecated. These fields will be empty/omitted.
     The list of virtual machine resource IDs, excluding any Hybrid AKS virtual machines, that are
     currently using this cloud services network.
    :vartype virtual_machines_associated_ids: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "extended_location": {"required": True},
        "associated_resource_ids": {"readonly": True},
        "cluster_id": {"readonly": True},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "enabled_egress_endpoints": {"readonly": True},
        "hybrid_aks_clusters_associated_ids": {"readonly": True},
        "interface_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "virtual_machines_associated_ids": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "additional_egress_endpoints": {"key": "properties.additionalEgressEndpoints", "type": "[EgressEndpoint]"},
        "associated_resource_ids": {"key": "properties.associatedResourceIds", "type": "[str]"},
        "cluster_id": {"key": "properties.clusterId", "type": "str"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "enable_default_egress_endpoints": {"key": "properties.enableDefaultEgressEndpoints", "type": "str"},
        "enabled_egress_endpoints": {"key": "properties.enabledEgressEndpoints", "type": "[EgressEndpoint]"},
        "hybrid_aks_clusters_associated_ids": {"key": "properties.hybridAksClustersAssociatedIds", "type": "[str]"},
        "interface_name": {"key": "properties.interfaceName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "virtual_machines_associated_ids": {"key": "properties.virtualMachinesAssociatedIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        tags: Optional[Dict[str, str]] = None,
        additional_egress_endpoints: Optional[List["_models.EgressEndpoint"]] = None,
        enable_default_egress_endpoints: Optional[
            Union[str, "_models.CloudServicesNetworkEnableDefaultEgressEndpoints"]
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location of the cluster associated with the resource.
         Required.
        :paramtype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
        :keyword additional_egress_endpoints: The list of egress endpoints. This allows for connection
         from a Hybrid AKS cluster to the specified endpoint.
        :paramtype additional_egress_endpoints: list[~azure.mgmt.networkcloud.models.EgressEndpoint]
        :keyword enable_default_egress_endpoints: The indicator of whether the platform default
         endpoints are allowed for the egress traffic. Known values are: "True" and "False".
        :paramtype enable_default_egress_endpoints: str or
         ~azure.mgmt.networkcloud.models.CloudServicesNetworkEnableDefaultEgressEndpoints
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.additional_egress_endpoints = additional_egress_endpoints
        self.associated_resource_ids = None
        self.cluster_id = None
        self.detailed_status = None
        self.detailed_status_message = None
        self.enable_default_egress_endpoints = enable_default_egress_endpoints
        self.enabled_egress_endpoints = None
        self.hybrid_aks_clusters_associated_ids = None
        self.interface_name = None
        self.provisioning_state = None
        self.virtual_machines_associated_ids = None


class CloudServicesNetworkList(_serialization.Model):
    """CloudServicesNetworkList represents a list of cloud services networks.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of cloud services networks.
    :vartype value: list[~azure.mgmt.networkcloud.models.CloudServicesNetwork]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[CloudServicesNetwork]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.CloudServicesNetwork"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of cloud services networks.
        :paramtype value: list[~azure.mgmt.networkcloud.models.CloudServicesNetwork]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class CloudServicesNetworkPatchParameters(_serialization.Model):
    """CloudServicesNetworkPatchParameters represents the body of the request to patch the cloud
    services network.

    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    :ivar additional_egress_endpoints: The list of egress endpoints. This allows for connection
     from a Hybrid AKS cluster to the specified endpoint.
    :vartype additional_egress_endpoints: list[~azure.mgmt.networkcloud.models.EgressEndpoint]
    :ivar enable_default_egress_endpoints: The indicator of whether the platform default endpoints
     are allowed for the egress traffic. Known values are: "True" and "False".
    :vartype enable_default_egress_endpoints: str or
     ~azure.mgmt.networkcloud.models.CloudServicesNetworkEnableDefaultEgressEndpoints
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "additional_egress_endpoints": {"key": "properties.additionalEgressEndpoints", "type": "[EgressEndpoint]"},
        "enable_default_egress_endpoints": {"key": "properties.enableDefaultEgressEndpoints", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        additional_egress_endpoints: Optional[List["_models.EgressEndpoint"]] = None,
        enable_default_egress_endpoints: Optional[
            Union[str, "_models.CloudServicesNetworkEnableDefaultEgressEndpoints"]
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        :keyword additional_egress_endpoints: The list of egress endpoints. This allows for connection
         from a Hybrid AKS cluster to the specified endpoint.
        :paramtype additional_egress_endpoints: list[~azure.mgmt.networkcloud.models.EgressEndpoint]
        :keyword enable_default_egress_endpoints: The indicator of whether the platform default
         endpoints are allowed for the egress traffic. Known values are: "True" and "False".
        :paramtype enable_default_egress_endpoints: str or
         ~azure.mgmt.networkcloud.models.CloudServicesNetworkEnableDefaultEgressEndpoints
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.additional_egress_endpoints = additional_egress_endpoints
        self.enable_default_egress_endpoints = enable_default_egress_endpoints


class Cluster(TrackedResource):
    """Cluster represents the on-premises Network Cloud cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location of the cluster manager associated with the
     cluster. Required.
    :vartype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar identity: The identity for the resource.
    :vartype identity: ~azure.mgmt.networkcloud.models.ManagedServiceIdentity
    :ivar aggregator_or_single_rack_definition: The rack definition that is intended to reflect
     only a single rack in a single rack cluster, or an aggregator rack in a multi-rack cluster.
     Required.
    :vartype aggregator_or_single_rack_definition: ~azure.mgmt.networkcloud.models.RackDefinition
    :ivar analytics_workspace_id: The resource ID of the Log Analytics Workspace that will be used
     for storing relevant logs.
    :vartype analytics_workspace_id: str
    :ivar available_upgrade_versions: The list of cluster runtime version upgrades available for
     this cluster.
    :vartype available_upgrade_versions:
     list[~azure.mgmt.networkcloud.models.ClusterAvailableUpgradeVersion]
    :ivar cluster_capacity: The capacity supported by this cluster.
    :vartype cluster_capacity: ~azure.mgmt.networkcloud.models.ClusterCapacity
    :ivar cluster_connection_status: The latest heartbeat status between the cluster manager and
     the cluster. Known values are: "Connected", "Disconnected", "Timeout", and "Undefined".
    :vartype cluster_connection_status: str or
     ~azure.mgmt.networkcloud.models.ClusterConnectionStatus
    :ivar cluster_extended_location: The extended location (custom location) that represents the
     cluster's control plane location. This extended location is used to route the requests of child
     objects of the cluster that are handled by the platform operator.
    :vartype cluster_extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar cluster_location: The customer-provided location information to identify where the
     cluster resides.
    :vartype cluster_location: str
    :ivar cluster_manager_connection_status: The latest connectivity status between cluster manager
     and the cluster. Known values are: "Connected" and "Unreachable".
    :vartype cluster_manager_connection_status: str or
     ~azure.mgmt.networkcloud.models.ClusterManagerConnectionStatus
    :ivar cluster_manager_id: The resource ID of the cluster manager that manages this cluster.
     This is set by the Cluster Manager when the cluster is created.
    :vartype cluster_manager_id: str
    :ivar cluster_service_principal: The service principal to be used by the cluster during Arc
     Appliance installation.
    :vartype cluster_service_principal: ~azure.mgmt.networkcloud.models.ServicePrincipalInformation
    :ivar cluster_type: The type of rack configuration for the cluster. Required. Known values are:
     "SingleRack" and "MultiRack".
    :vartype cluster_type: str or ~azure.mgmt.networkcloud.models.ClusterType
    :ivar cluster_version: The current runtime version of the cluster. Required.
    :vartype cluster_version: str
    :ivar command_output_settings: The settings for commands run in this cluster, such as bare
     metal machine run read only commands and data extracts.
    :vartype command_output_settings: ~azure.mgmt.networkcloud.models.CommandOutputSettings
    :ivar compute_deployment_threshold: The validation threshold indicating the allowable failures
     of compute machines during environment validation and deployment.
    :vartype compute_deployment_threshold: ~azure.mgmt.networkcloud.models.ValidationThreshold
    :ivar compute_rack_definitions: The list of rack definitions for the compute racks in a
     multi-rack
     cluster, or an empty list in a single-rack cluster.
    :vartype compute_rack_definitions: list[~azure.mgmt.networkcloud.models.RackDefinition]
    :ivar detailed_status: The current detailed status of the cluster. Known values are:
     "PendingDeployment", "Deploying", "Running", "Updating", "UpdatePaused", "Degraded",
     "Deleting", "Disconnected", and "Failed".
    :vartype detailed_status: str or ~azure.mgmt.networkcloud.models.ClusterDetailedStatus
    :ivar detailed_status_message: The descriptive message about the detailed status.
    :vartype detailed_status_message: str
    :ivar hybrid_aks_extended_location: Field Deprecated. This field will not be populated in an
     upcoming version. The extended location (custom location) that represents the Hybrid AKS
     control plane location. This extended location is used when creating provisioned clusters
     (Hybrid AKS clusters).
    :vartype hybrid_aks_extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar managed_resource_group_configuration: The configuration of the managed resource group
     associated with the resource.
    :vartype managed_resource_group_configuration:
     ~azure.mgmt.networkcloud.models.ManagedResourceGroupConfiguration
    :ivar manual_action_count: The count of Manual Action Taken (MAT) events that have not been
     validated.
    :vartype manual_action_count: int
    :ivar network_fabric_id: The resource ID of the Network Fabric associated with the cluster.
     Required.
    :vartype network_fabric_id: str
    :ivar provisioning_state: The provisioning state of the cluster. Known values are: "Succeeded",
     "Failed", "Canceled", "Accepted", "Validating", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.networkcloud.models.ClusterProvisioningState
    :ivar runtime_protection_configuration: The settings for cluster runtime protection.
    :vartype runtime_protection_configuration:
     ~azure.mgmt.networkcloud.models.RuntimeProtectionConfiguration
    :ivar secret_archive: The configuration for use of a key vault to store secrets for later
     retrieval by the operator.
    :vartype secret_archive: ~azure.mgmt.networkcloud.models.ClusterSecretArchive
    :ivar support_expiry_date: The support end date of the runtime version of the cluster.
    :vartype support_expiry_date: str
    :ivar update_strategy: The strategy for updating the cluster.
    :vartype update_strategy: ~azure.mgmt.networkcloud.models.ClusterUpdateStrategy
    :ivar workload_resource_ids: The list of workload resource IDs that are hosted within this
     cluster.
    :vartype workload_resource_ids: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "extended_location": {"required": True},
        "aggregator_or_single_rack_definition": {"required": True},
        "available_upgrade_versions": {"readonly": True},
        "cluster_capacity": {"readonly": True},
        "cluster_connection_status": {"readonly": True},
        "cluster_extended_location": {"readonly": True},
        "cluster_location": {"max_length": 256},
        "cluster_manager_connection_status": {"readonly": True},
        "cluster_manager_id": {"readonly": True},
        "cluster_type": {"required": True},
        "cluster_version": {"required": True},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "hybrid_aks_extended_location": {"readonly": True},
        "manual_action_count": {"readonly": True},
        "network_fabric_id": {"required": True},
        "provisioning_state": {"readonly": True},
        "support_expiry_date": {"readonly": True},
        "workload_resource_ids": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "aggregator_or_single_rack_definition": {
            "key": "properties.aggregatorOrSingleRackDefinition",
            "type": "RackDefinition",
        },
        "analytics_workspace_id": {"key": "properties.analyticsWorkspaceId", "type": "str"},
        "available_upgrade_versions": {
            "key": "properties.availableUpgradeVersions",
            "type": "[ClusterAvailableUpgradeVersion]",
        },
        "cluster_capacity": {"key": "properties.clusterCapacity", "type": "ClusterCapacity"},
        "cluster_connection_status": {"key": "properties.clusterConnectionStatus", "type": "str"},
        "cluster_extended_location": {"key": "properties.clusterExtendedLocation", "type": "ExtendedLocation"},
        "cluster_location": {"key": "properties.clusterLocation", "type": "str"},
        "cluster_manager_connection_status": {"key": "properties.clusterManagerConnectionStatus", "type": "str"},
        "cluster_manager_id": {"key": "properties.clusterManagerId", "type": "str"},
        "cluster_service_principal": {
            "key": "properties.clusterServicePrincipal",
            "type": "ServicePrincipalInformation",
        },
        "cluster_type": {"key": "properties.clusterType", "type": "str"},
        "cluster_version": {"key": "properties.clusterVersion", "type": "str"},
        "command_output_settings": {"key": "properties.commandOutputSettings", "type": "CommandOutputSettings"},
        "compute_deployment_threshold": {"key": "properties.computeDeploymentThreshold", "type": "ValidationThreshold"},
        "compute_rack_definitions": {"key": "properties.computeRackDefinitions", "type": "[RackDefinition]"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "hybrid_aks_extended_location": {"key": "properties.hybridAksExtendedLocation", "type": "ExtendedLocation"},
        "managed_resource_group_configuration": {
            "key": "properties.managedResourceGroupConfiguration",
            "type": "ManagedResourceGroupConfiguration",
        },
        "manual_action_count": {"key": "properties.manualActionCount", "type": "int"},
        "network_fabric_id": {"key": "properties.networkFabricId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "runtime_protection_configuration": {
            "key": "properties.runtimeProtectionConfiguration",
            "type": "RuntimeProtectionConfiguration",
        },
        "secret_archive": {"key": "properties.secretArchive", "type": "ClusterSecretArchive"},
        "support_expiry_date": {"key": "properties.supportExpiryDate", "type": "str"},
        "update_strategy": {"key": "properties.updateStrategy", "type": "ClusterUpdateStrategy"},
        "workload_resource_ids": {"key": "properties.workloadResourceIds", "type": "[str]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        aggregator_or_single_rack_definition: "_models.RackDefinition",
        cluster_type: Union[str, "_models.ClusterType"],
        cluster_version: str,
        network_fabric_id: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        analytics_workspace_id: Optional[str] = None,
        cluster_location: Optional[str] = None,
        cluster_service_principal: Optional["_models.ServicePrincipalInformation"] = None,
        command_output_settings: Optional["_models.CommandOutputSettings"] = None,
        compute_deployment_threshold: Optional["_models.ValidationThreshold"] = None,
        compute_rack_definitions: Optional[List["_models.RackDefinition"]] = None,
        managed_resource_group_configuration: Optional["_models.ManagedResourceGroupConfiguration"] = None,
        runtime_protection_configuration: Optional["_models.RuntimeProtectionConfiguration"] = None,
        secret_archive: Optional["_models.ClusterSecretArchive"] = None,
        update_strategy: Optional["_models.ClusterUpdateStrategy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location of the cluster manager associated with the
         cluster. Required.
        :paramtype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
        :keyword identity: The identity for the resource.
        :paramtype identity: ~azure.mgmt.networkcloud.models.ManagedServiceIdentity
        :keyword aggregator_or_single_rack_definition: The rack definition that is intended to reflect
         only a single rack in a single rack cluster, or an aggregator rack in a multi-rack cluster.
         Required.
        :paramtype aggregator_or_single_rack_definition: ~azure.mgmt.networkcloud.models.RackDefinition
        :keyword analytics_workspace_id: The resource ID of the Log Analytics Workspace that will be
         used for storing relevant logs.
        :paramtype analytics_workspace_id: str
        :keyword cluster_location: The customer-provided location information to identify where the
         cluster resides.
        :paramtype cluster_location: str
        :keyword cluster_service_principal: The service principal to be used by the cluster during Arc
         Appliance installation.
        :paramtype cluster_service_principal:
         ~azure.mgmt.networkcloud.models.ServicePrincipalInformation
        :keyword cluster_type: The type of rack configuration for the cluster. Required. Known values
         are: "SingleRack" and "MultiRack".
        :paramtype cluster_type: str or ~azure.mgmt.networkcloud.models.ClusterType
        :keyword cluster_version: The current runtime version of the cluster. Required.
        :paramtype cluster_version: str
        :keyword command_output_settings: The settings for commands run in this cluster, such as bare
         metal machine run read only commands and data extracts.
        :paramtype command_output_settings: ~azure.mgmt.networkcloud.models.CommandOutputSettings
        :keyword compute_deployment_threshold: The validation threshold indicating the allowable
         failures of compute machines during environment validation and deployment.
        :paramtype compute_deployment_threshold: ~azure.mgmt.networkcloud.models.ValidationThreshold
        :keyword compute_rack_definitions: The list of rack definitions for the compute racks in a
         multi-rack
         cluster, or an empty list in a single-rack cluster.
        :paramtype compute_rack_definitions: list[~azure.mgmt.networkcloud.models.RackDefinition]
        :keyword managed_resource_group_configuration: The configuration of the managed resource group
         associated with the resource.
        :paramtype managed_resource_group_configuration:
         ~azure.mgmt.networkcloud.models.ManagedResourceGroupConfiguration
        :keyword network_fabric_id: The resource ID of the Network Fabric associated with the cluster.
         Required.
        :paramtype network_fabric_id: str
        :keyword runtime_protection_configuration: The settings for cluster runtime protection.
        :paramtype runtime_protection_configuration:
         ~azure.mgmt.networkcloud.models.RuntimeProtectionConfiguration
        :keyword secret_archive: The configuration for use of a key vault to store secrets for later
         retrieval by the operator.
        :paramtype secret_archive: ~azure.mgmt.networkcloud.models.ClusterSecretArchive
        :keyword update_strategy: The strategy for updating the cluster.
        :paramtype update_strategy: ~azure.mgmt.networkcloud.models.ClusterUpdateStrategy
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.identity = identity
        self.aggregator_or_single_rack_definition = aggregator_or_single_rack_definition
        self.analytics_workspace_id = analytics_workspace_id
        self.available_upgrade_versions = None
        self.cluster_capacity = None
        self.cluster_connection_status = None
        self.cluster_extended_location = None
        self.cluster_location = cluster_location
        self.cluster_manager_connection_status = None
        self.cluster_manager_id = None
        self.cluster_service_principal = cluster_service_principal
        self.cluster_type = cluster_type
        self.cluster_version = cluster_version
        self.command_output_settings = command_output_settings
        self.compute_deployment_threshold = compute_deployment_threshold
        self.compute_rack_definitions = compute_rack_definitions
        self.detailed_status = None
        self.detailed_status_message = None
        self.hybrid_aks_extended_location = None
        self.managed_resource_group_configuration = managed_resource_group_configuration
        self.manual_action_count = None
        self.network_fabric_id = network_fabric_id
        self.provisioning_state = None
        self.runtime_protection_configuration = runtime_protection_configuration
        self.secret_archive = secret_archive
        self.support_expiry_date = None
        self.update_strategy = update_strategy
        self.workload_resource_ids = None


class ClusterAvailableUpgradeVersion(_serialization.Model):
    """ClusterAvailableUpgradeVersion represents the various cluster upgrade parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar control_impact: The indicator of whether the control plane will be impacted during the
     upgrade. Known values are: "True" and "False".
    :vartype control_impact: str or ~azure.mgmt.networkcloud.models.ControlImpact
    :ivar expected_duration: The expected duration needed for this upgrade.
    :vartype expected_duration: str
    :ivar impact_description: The impact description including the specific details and release
     notes.
    :vartype impact_description: str
    :ivar support_expiry_date: The last date the version of the platform is supported.
    :vartype support_expiry_date: str
    :ivar target_cluster_version: The target version this cluster will be upgraded to.
    :vartype target_cluster_version: str
    :ivar workload_impact: The indicator of whether the workload will be impacted during the
     upgrade. Known values are: "True" and "False".
    :vartype workload_impact: str or ~azure.mgmt.networkcloud.models.WorkloadImpact
    """

    _validation = {
        "control_impact": {"readonly": True},
        "expected_duration": {"readonly": True},
        "impact_description": {"readonly": True},
        "support_expiry_date": {"readonly": True},
        "target_cluster_version": {"readonly": True},
        "workload_impact": {"readonly": True},
    }

    _attribute_map = {
        "control_impact": {"key": "controlImpact", "type": "str"},
        "expected_duration": {"key": "expectedDuration", "type": "str"},
        "impact_description": {"key": "impactDescription", "type": "str"},
        "support_expiry_date": {"key": "supportExpiryDate", "type": "str"},
        "target_cluster_version": {"key": "targetClusterVersion", "type": "str"},
        "workload_impact": {"key": "workloadImpact", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.control_impact = None
        self.expected_duration = None
        self.impact_description = None
        self.support_expiry_date = None
        self.target_cluster_version = None
        self.workload_impact = None


class ClusterAvailableVersion(_serialization.Model):
    """ClusterAvailableVersion represents the cluster version that the cluster manager can be asked to
    create and manage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar support_expiry_date: The last date the version of the platform is supported.
    :vartype support_expiry_date: str
    :ivar target_cluster_version: The version of the cluster to be deployed.
    :vartype target_cluster_version: str
    """

    _validation = {
        "support_expiry_date": {"readonly": True},
        "target_cluster_version": {"readonly": True},
    }

    _attribute_map = {
        "support_expiry_date": {"key": "supportExpiryDate", "type": "str"},
        "target_cluster_version": {"key": "targetClusterVersion", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.support_expiry_date = None
        self.target_cluster_version = None


class ClusterCapacity(_serialization.Model):
    """ClusterCapacity represents various details regarding compute capacity.

    :ivar available_appliance_storage_gb: The remaining appliance-based storage in GB available for
     workload use. Measured in gibibytes.
    :vartype available_appliance_storage_gb: int
    :ivar available_core_count: The remaining number of cores that are available in this cluster
     for workload use.
    :vartype available_core_count: int
    :ivar available_host_storage_gb: The remaining machine or host-based storage in GB available
     for workload use. Measured in gibibytes.
    :vartype available_host_storage_gb: int
    :ivar available_memory_gb: The remaining memory in GB that are available in this cluster for
     workload use. Measured in gibibytes.
    :vartype available_memory_gb: int
    :ivar total_appliance_storage_gb: The total appliance-based storage in GB supported by this
     cluster for workload use. Measured in gibibytes.
    :vartype total_appliance_storage_gb: int
    :ivar total_core_count: The total number of cores that are supported by this cluster for
     workload use.
    :vartype total_core_count: int
    :ivar total_host_storage_gb: The total machine or host-based storage in GB supported by this
     cluster for workload use. Measured in gibibytes.
    :vartype total_host_storage_gb: int
    :ivar total_memory_gb: The total memory supported by this cluster for workload use. Measured in
     gibibytes.
    :vartype total_memory_gb: int
    """

    _attribute_map = {
        "available_appliance_storage_gb": {"key": "availableApplianceStorageGB", "type": "int"},
        "available_core_count": {"key": "availableCoreCount", "type": "int"},
        "available_host_storage_gb": {"key": "availableHostStorageGB", "type": "int"},
        "available_memory_gb": {"key": "availableMemoryGB", "type": "int"},
        "total_appliance_storage_gb": {"key": "totalApplianceStorageGB", "type": "int"},
        "total_core_count": {"key": "totalCoreCount", "type": "int"},
        "total_host_storage_gb": {"key": "totalHostStorageGB", "type": "int"},
        "total_memory_gb": {"key": "totalMemoryGB", "type": "int"},
    }

    def __init__(
        self,
        *,
        available_appliance_storage_gb: Optional[int] = None,
        available_core_count: Optional[int] = None,
        available_host_storage_gb: Optional[int] = None,
        available_memory_gb: Optional[int] = None,
        total_appliance_storage_gb: Optional[int] = None,
        total_core_count: Optional[int] = None,
        total_host_storage_gb: Optional[int] = None,
        total_memory_gb: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword available_appliance_storage_gb: The remaining appliance-based storage in GB available
         for workload use. Measured in gibibytes.
        :paramtype available_appliance_storage_gb: int
        :keyword available_core_count: The remaining number of cores that are available in this cluster
         for workload use.
        :paramtype available_core_count: int
        :keyword available_host_storage_gb: The remaining machine or host-based storage in GB available
         for workload use. Measured in gibibytes.
        :paramtype available_host_storage_gb: int
        :keyword available_memory_gb: The remaining memory in GB that are available in this cluster for
         workload use. Measured in gibibytes.
        :paramtype available_memory_gb: int
        :keyword total_appliance_storage_gb: The total appliance-based storage in GB supported by this
         cluster for workload use. Measured in gibibytes.
        :paramtype total_appliance_storage_gb: int
        :keyword total_core_count: The total number of cores that are supported by this cluster for
         workload use.
        :paramtype total_core_count: int
        :keyword total_host_storage_gb: The total machine or host-based storage in GB supported by this
         cluster for workload use. Measured in gibibytes.
        :paramtype total_host_storage_gb: int
        :keyword total_memory_gb: The total memory supported by this cluster for workload use. Measured
         in gibibytes.
        :paramtype total_memory_gb: int
        """
        super().__init__(**kwargs)
        self.available_appliance_storage_gb = available_appliance_storage_gb
        self.available_core_count = available_core_count
        self.available_host_storage_gb = available_host_storage_gb
        self.available_memory_gb = available_memory_gb
        self.total_appliance_storage_gb = total_appliance_storage_gb
        self.total_core_count = total_core_count
        self.total_host_storage_gb = total_host_storage_gb
        self.total_memory_gb = total_memory_gb


class ClusterContinueUpdateVersionParameters(_serialization.Model):
    """ClusterContinueUpdateVersionParameters represents the body of the request to continue the
    update of a cluster version.

    :ivar machine_group_targeting_mode: The mode by which the cluster will target the next grouping
     of servers to continue the update. "AlphaByRack"
    :vartype machine_group_targeting_mode: str or
     ~azure.mgmt.networkcloud.models.ClusterContinueUpdateVersionMachineGroupTargetingMode
    """

    _attribute_map = {
        "machine_group_targeting_mode": {"key": "machineGroupTargetingMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        machine_group_targeting_mode: Union[
            str, "_models.ClusterContinueUpdateVersionMachineGroupTargetingMode"
        ] = "AlphaByRack",
        **kwargs: Any
    ) -> None:
        """
        :keyword machine_group_targeting_mode: The mode by which the cluster will target the next
         grouping of servers to continue the update. "AlphaByRack"
        :paramtype machine_group_targeting_mode: str or
         ~azure.mgmt.networkcloud.models.ClusterContinueUpdateVersionMachineGroupTargetingMode
        """
        super().__init__(**kwargs)
        self.machine_group_targeting_mode = machine_group_targeting_mode


class ClusterDeployParameters(_serialization.Model):
    """ClusterDeployParameters represents the body of the request to deploy cluster.

    :ivar skip_validations_for_machines: The names of bare metal machines in the cluster that
     should be skipped during environment validation.
    :vartype skip_validations_for_machines: list[str]
    """

    _attribute_map = {
        "skip_validations_for_machines": {"key": "skipValidationsForMachines", "type": "[str]"},
    }

    def __init__(self, *, skip_validations_for_machines: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword skip_validations_for_machines: The names of bare metal machines in the cluster that
         should be skipped during environment validation.
        :paramtype skip_validations_for_machines: list[str]
        """
        super().__init__(**kwargs)
        self.skip_validations_for_machines = skip_validations_for_machines


class ClusterList(_serialization.Model):
    """ClusterList represents a list of clusters.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of clusters.
    :vartype value: list[~azure.mgmt.networkcloud.models.Cluster]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Cluster]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.Cluster"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of clusters.
        :paramtype value: list[~azure.mgmt.networkcloud.models.Cluster]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ClusterManager(TrackedResource):
    """ClusterManager represents a control-plane to manage one or more on-premises clusters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: The identity of the cluster manager.
    :vartype identity: ~azure.mgmt.networkcloud.models.ManagedServiceIdentity
    :ivar analytics_workspace_id: The resource ID of the Log Analytics workspace that is used for
     the logs collection.
    :vartype analytics_workspace_id: str
    :ivar availability_zones: Field deprecated, this value will no longer influence the cluster
     manager allocation process and will be removed in a future version. The Azure availability
     zones within the region that will be used to support the cluster manager resource.
    :vartype availability_zones: list[str]
    :ivar cluster_versions: The list of the cluster versions the manager supports. It is used as
     input in clusterVersion property of a cluster resource.
    :vartype cluster_versions: list[~azure.mgmt.networkcloud.models.ClusterAvailableVersion]
    :ivar detailed_status: The detailed status that provides additional information about the
     cluster manager. Known values are: "Error", "Available", "Provisioning", "ProvisioningFailed",
     "Updating", and "UpdateFailed".
    :vartype detailed_status: str or ~azure.mgmt.networkcloud.models.ClusterManagerDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar fabric_controller_id: The resource ID of the fabric controller that has one to one
     mapping with the cluster manager. Required.
    :vartype fabric_controller_id: str
    :ivar managed_resource_group_configuration: The configuration of the managed resource group
     associated with the resource.
    :vartype managed_resource_group_configuration:
     ~azure.mgmt.networkcloud.models.ManagedResourceGroupConfiguration
    :ivar manager_extended_location: The extended location (custom location) that represents the
     cluster manager's control plane location. This extended location is used when creating cluster
     and rack manifest resources.
    :vartype manager_extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar provisioning_state: The provisioning state of the cluster manager. Known values are:
     "Succeeded", "Failed", "Canceled", "Provisioning", "Accepted", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.networkcloud.models.ClusterManagerProvisioningState
    :ivar vm_size: Field deprecated, this value will no longer influence the cluster manager
     allocation process and will be removed in a future version. The size of the Azure virtual
     machines to use for hosting the cluster manager resource.
    :vartype vm_size: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "cluster_versions": {"readonly": True},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "fabric_controller_id": {"required": True},
        "manager_extended_location": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "analytics_workspace_id": {"key": "properties.analyticsWorkspaceId", "type": "str"},
        "availability_zones": {"key": "properties.availabilityZones", "type": "[str]"},
        "cluster_versions": {"key": "properties.clusterVersions", "type": "[ClusterAvailableVersion]"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "fabric_controller_id": {"key": "properties.fabricControllerId", "type": "str"},
        "managed_resource_group_configuration": {
            "key": "properties.managedResourceGroupConfiguration",
            "type": "ManagedResourceGroupConfiguration",
        },
        "manager_extended_location": {"key": "properties.managerExtendedLocation", "type": "ExtendedLocation"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "vm_size": {"key": "properties.vmSize", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        fabric_controller_id: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        analytics_workspace_id: Optional[str] = None,
        availability_zones: Optional[List[str]] = None,
        managed_resource_group_configuration: Optional["_models.ManagedResourceGroupConfiguration"] = None,
        vm_size: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The identity of the cluster manager.
        :paramtype identity: ~azure.mgmt.networkcloud.models.ManagedServiceIdentity
        :keyword analytics_workspace_id: The resource ID of the Log Analytics workspace that is used
         for the logs collection.
        :paramtype analytics_workspace_id: str
        :keyword availability_zones: Field deprecated, this value will no longer influence the cluster
         manager allocation process and will be removed in a future version. The Azure availability
         zones within the region that will be used to support the cluster manager resource.
        :paramtype availability_zones: list[str]
        :keyword fabric_controller_id: The resource ID of the fabric controller that has one to one
         mapping with the cluster manager. Required.
        :paramtype fabric_controller_id: str
        :keyword managed_resource_group_configuration: The configuration of the managed resource group
         associated with the resource.
        :paramtype managed_resource_group_configuration:
         ~azure.mgmt.networkcloud.models.ManagedResourceGroupConfiguration
        :keyword vm_size: Field deprecated, this value will no longer influence the cluster manager
         allocation process and will be removed in a future version. The size of the Azure virtual
         machines to use for hosting the cluster manager resource.
        :paramtype vm_size: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.analytics_workspace_id = analytics_workspace_id
        self.availability_zones = availability_zones
        self.cluster_versions = None
        self.detailed_status = None
        self.detailed_status_message = None
        self.fabric_controller_id = fabric_controller_id
        self.managed_resource_group_configuration = managed_resource_group_configuration
        self.manager_extended_location = None
        self.provisioning_state = None
        self.vm_size = vm_size


class ClusterManagerList(_serialization.Model):
    """ClusterManagerList represents a list of cluster manager objects.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of cluster managers.
    :vartype value: list[~azure.mgmt.networkcloud.models.ClusterManager]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ClusterManager]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.ClusterManager"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of cluster managers.
        :paramtype value: list[~azure.mgmt.networkcloud.models.ClusterManager]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ClusterManagerPatchParameters(_serialization.Model):
    """ClusterManagerPatchParameters represents the body of the request to patch the cluster
    properties.

    :ivar identity: The identity for the resource.
    :vartype identity: ~azure.mgmt.networkcloud.models.ManagedServiceIdentity
    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity for the resource.
        :paramtype identity: ~azure.mgmt.networkcloud.models.ManagedServiceIdentity
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags


class ClusterMetricsConfiguration(TrackedResource):
    """ClusterMetricsConfiguration represents the metrics configuration of an on-premises Network
    Cloud cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location of the cluster associated with the resource.
     Required.
    :vartype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar collection_interval: The interval in minutes by which metrics will be collected.
     Required.
    :vartype collection_interval: int
    :ivar detailed_status: The more detailed status of the metrics configuration. Known values are:
     "Processing", "Applied", and "Error".
    :vartype detailed_status: str or
     ~azure.mgmt.networkcloud.models.ClusterMetricsConfigurationDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar disabled_metrics: The list of metrics that are available for the cluster but disabled at
     the moment.
    :vartype disabled_metrics: list[str]
    :ivar enabled_metrics: The list of metric names that have been chosen to be enabled in addition
     to the core set of enabled metrics.
    :vartype enabled_metrics: list[str]
    :ivar provisioning_state: The provisioning state of the metrics configuration. Known values
     are: "Succeeded", "Failed", "Canceled", "Accepted", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.networkcloud.models.ClusterMetricsConfigurationProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "extended_location": {"required": True},
        "collection_interval": {"required": True, "maximum": 1440, "minimum": 1},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "disabled_metrics": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "collection_interval": {"key": "properties.collectionInterval", "type": "int"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "disabled_metrics": {"key": "properties.disabledMetrics", "type": "[str]"},
        "enabled_metrics": {"key": "properties.enabledMetrics", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        collection_interval: int,
        tags: Optional[Dict[str, str]] = None,
        enabled_metrics: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location of the cluster associated with the resource.
         Required.
        :paramtype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
        :keyword collection_interval: The interval in minutes by which metrics will be collected.
         Required.
        :paramtype collection_interval: int
        :keyword enabled_metrics: The list of metric names that have been chosen to be enabled in
         addition to the core set of enabled metrics.
        :paramtype enabled_metrics: list[str]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.collection_interval = collection_interval
        self.detailed_status = None
        self.detailed_status_message = None
        self.disabled_metrics = None
        self.enabled_metrics = enabled_metrics
        self.provisioning_state = None


class ClusterMetricsConfigurationList(_serialization.Model):
    """ClusterMetricsConfigurationList represents a list of metrics configuration of the cluster.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of metrics configurations.
    :vartype value: list[~azure.mgmt.networkcloud.models.ClusterMetricsConfiguration]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ClusterMetricsConfiguration]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.ClusterMetricsConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of metrics configurations.
        :paramtype value: list[~azure.mgmt.networkcloud.models.ClusterMetricsConfiguration]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ClusterMetricsConfigurationPatchParameters(_serialization.Model):  # pylint: disable=name-too-long
    """ClusterMetricsConfigurationPatchParameters represents the body of the request to patch the
    metrics configuration of cluster.

    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    :ivar collection_interval: The interval in minutes by which metrics will be collected.
    :vartype collection_interval: int
    :ivar enabled_metrics: The list of metric names that have been chosen to be enabled in addition
     to the core set of enabled metrics.
    :vartype enabled_metrics: list[str]
    """

    _validation = {
        "collection_interval": {"maximum": 1440, "minimum": 1},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "collection_interval": {"key": "properties.collectionInterval", "type": "int"},
        "enabled_metrics": {"key": "properties.enabledMetrics", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        collection_interval: Optional[int] = None,
        enabled_metrics: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        :keyword collection_interval: The interval in minutes by which metrics will be collected.
        :paramtype collection_interval: int
        :keyword enabled_metrics: The list of metric names that have been chosen to be enabled in
         addition to the core set of enabled metrics.
        :paramtype enabled_metrics: list[str]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.collection_interval = collection_interval
        self.enabled_metrics = enabled_metrics


class ClusterPatchParameters(_serialization.Model):
    """ClusterPatchParameters represents the body of the request to patch the cluster properties.

    :ivar identity: The identity for the resource.
    :vartype identity: ~azure.mgmt.networkcloud.models.ManagedServiceIdentity
    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    :ivar aggregator_or_single_rack_definition: The rack definition that is intended to reflect
     only a single rack in a single rack cluster, or an aggregator rack in a multi-rack cluster.
    :vartype aggregator_or_single_rack_definition: ~azure.mgmt.networkcloud.models.RackDefinition
    :ivar cluster_location: The customer-provided location information to identify where the
     cluster resides.
    :vartype cluster_location: str
    :ivar cluster_service_principal: The service principal to be used by the cluster during Arc
     Appliance installation.
    :vartype cluster_service_principal: ~azure.mgmt.networkcloud.models.ServicePrincipalInformation
    :ivar command_output_settings: The settings for commands run in this cluster, such as bare
     metal machine run read only commands and data extracts.
    :vartype command_output_settings: ~azure.mgmt.networkcloud.models.CommandOutputSettings
    :ivar compute_deployment_threshold: The validation threshold indicating the allowable failures
     of compute machines during environment validation and deployment.
    :vartype compute_deployment_threshold: ~azure.mgmt.networkcloud.models.ValidationThreshold
    :ivar compute_rack_definitions: The list of rack definitions for the compute racks in a
     multi-rack
     cluster, or an empty list in a single-rack cluster.
    :vartype compute_rack_definitions: list[~azure.mgmt.networkcloud.models.RackDefinition]
    :ivar runtime_protection_configuration: The settings for cluster runtime protection.
    :vartype runtime_protection_configuration:
     ~azure.mgmt.networkcloud.models.RuntimeProtectionConfiguration
    :ivar secret_archive: The configuration for use of a key vault to store secrets for later
     retrieval by the operator.
    :vartype secret_archive: ~azure.mgmt.networkcloud.models.ClusterSecretArchive
    :ivar update_strategy: The strategy for updating the cluster.
    :vartype update_strategy: ~azure.mgmt.networkcloud.models.ClusterUpdateStrategy
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "tags": {"key": "tags", "type": "{str}"},
        "aggregator_or_single_rack_definition": {
            "key": "properties.aggregatorOrSingleRackDefinition",
            "type": "RackDefinition",
        },
        "cluster_location": {"key": "properties.clusterLocation", "type": "str"},
        "cluster_service_principal": {
            "key": "properties.clusterServicePrincipal",
            "type": "ServicePrincipalInformation",
        },
        "command_output_settings": {"key": "properties.commandOutputSettings", "type": "CommandOutputSettings"},
        "compute_deployment_threshold": {"key": "properties.computeDeploymentThreshold", "type": "ValidationThreshold"},
        "compute_rack_definitions": {"key": "properties.computeRackDefinitions", "type": "[RackDefinition]"},
        "runtime_protection_configuration": {
            "key": "properties.runtimeProtectionConfiguration",
            "type": "RuntimeProtectionConfiguration",
        },
        "secret_archive": {"key": "properties.secretArchive", "type": "ClusterSecretArchive"},
        "update_strategy": {"key": "properties.updateStrategy", "type": "ClusterUpdateStrategy"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        aggregator_or_single_rack_definition: Optional["_models.RackDefinition"] = None,
        cluster_location: Optional[str] = None,
        cluster_service_principal: Optional["_models.ServicePrincipalInformation"] = None,
        command_output_settings: Optional["_models.CommandOutputSettings"] = None,
        compute_deployment_threshold: Optional["_models.ValidationThreshold"] = None,
        compute_rack_definitions: Optional[List["_models.RackDefinition"]] = None,
        runtime_protection_configuration: Optional["_models.RuntimeProtectionConfiguration"] = None,
        secret_archive: Optional["_models.ClusterSecretArchive"] = None,
        update_strategy: Optional["_models.ClusterUpdateStrategy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity for the resource.
        :paramtype identity: ~azure.mgmt.networkcloud.models.ManagedServiceIdentity
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        :keyword aggregator_or_single_rack_definition: The rack definition that is intended to reflect
         only a single rack in a single rack cluster, or an aggregator rack in a multi-rack cluster.
        :paramtype aggregator_or_single_rack_definition: ~azure.mgmt.networkcloud.models.RackDefinition
        :keyword cluster_location: The customer-provided location information to identify where the
         cluster resides.
        :paramtype cluster_location: str
        :keyword cluster_service_principal: The service principal to be used by the cluster during Arc
         Appliance installation.
        :paramtype cluster_service_principal:
         ~azure.mgmt.networkcloud.models.ServicePrincipalInformation
        :keyword command_output_settings: The settings for commands run in this cluster, such as bare
         metal machine run read only commands and data extracts.
        :paramtype command_output_settings: ~azure.mgmt.networkcloud.models.CommandOutputSettings
        :keyword compute_deployment_threshold: The validation threshold indicating the allowable
         failures of compute machines during environment validation and deployment.
        :paramtype compute_deployment_threshold: ~azure.mgmt.networkcloud.models.ValidationThreshold
        :keyword compute_rack_definitions: The list of rack definitions for the compute racks in a
         multi-rack
         cluster, or an empty list in a single-rack cluster.
        :paramtype compute_rack_definitions: list[~azure.mgmt.networkcloud.models.RackDefinition]
        :keyword runtime_protection_configuration: The settings for cluster runtime protection.
        :paramtype runtime_protection_configuration:
         ~azure.mgmt.networkcloud.models.RuntimeProtectionConfiguration
        :keyword secret_archive: The configuration for use of a key vault to store secrets for later
         retrieval by the operator.
        :paramtype secret_archive: ~azure.mgmt.networkcloud.models.ClusterSecretArchive
        :keyword update_strategy: The strategy for updating the cluster.
        :paramtype update_strategy: ~azure.mgmt.networkcloud.models.ClusterUpdateStrategy
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.aggregator_or_single_rack_definition = aggregator_or_single_rack_definition
        self.cluster_location = cluster_location
        self.cluster_service_principal = cluster_service_principal
        self.command_output_settings = command_output_settings
        self.compute_deployment_threshold = compute_deployment_threshold
        self.compute_rack_definitions = compute_rack_definitions
        self.runtime_protection_configuration = runtime_protection_configuration
        self.secret_archive = secret_archive
        self.update_strategy = update_strategy


class ClusterScanRuntimeParameters(_serialization.Model):
    """ClusterScanRuntimeParameters defines the parameters for the cluster scan runtime operation.

    :ivar scan_activity: The choice of if the scan operation should run the scan. Known values are:
     "Scan" and "Skip".
    :vartype scan_activity: str or
     ~azure.mgmt.networkcloud.models.ClusterScanRuntimeParametersScanActivity
    """

    _attribute_map = {
        "scan_activity": {"key": "scanActivity", "type": "str"},
    }

    def __init__(
        self, *, scan_activity: Union[str, "_models.ClusterScanRuntimeParametersScanActivity"] = "Scan", **kwargs: Any
    ) -> None:
        """
        :keyword scan_activity: The choice of if the scan operation should run the scan. Known values
         are: "Scan" and "Skip".
        :paramtype scan_activity: str or
         ~azure.mgmt.networkcloud.models.ClusterScanRuntimeParametersScanActivity
        """
        super().__init__(**kwargs)
        self.scan_activity = scan_activity


class ClusterSecretArchive(_serialization.Model):
    """ClusterSecretArchive configures the key vault to archive the secrets of the cluster for later
    retrieval.

    All required parameters must be populated in order to send to server.

    :ivar key_vault_id: The resource ID of the key vault to archive the secrets of the cluster.
     Required.
    :vartype key_vault_id: str
    :ivar use_key_vault: The indicator if the specified key vault should be used to archive the
     secrets of the cluster. Known values are: "True" and "False".
    :vartype use_key_vault: str or ~azure.mgmt.networkcloud.models.ClusterSecretArchiveEnabled
    """

    _validation = {
        "key_vault_id": {"required": True},
    }

    _attribute_map = {
        "key_vault_id": {"key": "keyVaultId", "type": "str"},
        "use_key_vault": {"key": "useKeyVault", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_vault_id: str,
        use_key_vault: Union[str, "_models.ClusterSecretArchiveEnabled"] = "False",
        **kwargs: Any
    ) -> None:
        """
        :keyword key_vault_id: The resource ID of the key vault to archive the secrets of the cluster.
         Required.
        :paramtype key_vault_id: str
        :keyword use_key_vault: The indicator if the specified key vault should be used to archive the
         secrets of the cluster. Known values are: "True" and "False".
        :paramtype use_key_vault: str or ~azure.mgmt.networkcloud.models.ClusterSecretArchiveEnabled
        """
        super().__init__(**kwargs)
        self.key_vault_id = key_vault_id
        self.use_key_vault = use_key_vault


class ClusterUpdateStrategy(_serialization.Model):
    """ClusterUpdateStrategy represents the strategy for updating the cluster.

    All required parameters must be populated in order to send to server.

    :ivar max_unavailable: The maximum number of worker nodes that can be offline within the
     increment of update, e.g., rack-by-rack.
     Limited by the maximum number of machines in the increment. Defaults to the whole increment
     size.
    :vartype max_unavailable: int
    :ivar strategy_type: The mode of operation for runtime protection. Required. Known values are:
     "Rack" and "PauseAfterRack".
    :vartype strategy_type: str or ~azure.mgmt.networkcloud.models.ClusterUpdateStrategyType
    :ivar threshold_type: Selection of how the threshold should be evaluated. Required. Known
     values are: "CountSuccess" and "PercentSuccess".
    :vartype threshold_type: str or ~azure.mgmt.networkcloud.models.ValidationThresholdType
    :ivar threshold_value: The numeric threshold value. Required.
    :vartype threshold_value: int
    :ivar wait_time_minutes: The time to wait between the increments of update defined by the
     strategy.
    :vartype wait_time_minutes: int
    """

    _validation = {
        "max_unavailable": {"minimum": 1},
        "strategy_type": {"required": True},
        "threshold_type": {"required": True},
        "threshold_value": {"required": True, "minimum": 0},
        "wait_time_minutes": {"maximum": 60, "minimum": 0},
    }

    _attribute_map = {
        "max_unavailable": {"key": "maxUnavailable", "type": "int"},
        "strategy_type": {"key": "strategyType", "type": "str"},
        "threshold_type": {"key": "thresholdType", "type": "str"},
        "threshold_value": {"key": "thresholdValue", "type": "int"},
        "wait_time_minutes": {"key": "waitTimeMinutes", "type": "int"},
    }

    def __init__(
        self,
        *,
        strategy_type: Union[str, "_models.ClusterUpdateStrategyType"],
        threshold_type: Union[str, "_models.ValidationThresholdType"],
        threshold_value: int,
        max_unavailable: Optional[int] = None,
        wait_time_minutes: int = 15,
        **kwargs: Any
    ) -> None:
        """
        :keyword max_unavailable: The maximum number of worker nodes that can be offline within the
         increment of update, e.g., rack-by-rack.
         Limited by the maximum number of machines in the increment. Defaults to the whole increment
         size.
        :paramtype max_unavailable: int
        :keyword strategy_type: The mode of operation for runtime protection. Required. Known values
         are: "Rack" and "PauseAfterRack".
        :paramtype strategy_type: str or ~azure.mgmt.networkcloud.models.ClusterUpdateStrategyType
        :keyword threshold_type: Selection of how the threshold should be evaluated. Required. Known
         values are: "CountSuccess" and "PercentSuccess".
        :paramtype threshold_type: str or ~azure.mgmt.networkcloud.models.ValidationThresholdType
        :keyword threshold_value: The numeric threshold value. Required.
        :paramtype threshold_value: int
        :keyword wait_time_minutes: The time to wait between the increments of update defined by the
         strategy.
        :paramtype wait_time_minutes: int
        """
        super().__init__(**kwargs)
        self.max_unavailable = max_unavailable
        self.strategy_type = strategy_type
        self.threshold_type = threshold_type
        self.threshold_value = threshold_value
        self.wait_time_minutes = wait_time_minutes


class ClusterUpdateVersionParameters(_serialization.Model):
    """ClusterUpdateVersionParameters represents the body of the request to update cluster version.

    All required parameters must be populated in order to send to server.

    :ivar target_cluster_version: The version to be applied to the cluster during update. Required.
    :vartype target_cluster_version: str
    """

    _validation = {
        "target_cluster_version": {"required": True},
    }

    _attribute_map = {
        "target_cluster_version": {"key": "targetClusterVersion", "type": "str"},
    }

    def __init__(self, *, target_cluster_version: str, **kwargs: Any) -> None:
        """
        :keyword target_cluster_version: The version to be applied to the cluster during update.
         Required.
        :paramtype target_cluster_version: str
        """
        super().__init__(**kwargs)
        self.target_cluster_version = target_cluster_version


class CommandOutputSettings(_serialization.Model):
    """CommandOutputSettings represents the settings for commands run within the cluster such as bare
    metal machine run read-only commands.

    :ivar associated_identity: The selection of the managed identity to use with this storage
     account container. The identity type must be either system assigned or user assigned.
    :vartype associated_identity: ~azure.mgmt.networkcloud.models.IdentitySelector
    :ivar container_url: The URL of the storage account container that is to be used by the
     specified identities.
    :vartype container_url: str
    """

    _attribute_map = {
        "associated_identity": {"key": "associatedIdentity", "type": "IdentitySelector"},
        "container_url": {"key": "containerUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        associated_identity: Optional["_models.IdentitySelector"] = None,
        container_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword associated_identity: The selection of the managed identity to use with this storage
         account container. The identity type must be either system assigned or user assigned.
        :paramtype associated_identity: ~azure.mgmt.networkcloud.models.IdentitySelector
        :keyword container_url: The URL of the storage account container that is to be used by the
         specified identities.
        :paramtype container_url: str
        """
        super().__init__(**kwargs)
        self.associated_identity = associated_identity
        self.container_url = container_url


class Console(TrackedResource):
    """Console represents the console of an on-premises Network Cloud virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location of the cluster manager associated with the
     cluster this virtual machine is created on. Required.
    :vartype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar detailed_status: The more detailed status of the console. Known values are: "Ready" and
     "Error".
    :vartype detailed_status: str or ~azure.mgmt.networkcloud.models.ConsoleDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar enabled: The indicator of whether the console access is enabled. Required. Known values
     are: "True" and "False".
    :vartype enabled: str or ~azure.mgmt.networkcloud.models.ConsoleEnabled
    :ivar expiration: The date and time after which the key will be disallowed access.
    :vartype expiration: ~datetime.datetime
    :ivar private_link_service_id: The resource ID of the private link service that is used to
     provide virtual machine console access.
    :vartype private_link_service_id: str
    :ivar provisioning_state: The provisioning state of the virtual machine console. Known values
     are: "Succeeded", "Failed", "Canceled", "Provisioning", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.networkcloud.models.ConsoleProvisioningState
    :ivar ssh_public_key: The SSH public key that will be provisioned for user access. The user is
     expected to have the corresponding SSH private key for logging in. Required.
    :vartype ssh_public_key: ~azure.mgmt.networkcloud.models.SshPublicKey
    :ivar virtual_machine_access_id: The unique identifier for the virtual machine that is used to
     access the console.
    :vartype virtual_machine_access_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "extended_location": {"required": True},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "enabled": {"required": True},
        "private_link_service_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "ssh_public_key": {"required": True},
        "virtual_machine_access_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "str"},
        "expiration": {"key": "properties.expiration", "type": "iso-8601"},
        "private_link_service_id": {"key": "properties.privateLinkServiceId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "ssh_public_key": {"key": "properties.sshPublicKey", "type": "SshPublicKey"},
        "virtual_machine_access_id": {"key": "properties.virtualMachineAccessId", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        enabled: Union[str, "_models.ConsoleEnabled"],
        ssh_public_key: "_models.SshPublicKey",
        tags: Optional[Dict[str, str]] = None,
        expiration: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location of the cluster manager associated with the
         cluster this virtual machine is created on. Required.
        :paramtype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
        :keyword enabled: The indicator of whether the console access is enabled. Required. Known
         values are: "True" and "False".
        :paramtype enabled: str or ~azure.mgmt.networkcloud.models.ConsoleEnabled
        :keyword expiration: The date and time after which the key will be disallowed access.
        :paramtype expiration: ~datetime.datetime
        :keyword ssh_public_key: The SSH public key that will be provisioned for user access. The user
         is expected to have the corresponding SSH private key for logging in. Required.
        :paramtype ssh_public_key: ~azure.mgmt.networkcloud.models.SshPublicKey
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.detailed_status = None
        self.detailed_status_message = None
        self.enabled = enabled
        self.expiration = expiration
        self.private_link_service_id = None
        self.provisioning_state = None
        self.ssh_public_key = ssh_public_key
        self.virtual_machine_access_id = None


class ConsoleList(_serialization.Model):
    """ConsoleList represents a list of virtual machine consoles.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of virtual machine consoles.
    :vartype value: list[~azure.mgmt.networkcloud.models.Console]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Console]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.Console"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of virtual machine consoles.
        :paramtype value: list[~azure.mgmt.networkcloud.models.Console]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ConsolePatchParameters(_serialization.Model):
    """ConsolePatchParameters represents the body of the request to patch the virtual machine console.

    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    :ivar enabled: The indicator of whether the console access is enabled. Known values are: "True"
     and "False".
    :vartype enabled: str or ~azure.mgmt.networkcloud.models.ConsoleEnabled
    :ivar expiration: The date and time after which the key will be disallowed access.
    :vartype expiration: ~datetime.datetime
    :ivar ssh_public_key: The SSH public key that will be provisioned for user access. The user is
     expected to have the corresponding SSH private key for logging in.
    :vartype ssh_public_key: ~azure.mgmt.networkcloud.models.SshPublicKey
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "enabled": {"key": "properties.enabled", "type": "str"},
        "expiration": {"key": "properties.expiration", "type": "iso-8601"},
        "ssh_public_key": {"key": "properties.sshPublicKey", "type": "SshPublicKey"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        enabled: Optional[Union[str, "_models.ConsoleEnabled"]] = None,
        expiration: Optional[datetime.datetime] = None,
        ssh_public_key: Optional["_models.SshPublicKey"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        :keyword enabled: The indicator of whether the console access is enabled. Known values are:
         "True" and "False".
        :paramtype enabled: str or ~azure.mgmt.networkcloud.models.ConsoleEnabled
        :keyword expiration: The date and time after which the key will be disallowed access.
        :paramtype expiration: ~datetime.datetime
        :keyword ssh_public_key: The SSH public key that will be provisioned for user access. The user
         is expected to have the corresponding SSH private key for logging in.
        :paramtype ssh_public_key: ~azure.mgmt.networkcloud.models.SshPublicKey
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.enabled = enabled
        self.expiration = expiration
        self.ssh_public_key = ssh_public_key


class ControlPlaneNodeConfiguration(_serialization.Model):
    """ControlPlaneNodeConfiguration represents the selection of virtual machines and size of the
    control plane for a Kubernetes cluster.

    All required parameters must be populated in order to send to server.

    :ivar administrator_configuration: The administrator credentials to be used for the nodes in
     the control plane.
    :vartype administrator_configuration:
     ~azure.mgmt.networkcloud.models.AdministratorConfiguration
    :ivar availability_zones: The list of availability zones of the Network Cloud cluster to be
     used for the provisioning of nodes in the control plane. If not specified, all availability
     zones will be used.
    :vartype availability_zones: list[str]
    :ivar count: The number of virtual machines that use this configuration. Required.
    :vartype count: int
    :ivar vm_sku_name: The name of the VM SKU supplied during creation. Required.
    :vartype vm_sku_name: str
    """

    _validation = {
        "count": {"required": True, "minimum": 1},
        "vm_sku_name": {"required": True},
    }

    _attribute_map = {
        "administrator_configuration": {"key": "administratorConfiguration", "type": "AdministratorConfiguration"},
        "availability_zones": {"key": "availabilityZones", "type": "[str]"},
        "count": {"key": "count", "type": "int"},
        "vm_sku_name": {"key": "vmSkuName", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: int,
        vm_sku_name: str,
        administrator_configuration: Optional["_models.AdministratorConfiguration"] = None,
        availability_zones: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword administrator_configuration: The administrator credentials to be used for the nodes in
         the control plane.
        :paramtype administrator_configuration:
         ~azure.mgmt.networkcloud.models.AdministratorConfiguration
        :keyword availability_zones: The list of availability zones of the Network Cloud cluster to be
         used for the provisioning of nodes in the control plane. If not specified, all availability
         zones will be used.
        :paramtype availability_zones: list[str]
        :keyword count: The number of virtual machines that use this configuration. Required.
        :paramtype count: int
        :keyword vm_sku_name: The name of the VM SKU supplied during creation. Required.
        :paramtype vm_sku_name: str
        """
        super().__init__(**kwargs)
        self.administrator_configuration = administrator_configuration
        self.availability_zones = availability_zones
        self.count = count
        self.vm_sku_name = vm_sku_name


class ControlPlaneNodePatchConfiguration(_serialization.Model):
    """ControlPlaneNodePatchConfiguration represents the properties of the control plane that can be
    patched for this Kubernetes cluster.

    :ivar administrator_configuration: The configuration of administrator credentials for the
     control plane nodes.
    :vartype administrator_configuration:
     ~azure.mgmt.networkcloud.models.AdministratorConfigurationPatch
    :ivar count: The number of virtual machines that use this configuration.
    :vartype count: int
    """

    _validation = {
        "count": {"minimum": 1},
    }

    _attribute_map = {
        "administrator_configuration": {"key": "administratorConfiguration", "type": "AdministratorConfigurationPatch"},
        "count": {"key": "count", "type": "int"},
    }

    def __init__(
        self,
        *,
        administrator_configuration: Optional["_models.AdministratorConfigurationPatch"] = None,
        count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword administrator_configuration: The configuration of administrator credentials for the
         control plane nodes.
        :paramtype administrator_configuration:
         ~azure.mgmt.networkcloud.models.AdministratorConfigurationPatch
        :keyword count: The number of virtual machines that use this configuration.
        :paramtype count: int
        """
        super().__init__(**kwargs)
        self.administrator_configuration = administrator_configuration
        self.count = count


class EgressEndpoint(_serialization.Model):
    """EgressEndpoint represents the connection from a cloud services network to the specified
    endpoint for a common purpose.

    All required parameters must be populated in order to send to server.

    :ivar category: The descriptive category name of endpoints accessible by the AKS agent node.
     For example, azure-resource-management, API server, etc. The platform egress endpoints provided
     by default will use the category 'default'. Required.
    :vartype category: str
    :ivar endpoints: The list of endpoint dependencies. Required.
    :vartype endpoints: list[~azure.mgmt.networkcloud.models.EndpointDependency]
    """

    _validation = {
        "category": {"required": True},
        "endpoints": {"required": True, "min_items": 1},
    }

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "endpoints": {"key": "endpoints", "type": "[EndpointDependency]"},
    }

    def __init__(self, *, category: str, endpoints: List["_models.EndpointDependency"], **kwargs: Any) -> None:
        """
        :keyword category: The descriptive category name of endpoints accessible by the AKS agent node.
         For example, azure-resource-management, API server, etc. The platform egress endpoints provided
         by default will use the category 'default'. Required.
        :paramtype category: str
        :keyword endpoints: The list of endpoint dependencies. Required.
        :paramtype endpoints: list[~azure.mgmt.networkcloud.models.EndpointDependency]
        """
        super().__init__(**kwargs)
        self.category = category
        self.endpoints = endpoints


class EndpointDependency(_serialization.Model):
    """EndpointDependency represents the definition of an endpoint, including the domain and details.

    All required parameters must be populated in order to send to server.

    :ivar domain_name: The domain name of the dependency. Required.
    :vartype domain_name: str
    :ivar port: The port of this endpoint.
    :vartype port: int
    """

    _validation = {
        "domain_name": {"required": True},
        "port": {"maximum": 65535, "minimum": 1},
    }

    _attribute_map = {
        "domain_name": {"key": "domainName", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(self, *, domain_name: str, port: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword domain_name: The domain name of the dependency. Required.
        :paramtype domain_name: str
        :keyword port: The port of this endpoint.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.domain_name = domain_name
        self.port = port


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.networkcloud.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.networkcloud.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.networkcloud.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.networkcloud.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExtendedLocation(_serialization.Model):
    """ExtendedLocation represents the Azure custom location where the resource will be created.

    All required parameters must be populated in order to send to server.

    :ivar name: The resource ID of the extended location on which the resource will be created.
     Required.
    :vartype name: str
    :ivar type: The extended location type, for example, CustomLocation. Required.
    :vartype type: str
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: str, type: str, **kwargs: Any) -> None:
        """
        :keyword name: The resource ID of the extended location on which the resource will be created.
         Required.
        :paramtype name: str
        :keyword type: The extended location type, for example, CustomLocation. Required.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class FeatureStatus(_serialization.Model):
    """FeatureStatus contains information regarding a Kubernetes cluster feature.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar detailed_status: The status representing the state of this feature. Known values are:
     "Running", "Failed", and "Unknown".
    :vartype detailed_status: str or ~azure.mgmt.networkcloud.models.FeatureDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar name: The name of the feature.
    :vartype name: str
    :ivar version: The version of the feature.
    :vartype version: str
    """

    _validation = {
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "name": {"readonly": True},
        "version": {"readonly": True},
    }

    _attribute_map = {
        "detailed_status": {"key": "detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "detailedStatusMessage", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.detailed_status = None
        self.detailed_status_message = None
        self.name = None
        self.version = None


class HardwareInventory(_serialization.Model):
    """HardwareInventory represents the hardware configuration of this machine as exposed to the
    customer, including information acquired from the model/sku information and from the ironic
    inspector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_host_information: Freeform data extracted from the environment about this
     machine. This information varies depending on the specific hardware and configuration.
    :vartype additional_host_information: str
    :ivar interfaces: The list of network interfaces and associated details for the bare metal
     machine.
    :vartype interfaces: list[~azure.mgmt.networkcloud.models.HardwareInventoryNetworkInterface]
    :ivar nics: Field Deprecated. Will be removed in an upcoming version. The list of network
     interface cards and associated details for the bare metal machine.
    :vartype nics: list[~azure.mgmt.networkcloud.models.Nic]
    """

    _validation = {
        "additional_host_information": {"readonly": True},
        "interfaces": {"readonly": True},
        "nics": {"readonly": True},
    }

    _attribute_map = {
        "additional_host_information": {"key": "additionalHostInformation", "type": "str"},
        "interfaces": {"key": "interfaces", "type": "[HardwareInventoryNetworkInterface]"},
        "nics": {"key": "nics", "type": "[Nic]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.additional_host_information = None
        self.interfaces = None
        self.nics = None


class HardwareInventoryNetworkInterface(_serialization.Model):
    """HardwareInventoryNetworkInterface represents the network interface details as part of a
    hardware inventory.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar link_status: The current status of the link.
    :vartype link_status: str
    :ivar mac_address: The MAC address associated with this interface.
    :vartype mac_address: str
    :ivar name: The name of the interface.
    :vartype name: str
    :ivar network_interface_id: The resource ID of the network interface for the port on the switch
     that this machine's interface is connected to.
    :vartype network_interface_id: str
    """

    _validation = {
        "link_status": {"readonly": True},
        "mac_address": {"readonly": True},
        "name": {"readonly": True},
        "network_interface_id": {"readonly": True},
    }

    _attribute_map = {
        "link_status": {"key": "linkStatus", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "network_interface_id": {"key": "networkInterfaceId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.link_status = None
        self.mac_address = None
        self.name = None
        self.network_interface_id = None


class HardwareValidationStatus(_serialization.Model):
    """HardwareValidationStatus represents the latest hardware validation details performed for this
    bare metal machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar last_validation_time: The timestamp of the hardware validation execution.
    :vartype last_validation_time: ~datetime.datetime
    :ivar result: The outcome of the hardware validation. Known values are: "Pass", "Fail", and
     "Pass".
    :vartype result: str or
     ~azure.mgmt.networkcloud.models.BareMetalMachineHardwareValidationResult
    """

    _validation = {
        "last_validation_time": {"readonly": True},
        "result": {"readonly": True},
    }

    _attribute_map = {
        "last_validation_time": {"key": "lastValidationTime", "type": "iso-8601"},
        "result": {"key": "result", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.last_validation_time = None
        self.result = None


class IdentitySelector(_serialization.Model):
    """IdentitySelector represents the selection of a managed identity for use.

    :ivar identity_type: The type of managed identity that is being selected. Known values are:
     "SystemAssignedIdentity" and "UserAssignedIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.networkcloud.models.ManagedServiceIdentitySelectorType
    :ivar user_assigned_identity_resource_id: The user assigned managed identity resource ID to
     use. Mutually exclusive with a system assigned identity type.
    :vartype user_assigned_identity_resource_id: str
    """

    _attribute_map = {
        "identity_type": {"key": "identityType", "type": "str"},
        "user_assigned_identity_resource_id": {"key": "userAssignedIdentityResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity_type: Optional[Union[str, "_models.ManagedServiceIdentitySelectorType"]] = None,
        user_assigned_identity_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity_type: The type of managed identity that is being selected. Known values are:
         "SystemAssignedIdentity" and "UserAssignedIdentity".
        :paramtype identity_type: str or
         ~azure.mgmt.networkcloud.models.ManagedServiceIdentitySelectorType
        :keyword user_assigned_identity_resource_id: The user assigned managed identity resource ID to
         use. Mutually exclusive with a system assigned identity type.
        :paramtype user_assigned_identity_resource_id: str
        """
        super().__init__(**kwargs)
        self.identity_type = identity_type
        self.user_assigned_identity_resource_id = user_assigned_identity_resource_id


class ImageRepositoryCredentials(_serialization.Model):
    """ImageRepositoryCredentials represents the credentials used to login to the image repository.

    All required parameters must be populated in order to send to server.

    :ivar password: The password or token used to access an image in the target repository.
     Required.
    :vartype password: str
    :ivar registry_url: The URL of the authentication server used to validate the repository
     credentials. Required.
    :vartype registry_url: str
    :ivar username: The username used to access an image in the target repository. Required.
    :vartype username: str
    """

    _validation = {
        "password": {"required": True, "min_length": 1},
        "registry_url": {"required": True},
        "username": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "password": {"key": "password", "type": "str"},
        "registry_url": {"key": "registryUrl", "type": "str"},
        "username": {"key": "username", "type": "str"},
    }

    def __init__(self, *, password: str, registry_url: str, username: str, **kwargs: Any) -> None:
        """
        :keyword password: The password or token used to access an image in the target repository.
         Required.
        :paramtype password: str
        :keyword registry_url: The URL of the authentication server used to validate the repository
         credentials. Required.
        :paramtype registry_url: str
        :keyword username: The username used to access an image in the target repository. Required.
        :paramtype username: str
        """
        super().__init__(**kwargs)
        self.password = password
        self.registry_url = registry_url
        self.username = username


class InitialAgentPoolConfiguration(_serialization.Model):
    """InitialAgentPoolConfiguration specifies the configuration of a pool of virtual machines that
    are initially defined with a Kubernetes cluster.

    All required parameters must be populated in order to send to server.

    :ivar administrator_configuration: The administrator credentials to be used for the nodes in
     this agent pool.
    :vartype administrator_configuration:
     ~azure.mgmt.networkcloud.models.AdministratorConfiguration
    :ivar agent_options: The configurations that will be applied to each agent in this agent pool.
    :vartype agent_options: ~azure.mgmt.networkcloud.models.AgentOptions
    :ivar attached_network_configuration: The configuration of networks being attached to the agent
     pool for use by the workloads that run on this Kubernetes cluster.
    :vartype attached_network_configuration:
     ~azure.mgmt.networkcloud.models.AttachedNetworkConfiguration
    :ivar availability_zones: The list of availability zones of the Network Cloud cluster used for
     the provisioning of nodes in this agent pool. If not specified, all availability zones will be
     used.
    :vartype availability_zones: list[str]
    :ivar count: The number of virtual machines that use this configuration. Required.
    :vartype count: int
    :ivar labels: The labels applied to the nodes in this agent pool.
    :vartype labels: list[~azure.mgmt.networkcloud.models.KubernetesLabel]
    :ivar mode: The selection of how this agent pool is utilized, either as a system pool or a user
     pool. System pools run the features and critical services for the Kubernetes Cluster, while
     user pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one
     system node pool with at least one node. Required. Known values are: "System", "User", and
     "NotApplicable".
    :vartype mode: str or ~azure.mgmt.networkcloud.models.AgentPoolMode
    :ivar name: The name that will be used for the agent pool resource representing this agent
     pool. Required.
    :vartype name: str
    :ivar taints: The taints applied to the nodes in this agent pool.
    :vartype taints: list[~azure.mgmt.networkcloud.models.KubernetesLabel]
    :ivar upgrade_settings: The configuration of the agent pool.
    :vartype upgrade_settings: ~azure.mgmt.networkcloud.models.AgentPoolUpgradeSettings
    :ivar vm_sku_name: The name of the VM SKU that determines the size of resources allocated for
     node VMs. Required.
    :vartype vm_sku_name: str
    """

    _validation = {
        "count": {"required": True},
        "mode": {"required": True},
        "name": {"required": True, "pattern": r"^([a-zA-Z0-9][a-zA-Z0-9-_]{0,28}[a-zA-Z0-9])$"},
        "vm_sku_name": {"required": True},
    }

    _attribute_map = {
        "administrator_configuration": {"key": "administratorConfiguration", "type": "AdministratorConfiguration"},
        "agent_options": {"key": "agentOptions", "type": "AgentOptions"},
        "attached_network_configuration": {
            "key": "attachedNetworkConfiguration",
            "type": "AttachedNetworkConfiguration",
        },
        "availability_zones": {"key": "availabilityZones", "type": "[str]"},
        "count": {"key": "count", "type": "int"},
        "labels": {"key": "labels", "type": "[KubernetesLabel]"},
        "mode": {"key": "mode", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "taints": {"key": "taints", "type": "[KubernetesLabel]"},
        "upgrade_settings": {"key": "upgradeSettings", "type": "AgentPoolUpgradeSettings"},
        "vm_sku_name": {"key": "vmSkuName", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: int,
        mode: Union[str, "_models.AgentPoolMode"],
        name: str,
        vm_sku_name: str,
        administrator_configuration: Optional["_models.AdministratorConfiguration"] = None,
        agent_options: Optional["_models.AgentOptions"] = None,
        attached_network_configuration: Optional["_models.AttachedNetworkConfiguration"] = None,
        availability_zones: Optional[List[str]] = None,
        labels: Optional[List["_models.KubernetesLabel"]] = None,
        taints: Optional[List["_models.KubernetesLabel"]] = None,
        upgrade_settings: Optional["_models.AgentPoolUpgradeSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword administrator_configuration: The administrator credentials to be used for the nodes in
         this agent pool.
        :paramtype administrator_configuration:
         ~azure.mgmt.networkcloud.models.AdministratorConfiguration
        :keyword agent_options: The configurations that will be applied to each agent in this agent
         pool.
        :paramtype agent_options: ~azure.mgmt.networkcloud.models.AgentOptions
        :keyword attached_network_configuration: The configuration of networks being attached to the
         agent pool for use by the workloads that run on this Kubernetes cluster.
        :paramtype attached_network_configuration:
         ~azure.mgmt.networkcloud.models.AttachedNetworkConfiguration
        :keyword availability_zones: The list of availability zones of the Network Cloud cluster used
         for the provisioning of nodes in this agent pool. If not specified, all availability zones will
         be used.
        :paramtype availability_zones: list[str]
        :keyword count: The number of virtual machines that use this configuration. Required.
        :paramtype count: int
        :keyword labels: The labels applied to the nodes in this agent pool.
        :paramtype labels: list[~azure.mgmt.networkcloud.models.KubernetesLabel]
        :keyword mode: The selection of how this agent pool is utilized, either as a system pool or a
         user pool. System pools run the features and critical services for the Kubernetes Cluster,
         while user pools are dedicated to user workloads. Every Kubernetes cluster must contain at
         least one system node pool with at least one node. Required. Known values are: "System",
         "User", and "NotApplicable".
        :paramtype mode: str or ~azure.mgmt.networkcloud.models.AgentPoolMode
        :keyword name: The name that will be used for the agent pool resource representing this agent
         pool. Required.
        :paramtype name: str
        :keyword taints: The taints applied to the nodes in this agent pool.
        :paramtype taints: list[~azure.mgmt.networkcloud.models.KubernetesLabel]
        :keyword upgrade_settings: The configuration of the agent pool.
        :paramtype upgrade_settings: ~azure.mgmt.networkcloud.models.AgentPoolUpgradeSettings
        :keyword vm_sku_name: The name of the VM SKU that determines the size of resources allocated
         for node VMs. Required.
        :paramtype vm_sku_name: str
        """
        super().__init__(**kwargs)
        self.administrator_configuration = administrator_configuration
        self.agent_options = agent_options
        self.attached_network_configuration = attached_network_configuration
        self.availability_zones = availability_zones
        self.count = count
        self.labels = labels
        self.mode = mode
        self.name = name
        self.taints = taints
        self.upgrade_settings = upgrade_settings
        self.vm_sku_name = vm_sku_name


class IpAddressPool(_serialization.Model):
    """IpAddressPool represents a pool of IP addresses that can be allocated to a service.

    All required parameters must be populated in order to send to server.

    :ivar addresses: The list of IP address ranges. Each range can be a either a subnet in CIDR
     format or an explicit start-end range of IP addresses. For a BGP service load balancer
     configuration, only CIDR format is supported and excludes /32 (IPv4) and /128 (IPv6) prefixes.
     Required.
    :vartype addresses: list[str]
    :ivar auto_assign: The indicator to determine if automatic allocation from the pool should
     occur. Known values are: "True" and "False".
    :vartype auto_assign: str or ~azure.mgmt.networkcloud.models.BfdEnabled
    :ivar name: The name used to identify this IP address pool for association with a BGP
     advertisement. Required.
    :vartype name: str
    :ivar only_use_host_ips: The indicator to prevent the use of IP addresses ending with .0 and
     .255 for this pool. Enabling this option will only use IP addresses between .1 and .254
     inclusive. Known values are: "True" and "False".
    :vartype only_use_host_ips: str or ~azure.mgmt.networkcloud.models.BfdEnabled
    """

    _validation = {
        "addresses": {"required": True},
        "name": {"required": True, "pattern": r"^[a-z0-9]([a-z0-9.-]{0,61}[a-z0-9]){0,1}$"},
    }

    _attribute_map = {
        "addresses": {"key": "addresses", "type": "[str]"},
        "auto_assign": {"key": "autoAssign", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "only_use_host_ips": {"key": "onlyUseHostIps", "type": "str"},
    }

    def __init__(
        self,
        *,
        addresses: List[str],
        name: str,
        auto_assign: Optional[Union[str, "_models.BfdEnabled"]] = None,
        only_use_host_ips: Optional[Union[str, "_models.BfdEnabled"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword addresses: The list of IP address ranges. Each range can be a either a subnet in CIDR
         format or an explicit start-end range of IP addresses. For a BGP service load balancer
         configuration, only CIDR format is supported and excludes /32 (IPv4) and /128 (IPv6) prefixes.
         Required.
        :paramtype addresses: list[str]
        :keyword auto_assign: The indicator to determine if automatic allocation from the pool should
         occur. Known values are: "True" and "False".
        :paramtype auto_assign: str or ~azure.mgmt.networkcloud.models.BfdEnabled
        :keyword name: The name used to identify this IP address pool for association with a BGP
         advertisement. Required.
        :paramtype name: str
        :keyword only_use_host_ips: The indicator to prevent the use of IP addresses ending with .0 and
         .255 for this pool. Enabling this option will only use IP addresses between .1 and .254
         inclusive. Known values are: "True" and "False".
        :paramtype only_use_host_ips: str or ~azure.mgmt.networkcloud.models.BfdEnabled
        """
        super().__init__(**kwargs)
        self.addresses = addresses
        self.auto_assign = auto_assign
        self.name = name
        self.only_use_host_ips = only_use_host_ips


class KeySetUser(_serialization.Model):
    """KeySetUser represents the properties of the user in the key set.

    All required parameters must be populated in order to send to server.

    :ivar azure_user_name: The user name that will be used for access. Required.
    :vartype azure_user_name: str
    :ivar description: The free-form description for this user.
    :vartype description: str
    :ivar ssh_public_key: The SSH public key that will be provisioned for user access. The user is
     expected to have the corresponding SSH private key for logging in. Required.
    :vartype ssh_public_key: ~azure.mgmt.networkcloud.models.SshPublicKey
    :ivar user_principal_name: The user principal name (email format) used to validate this user's
     group membership.
    :vartype user_principal_name: str
    """

    _validation = {
        "azure_user_name": {"required": True},
        "description": {"max_length": 256},
        "ssh_public_key": {"required": True},
    }

    _attribute_map = {
        "azure_user_name": {"key": "azureUserName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "ssh_public_key": {"key": "sshPublicKey", "type": "SshPublicKey"},
        "user_principal_name": {"key": "userPrincipalName", "type": "str"},
    }

    def __init__(
        self,
        *,
        azure_user_name: str,
        ssh_public_key: "_models.SshPublicKey",
        description: Optional[str] = None,
        user_principal_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword azure_user_name: The user name that will be used for access. Required.
        :paramtype azure_user_name: str
        :keyword description: The free-form description for this user.
        :paramtype description: str
        :keyword ssh_public_key: The SSH public key that will be provisioned for user access. The user
         is expected to have the corresponding SSH private key for logging in. Required.
        :paramtype ssh_public_key: ~azure.mgmt.networkcloud.models.SshPublicKey
        :keyword user_principal_name: The user principal name (email format) used to validate this
         user's group membership.
        :paramtype user_principal_name: str
        """
        super().__init__(**kwargs)
        self.azure_user_name = azure_user_name
        self.description = description
        self.ssh_public_key = ssh_public_key
        self.user_principal_name = user_principal_name


class KeySetUserStatus(_serialization.Model):
    """KeySetUserStatus represents the status of the key set user.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar azure_user_name: The user name that will be used for access.
    :vartype azure_user_name: str
    :ivar status: The indicator of whether the user is currently deployed for access. Known values
     are: "Active" and "Invalid".
    :vartype status: str or ~azure.mgmt.networkcloud.models.BareMetalMachineKeySetUserSetupStatus
    :ivar status_message: The additional information describing the current status of this user, if
     any available.
    :vartype status_message: str
    """

    _validation = {
        "azure_user_name": {"readonly": True},
        "status": {"readonly": True},
        "status_message": {"readonly": True, "max_length": 256},
    }

    _attribute_map = {
        "azure_user_name": {"key": "azureUserName", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "status_message": {"key": "statusMessage", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.azure_user_name = None
        self.status = None
        self.status_message = None


class KubernetesCluster(TrackedResource):
    """KubernetesCluster represents the Kubernetes cluster hosted on Network Cloud.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location of the cluster associated with the resource.
     Required.
    :vartype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar aad_configuration: The Azure Active Directory Integration properties.
    :vartype aad_configuration: ~azure.mgmt.networkcloud.models.AadConfiguration
    :ivar administrator_configuration: The administrative credentials that will be applied to the
     control plane and agent pool nodes that do not specify their own values.
    :vartype administrator_configuration:
     ~azure.mgmt.networkcloud.models.AdministratorConfiguration
    :ivar attached_network_ids: The full list of network resource IDs that are attached to this
     cluster, including those attached only to specific agent pools.
    :vartype attached_network_ids: list[str]
    :ivar available_upgrades: The list of versions that this Kubernetes cluster can be upgraded to.
    :vartype available_upgrades: list[~azure.mgmt.networkcloud.models.AvailableUpgrade]
    :ivar cluster_id: The resource ID of the Network Cloud cluster.
    :vartype cluster_id: str
    :ivar connected_cluster_id: The resource ID of the connected cluster set up when this
     Kubernetes cluster is created.
    :vartype connected_cluster_id: str
    :ivar control_plane_kubernetes_version: The current running version of Kubernetes on the
     control plane.
    :vartype control_plane_kubernetes_version: str
    :ivar control_plane_node_configuration: The defining characteristics of the control plane for
     this Kubernetes Cluster. Required.
    :vartype control_plane_node_configuration:
     ~azure.mgmt.networkcloud.models.ControlPlaneNodeConfiguration
    :ivar detailed_status: The current status of the Kubernetes cluster. Known values are:
     "Available", "Error", and "Provisioning".
    :vartype detailed_status: str or
     ~azure.mgmt.networkcloud.models.KubernetesClusterDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar feature_statuses: The current feature settings.
    :vartype feature_statuses: list[~azure.mgmt.networkcloud.models.FeatureStatus]
    :ivar initial_agent_pool_configurations: The agent pools that are created with this Kubernetes
     cluster for running critical system services and workloads. This data in this field is only
     used during creation, and the field will be empty following the creation of the Kubernetes
     Cluster. After creation, the management of agent pools is done using the agentPools
     sub-resource. Required.
    :vartype initial_agent_pool_configurations:
     list[~azure.mgmt.networkcloud.models.InitialAgentPoolConfiguration]
    :ivar kubernetes_version: The Kubernetes version for this cluster. Required.
    :vartype kubernetes_version: str
    :ivar managed_resource_group_configuration: The configuration of the managed resource group
     associated with the resource.
    :vartype managed_resource_group_configuration:
     ~azure.mgmt.networkcloud.models.ManagedResourceGroupConfiguration
    :ivar network_configuration: The configuration of the Kubernetes cluster networking, including
     the attachment of networks that span the cluster. Required.
    :vartype network_configuration: ~azure.mgmt.networkcloud.models.NetworkConfiguration
    :ivar nodes: The details of the nodes in this cluster.
    :vartype nodes: list[~azure.mgmt.networkcloud.models.KubernetesClusterNode]
    :ivar provisioning_state: The provisioning state of the Kubernetes cluster resource. Known
     values are: "Succeeded", "Failed", "Canceled", "Accepted", "InProgress", "Created", "Updating",
     and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.networkcloud.models.KubernetesClusterProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "extended_location": {"required": True},
        "attached_network_ids": {"readonly": True},
        "available_upgrades": {"readonly": True},
        "cluster_id": {"readonly": True},
        "connected_cluster_id": {"readonly": True},
        "control_plane_kubernetes_version": {"readonly": True},
        "control_plane_node_configuration": {"required": True},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "feature_statuses": {"readonly": True},
        "initial_agent_pool_configurations": {"required": True, "min_items": 1},
        "kubernetes_version": {"required": True},
        "network_configuration": {"required": True},
        "nodes": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "aad_configuration": {"key": "properties.aadConfiguration", "type": "AadConfiguration"},
        "administrator_configuration": {
            "key": "properties.administratorConfiguration",
            "type": "AdministratorConfiguration",
        },
        "attached_network_ids": {"key": "properties.attachedNetworkIds", "type": "[str]"},
        "available_upgrades": {"key": "properties.availableUpgrades", "type": "[AvailableUpgrade]"},
        "cluster_id": {"key": "properties.clusterId", "type": "str"},
        "connected_cluster_id": {"key": "properties.connectedClusterId", "type": "str"},
        "control_plane_kubernetes_version": {"key": "properties.controlPlaneKubernetesVersion", "type": "str"},
        "control_plane_node_configuration": {
            "key": "properties.controlPlaneNodeConfiguration",
            "type": "ControlPlaneNodeConfiguration",
        },
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "feature_statuses": {"key": "properties.featureStatuses", "type": "[FeatureStatus]"},
        "initial_agent_pool_configurations": {
            "key": "properties.initialAgentPoolConfigurations",
            "type": "[InitialAgentPoolConfiguration]",
        },
        "kubernetes_version": {"key": "properties.kubernetesVersion", "type": "str"},
        "managed_resource_group_configuration": {
            "key": "properties.managedResourceGroupConfiguration",
            "type": "ManagedResourceGroupConfiguration",
        },
        "network_configuration": {"key": "properties.networkConfiguration", "type": "NetworkConfiguration"},
        "nodes": {"key": "properties.nodes", "type": "[KubernetesClusterNode]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        control_plane_node_configuration: "_models.ControlPlaneNodeConfiguration",
        initial_agent_pool_configurations: List["_models.InitialAgentPoolConfiguration"],
        kubernetes_version: str,
        network_configuration: "_models.NetworkConfiguration",
        tags: Optional[Dict[str, str]] = None,
        aad_configuration: Optional["_models.AadConfiguration"] = None,
        administrator_configuration: Optional["_models.AdministratorConfiguration"] = None,
        managed_resource_group_configuration: Optional["_models.ManagedResourceGroupConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location of the cluster associated with the resource.
         Required.
        :paramtype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
        :keyword aad_configuration: The Azure Active Directory Integration properties.
        :paramtype aad_configuration: ~azure.mgmt.networkcloud.models.AadConfiguration
        :keyword administrator_configuration: The administrative credentials that will be applied to
         the control plane and agent pool nodes that do not specify their own values.
        :paramtype administrator_configuration:
         ~azure.mgmt.networkcloud.models.AdministratorConfiguration
        :keyword control_plane_node_configuration: The defining characteristics of the control plane
         for this Kubernetes Cluster. Required.
        :paramtype control_plane_node_configuration:
         ~azure.mgmt.networkcloud.models.ControlPlaneNodeConfiguration
        :keyword initial_agent_pool_configurations: The agent pools that are created with this
         Kubernetes cluster for running critical system services and workloads. This data in this field
         is only used during creation, and the field will be empty following the creation of the
         Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools
         sub-resource. Required.
        :paramtype initial_agent_pool_configurations:
         list[~azure.mgmt.networkcloud.models.InitialAgentPoolConfiguration]
        :keyword kubernetes_version: The Kubernetes version for this cluster. Required.
        :paramtype kubernetes_version: str
        :keyword managed_resource_group_configuration: The configuration of the managed resource group
         associated with the resource.
        :paramtype managed_resource_group_configuration:
         ~azure.mgmt.networkcloud.models.ManagedResourceGroupConfiguration
        :keyword network_configuration: The configuration of the Kubernetes cluster networking,
         including the attachment of networks that span the cluster. Required.
        :paramtype network_configuration: ~azure.mgmt.networkcloud.models.NetworkConfiguration
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.aad_configuration = aad_configuration
        self.administrator_configuration = administrator_configuration
        self.attached_network_ids = None
        self.available_upgrades = None
        self.cluster_id = None
        self.connected_cluster_id = None
        self.control_plane_kubernetes_version = None
        self.control_plane_node_configuration = control_plane_node_configuration
        self.detailed_status = None
        self.detailed_status_message = None
        self.feature_statuses = None
        self.initial_agent_pool_configurations = initial_agent_pool_configurations
        self.kubernetes_version = kubernetes_version
        self.managed_resource_group_configuration = managed_resource_group_configuration
        self.network_configuration = network_configuration
        self.nodes = None
        self.provisioning_state = None


class KubernetesClusterFeature(TrackedResource):
    """KubernetesClusterFeature represents the feature of a Kubernetes cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar availability_lifecycle: The lifecycle indicator of the feature. Known values are:
     "Preview" and "GenerallyAvailable".
    :vartype availability_lifecycle: str or
     ~azure.mgmt.networkcloud.models.KubernetesClusterFeatureAvailabilityLifecycle
    :ivar detailed_status: The detailed status of the feature. Known values are: "Error",
     "Provisioning", and "Installed".
    :vartype detailed_status: str or
     ~azure.mgmt.networkcloud.models.KubernetesClusterFeatureDetailedStatus
    :ivar detailed_status_message: The descriptive message for the detailed status of the feature.
    :vartype detailed_status_message: str
    :ivar options: The configured options for the feature.
    :vartype options: list[~azure.mgmt.networkcloud.models.StringKeyValuePair]
    :ivar provisioning_state: The provisioning state of the Kubernetes cluster feature. Known
     values are: "Accepted", "Canceled", "Deleting", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.networkcloud.models.KubernetesClusterFeatureProvisioningState
    :ivar required: The indicator of if the feature is required or optional. Optional features may
     be deleted by the user, while required features are managed with the kubernetes cluster
     lifecycle. Known values are: "True" and "False".
    :vartype required: str or ~azure.mgmt.networkcloud.models.KubernetesClusterFeatureRequired
    :ivar version: The version of the feature.
    :vartype version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "availability_lifecycle": {"readonly": True},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "required": {"readonly": True},
        "version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "availability_lifecycle": {"key": "properties.availabilityLifecycle", "type": "str"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "options": {"key": "properties.options", "type": "[StringKeyValuePair]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "required": {"key": "properties.required", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        options: Optional[List["_models.StringKeyValuePair"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword options: The configured options for the feature.
        :paramtype options: list[~azure.mgmt.networkcloud.models.StringKeyValuePair]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.availability_lifecycle = None
        self.detailed_status = None
        self.detailed_status_message = None
        self.options = options
        self.provisioning_state = None
        self.required = None
        self.version = None


class KubernetesClusterFeatureList(_serialization.Model):
    """KubernetesClusterFeatureList represents the list of Kubernetes cluster feature resources.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of Kubernetes cluster features.
    :vartype value: list[~azure.mgmt.networkcloud.models.KubernetesClusterFeature]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[KubernetesClusterFeature]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.KubernetesClusterFeature"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of Kubernetes cluster features.
        :paramtype value: list[~azure.mgmt.networkcloud.models.KubernetesClusterFeature]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class KubernetesClusterFeaturePatchParameters(_serialization.Model):
    """KubernetesClusterFeaturePatchParameters represents the body of the request to patch the
    Kubernetes cluster feature.

    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    :ivar options: The configured options for the feature.
    :vartype options: list[~azure.mgmt.networkcloud.models.StringKeyValuePair]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "options": {"key": "properties.options", "type": "[StringKeyValuePair]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        options: Optional[List["_models.StringKeyValuePair"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        :keyword options: The configured options for the feature.
        :paramtype options: list[~azure.mgmt.networkcloud.models.StringKeyValuePair]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.options = options


class KubernetesClusterList(_serialization.Model):
    """KubernetesClusterList represents a list of Kubernetes clusters.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of additional details related to Kubernetes clusters.
    :vartype value: list[~azure.mgmt.networkcloud.models.KubernetesCluster]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[KubernetesCluster]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.KubernetesCluster"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of additional details related to Kubernetes clusters.
        :paramtype value: list[~azure.mgmt.networkcloud.models.KubernetesCluster]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class KubernetesClusterNode(_serialization.Model):
    """KubernetesClusterNode represents the details of a node in a Kubernetes cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar agent_pool_id: The resource ID of the agent pool that this node belongs to. This value is
     not represented on control plane nodes.
    :vartype agent_pool_id: str
    :ivar availability_zone: The availability zone this node is running within.
    :vartype availability_zone: str
    :ivar bare_metal_machine_id: The resource ID of the bare metal machine that hosts this node.
    :vartype bare_metal_machine_id: str
    :ivar cpu_cores: The number of CPU cores configured for this node, derived from the VM SKU
     specified.
    :vartype cpu_cores: int
    :ivar detailed_status: The detailed state of this node. Known values are: "Available", "Error",
     "Provisioning", "Running", "Scheduling", "Stopped", "Terminating", and "Unknown".
    :vartype detailed_status: str or
     ~azure.mgmt.networkcloud.models.KubernetesClusterNodeDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar disk_size_gb: The size of the disk configured for this node. Allocations are measured in
     gibibytes.
    :vartype disk_size_gb: int
    :ivar image: The machine image used to deploy this node.
    :vartype image: str
    :ivar kubernetes_version: The currently running version of Kubernetes and bundled features
     running on this node.
    :vartype kubernetes_version: str
    :ivar labels: The list of labels on this node that have been assigned to the agent pool
     containing this node.
    :vartype labels: list[~azure.mgmt.networkcloud.models.KubernetesLabel]
    :ivar memory_size_gb: The amount of memory configured for this node, derived from the vm SKU
     specified. Allocations are measured in gibibytes.
    :vartype memory_size_gb: int
    :ivar mode: The mode of the agent pool containing this node. Not applicable for control plane
     nodes. Known values are: "System", "User", and "NotApplicable".
    :vartype mode: str or ~azure.mgmt.networkcloud.models.AgentPoolMode
    :ivar name: The name of this node, as realized in the Kubernetes cluster.
    :vartype name: str
    :ivar network_attachments: The NetworkAttachments made to this node.
    :vartype network_attachments: list[~azure.mgmt.networkcloud.models.NetworkAttachment]
    :ivar power_state: The power state of this node. Known values are: "On", "Off", and "Unknown".
    :vartype power_state: str or ~azure.mgmt.networkcloud.models.KubernetesNodePowerState
    :ivar role: The role of this node in the cluster. Known values are: "ControlPlane" and
     "Worker".
    :vartype role: str or ~azure.mgmt.networkcloud.models.KubernetesNodeRole
    :ivar taints: The list of taints that have been assigned to the agent pool containing this
     node.
    :vartype taints: list[~azure.mgmt.networkcloud.models.KubernetesLabel]
    :ivar vm_sku_name: The VM SKU name that was used to create this cluster node.
    :vartype vm_sku_name: str
    """

    _validation = {
        "agent_pool_id": {"readonly": True},
        "availability_zone": {"readonly": True},
        "bare_metal_machine_id": {"readonly": True},
        "cpu_cores": {"readonly": True},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "disk_size_gb": {"readonly": True},
        "image": {"readonly": True},
        "kubernetes_version": {"readonly": True},
        "labels": {"readonly": True},
        "memory_size_gb": {"readonly": True},
        "mode": {"readonly": True},
        "name": {"readonly": True},
        "network_attachments": {"readonly": True},
        "power_state": {"readonly": True},
        "role": {"readonly": True},
        "taints": {"readonly": True},
        "vm_sku_name": {"readonly": True},
    }

    _attribute_map = {
        "agent_pool_id": {"key": "agentPoolId", "type": "str"},
        "availability_zone": {"key": "availabilityZone", "type": "str"},
        "bare_metal_machine_id": {"key": "bareMetalMachineId", "type": "str"},
        "cpu_cores": {"key": "cpuCores", "type": "int"},
        "detailed_status": {"key": "detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "detailedStatusMessage", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "image": {"key": "image", "type": "str"},
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "labels": {"key": "labels", "type": "[KubernetesLabel]"},
        "memory_size_gb": {"key": "memorySizeGB", "type": "int"},
        "mode": {"key": "mode", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "network_attachments": {"key": "networkAttachments", "type": "[NetworkAttachment]"},
        "power_state": {"key": "powerState", "type": "str"},
        "role": {"key": "role", "type": "str"},
        "taints": {"key": "taints", "type": "[KubernetesLabel]"},
        "vm_sku_name": {"key": "vmSkuName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.agent_pool_id = None
        self.availability_zone = None
        self.bare_metal_machine_id = None
        self.cpu_cores = None
        self.detailed_status = None
        self.detailed_status_message = None
        self.disk_size_gb = None
        self.image = None
        self.kubernetes_version = None
        self.labels = None
        self.memory_size_gb = None
        self.mode = None
        self.name = None
        self.network_attachments = None
        self.power_state = None
        self.role = None
        self.taints = None
        self.vm_sku_name = None


class KubernetesClusterPatchParameters(_serialization.Model):
    """KubernetesClusterPatchParameters represents the body of the request to patch the Hybrid AKS
    cluster.

    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    :ivar administrator_configuration: The configuration of the default administrator credentials.
    :vartype administrator_configuration:
     ~azure.mgmt.networkcloud.models.AdministratorConfigurationPatch
    :ivar control_plane_node_configuration: The defining characteristics of the control plane that
     can be patched for this Kubernetes cluster.
    :vartype control_plane_node_configuration:
     ~azure.mgmt.networkcloud.models.ControlPlaneNodePatchConfiguration
    :ivar kubernetes_version: The Kubernetes version for this cluster.
    :vartype kubernetes_version: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "administrator_configuration": {
            "key": "properties.administratorConfiguration",
            "type": "AdministratorConfigurationPatch",
        },
        "control_plane_node_configuration": {
            "key": "properties.controlPlaneNodeConfiguration",
            "type": "ControlPlaneNodePatchConfiguration",
        },
        "kubernetes_version": {"key": "properties.kubernetesVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        administrator_configuration: Optional["_models.AdministratorConfigurationPatch"] = None,
        control_plane_node_configuration: Optional["_models.ControlPlaneNodePatchConfiguration"] = None,
        kubernetes_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        :keyword administrator_configuration: The configuration of the default administrator
         credentials.
        :paramtype administrator_configuration:
         ~azure.mgmt.networkcloud.models.AdministratorConfigurationPatch
        :keyword control_plane_node_configuration: The defining characteristics of the control plane
         that can be patched for this Kubernetes cluster.
        :paramtype control_plane_node_configuration:
         ~azure.mgmt.networkcloud.models.ControlPlaneNodePatchConfiguration
        :keyword kubernetes_version: The Kubernetes version for this cluster.
        :paramtype kubernetes_version: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.administrator_configuration = administrator_configuration
        self.control_plane_node_configuration = control_plane_node_configuration
        self.kubernetes_version = kubernetes_version


class KubernetesClusterRestartNodeParameters(_serialization.Model):
    """KubernetesClusterRestartNodeParameters represents the body of the request to restart the node
    of a Kubernetes cluster.

    All required parameters must be populated in order to send to server.

    :ivar node_name: The name of the node to restart. Required.
    :vartype node_name: str
    """

    _validation = {
        "node_name": {"required": True},
    }

    _attribute_map = {
        "node_name": {"key": "nodeName", "type": "str"},
    }

    def __init__(self, *, node_name: str, **kwargs: Any) -> None:
        """
        :keyword node_name: The name of the node to restart. Required.
        :paramtype node_name: str
        """
        super().__init__(**kwargs)
        self.node_name = node_name


class KubernetesLabel(_serialization.Model):
    """KubernetesLabel represents a single entry for a Kubernetes label or taint such as those used on
    a node or pod.

    All required parameters must be populated in order to send to server.

    :ivar key: The name of the label or taint. Required.
    :vartype key: str
    :ivar value: The value of the label or taint. Required.
    :vartype value: str
    """

    _validation = {
        "key": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key: str, value: str, **kwargs: Any) -> None:
        """
        :keyword key: The name of the label or taint. Required.
        :paramtype key: str
        :keyword value: The value of the label or taint. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.value = value


class L2Network(TrackedResource):
    """L2Network represents a network that utilizes a single isolation domain set up for layer-2
    resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location of the cluster associated with the resource.
     Required.
    :vartype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar associated_resource_ids: The list of resource IDs for the other Microsoft.NetworkCloud
     resources that have attached this network.
    :vartype associated_resource_ids: list[str]
    :ivar cluster_id: The resource ID of the Network Cloud cluster this L2 network is associated
     with.
    :vartype cluster_id: str
    :ivar detailed_status: The more detailed status of the L2 network. Known values are: "Error",
     "Available", and "Provisioning".
    :vartype detailed_status: str or ~azure.mgmt.networkcloud.models.L2NetworkDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar hybrid_aks_clusters_associated_ids: Field Deprecated. These fields will be empty/omitted.
     The list of Hybrid AKS cluster resource ID(s) that are associated with this L2 network.
    :vartype hybrid_aks_clusters_associated_ids: list[str]
    :ivar hybrid_aks_plugin_type: Field Deprecated. The field was previously optional, now it will
     have no defined behavior and will be ignored. The network plugin type for Hybrid AKS. Known
     values are: "DPDK", "SRIOV", and "OSDevice".
    :vartype hybrid_aks_plugin_type: str or ~azure.mgmt.networkcloud.models.HybridAksPluginType
    :ivar interface_name: The default interface name for this L2 network in the virtual machine.
     This name can be overridden by the name supplied in the network attachment configuration of
     that virtual machine.
    :vartype interface_name: str
    :ivar l2_isolation_domain_id: The resource ID of the Network Fabric l2IsolationDomain.
     Required.
    :vartype l2_isolation_domain_id: str
    :ivar provisioning_state: The provisioning state of the L2 network. Known values are:
     "Succeeded", "Failed", "Canceled", "Provisioning", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.networkcloud.models.L2NetworkProvisioningState
    :ivar virtual_machines_associated_ids: Field Deprecated. These fields will be empty/omitted.
     The list of virtual machine resource ID(s), excluding any Hybrid AKS virtual machines, that are
     currently using this L2 network.
    :vartype virtual_machines_associated_ids: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "extended_location": {"required": True},
        "associated_resource_ids": {"readonly": True},
        "cluster_id": {"readonly": True},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "hybrid_aks_clusters_associated_ids": {"readonly": True},
        "interface_name": {"max_length": 12, "pattern": r"^[a-zA-Z0-9@._-]*$"},
        "l2_isolation_domain_id": {"required": True},
        "provisioning_state": {"readonly": True},
        "virtual_machines_associated_ids": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "associated_resource_ids": {"key": "properties.associatedResourceIds", "type": "[str]"},
        "cluster_id": {"key": "properties.clusterId", "type": "str"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "hybrid_aks_clusters_associated_ids": {"key": "properties.hybridAksClustersAssociatedIds", "type": "[str]"},
        "hybrid_aks_plugin_type": {"key": "properties.hybridAksPluginType", "type": "str"},
        "interface_name": {"key": "properties.interfaceName", "type": "str"},
        "l2_isolation_domain_id": {"key": "properties.l2IsolationDomainId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "virtual_machines_associated_ids": {"key": "properties.virtualMachinesAssociatedIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        l2_isolation_domain_id: str,
        tags: Optional[Dict[str, str]] = None,
        hybrid_aks_plugin_type: Optional[Union[str, "_models.HybridAksPluginType"]] = None,
        interface_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location of the cluster associated with the resource.
         Required.
        :paramtype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
        :keyword hybrid_aks_plugin_type: Field Deprecated. The field was previously optional, now it
         will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
         Known values are: "DPDK", "SRIOV", and "OSDevice".
        :paramtype hybrid_aks_plugin_type: str or ~azure.mgmt.networkcloud.models.HybridAksPluginType
        :keyword interface_name: The default interface name for this L2 network in the virtual machine.
         This name can be overridden by the name supplied in the network attachment configuration of
         that virtual machine.
        :paramtype interface_name: str
        :keyword l2_isolation_domain_id: The resource ID of the Network Fabric l2IsolationDomain.
         Required.
        :paramtype l2_isolation_domain_id: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.associated_resource_ids = None
        self.cluster_id = None
        self.detailed_status = None
        self.detailed_status_message = None
        self.hybrid_aks_clusters_associated_ids = None
        self.hybrid_aks_plugin_type = hybrid_aks_plugin_type
        self.interface_name = interface_name
        self.l2_isolation_domain_id = l2_isolation_domain_id
        self.provisioning_state = None
        self.virtual_machines_associated_ids = None


class L2NetworkAttachmentConfiguration(_serialization.Model):
    """L2NetworkAttachmentConfiguration represents the configuration of the attachment of a Layer 2
    network.

    All required parameters must be populated in order to send to server.

    :ivar network_id: The resource ID of the network that is being configured for attachment.
     Required.
    :vartype network_id: str
    :ivar plugin_type: The indicator of how this network will be utilized by the Kubernetes
     cluster. Known values are: "DPDK", "SRIOV", "OSDevice", "MACVLAN", and "IPVLAN".
    :vartype plugin_type: str or ~azure.mgmt.networkcloud.models.KubernetesPluginType
    """

    _validation = {
        "network_id": {"required": True},
    }

    _attribute_map = {
        "network_id": {"key": "networkId", "type": "str"},
        "plugin_type": {"key": "pluginType", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_id: str,
        plugin_type: Optional[Union[str, "_models.KubernetesPluginType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_id: The resource ID of the network that is being configured for attachment.
         Required.
        :paramtype network_id: str
        :keyword plugin_type: The indicator of how this network will be utilized by the Kubernetes
         cluster. Known values are: "DPDK", "SRIOV", "OSDevice", "MACVLAN", and "IPVLAN".
        :paramtype plugin_type: str or ~azure.mgmt.networkcloud.models.KubernetesPluginType
        """
        super().__init__(**kwargs)
        self.network_id = network_id
        self.plugin_type = plugin_type


class L2NetworkList(_serialization.Model):
    """L2NetworkList represents a list of L2 networks.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of L2 networks.
    :vartype value: list[~azure.mgmt.networkcloud.models.L2Network]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[L2Network]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.L2Network"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of L2 networks.
        :paramtype value: list[~azure.mgmt.networkcloud.models.L2Network]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class L2NetworkPatchParameters(_serialization.Model):
    """L2NetworkPatchParameters represents the body of the request to patch the L2 network.

    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class L2ServiceLoadBalancerConfiguration(_serialization.Model):
    """L2ServiceLoadBalancerConfiguration represents the configuration of a layer 2 service load
    balancer.

    :ivar ip_address_pools: The list of pools of IP addresses that can be allocated to load
     balancer services.
    :vartype ip_address_pools: list[~azure.mgmt.networkcloud.models.IpAddressPool]
    """

    _attribute_map = {
        "ip_address_pools": {"key": "ipAddressPools", "type": "[IpAddressPool]"},
    }

    def __init__(self, *, ip_address_pools: Optional[List["_models.IpAddressPool"]] = None, **kwargs: Any) -> None:
        """
        :keyword ip_address_pools: The list of pools of IP addresses that can be allocated to load
         balancer services.
        :paramtype ip_address_pools: list[~azure.mgmt.networkcloud.models.IpAddressPool]
        """
        super().__init__(**kwargs)
        self.ip_address_pools = ip_address_pools


class L3Network(TrackedResource):
    """L3Network represents a network that utilizes a single isolation domain set up for layer-3
    resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location of the cluster associated with the resource.
     Required.
    :vartype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar associated_resource_ids: The list of resource IDs for the other Microsoft.NetworkCloud
     resources that have attached this network.
    :vartype associated_resource_ids: list[str]
    :ivar cluster_id: The resource ID of the Network Cloud cluster this L3 network is associated
     with.
    :vartype cluster_id: str
    :ivar detailed_status: The more detailed status of the L3 network. Known values are: "Error",
     "Available", and "Provisioning".
    :vartype detailed_status: str or ~azure.mgmt.networkcloud.models.L3NetworkDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar hybrid_aks_clusters_associated_ids: Field Deprecated. These fields will be empty/omitted.
     The list of Hybrid AKS cluster resource IDs that are associated with this L3 network.
    :vartype hybrid_aks_clusters_associated_ids: list[str]
    :ivar hybrid_aks_ipam_enabled: Field Deprecated. The field was previously optional, now it will
     have no defined behavior and will be ignored. The indicator of whether or not to disable IPAM
     allocation on the network attachment definition injected into the Hybrid AKS Cluster. Known
     values are: "True" and "False".
    :vartype hybrid_aks_ipam_enabled: str or ~azure.mgmt.networkcloud.models.HybridAksIpamEnabled
    :ivar hybrid_aks_plugin_type: Field Deprecated. The field was previously optional, now it will
     have no defined behavior and will be ignored. The network plugin type for Hybrid AKS. Known
     values are: "DPDK", "SRIOV", and "OSDevice".
    :vartype hybrid_aks_plugin_type: str or ~azure.mgmt.networkcloud.models.HybridAksPluginType
    :ivar interface_name: The default interface name for this L3 network in the virtual machine.
     This name can be overridden by the name supplied in the network attachment configuration of
     that virtual machine.
    :vartype interface_name: str
    :ivar ip_allocation_type: The type of the IP address allocation, defaulted to "DualStack".
     Known values are: "IPV4", "IPV6", and "DualStack".
    :vartype ip_allocation_type: str or ~azure.mgmt.networkcloud.models.IpAllocationType
    :ivar ipv4_connected_prefix: The IPV4 prefix (CIDR) assigned to this L3 network. Required when
     the IP allocation type
     is IPV4 or DualStack.
    :vartype ipv4_connected_prefix: str
    :ivar ipv6_connected_prefix: The IPV6 prefix (CIDR) assigned to this L3 network. Required when
     the IP allocation type
     is IPV6 or DualStack.
    :vartype ipv6_connected_prefix: str
    :ivar l3_isolation_domain_id: The resource ID of the Network Fabric l3IsolationDomain.
     Required.
    :vartype l3_isolation_domain_id: str
    :ivar provisioning_state: The provisioning state of the L3 network. Known values are:
     "Succeeded", "Failed", "Canceled", "Provisioning", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.networkcloud.models.L3NetworkProvisioningState
    :ivar virtual_machines_associated_ids: Field Deprecated. These fields will be empty/omitted.
     The list of virtual machine resource IDs, excluding any Hybrid AKS virtual machines, that are
     currently using this L3 network.
    :vartype virtual_machines_associated_ids: list[str]
    :ivar vlan: The VLAN from the l3IsolationDomain that is used for this network. Required.
    :vartype vlan: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "extended_location": {"required": True},
        "associated_resource_ids": {"readonly": True},
        "cluster_id": {"readonly": True},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "hybrid_aks_clusters_associated_ids": {"readonly": True},
        "interface_name": {"max_length": 12, "pattern": r"^[a-zA-Z0-9@._-]*$"},
        "l3_isolation_domain_id": {"required": True},
        "provisioning_state": {"readonly": True},
        "virtual_machines_associated_ids": {"readonly": True},
        "vlan": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "associated_resource_ids": {"key": "properties.associatedResourceIds", "type": "[str]"},
        "cluster_id": {"key": "properties.clusterId", "type": "str"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "hybrid_aks_clusters_associated_ids": {"key": "properties.hybridAksClustersAssociatedIds", "type": "[str]"},
        "hybrid_aks_ipam_enabled": {"key": "properties.hybridAksIpamEnabled", "type": "str"},
        "hybrid_aks_plugin_type": {"key": "properties.hybridAksPluginType", "type": "str"},
        "interface_name": {"key": "properties.interfaceName", "type": "str"},
        "ip_allocation_type": {"key": "properties.ipAllocationType", "type": "str"},
        "ipv4_connected_prefix": {"key": "properties.ipv4ConnectedPrefix", "type": "str"},
        "ipv6_connected_prefix": {"key": "properties.ipv6ConnectedPrefix", "type": "str"},
        "l3_isolation_domain_id": {"key": "properties.l3IsolationDomainId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "virtual_machines_associated_ids": {"key": "properties.virtualMachinesAssociatedIds", "type": "[str]"},
        "vlan": {"key": "properties.vlan", "type": "int"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        l3_isolation_domain_id: str,
        vlan: int,
        tags: Optional[Dict[str, str]] = None,
        hybrid_aks_ipam_enabled: Union[str, "_models.HybridAksIpamEnabled"] = "True",
        hybrid_aks_plugin_type: Optional[Union[str, "_models.HybridAksPluginType"]] = None,
        interface_name: Optional[str] = None,
        ip_allocation_type: Union[str, "_models.IpAllocationType"] = "DualStack",
        ipv4_connected_prefix: Optional[str] = None,
        ipv6_connected_prefix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location of the cluster associated with the resource.
         Required.
        :paramtype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
        :keyword hybrid_aks_ipam_enabled: Field Deprecated. The field was previously optional, now it
         will have no defined behavior and will be ignored. The indicator of whether or not to disable
         IPAM allocation on the network attachment definition injected into the Hybrid AKS Cluster.
         Known values are: "True" and "False".
        :paramtype hybrid_aks_ipam_enabled: str or ~azure.mgmt.networkcloud.models.HybridAksIpamEnabled
        :keyword hybrid_aks_plugin_type: Field Deprecated. The field was previously optional, now it
         will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
         Known values are: "DPDK", "SRIOV", and "OSDevice".
        :paramtype hybrid_aks_plugin_type: str or ~azure.mgmt.networkcloud.models.HybridAksPluginType
        :keyword interface_name: The default interface name for this L3 network in the virtual machine.
         This name can be overridden by the name supplied in the network attachment configuration of
         that virtual machine.
        :paramtype interface_name: str
        :keyword ip_allocation_type: The type of the IP address allocation, defaulted to "DualStack".
         Known values are: "IPV4", "IPV6", and "DualStack".
        :paramtype ip_allocation_type: str or ~azure.mgmt.networkcloud.models.IpAllocationType
        :keyword ipv4_connected_prefix: The IPV4 prefix (CIDR) assigned to this L3 network. Required
         when the IP allocation type
         is IPV4 or DualStack.
        :paramtype ipv4_connected_prefix: str
        :keyword ipv6_connected_prefix: The IPV6 prefix (CIDR) assigned to this L3 network. Required
         when the IP allocation type
         is IPV6 or DualStack.
        :paramtype ipv6_connected_prefix: str
        :keyword l3_isolation_domain_id: The resource ID of the Network Fabric l3IsolationDomain.
         Required.
        :paramtype l3_isolation_domain_id: str
        :keyword vlan: The VLAN from the l3IsolationDomain that is used for this network. Required.
        :paramtype vlan: int
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.associated_resource_ids = None
        self.cluster_id = None
        self.detailed_status = None
        self.detailed_status_message = None
        self.hybrid_aks_clusters_associated_ids = None
        self.hybrid_aks_ipam_enabled = hybrid_aks_ipam_enabled
        self.hybrid_aks_plugin_type = hybrid_aks_plugin_type
        self.interface_name = interface_name
        self.ip_allocation_type = ip_allocation_type
        self.ipv4_connected_prefix = ipv4_connected_prefix
        self.ipv6_connected_prefix = ipv6_connected_prefix
        self.l3_isolation_domain_id = l3_isolation_domain_id
        self.provisioning_state = None
        self.virtual_machines_associated_ids = None
        self.vlan = vlan


class L3NetworkAttachmentConfiguration(_serialization.Model):
    """L3NetworkAttachmentConfiguration represents the configuration of the attachment of a Layer 3
    network.

    All required parameters must be populated in order to send to server.

    :ivar ipam_enabled: The indication of whether this network will or will not perform IP address
     management and allocate IP addresses when attached. Known values are: "True" and "False".
    :vartype ipam_enabled: str or ~azure.mgmt.networkcloud.models.L3NetworkConfigurationIpamEnabled
    :ivar network_id: The resource ID of the network that is being configured for attachment.
     Required.
    :vartype network_id: str
    :ivar plugin_type: The indicator of how this network will be utilized by the Kubernetes
     cluster. Known values are: "DPDK", "SRIOV", "OSDevice", "MACVLAN", and "IPVLAN".
    :vartype plugin_type: str or ~azure.mgmt.networkcloud.models.KubernetesPluginType
    """

    _validation = {
        "network_id": {"required": True},
    }

    _attribute_map = {
        "ipam_enabled": {"key": "ipamEnabled", "type": "str"},
        "network_id": {"key": "networkId", "type": "str"},
        "plugin_type": {"key": "pluginType", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_id: str,
        ipam_enabled: Union[str, "_models.L3NetworkConfigurationIpamEnabled"] = "False",
        plugin_type: Optional[Union[str, "_models.KubernetesPluginType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ipam_enabled: The indication of whether this network will or will not perform IP
         address management and allocate IP addresses when attached. Known values are: "True" and
         "False".
        :paramtype ipam_enabled: str or
         ~azure.mgmt.networkcloud.models.L3NetworkConfigurationIpamEnabled
        :keyword network_id: The resource ID of the network that is being configured for attachment.
         Required.
        :paramtype network_id: str
        :keyword plugin_type: The indicator of how this network will be utilized by the Kubernetes
         cluster. Known values are: "DPDK", "SRIOV", "OSDevice", "MACVLAN", and "IPVLAN".
        :paramtype plugin_type: str or ~azure.mgmt.networkcloud.models.KubernetesPluginType
        """
        super().__init__(**kwargs)
        self.ipam_enabled = ipam_enabled
        self.network_id = network_id
        self.plugin_type = plugin_type


class L3NetworkList(_serialization.Model):
    """L3NetworkList represents a list of L3 networks.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of L3 networks.
    :vartype value: list[~azure.mgmt.networkcloud.models.L3Network]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[L3Network]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.L3Network"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of L3 networks.
        :paramtype value: list[~azure.mgmt.networkcloud.models.L3Network]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class L3NetworkPatchParameters(_serialization.Model):
    """L3NetworkPatchParameters represents the body of the request to patch the cloud services
    network.

    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class LldpNeighbor(_serialization.Model):
    """Type Deprecated. Will be removed in an upcoming version. LldpNeighbor represents the details
    about the device connected to the NIC.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar port_description: The descriptive information about the port on the connected device.
    :vartype port_description: str
    :ivar port_name: The system-assigned name of the port on the connected device.
    :vartype port_name: str
    :ivar system_description: The descriptive information about the connected device.
    :vartype system_description: str
    :ivar system_name: The system-assigned name of the connected device.
    :vartype system_name: str
    """

    _validation = {
        "port_description": {"readonly": True},
        "port_name": {"readonly": True},
        "system_description": {"readonly": True},
        "system_name": {"readonly": True},
    }

    _attribute_map = {
        "port_description": {"key": "portDescription", "type": "str"},
        "port_name": {"key": "portName", "type": "str"},
        "system_description": {"key": "systemDescription", "type": "str"},
        "system_name": {"key": "systemName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.port_description = None
        self.port_name = None
        self.system_description = None
        self.system_name = None


class MachineDisk(_serialization.Model):
    """Disk represents the properties of the disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar capacity_gb: The maximum amount of storage. Measured in gibibytes.
    :vartype capacity_gb: int
    :ivar connection: The connection type of the rack SKU resource. Known values are: "PCIE",
     "SATA", "RAID", and "SAS".
    :vartype connection: str or ~azure.mgmt.networkcloud.models.MachineSkuDiskConnectionType
    :ivar type: The disk type of rack SKU resource. Known values are: "HDD" and "SSD".
    :vartype type: str or ~azure.mgmt.networkcloud.models.DiskType
    """

    _validation = {
        "capacity_gb": {"readonly": True},
        "connection": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "capacity_gb": {"key": "capacityGB", "type": "int"},
        "connection": {"key": "connection", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.capacity_gb = None
        self.connection = None
        self.type = None


class MachineSkuSlot(_serialization.Model):
    """MachineSkuSlot represents a single SKU and rack slot associated with the machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rack_slot: The position in the rack for the machine.
    :vartype rack_slot: int
    :ivar bootstrap_protocol: The type of bootstrap protocol used. "PXE"
    :vartype bootstrap_protocol: str or ~azure.mgmt.networkcloud.models.BootstrapProtocol
    :ivar cpu_cores: The count of CPU cores for this machine.
    :vartype cpu_cores: int
    :ivar cpu_sockets: The count of CPU sockets for this machine.
    :vartype cpu_sockets: int
    :ivar disks: The list of disks.
    :vartype disks: list[~azure.mgmt.networkcloud.models.MachineDisk]
    :ivar generation: The generation of the architecture.
    :vartype generation: str
    :ivar hardware_version: The hardware version of the machine.
    :vartype hardware_version: str
    :ivar memory_capacity_gb: The maximum amount of memory. Measured in gibibytes.
    :vartype memory_capacity_gb: int
    :ivar model: The model of the machine.
    :vartype model: str
    :ivar network_interfaces: The list of network interfaces.
    :vartype network_interfaces: list[~azure.mgmt.networkcloud.models.NetworkInterface]
    :ivar total_threads: The count of SMT and physical core threads for this machine.
    :vartype total_threads: int
    :ivar vendor: The make of the machine.
    :vartype vendor: str
    """

    _validation = {
        "rack_slot": {"readonly": True},
        "bootstrap_protocol": {"readonly": True},
        "cpu_cores": {"readonly": True},
        "cpu_sockets": {"readonly": True},
        "disks": {"readonly": True},
        "generation": {"readonly": True},
        "hardware_version": {"readonly": True},
        "memory_capacity_gb": {"readonly": True},
        "model": {"readonly": True},
        "network_interfaces": {"readonly": True},
        "total_threads": {"readonly": True},
        "vendor": {"readonly": True},
    }

    _attribute_map = {
        "rack_slot": {"key": "rackSlot", "type": "int"},
        "bootstrap_protocol": {"key": "properties.bootstrapProtocol", "type": "str"},
        "cpu_cores": {"key": "properties.cpuCores", "type": "int"},
        "cpu_sockets": {"key": "properties.cpuSockets", "type": "int"},
        "disks": {"key": "properties.disks", "type": "[MachineDisk]"},
        "generation": {"key": "properties.generation", "type": "str"},
        "hardware_version": {"key": "properties.hardwareVersion", "type": "str"},
        "memory_capacity_gb": {"key": "properties.memoryCapacityGB", "type": "int"},
        "model": {"key": "properties.model", "type": "str"},
        "network_interfaces": {"key": "properties.networkInterfaces", "type": "[NetworkInterface]"},
        "total_threads": {"key": "properties.totalThreads", "type": "int"},
        "vendor": {"key": "properties.vendor", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.rack_slot = None
        self.bootstrap_protocol = None
        self.cpu_cores = None
        self.cpu_sockets = None
        self.disks = None
        self.generation = None
        self.hardware_version = None
        self.memory_capacity_gb = None
        self.model = None
        self.network_interfaces = None
        self.total_threads = None
        self.vendor = None


class ManagedResourceGroupConfiguration(_serialization.Model):
    """ManagedResourceGroupConfiguration represents the configuration of the resource group managed by
    Azure.

    :ivar location: The location of the managed resource group. If not specified, the location of
     the parent resource is chosen.
    :vartype location: str
    :ivar name: The name for the managed resource group. If not specified, the unique name is
     automatically generated.
    :vartype name: str
    """

    _validation = {
        "name": {"max_length": 75},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, location: Optional[str] = None, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword location: The location of the managed resource group. If not specified, the location
         of the parent resource is chosen.
        :paramtype location: str
        :keyword name: The name for the managed resource group. If not specified, the unique name is
         automatically generated.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.location = location
        self.name = name


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.networkcloud.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.  # pylint: disable=line-too-long
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.networkcloud.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.networkcloud.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.  # pylint: disable=line-too-long
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.networkcloud.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class NetworkAttachment(_serialization.Model):
    """NetworkAttachment represents the single network attachment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar attached_network_id: The resource ID of the associated network attached to the virtual
     machine.
     It can be one of cloudServicesNetwork, l3Network, l2Network or trunkedNetwork resources.
     Required.
    :vartype attached_network_id: str
    :ivar default_gateway: The indicator of whether this is the default gateway.
     Only one of the attached networks (including the CloudServicesNetwork attachment) for a single
     machine may be specified as True. Known values are: "True" and "False".
    :vartype default_gateway: str or ~azure.mgmt.networkcloud.models.DefaultGateway
    :ivar ip_allocation_method: The IP allocation mechanism for the virtual machine.
     Dynamic and Static are only valid for l3Network which may also specify Disabled.
     Otherwise, Disabled is the only permitted value. Required. Known values are: "Dynamic",
     "Static", and "Disabled".
    :vartype ip_allocation_method: str or
     ~azure.mgmt.networkcloud.models.VirtualMachineIPAllocationMethod
    :ivar ipv4_address: The IPv4 address of the virtual machine.

     This field is used only if the attached network has IPAllocationType of IPV4 or DualStack.

     If IPAllocationMethod is:
     Static - this field must contain a user specified IPv4 address from within the subnet
     specified in the attached network.
     Dynamic - this field is read-only, but will be populated with an address from within the
     subnet specified in the attached network.
     Disabled - this field will be empty.
    :vartype ipv4_address: str
    :ivar ipv6_address: The IPv6 address of the virtual machine.

     This field is used only if the attached network has IPAllocationType of IPV6 or DualStack.

     If IPAllocationMethod is:
     Static - this field must contain an IPv6 address range from within the range specified in the
     attached network.
     Dynamic - this field is read-only, but will be populated with an range from within the subnet
     specified in the attached network.
     Disabled - this field will be empty.
    :vartype ipv6_address: str
    :ivar mac_address: The MAC address of the interface for the virtual machine that corresponds to
     this network attachment.
    :vartype mac_address: str
    :ivar network_attachment_name: The associated network's interface name.
     If specified, the network attachment name has a maximum length of 15 characters and must be
     unique to this virtual machine.
     If the user doesn’t specify this value, the default interface name of the network resource
     will be used.
     For a CloudServicesNetwork resource, this name will be ignored.
    :vartype network_attachment_name: str
    """

    _validation = {
        "attached_network_id": {"required": True},
        "ip_allocation_method": {"required": True},
        "mac_address": {"readonly": True},
        "network_attachment_name": {"max_length": 15},
    }

    _attribute_map = {
        "attached_network_id": {"key": "attachedNetworkId", "type": "str"},
        "default_gateway": {"key": "defaultGateway", "type": "str"},
        "ip_allocation_method": {"key": "ipAllocationMethod", "type": "str"},
        "ipv4_address": {"key": "ipv4Address", "type": "str"},
        "ipv6_address": {"key": "ipv6Address", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
        "network_attachment_name": {"key": "networkAttachmentName", "type": "str"},
    }

    def __init__(
        self,
        *,
        attached_network_id: str,
        ip_allocation_method: Union[str, "_models.VirtualMachineIPAllocationMethod"],
        default_gateway: Optional[Union[str, "_models.DefaultGateway"]] = None,
        ipv4_address: Optional[str] = None,
        ipv6_address: Optional[str] = None,
        network_attachment_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword attached_network_id: The resource ID of the associated network attached to the virtual
         machine.
         It can be one of cloudServicesNetwork, l3Network, l2Network or trunkedNetwork resources.
         Required.
        :paramtype attached_network_id: str
        :keyword default_gateway: The indicator of whether this is the default gateway.
         Only one of the attached networks (including the CloudServicesNetwork attachment) for a single
         machine may be specified as True. Known values are: "True" and "False".
        :paramtype default_gateway: str or ~azure.mgmt.networkcloud.models.DefaultGateway
        :keyword ip_allocation_method: The IP allocation mechanism for the virtual machine.
         Dynamic and Static are only valid for l3Network which may also specify Disabled.
         Otherwise, Disabled is the only permitted value. Required. Known values are: "Dynamic",
         "Static", and "Disabled".
        :paramtype ip_allocation_method: str or
         ~azure.mgmt.networkcloud.models.VirtualMachineIPAllocationMethod
        :keyword ipv4_address: The IPv4 address of the virtual machine.

         This field is used only if the attached network has IPAllocationType of IPV4 or DualStack.

         If IPAllocationMethod is:
         Static - this field must contain a user specified IPv4 address from within the subnet
         specified in the attached network.
         Dynamic - this field is read-only, but will be populated with an address from within the
         subnet specified in the attached network.
         Disabled - this field will be empty.
        :paramtype ipv4_address: str
        :keyword ipv6_address: The IPv6 address of the virtual machine.

         This field is used only if the attached network has IPAllocationType of IPV6 or DualStack.

         If IPAllocationMethod is:
         Static - this field must contain an IPv6 address range from within the range specified in the
         attached network.
         Dynamic - this field is read-only, but will be populated with an range from within the subnet
         specified in the attached network.
         Disabled - this field will be empty.
        :paramtype ipv6_address: str
        :keyword network_attachment_name: The associated network's interface name.
         If specified, the network attachment name has a maximum length of 15 characters and must be
         unique to this virtual machine.
         If the user doesn’t specify this value, the default interface name of the network resource
         will be used.
         For a CloudServicesNetwork resource, this name will be ignored.
        :paramtype network_attachment_name: str
        """
        super().__init__(**kwargs)
        self.attached_network_id = attached_network_id
        self.default_gateway = default_gateway
        self.ip_allocation_method = ip_allocation_method
        self.ipv4_address = ipv4_address
        self.ipv6_address = ipv6_address
        self.mac_address = None
        self.network_attachment_name = network_attachment_name


class NetworkConfiguration(_serialization.Model):
    """NetworkConfiguration specifies the Kubernetes cluster network related configuration.

    All required parameters must be populated in order to send to server.

    :ivar attached_network_configuration: The configuration of networks being attached to the
     cluster for use by the workloads that run on this Kubernetes cluster.
    :vartype attached_network_configuration:
     ~azure.mgmt.networkcloud.models.AttachedNetworkConfiguration
    :ivar bgp_service_load_balancer_configuration: The configuration of the BGP service load
     balancer for this Kubernetes cluster. A maximum of one service load balancer may be specified,
     either Layer 2 or BGP.
    :vartype bgp_service_load_balancer_configuration:
     ~azure.mgmt.networkcloud.models.BgpServiceLoadBalancerConfiguration
    :ivar cloud_services_network_id: The resource ID of the associated Cloud Services network.
     Required.
    :vartype cloud_services_network_id: str
    :ivar cni_network_id: The resource ID of the Layer 3 network that is used for creation of the
     Container Networking Interface network. Required.
    :vartype cni_network_id: str
    :ivar dns_service_ip: The IP address assigned to the Kubernetes DNS service. It must be within
     the Kubernetes service address range specified in service CIDR.
    :vartype dns_service_ip: str
    :ivar l2_service_load_balancer_configuration: The configuration of the Layer 2 service load
     balancer for this Kubernetes cluster. A maximum of one service load balancer may be specified,
     either Layer 2 or BGP.
    :vartype l2_service_load_balancer_configuration:
     ~azure.mgmt.networkcloud.models.L2ServiceLoadBalancerConfiguration
    :ivar pod_cidrs: The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is
     expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is
     expected for dual-stack networking.
    :vartype pod_cidrs: list[str]
    :ivar service_cidrs: The CIDR notation IP ranges from which to assign service IPs. One IPv4
     CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is
     expected for dual-stack networking.
    :vartype service_cidrs: list[str]
    """

    _validation = {
        "cloud_services_network_id": {"required": True},
        "cni_network_id": {"required": True},
    }

    _attribute_map = {
        "attached_network_configuration": {
            "key": "attachedNetworkConfiguration",
            "type": "AttachedNetworkConfiguration",
        },
        "bgp_service_load_balancer_configuration": {
            "key": "bgpServiceLoadBalancerConfiguration",
            "type": "BgpServiceLoadBalancerConfiguration",
        },
        "cloud_services_network_id": {"key": "cloudServicesNetworkId", "type": "str"},
        "cni_network_id": {"key": "cniNetworkId", "type": "str"},
        "dns_service_ip": {"key": "dnsServiceIp", "type": "str"},
        "l2_service_load_balancer_configuration": {
            "key": "l2ServiceLoadBalancerConfiguration",
            "type": "L2ServiceLoadBalancerConfiguration",
        },
        "pod_cidrs": {"key": "podCidrs", "type": "[str]"},
        "service_cidrs": {"key": "serviceCidrs", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        cloud_services_network_id: str,
        cni_network_id: str,
        attached_network_configuration: Optional["_models.AttachedNetworkConfiguration"] = None,
        bgp_service_load_balancer_configuration: Optional["_models.BgpServiceLoadBalancerConfiguration"] = None,
        dns_service_ip: Optional[str] = None,
        l2_service_load_balancer_configuration: Optional["_models.L2ServiceLoadBalancerConfiguration"] = None,
        pod_cidrs: Optional[List[str]] = None,
        service_cidrs: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword attached_network_configuration: The configuration of networks being attached to the
         cluster for use by the workloads that run on this Kubernetes cluster.
        :paramtype attached_network_configuration:
         ~azure.mgmt.networkcloud.models.AttachedNetworkConfiguration
        :keyword bgp_service_load_balancer_configuration: The configuration of the BGP service load
         balancer for this Kubernetes cluster. A maximum of one service load balancer may be specified,
         either Layer 2 or BGP.
        :paramtype bgp_service_load_balancer_configuration:
         ~azure.mgmt.networkcloud.models.BgpServiceLoadBalancerConfiguration
        :keyword cloud_services_network_id: The resource ID of the associated Cloud Services network.
         Required.
        :paramtype cloud_services_network_id: str
        :keyword cni_network_id: The resource ID of the Layer 3 network that is used for creation of
         the Container Networking Interface network. Required.
        :paramtype cni_network_id: str
        :keyword dns_service_ip: The IP address assigned to the Kubernetes DNS service. It must be
         within the Kubernetes service address range specified in service CIDR.
        :paramtype dns_service_ip: str
        :keyword l2_service_load_balancer_configuration: The configuration of the Layer 2 service load
         balancer for this Kubernetes cluster. A maximum of one service load balancer may be specified,
         either Layer 2 or BGP.
        :paramtype l2_service_load_balancer_configuration:
         ~azure.mgmt.networkcloud.models.L2ServiceLoadBalancerConfiguration
        :keyword pod_cidrs: The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is
         expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is
         expected for dual-stack networking.
        :paramtype pod_cidrs: list[str]
        :keyword service_cidrs: The CIDR notation IP ranges from which to assign service IPs. One IPv4
         CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is
         expected for dual-stack networking.
        :paramtype service_cidrs: list[str]
        """
        super().__init__(**kwargs)
        self.attached_network_configuration = attached_network_configuration
        self.bgp_service_load_balancer_configuration = bgp_service_load_balancer_configuration
        self.cloud_services_network_id = cloud_services_network_id
        self.cni_network_id = cni_network_id
        self.dns_service_ip = dns_service_ip
        self.l2_service_load_balancer_configuration = l2_service_load_balancer_configuration
        self.pod_cidrs = pod_cidrs
        self.service_cidrs = service_cidrs


class NetworkInterface(_serialization.Model):
    """NetworkInterface represents properties of the network interface.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar address: The partial address of Peripheral Component Interconnect (PCI).
    :vartype address: str
    :ivar device_connection_type: The connection type of the device. "PCI"
    :vartype device_connection_type: str or ~azure.mgmt.networkcloud.models.DeviceConnectionType
    :ivar model: The model name of the device.
    :vartype model: str
    :ivar physical_slot: The physical slot for this device.
    :vartype physical_slot: int
    :ivar port_count: The number of ports on the device.
    :vartype port_count: int
    :ivar port_speed: The maximum amount of data in gigabits that the line card transmits through a
     port at any given second.
    :vartype port_speed: int
    :ivar vendor: The vendor name of the device.
    :vartype vendor: str
    """

    _validation = {
        "address": {"readonly": True},
        "device_connection_type": {"readonly": True},
        "model": {"readonly": True},
        "physical_slot": {"readonly": True},
        "port_count": {"readonly": True},
        "port_speed": {"readonly": True},
        "vendor": {"readonly": True},
    }

    _attribute_map = {
        "address": {"key": "address", "type": "str"},
        "device_connection_type": {"key": "deviceConnectionType", "type": "str"},
        "model": {"key": "model", "type": "str"},
        "physical_slot": {"key": "physicalSlot", "type": "int"},
        "port_count": {"key": "portCount", "type": "int"},
        "port_speed": {"key": "portSpeed", "type": "int"},
        "vendor": {"key": "vendor", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.address = None
        self.device_connection_type = None
        self.model = None
        self.physical_slot = None
        self.port_count = None
        self.port_speed = None
        self.vendor = None


class Nic(_serialization.Model):
    """Type Deprecated. Will be removed in an upcoming version. Nic represents the network interface
    card details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar lldp_neighbor: The information about the device connected to this NIC.
    :vartype lldp_neighbor: ~azure.mgmt.networkcloud.models.LldpNeighbor
    :ivar mac_address: The MAC address associated with this NIC.
    :vartype mac_address: str
    :ivar name: The name of the NIC/interface.
    :vartype name: str
    """

    _validation = {
        "lldp_neighbor": {"readonly": True},
        "mac_address": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "lldp_neighbor": {"key": "lldpNeighbor", "type": "LldpNeighbor"},
        "mac_address": {"key": "macAddress", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.lldp_neighbor = None
        self.mac_address = None
        self.name = None


class NodePoolAdministratorConfigurationPatch(_serialization.Model):
    """NodePoolAdministratorConfigurationPatch represents the patching capabilities for the
    administrator configuration.

    :ivar ssh_public_keys: SshPublicKey represents the public key used to authenticate with a
     resource through SSH.
    :vartype ssh_public_keys: list[~azure.mgmt.networkcloud.models.SshPublicKey]
    """

    _attribute_map = {
        "ssh_public_keys": {"key": "sshPublicKeys", "type": "[SshPublicKey]"},
    }

    def __init__(self, *, ssh_public_keys: Optional[List["_models.SshPublicKey"]] = None, **kwargs: Any) -> None:
        """
        :keyword ssh_public_keys: SshPublicKey represents the public key used to authenticate with a
         resource through SSH.
        :paramtype ssh_public_keys: list[~azure.mgmt.networkcloud.models.SshPublicKey]
        """
        super().__init__(**kwargs)
        self.ssh_public_keys = ssh_public_keys


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.networkcloud.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.networkcloud.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.networkcloud.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.networkcloud.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.networkcloud.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationStatusResult(_serialization.Model):
    """The current status of an async operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.networkcloud.models.ErrorDetail
    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar operations: The operations list.
    :vartype operations: list[~azure.mgmt.networkcloud.models.OperationStatusResult]
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar resource_id: Fully qualified ID of the resource against which the original async
     operation was started.
    :vartype resource_id: str
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar exit_code: For actions that run commands or scripts, the exit code of the script
     execution.
    :vartype exit_code: str
    :ivar output_head: For actions that run commands or scripts, the leading bytes of the output of
     the script execution.
    :vartype output_head: str
    :ivar result_ref: For actions that run commands or scripts, a reference to the location of the
     result.
    :vartype result_ref: str
    :ivar result_url: For actions that run commands or scripts, the URL where the full output of
     the script output can be retrieved.
    :vartype result_url: str
    """

    _validation = {
        "end_time": {"readonly": True},
        "error": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "operations": {"readonly": True},
        "percent_complete": {"readonly": True, "maximum": 100, "minimum": 0},
        "resource_id": {"readonly": True},
        "start_time": {"readonly": True},
        "status": {"required": True},
        "exit_code": {"readonly": True},
        "output_head": {"readonly": True},
        "result_ref": {"readonly": True},
        "result_url": {"readonly": True},
    }

    _attribute_map = {
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "ErrorDetail"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "operations": {"key": "operations", "type": "[OperationStatusResult]"},
        "percent_complete": {"key": "percentComplete", "type": "float"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "exit_code": {"key": "properties.exitCode", "type": "str"},
        "output_head": {"key": "properties.outputHead", "type": "str"},
        "result_ref": {"key": "properties.resultRef", "type": "str"},
        "result_url": {"key": "properties.resultUrl", "type": "str"},
    }

    def __init__(self, *, status: str, **kwargs: Any) -> None:
        """
        :keyword status: Operation status. Required.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.end_time = None
        self.error = None
        self.id = None
        self.name = None
        self.operations = None
        self.percent_complete = None
        self.resource_id = None
        self.start_time = None
        self.status = status
        self.exit_code = None
        self.output_head = None
        self.result_ref = None
        self.result_url = None


class OsDisk(_serialization.Model):
    """OsDisk represents configuration of the boot disk.

    All required parameters must be populated in order to send to server.

    :ivar create_option: The strategy for creating the OS disk. "Ephemeral"
    :vartype create_option: str or ~azure.mgmt.networkcloud.models.OsDiskCreateOption
    :ivar delete_option: The strategy for deleting the OS disk. "Delete"
    :vartype delete_option: str or ~azure.mgmt.networkcloud.models.OsDiskDeleteOption
    :ivar disk_size_gb: The size of the disk. Required if the createOption is Ephemeral.
     Allocations are measured in gibibytes. Required.
    :vartype disk_size_gb: int
    """

    _validation = {
        "disk_size_gb": {"required": True},
    }

    _attribute_map = {
        "create_option": {"key": "createOption", "type": "str"},
        "delete_option": {"key": "deleteOption", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
    }

    def __init__(
        self,
        *,
        disk_size_gb: int,
        create_option: Union[str, "_models.OsDiskCreateOption"] = "Ephemeral",
        delete_option: Union[str, "_models.OsDiskDeleteOption"] = "Delete",
        **kwargs: Any
    ) -> None:
        """
        :keyword create_option: The strategy for creating the OS disk. "Ephemeral"
        :paramtype create_option: str or ~azure.mgmt.networkcloud.models.OsDiskCreateOption
        :keyword delete_option: The strategy for deleting the OS disk. "Delete"
        :paramtype delete_option: str or ~azure.mgmt.networkcloud.models.OsDiskDeleteOption
        :keyword disk_size_gb: The size of the disk. Required if the createOption is Ephemeral.
         Allocations are measured in gibibytes. Required.
        :paramtype disk_size_gb: int
        """
        super().__init__(**kwargs)
        self.create_option = create_option
        self.delete_option = delete_option
        self.disk_size_gb = disk_size_gb


class Rack(TrackedResource):
    """Rack represents the hardware of the rack and is dependent upon the cluster for lifecycle.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location of the cluster associated with the resource.
     Required.
    :vartype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar availability_zone: The value that will be used for machines in this rack to represent the
     availability zones that can be referenced by Hybrid AKS Clusters for node arrangement.
     Required.
    :vartype availability_zone: str
    :ivar cluster_id: The resource ID of the cluster the rack is created for. This value is set
     when the rack is created by the cluster.
    :vartype cluster_id: str
    :ivar detailed_status: The more detailed status of the rack. Known values are: "Error",
     "Available", and "Provisioning".
    :vartype detailed_status: str or ~azure.mgmt.networkcloud.models.RackDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar provisioning_state: The provisioning state of the rack resource. Known values are:
     "Succeeded", "Failed", "Canceled", "Provisioning", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.networkcloud.models.RackProvisioningState
    :ivar rack_location: The free-form description of the rack location. (e.g. “DTN Datacenter,
     Floor 3, Isle 9, Rack 2B”). Required.
    :vartype rack_location: str
    :ivar rack_serial_number: The unique identifier for the rack within Network Cloud cluster. An
     alternate unique alphanumeric value other than a serial number may be provided if desired.
     Required.
    :vartype rack_serial_number: str
    :ivar rack_sku_id: The SKU for the rack. Required.
    :vartype rack_sku_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "extended_location": {"required": True},
        "availability_zone": {"required": True, "pattern": r"^[a-zA-Z0-9]{1,10}$"},
        "cluster_id": {"readonly": True},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "rack_location": {"required": True, "max_length": 256},
        "rack_serial_number": {"required": True, "max_length": 64, "min_length": 1},
        "rack_sku_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "availability_zone": {"key": "properties.availabilityZone", "type": "str"},
        "cluster_id": {"key": "properties.clusterId", "type": "str"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "rack_location": {"key": "properties.rackLocation", "type": "str"},
        "rack_serial_number": {"key": "properties.rackSerialNumber", "type": "str"},
        "rack_sku_id": {"key": "properties.rackSkuId", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        availability_zone: str,
        rack_location: str,
        rack_serial_number: str,
        rack_sku_id: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location of the cluster associated with the resource.
         Required.
        :paramtype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
        :keyword availability_zone: The value that will be used for machines in this rack to represent
         the availability zones that can be referenced by Hybrid AKS Clusters for node arrangement.
         Required.
        :paramtype availability_zone: str
        :keyword rack_location: The free-form description of the rack location. (e.g. “DTN Datacenter,
         Floor 3, Isle 9, Rack 2B”). Required.
        :paramtype rack_location: str
        :keyword rack_serial_number: The unique identifier for the rack within Network Cloud cluster.
         An alternate unique alphanumeric value other than a serial number may be provided if desired.
         Required.
        :paramtype rack_serial_number: str
        :keyword rack_sku_id: The SKU for the rack. Required.
        :paramtype rack_sku_id: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.availability_zone = availability_zone
        self.cluster_id = None
        self.detailed_status = None
        self.detailed_status_message = None
        self.provisioning_state = None
        self.rack_location = rack_location
        self.rack_serial_number = rack_serial_number
        self.rack_sku_id = rack_sku_id


class RackDefinition(_serialization.Model):
    """RackDefinition represents details regarding the rack.

    All required parameters must be populated in order to send to server.

    :ivar availability_zone: The zone name used for this rack when created. Availability zones are
     used for workload placement.
    :vartype availability_zone: str
    :ivar bare_metal_machine_configuration_data: The unordered list of bare metal machine
     configuration.
    :vartype bare_metal_machine_configuration_data:
     list[~azure.mgmt.networkcloud.models.BareMetalMachineConfigurationData]
    :ivar network_rack_id: The resource ID of the network rack that matches this rack definition.
     Required.
    :vartype network_rack_id: str
    :ivar rack_location: The free-form description of the rack's location.
    :vartype rack_location: str
    :ivar rack_serial_number: The unique identifier for the rack within Network Cloud cluster. An
     alternate unique alphanumeric value other than a serial number may be provided if desired.
     Required.
    :vartype rack_serial_number: str
    :ivar rack_sku_id: The resource ID of the sku for the rack being added. Required.
    :vartype rack_sku_id: str
    :ivar storage_appliance_configuration_data: The list of storage appliance configuration data
     for this rack.
    :vartype storage_appliance_configuration_data:
     list[~azure.mgmt.networkcloud.models.StorageApplianceConfigurationData]
    """

    _validation = {
        "availability_zone": {"pattern": r"^[a-zA-Z0-9]{1,10}$"},
        "network_rack_id": {"required": True},
        "rack_location": {"max_length": 256},
        "rack_serial_number": {"required": True, "max_length": 64, "min_length": 1},
        "rack_sku_id": {"required": True},
    }

    _attribute_map = {
        "availability_zone": {"key": "availabilityZone", "type": "str"},
        "bare_metal_machine_configuration_data": {
            "key": "bareMetalMachineConfigurationData",
            "type": "[BareMetalMachineConfigurationData]",
        },
        "network_rack_id": {"key": "networkRackId", "type": "str"},
        "rack_location": {"key": "rackLocation", "type": "str"},
        "rack_serial_number": {"key": "rackSerialNumber", "type": "str"},
        "rack_sku_id": {"key": "rackSkuId", "type": "str"},
        "storage_appliance_configuration_data": {
            "key": "storageApplianceConfigurationData",
            "type": "[StorageApplianceConfigurationData]",
        },
    }

    def __init__(
        self,
        *,
        network_rack_id: str,
        rack_serial_number: str,
        rack_sku_id: str,
        availability_zone: Optional[str] = None,
        bare_metal_machine_configuration_data: Optional[List["_models.BareMetalMachineConfigurationData"]] = None,
        rack_location: Optional[str] = None,
        storage_appliance_configuration_data: Optional[List["_models.StorageApplianceConfigurationData"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword availability_zone: The zone name used for this rack when created. Availability zones
         are used for workload placement.
        :paramtype availability_zone: str
        :keyword bare_metal_machine_configuration_data: The unordered list of bare metal machine
         configuration.
        :paramtype bare_metal_machine_configuration_data:
         list[~azure.mgmt.networkcloud.models.BareMetalMachineConfigurationData]
        :keyword network_rack_id: The resource ID of the network rack that matches this rack
         definition. Required.
        :paramtype network_rack_id: str
        :keyword rack_location: The free-form description of the rack's location.
        :paramtype rack_location: str
        :keyword rack_serial_number: The unique identifier for the rack within Network Cloud cluster.
         An alternate unique alphanumeric value other than a serial number may be provided if desired.
         Required.
        :paramtype rack_serial_number: str
        :keyword rack_sku_id: The resource ID of the sku for the rack being added. Required.
        :paramtype rack_sku_id: str
        :keyword storage_appliance_configuration_data: The list of storage appliance configuration data
         for this rack.
        :paramtype storage_appliance_configuration_data:
         list[~azure.mgmt.networkcloud.models.StorageApplianceConfigurationData]
        """
        super().__init__(**kwargs)
        self.availability_zone = availability_zone
        self.bare_metal_machine_configuration_data = bare_metal_machine_configuration_data
        self.network_rack_id = network_rack_id
        self.rack_location = rack_location
        self.rack_serial_number = rack_serial_number
        self.rack_sku_id = rack_sku_id
        self.storage_appliance_configuration_data = storage_appliance_configuration_data


class RackList(_serialization.Model):
    """RackList represents a list of racks.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of racks.
    :vartype value: list[~azure.mgmt.networkcloud.models.Rack]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Rack]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.Rack"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of racks.
        :paramtype value: list[~azure.mgmt.networkcloud.models.Rack]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class RackPatchParameters(_serialization.Model):
    """RackPatchParameters represents the body of the request to patch the rack properties.

    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    :ivar rack_location: The free-form description of the rack location. (e.g. “DTN Datacenter,
     Floor 3, Isle 9, Rack 2B”).
    :vartype rack_location: str
    :ivar rack_serial_number: The globally unique identifier for the rack.
    :vartype rack_serial_number: str
    """

    _validation = {
        "rack_location": {"max_length": 256},
        "rack_serial_number": {"max_length": 64, "min_length": 1},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "rack_location": {"key": "properties.rackLocation", "type": "str"},
        "rack_serial_number": {"key": "properties.rackSerialNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        rack_location: Optional[str] = None,
        rack_serial_number: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        :keyword rack_location: The free-form description of the rack location. (e.g. “DTN Datacenter,
         Floor 3, Isle 9, Rack 2B”).
        :paramtype rack_location: str
        :keyword rack_serial_number: The globally unique identifier for the rack.
        :paramtype rack_serial_number: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.rack_location = rack_location
        self.rack_serial_number = rack_serial_number


class RackSku(Resource):
    """RackSku represents the SKU information of the rack.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar compute_machines: The list of machine SKUs and associated rack slot for the
     compute-dedicated machines in this rack model.
    :vartype compute_machines: list[~azure.mgmt.networkcloud.models.MachineSkuSlot]
    :ivar controller_machines: The list of machine SKUs and associated rack slot for the
     control-plane dedicated machines in this rack model.
    :vartype controller_machines: list[~azure.mgmt.networkcloud.models.MachineSkuSlot]
    :ivar description: The free-form text describing the rack.
    :vartype description: str
    :ivar max_cluster_slots: The maximum number of compute racks supported by an aggregator rack. 0
     if this is a compute rack or a rack for a single rack cluster(rackType="Single").
    :vartype max_cluster_slots: int
    :ivar provisioning_state: The provisioning state of the rack SKU resource. Known values are:
     "Canceled", "Failed", and "Succeeded".
    :vartype provisioning_state: str or ~azure.mgmt.networkcloud.models.RackSkuProvisioningState
    :ivar rack_type: The type of the rack. Known values are: "Aggregator", "Compute", and "Single".
    :vartype rack_type: str or ~azure.mgmt.networkcloud.models.RackSkuType
    :ivar storage_appliances: The list of appliance SKUs and associated rack slot for the storage
     appliance(s) in this rack model.
    :vartype storage_appliances: list[~azure.mgmt.networkcloud.models.StorageApplianceSkuSlot]
    :ivar supported_rack_sku_ids: The list of supported SKUs if the rack is an aggregator.
    :vartype supported_rack_sku_ids: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "compute_machines": {"readonly": True},
        "controller_machines": {"readonly": True},
        "description": {"readonly": True},
        "max_cluster_slots": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "rack_type": {"readonly": True},
        "storage_appliances": {"readonly": True},
        "supported_rack_sku_ids": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "compute_machines": {"key": "properties.computeMachines", "type": "[MachineSkuSlot]"},
        "controller_machines": {"key": "properties.controllerMachines", "type": "[MachineSkuSlot]"},
        "description": {"key": "properties.description", "type": "str"},
        "max_cluster_slots": {"key": "properties.maxClusterSlots", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "rack_type": {"key": "properties.rackType", "type": "str"},
        "storage_appliances": {"key": "properties.storageAppliances", "type": "[StorageApplianceSkuSlot]"},
        "supported_rack_sku_ids": {"key": "properties.supportedRackSkuIds", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.compute_machines = None
        self.controller_machines = None
        self.description = None
        self.max_cluster_slots = None
        self.provisioning_state = None
        self.rack_type = None
        self.storage_appliances = None
        self.supported_rack_sku_ids = None


class RackSkuList(_serialization.Model):
    """RackSkuList represents a list of rack SKUs.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of Rack SKUs.
    :vartype value: list[~azure.mgmt.networkcloud.models.RackSku]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[RackSku]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.RackSku"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of Rack SKUs.
        :paramtype value: list[~azure.mgmt.networkcloud.models.RackSku]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class RuntimeProtectionConfiguration(_serialization.Model):
    """RuntimeProtectionConfiguration represents the runtime protection configuration for the cluster.

    :ivar enforcement_level: The mode of operation for runtime protection. Known values are:
     "Audit", "Disabled", "OnDemand", "Passive", and "RealTime".
    :vartype enforcement_level: str or
     ~azure.mgmt.networkcloud.models.RuntimeProtectionEnforcementLevel
    """

    _attribute_map = {
        "enforcement_level": {"key": "enforcementLevel", "type": "str"},
    }

    def __init__(
        self, *, enforcement_level: Union[str, "_models.RuntimeProtectionEnforcementLevel"] = "Disabled", **kwargs: Any
    ) -> None:
        """
        :keyword enforcement_level: The mode of operation for runtime protection. Known values are:
         "Audit", "Disabled", "OnDemand", "Passive", and "RealTime".
        :paramtype enforcement_level: str or
         ~azure.mgmt.networkcloud.models.RuntimeProtectionEnforcementLevel
        """
        super().__init__(**kwargs)
        self.enforcement_level = enforcement_level


class RuntimeProtectionStatus(_serialization.Model):
    """RuntimeProtectionStatus represents the runtime protection status of the bare metal machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar definitions_last_updated: The timestamp when the malware definitions were last updated.
    :vartype definitions_last_updated: ~datetime.datetime
    :ivar definitions_version: The version of the malware definitions.
    :vartype definitions_version: str
    :ivar scan_completed_time: The timestamp of the most recently completed scan, or empty if there
     has never been a scan.
    :vartype scan_completed_time: ~datetime.datetime
    :ivar scan_scheduled_time: The timestamp of the most recently scheduled scan, or empty if no
     scan has been scheduled.
    :vartype scan_scheduled_time: ~datetime.datetime
    :ivar scan_started_time: The timestamp of the most recently started scan, or empty if there has
     never been a scan.
    :vartype scan_started_time: ~datetime.datetime
    """

    _validation = {
        "definitions_last_updated": {"readonly": True},
        "definitions_version": {"readonly": True},
        "scan_completed_time": {"readonly": True},
        "scan_scheduled_time": {"readonly": True},
        "scan_started_time": {"readonly": True},
    }

    _attribute_map = {
        "definitions_last_updated": {"key": "definitionsLastUpdated", "type": "iso-8601"},
        "definitions_version": {"key": "definitionsVersion", "type": "str"},
        "scan_completed_time": {"key": "scanCompletedTime", "type": "iso-8601"},
        "scan_scheduled_time": {"key": "scanScheduledTime", "type": "iso-8601"},
        "scan_started_time": {"key": "scanStartedTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.definitions_last_updated = None
        self.definitions_version = None
        self.scan_completed_time = None
        self.scan_scheduled_time = None
        self.scan_started_time = None


class SecretArchiveReference(_serialization.Model):
    """SecretArchiveReference represents the reference to a secret in a key vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_vault_id: The resource ID of the key vault containing the secret.
    :vartype key_vault_id: str
    :ivar secret_name: The name of the secret in the key vault.
    :vartype secret_name: str
    :ivar secret_version: The version of the secret in the key vault.
    :vartype secret_version: str
    """

    _validation = {
        "key_vault_id": {"readonly": True},
        "secret_name": {"readonly": True},
        "secret_version": {"readonly": True},
    }

    _attribute_map = {
        "key_vault_id": {"key": "keyVaultId", "type": "str"},
        "secret_name": {"key": "secretName", "type": "str"},
        "secret_version": {"key": "secretVersion", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.key_vault_id = None
        self.secret_name = None
        self.secret_version = None


class SecretRotationStatus(_serialization.Model):
    """SecretRotationStatus represents the status of a secret rotation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar expire_period_days: The maximum number of days the secret may be used before it must be
     changed.
    :vartype expire_period_days: int
    :ivar last_rotation_time: The date and time when the secret was last changed.
    :vartype last_rotation_time: ~datetime.datetime
    :ivar rotation_period_days: The number of days a secret exists before rotations will be
     attempted.
    :vartype rotation_period_days: int
    :ivar secret_archive_reference: The reference to the secret in a key vault.
    :vartype secret_archive_reference: ~azure.mgmt.networkcloud.models.SecretArchiveReference
    :ivar secret_type: The type name used to identify the purpose of the secret.
    :vartype secret_type: str
    """

    _validation = {
        "expire_period_days": {"readonly": True},
        "last_rotation_time": {"readonly": True},
        "rotation_period_days": {"readonly": True},
        "secret_archive_reference": {"readonly": True},
        "secret_type": {"readonly": True},
    }

    _attribute_map = {
        "expire_period_days": {"key": "expirePeriodDays", "type": "int"},
        "last_rotation_time": {"key": "lastRotationTime", "type": "iso-8601"},
        "rotation_period_days": {"key": "rotationPeriodDays", "type": "int"},
        "secret_archive_reference": {"key": "secretArchiveReference", "type": "SecretArchiveReference"},
        "secret_type": {"key": "secretType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.expire_period_days = None
        self.last_rotation_time = None
        self.rotation_period_days = None
        self.secret_archive_reference = None
        self.secret_type = None


class ServiceLoadBalancerBgpPeer(_serialization.Model):
    """ServiceLoadBalancerBgpPeer represents the configuration of the BGP service load balancer for
    the Kubernetes cluster.

    All required parameters must be populated in order to send to server.

    :ivar bfd_enabled: The indicator of BFD enablement for this BgpPeer. Known values are: "True"
     and "False".
    :vartype bfd_enabled: str or ~azure.mgmt.networkcloud.models.BfdEnabled
    :ivar bgp_multi_hop: The indicator to enable multi-hop peering support. Known values are:
     "True" and "False".
    :vartype bgp_multi_hop: str or ~azure.mgmt.networkcloud.models.BgpMultiHop
    :ivar hold_time: Field Deprecated. The field was previously optional, now it will have no
     defined behavior and will be ignored. The requested BGP hold time value. This field uses ISO
     8601 duration format, for example P1H.
    :vartype hold_time: str
    :ivar keep_alive_time: Field Deprecated. The field was previously optional, now it will have no
     defined behavior and will be ignored. The requested BGP keepalive time value. This field uses
     ISO 8601 duration format, for example P1H.
    :vartype keep_alive_time: str
    :ivar my_asn: The autonomous system number used for the local end of the BGP session.
    :vartype my_asn: int
    :ivar name: The name used to identify this BGP peer for association with a BGP advertisement.
     Required.
    :vartype name: str
    :ivar password: The authentication password for routers enforcing TCP MD5 authenticated
     sessions.
    :vartype password: str
    :ivar peer_address: The IPv4 or IPv6 address used to connect this BGP session. Required.
    :vartype peer_address: str
    :ivar peer_asn: The autonomous system number expected from the remote end of the BGP session.
     Required.
    :vartype peer_asn: int
    :ivar peer_port: The port used to connect this BGP session.
    :vartype peer_port: int
    """

    _validation = {
        "my_asn": {"maximum": 4294967295, "minimum": 0},
        "name": {"required": True, "pattern": r"^[a-z0-9]([a-z0-9.-]{0,61}[a-z0-9]){0,1}$"},
        "password": {"max_length": 80, "pattern": r"^[a-zA-Z0-9]{0,80}$"},
        "peer_address": {"required": True},
        "peer_asn": {"required": True, "maximum": 4294967295, "minimum": 0},
    }

    _attribute_map = {
        "bfd_enabled": {"key": "bfdEnabled", "type": "str"},
        "bgp_multi_hop": {"key": "bgpMultiHop", "type": "str"},
        "hold_time": {"key": "holdTime", "type": "str"},
        "keep_alive_time": {"key": "keepAliveTime", "type": "str"},
        "my_asn": {"key": "myAsn", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "peer_address": {"key": "peerAddress", "type": "str"},
        "peer_asn": {"key": "peerAsn", "type": "int"},
        "peer_port": {"key": "peerPort", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: str,
        peer_address: str,
        peer_asn: int,
        bfd_enabled: Optional[Union[str, "_models.BfdEnabled"]] = None,
        bgp_multi_hop: Union[str, "_models.BgpMultiHop"] = "False",
        hold_time: Optional[str] = None,
        keep_alive_time: Optional[str] = None,
        my_asn: Optional[int] = None,
        password: Optional[str] = None,
        peer_port: int = 179,
        **kwargs: Any
    ) -> None:
        """
        :keyword bfd_enabled: The indicator of BFD enablement for this BgpPeer. Known values are:
         "True" and "False".
        :paramtype bfd_enabled: str or ~azure.mgmt.networkcloud.models.BfdEnabled
        :keyword bgp_multi_hop: The indicator to enable multi-hop peering support. Known values are:
         "True" and "False".
        :paramtype bgp_multi_hop: str or ~azure.mgmt.networkcloud.models.BgpMultiHop
        :keyword hold_time: Field Deprecated. The field was previously optional, now it will have no
         defined behavior and will be ignored. The requested BGP hold time value. This field uses ISO
         8601 duration format, for example P1H.
        :paramtype hold_time: str
        :keyword keep_alive_time: Field Deprecated. The field was previously optional, now it will have
         no defined behavior and will be ignored. The requested BGP keepalive time value. This field
         uses ISO 8601 duration format, for example P1H.
        :paramtype keep_alive_time: str
        :keyword my_asn: The autonomous system number used for the local end of the BGP session.
        :paramtype my_asn: int
        :keyword name: The name used to identify this BGP peer for association with a BGP
         advertisement. Required.
        :paramtype name: str
        :keyword password: The authentication password for routers enforcing TCP MD5 authenticated
         sessions.
        :paramtype password: str
        :keyword peer_address: The IPv4 or IPv6 address used to connect this BGP session. Required.
        :paramtype peer_address: str
        :keyword peer_asn: The autonomous system number expected from the remote end of the BGP
         session. Required.
        :paramtype peer_asn: int
        :keyword peer_port: The port used to connect this BGP session.
        :paramtype peer_port: int
        """
        super().__init__(**kwargs)
        self.bfd_enabled = bfd_enabled
        self.bgp_multi_hop = bgp_multi_hop
        self.hold_time = hold_time
        self.keep_alive_time = keep_alive_time
        self.my_asn = my_asn
        self.name = name
        self.password = password
        self.peer_address = peer_address
        self.peer_asn = peer_asn
        self.peer_port = peer_port


class ServicePrincipalInformation(_serialization.Model):
    """ServicePrincipalInformation represents the details of the service principal to be used by the
    cluster during Arc Appliance installation.

    All required parameters must be populated in order to send to server.

    :ivar application_id: The application ID, also known as client ID, of the service principal.
     Required.
    :vartype application_id: str
    :ivar password: The password of the service principal. Required.
    :vartype password: str
    :ivar principal_id: The principal ID, also known as the object ID, of the service principal.
     Required.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID, also known as the directory ID, of the tenant in which the
     service principal is created. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "application_id": {"required": True},
        "password": {"required": True},
        "principal_id": {"required": True},
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "application_id": {"key": "applicationId", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, application_id: str, password: str, principal_id: str, tenant_id: str, **kwargs: Any) -> None:
        """
        :keyword application_id: The application ID, also known as client ID, of the service principal.
         Required.
        :paramtype application_id: str
        :keyword password: The password of the service principal. Required.
        :paramtype password: str
        :keyword principal_id: The principal ID, also known as the object ID, of the service principal.
         Required.
        :paramtype principal_id: str
        :keyword tenant_id: The tenant ID, also known as the directory ID, of the tenant in which the
         service principal is created. Required.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.application_id = application_id
        self.password = password
        self.principal_id = principal_id
        self.tenant_id = tenant_id


class SshPublicKey(_serialization.Model):
    """SshPublicKey represents the public key used to authenticate with a resource through SSH.

    All required parameters must be populated in order to send to server.

    :ivar key_data: The SSH public key data. Required.
    :vartype key_data: str
    """

    _validation = {
        "key_data": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "key_data": {"key": "keyData", "type": "str"},
    }

    def __init__(self, *, key_data: str, **kwargs: Any) -> None:
        """
        :keyword key_data: The SSH public key data. Required.
        :paramtype key_data: str
        """
        super().__init__(**kwargs)
        self.key_data = key_data


class StorageAppliance(TrackedResource):
    """StorageAppliance represents on-premises Network Cloud storage appliance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location of the cluster associated with the resource.
     Required.
    :vartype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar administrator_credentials: The credentials of the administrative interface on this
     storage appliance. Required.
    :vartype administrator_credentials: ~azure.mgmt.networkcloud.models.AdministrativeCredentials
    :ivar capacity: The total capacity of the storage appliance.
    :vartype capacity: int
    :ivar capacity_used: The amount of storage consumed.
    :vartype capacity_used: int
    :ivar cluster_id: The resource ID of the cluster this storage appliance is associated with.
    :vartype cluster_id: str
    :ivar detailed_status: The detailed status of the storage appliance. Known values are: "Error",
     "Available", and "Provisioning".
    :vartype detailed_status: str or ~azure.mgmt.networkcloud.models.StorageApplianceDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar management_ipv4_address: The endpoint for the management interface of the storage
     appliance.
    :vartype management_ipv4_address: str
    :ivar manufacturer: The manufacturer of the storage appliance.
    :vartype manufacturer: str
    :ivar model: The model of the storage appliance.
    :vartype model: str
    :ivar provisioning_state: The provisioning state of the storage appliance. Known values are:
     "Succeeded", "Failed", "Canceled", "Provisioning", and "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.networkcloud.models.StorageApplianceProvisioningState
    :ivar rack_id: The resource ID of the rack where this storage appliance resides. Required.
    :vartype rack_id: str
    :ivar rack_slot: The slot the storage appliance is in the rack based on the BOM configuration.
     Required.
    :vartype rack_slot: int
    :ivar remote_vendor_management_feature: The indicator of whether the storage appliance supports
     remote vendor management. Known values are: "Supported" and "Unsupported".
    :vartype remote_vendor_management_feature: str or
     ~azure.mgmt.networkcloud.models.RemoteVendorManagementFeature
    :ivar remote_vendor_management_status: The indicator of whether the remote vendor management
     feature is enabled or disabled, or unsupported if it is an unsupported feature. Known values
     are: "Enabled", "Disabled", and "Unsupported".
    :vartype remote_vendor_management_status: str or
     ~azure.mgmt.networkcloud.models.RemoteVendorManagementStatus
    :ivar secret_rotation_status: The list of statuses that represent secret rotation activity.
    :vartype secret_rotation_status: list[~azure.mgmt.networkcloud.models.SecretRotationStatus]
    :ivar serial_number: The serial number for the storage appliance. Required.
    :vartype serial_number: str
    :ivar storage_appliance_sku_id: The SKU for the storage appliance. Required.
    :vartype storage_appliance_sku_id: str
    :ivar version: The version of the storage appliance.
    :vartype version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "extended_location": {"required": True},
        "administrator_credentials": {"required": True},
        "capacity": {"readonly": True},
        "capacity_used": {"readonly": True},
        "cluster_id": {"readonly": True},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "management_ipv4_address": {"readonly": True},
        "manufacturer": {"readonly": True},
        "model": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "rack_id": {"required": True},
        "rack_slot": {"required": True, "maximum": 256, "minimum": 1},
        "remote_vendor_management_feature": {"readonly": True},
        "remote_vendor_management_status": {"readonly": True},
        "secret_rotation_status": {"readonly": True},
        "serial_number": {"required": True},
        "storage_appliance_sku_id": {"required": True},
        "version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "administrator_credentials": {
            "key": "properties.administratorCredentials",
            "type": "AdministrativeCredentials",
        },
        "capacity": {"key": "properties.capacity", "type": "int"},
        "capacity_used": {"key": "properties.capacityUsed", "type": "int"},
        "cluster_id": {"key": "properties.clusterId", "type": "str"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "management_ipv4_address": {"key": "properties.managementIpv4Address", "type": "str"},
        "manufacturer": {"key": "properties.manufacturer", "type": "str"},
        "model": {"key": "properties.model", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "rack_id": {"key": "properties.rackId", "type": "str"},
        "rack_slot": {"key": "properties.rackSlot", "type": "int"},
        "remote_vendor_management_feature": {"key": "properties.remoteVendorManagementFeature", "type": "str"},
        "remote_vendor_management_status": {"key": "properties.remoteVendorManagementStatus", "type": "str"},
        "secret_rotation_status": {"key": "properties.secretRotationStatus", "type": "[SecretRotationStatus]"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "storage_appliance_sku_id": {"key": "properties.storageApplianceSkuId", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        administrator_credentials: "_models.AdministrativeCredentials",
        rack_id: str,
        rack_slot: int,
        serial_number: str,
        storage_appliance_sku_id: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location of the cluster associated with the resource.
         Required.
        :paramtype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
        :keyword administrator_credentials: The credentials of the administrative interface on this
         storage appliance. Required.
        :paramtype administrator_credentials: ~azure.mgmt.networkcloud.models.AdministrativeCredentials
        :keyword rack_id: The resource ID of the rack where this storage appliance resides. Required.
        :paramtype rack_id: str
        :keyword rack_slot: The slot the storage appliance is in the rack based on the BOM
         configuration. Required.
        :paramtype rack_slot: int
        :keyword serial_number: The serial number for the storage appliance. Required.
        :paramtype serial_number: str
        :keyword storage_appliance_sku_id: The SKU for the storage appliance. Required.
        :paramtype storage_appliance_sku_id: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.administrator_credentials = administrator_credentials
        self.capacity = None
        self.capacity_used = None
        self.cluster_id = None
        self.detailed_status = None
        self.detailed_status_message = None
        self.management_ipv4_address = None
        self.manufacturer = None
        self.model = None
        self.provisioning_state = None
        self.rack_id = rack_id
        self.rack_slot = rack_slot
        self.remote_vendor_management_feature = None
        self.remote_vendor_management_status = None
        self.secret_rotation_status = None
        self.serial_number = serial_number
        self.storage_appliance_sku_id = storage_appliance_sku_id
        self.version = None


class StorageApplianceConfigurationData(_serialization.Model):
    """StorageApplianceConfigurationData represents configuration for the storage application.

    All required parameters must be populated in order to send to server.

    :ivar admin_credentials: The credentials of the administrative interface on this storage
     appliance. Required.
    :vartype admin_credentials: ~azure.mgmt.networkcloud.models.AdministrativeCredentials
    :ivar rack_slot: The slot that storage appliance is in the rack based on the BOM configuration.
     Required.
    :vartype rack_slot: int
    :ivar serial_number: The serial number of the appliance. Required.
    :vartype serial_number: str
    :ivar storage_appliance_name: The user-provided name for the storage appliance that will be
     created from this specification.
    :vartype storage_appliance_name: str
    """

    _validation = {
        "admin_credentials": {"required": True},
        "rack_slot": {"required": True, "maximum": 256, "minimum": 1},
        "serial_number": {"required": True},
        "storage_appliance_name": {"pattern": r"^([a-zA-Z0-9][a-zA-Z0-9-_]{0,28}[a-zA-Z0-9])$"},
    }

    _attribute_map = {
        "admin_credentials": {"key": "adminCredentials", "type": "AdministrativeCredentials"},
        "rack_slot": {"key": "rackSlot", "type": "int"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "storage_appliance_name": {"key": "storageApplianceName", "type": "str"},
    }

    def __init__(
        self,
        *,
        admin_credentials: "_models.AdministrativeCredentials",
        rack_slot: int,
        serial_number: str,
        storage_appliance_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword admin_credentials: The credentials of the administrative interface on this storage
         appliance. Required.
        :paramtype admin_credentials: ~azure.mgmt.networkcloud.models.AdministrativeCredentials
        :keyword rack_slot: The slot that storage appliance is in the rack based on the BOM
         configuration. Required.
        :paramtype rack_slot: int
        :keyword serial_number: The serial number of the appliance. Required.
        :paramtype serial_number: str
        :keyword storage_appliance_name: The user-provided name for the storage appliance that will be
         created from this specification.
        :paramtype storage_appliance_name: str
        """
        super().__init__(**kwargs)
        self.admin_credentials = admin_credentials
        self.rack_slot = rack_slot
        self.serial_number = serial_number
        self.storage_appliance_name = storage_appliance_name


class StorageApplianceEnableRemoteVendorManagementParameters(_serialization.Model):  # pylint: disable=name-too-long
    """StorageApplianceEnableRemoteVendorManagementParameters represents the body of the request to
    enable remote vendor management of a storage appliance.

    :ivar support_endpoints: Field Deprecated. This field is not used and will be rejected if
     provided. The list of IPv4 subnets (in CIDR format), IPv6 subnets (in CIDR format), or
     hostnames that the storage appliance needs accessible in order to turn on the remote vendor
     management.
    :vartype support_endpoints: list[str]
    """

    _attribute_map = {
        "support_endpoints": {"key": "supportEndpoints", "type": "[str]"},
    }

    def __init__(self, *, support_endpoints: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword support_endpoints: Field Deprecated. This field is not used and will be rejected if
         provided. The list of IPv4 subnets (in CIDR format), IPv6 subnets (in CIDR format), or
         hostnames that the storage appliance needs accessible in order to turn on the remote vendor
         management.
        :paramtype support_endpoints: list[str]
        """
        super().__init__(**kwargs)
        self.support_endpoints = support_endpoints


class StorageApplianceList(_serialization.Model):
    """StorageApplianceList represents a list of storage appliances.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of storage appliances.
    :vartype value: list[~azure.mgmt.networkcloud.models.StorageAppliance]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[StorageAppliance]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.StorageAppliance"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of storage appliances.
        :paramtype value: list[~azure.mgmt.networkcloud.models.StorageAppliance]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class StorageAppliancePatchParameters(_serialization.Model):
    """StorageAppliancePatchParameters represents the body of the request to patch storage appliance
    properties.

    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    :ivar serial_number: The serial number for the storage appliance.
    :vartype serial_number: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, serial_number: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        :keyword serial_number: The serial number for the storage appliance.
        :paramtype serial_number: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.serial_number = serial_number


class StorageApplianceSkuSlot(_serialization.Model):
    """StorageApplianceSkuSlot represents the single SKU and rack slot associated with the storage
    appliance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rack_slot: The position in the rack for the storage appliance.
    :vartype rack_slot: int
    :ivar capacity_gb: The maximum capacity of the storage appliance. Measured in gibibytes.
    :vartype capacity_gb: int
    :ivar model: The model of the storage appliance.
    :vartype model: str
    """

    _validation = {
        "rack_slot": {"readonly": True},
        "capacity_gb": {"readonly": True},
        "model": {"readonly": True},
    }

    _attribute_map = {
        "rack_slot": {"key": "rackSlot", "type": "int"},
        "capacity_gb": {"key": "properties.capacityGB", "type": "int"},
        "model": {"key": "properties.model", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.rack_slot = None
        self.capacity_gb = None
        self.model = None


class StorageProfile(_serialization.Model):
    """StorageProfile represents information about a disk.

    All required parameters must be populated in order to send to server.

    :ivar os_disk: The disk to use with this virtual machine. Required.
    :vartype os_disk: ~azure.mgmt.networkcloud.models.OsDisk
    :ivar volume_attachments: The resource IDs of volumes that are requested to be attached to the
     virtual machine.
    :vartype volume_attachments: list[str]
    """

    _validation = {
        "os_disk": {"required": True},
    }

    _attribute_map = {
        "os_disk": {"key": "osDisk", "type": "OsDisk"},
        "volume_attachments": {"key": "volumeAttachments", "type": "[str]"},
    }

    def __init__(
        self, *, os_disk: "_models.OsDisk", volume_attachments: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword os_disk: The disk to use with this virtual machine. Required.
        :paramtype os_disk: ~azure.mgmt.networkcloud.models.OsDisk
        :keyword volume_attachments: The resource IDs of volumes that are requested to be attached to
         the virtual machine.
        :paramtype volume_attachments: list[str]
        """
        super().__init__(**kwargs)
        self.os_disk = os_disk
        self.volume_attachments = volume_attachments


class StringKeyValuePair(_serialization.Model):
    """StringKeyValuePair represents a single entry in a mapping of keys to values.

    All required parameters must be populated in order to send to server.

    :ivar key: The key to the mapped value. Required.
    :vartype key: str
    :ivar value: The value of the mapping key. Required.
    :vartype value: str
    """

    _validation = {
        "key": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key: str, value: str, **kwargs: Any) -> None:
        """
        :keyword key: The key to the mapped value. Required.
        :paramtype key: str
        :keyword value: The value of the mapping key. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.value = value


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.networkcloud.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.networkcloud.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.networkcloud.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.networkcloud.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagsParameter(_serialization.Model):
    """TagsParameter represents the resource tags.

    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class TrunkedNetwork(TrackedResource):
    """TrunkedNetwork represents a network that utilizes multiple isolation domains and specified
    VLANs to create a trunked network.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location of the cluster associated with the resource.
     Required.
    :vartype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar associated_resource_ids: The list of resource IDs for the other Microsoft.NetworkCloud
     resources that have attached this network.
    :vartype associated_resource_ids: list[str]
    :ivar cluster_id: The resource ID of the Network Cloud cluster this trunked network is
     associated with.
    :vartype cluster_id: str
    :ivar detailed_status: The more detailed status of the trunked network. Known values are:
     "Error", "Available", and "Provisioning".
    :vartype detailed_status: str or ~azure.mgmt.networkcloud.models.TrunkedNetworkDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar hybrid_aks_clusters_associated_ids: Field Deprecated. These fields will be empty/omitted.
     The list of Hybrid AKS cluster resource IDs that are associated with this trunked network.
    :vartype hybrid_aks_clusters_associated_ids: list[str]
    :ivar hybrid_aks_plugin_type: Field Deprecated. The field was previously optional, now it will
     have no defined behavior and will be ignored. The network plugin type for Hybrid AKS. Known
     values are: "DPDK", "SRIOV", and "OSDevice".
    :vartype hybrid_aks_plugin_type: str or ~azure.mgmt.networkcloud.models.HybridAksPluginType
    :ivar interface_name: The default interface name for this trunked network in the virtual
     machine. This name can be overridden by the name supplied in the network attachment
     configuration of that virtual machine.
    :vartype interface_name: str
    :ivar isolation_domain_ids: The list of resource IDs representing the Network Fabric isolation
     domains. It can be any combination of l2IsolationDomain and l3IsolationDomain resources.
     Required.
    :vartype isolation_domain_ids: list[str]
    :ivar provisioning_state: The provisioning state of the trunked network. Known values are:
     "Succeeded", "Failed", "Canceled", "Provisioning", and "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.networkcloud.models.TrunkedNetworkProvisioningState
    :ivar virtual_machines_associated_ids: Field Deprecated. These fields will be empty/omitted.
     The list of virtual machine resource IDs, excluding any Hybrid AKS virtual machines, that are
     currently using this trunked network.
    :vartype virtual_machines_associated_ids: list[str]
    :ivar vlans: The list of vlans that are selected from the isolation domains for trunking.
     Required.
    :vartype vlans: list[int]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "extended_location": {"required": True},
        "associated_resource_ids": {"readonly": True},
        "cluster_id": {"readonly": True},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "hybrid_aks_clusters_associated_ids": {"readonly": True},
        "interface_name": {"max_length": 12, "pattern": r"^[a-zA-Z0-9@._-]*$"},
        "isolation_domain_ids": {"required": True, "min_items": 1},
        "provisioning_state": {"readonly": True},
        "virtual_machines_associated_ids": {"readonly": True},
        "vlans": {"required": True, "min_items": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "associated_resource_ids": {"key": "properties.associatedResourceIds", "type": "[str]"},
        "cluster_id": {"key": "properties.clusterId", "type": "str"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "hybrid_aks_clusters_associated_ids": {"key": "properties.hybridAksClustersAssociatedIds", "type": "[str]"},
        "hybrid_aks_plugin_type": {"key": "properties.hybridAksPluginType", "type": "str"},
        "interface_name": {"key": "properties.interfaceName", "type": "str"},
        "isolation_domain_ids": {"key": "properties.isolationDomainIds", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "virtual_machines_associated_ids": {"key": "properties.virtualMachinesAssociatedIds", "type": "[str]"},
        "vlans": {"key": "properties.vlans", "type": "[int]"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        isolation_domain_ids: List[str],
        vlans: List[int],
        tags: Optional[Dict[str, str]] = None,
        hybrid_aks_plugin_type: Optional[Union[str, "_models.HybridAksPluginType"]] = None,
        interface_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location of the cluster associated with the resource.
         Required.
        :paramtype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
        :keyword hybrid_aks_plugin_type: Field Deprecated. The field was previously optional, now it
         will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
         Known values are: "DPDK", "SRIOV", and "OSDevice".
        :paramtype hybrid_aks_plugin_type: str or ~azure.mgmt.networkcloud.models.HybridAksPluginType
        :keyword interface_name: The default interface name for this trunked network in the virtual
         machine. This name can be overridden by the name supplied in the network attachment
         configuration of that virtual machine.
        :paramtype interface_name: str
        :keyword isolation_domain_ids: The list of resource IDs representing the Network Fabric
         isolation domains. It can be any combination of l2IsolationDomain and l3IsolationDomain
         resources. Required.
        :paramtype isolation_domain_ids: list[str]
        :keyword vlans: The list of vlans that are selected from the isolation domains for trunking.
         Required.
        :paramtype vlans: list[int]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.associated_resource_ids = None
        self.cluster_id = None
        self.detailed_status = None
        self.detailed_status_message = None
        self.hybrid_aks_clusters_associated_ids = None
        self.hybrid_aks_plugin_type = hybrid_aks_plugin_type
        self.interface_name = interface_name
        self.isolation_domain_ids = isolation_domain_ids
        self.provisioning_state = None
        self.virtual_machines_associated_ids = None
        self.vlans = vlans


class TrunkedNetworkAttachmentConfiguration(_serialization.Model):
    """TrunkedNetworkAttachmentConfiguration represents the configuration of the attachment of a
    trunked network.

    All required parameters must be populated in order to send to server.

    :ivar network_id: The resource ID of the network that is being configured for attachment.
     Required.
    :vartype network_id: str
    :ivar plugin_type: The indicator of how this network will be utilized by the Kubernetes
     cluster. Known values are: "DPDK", "SRIOV", "OSDevice", "MACVLAN", and "IPVLAN".
    :vartype plugin_type: str or ~azure.mgmt.networkcloud.models.KubernetesPluginType
    """

    _validation = {
        "network_id": {"required": True},
    }

    _attribute_map = {
        "network_id": {"key": "networkId", "type": "str"},
        "plugin_type": {"key": "pluginType", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_id: str,
        plugin_type: Optional[Union[str, "_models.KubernetesPluginType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_id: The resource ID of the network that is being configured for attachment.
         Required.
        :paramtype network_id: str
        :keyword plugin_type: The indicator of how this network will be utilized by the Kubernetes
         cluster. Known values are: "DPDK", "SRIOV", "OSDevice", "MACVLAN", and "IPVLAN".
        :paramtype plugin_type: str or ~azure.mgmt.networkcloud.models.KubernetesPluginType
        """
        super().__init__(**kwargs)
        self.network_id = network_id
        self.plugin_type = plugin_type


class TrunkedNetworkList(_serialization.Model):
    """TrunkedNetworkList represents a list of trunked networks.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of trunked networks.
    :vartype value: list[~azure.mgmt.networkcloud.models.TrunkedNetwork]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[TrunkedNetwork]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.TrunkedNetwork"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of trunked networks.
        :paramtype value: list[~azure.mgmt.networkcloud.models.TrunkedNetwork]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class TrunkedNetworkPatchParameters(_serialization.Model):
    """TrunkedNetworkPatchParameters represents the body of the request to patch the Trunked network.

    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class ValidationThreshold(_serialization.Model):
    """ValidationThreshold indicates allowed machine and node hardware and deployment failures.

    All required parameters must be populated in order to send to server.

    :ivar grouping: Selection of how the type evaluation is applied to the cluster calculation.
     Required. Known values are: "PerCluster" and "PerRack".
    :vartype grouping: str or ~azure.mgmt.networkcloud.models.ValidationThresholdGrouping
    :ivar type: Selection of how the threshold should be evaluated. Required. Known values are:
     "CountSuccess" and "PercentSuccess".
    :vartype type: str or ~azure.mgmt.networkcloud.models.ValidationThresholdType
    :ivar value: The numeric threshold value. Required.
    :vartype value: int
    """

    _validation = {
        "grouping": {"required": True},
        "type": {"required": True},
        "value": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "grouping": {"key": "grouping", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "int"},
    }

    def __init__(
        self,
        *,
        grouping: Union[str, "_models.ValidationThresholdGrouping"],
        type: Union[str, "_models.ValidationThresholdType"],
        value: int,
        **kwargs: Any
    ) -> None:
        """
        :keyword grouping: Selection of how the type evaluation is applied to the cluster calculation.
         Required. Known values are: "PerCluster" and "PerRack".
        :paramtype grouping: str or ~azure.mgmt.networkcloud.models.ValidationThresholdGrouping
        :keyword type: Selection of how the threshold should be evaluated. Required. Known values are:
         "CountSuccess" and "PercentSuccess".
        :paramtype type: str or ~azure.mgmt.networkcloud.models.ValidationThresholdType
        :keyword value: The numeric threshold value. Required.
        :paramtype value: int
        """
        super().__init__(**kwargs)
        self.grouping = grouping
        self.type = type
        self.value = value


class VirtualMachine(TrackedResource):
    """VirtualMachine represents the on-premises Network Cloud virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location of the cluster associated with the resource.
     Required.
    :vartype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar admin_username: The name of the administrator to which the ssh public keys will be added
     into the authorized keys. Required.
    :vartype admin_username: str
    :ivar availability_zone: The cluster availability zone containing this virtual machine.
    :vartype availability_zone: str
    :ivar bare_metal_machine_id: The resource ID of the bare metal machine that hosts the virtual
     machine.
    :vartype bare_metal_machine_id: str
    :ivar boot_method: Selects the boot method for the virtual machine. Known values are: "UEFI"
     and "BIOS".
    :vartype boot_method: str or ~azure.mgmt.networkcloud.models.VirtualMachineBootMethod
    :ivar cloud_services_network_attachment: The cloud service network that provides platform-level
     services for the virtual machine. Required.
    :vartype cloud_services_network_attachment: ~azure.mgmt.networkcloud.models.NetworkAttachment
    :ivar cluster_id: The resource ID of the cluster the virtual machine is created for.
    :vartype cluster_id: str
    :ivar cpu_cores: The number of CPU cores in the virtual machine. Required.
    :vartype cpu_cores: int
    :ivar detailed_status: The more detailed status of the virtual machine. Known values are:
     "Available", "Error", "Provisioning", "Running", "Scheduling", "Stopped", "Terminating", and
     "Unknown".
    :vartype detailed_status: str or ~azure.mgmt.networkcloud.models.VirtualMachineDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar isolate_emulator_thread: Field Deprecated, the value will be ignored if provided. The
     indicator of whether one of the specified CPU cores is isolated to run the emulator thread for
     this virtual machine. Known values are: "True" and "False".
    :vartype isolate_emulator_thread: str or
     ~azure.mgmt.networkcloud.models.VirtualMachineIsolateEmulatorThread
    :ivar memory_size_gb: The memory size of the virtual machine. Allocations are measured in
     gibibytes. Required.
    :vartype memory_size_gb: int
    :ivar network_attachments: The list of network attachments to the virtual machine.
    :vartype network_attachments: list[~azure.mgmt.networkcloud.models.NetworkAttachment]
    :ivar network_data: The Base64 encoded cloud-init network data.
    :vartype network_data: str
    :ivar placement_hints: The scheduling hints for the virtual machine.
    :vartype placement_hints: list[~azure.mgmt.networkcloud.models.VirtualMachinePlacementHint]
    :ivar power_state: The power state of the virtual machine. Known values are: "On", "Off", and
     "Unknown".
    :vartype power_state: str or ~azure.mgmt.networkcloud.models.VirtualMachinePowerState
    :ivar provisioning_state: The provisioning state of the virtual machine. Known values are:
     "Succeeded", "Failed", "Canceled", "Provisioning", and "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.networkcloud.models.VirtualMachineProvisioningState
    :ivar ssh_public_keys: The list of ssh public keys. Each key will be added to the virtual
     machine using the cloud-init ssh_authorized_keys mechanism for the adminUsername.
    :vartype ssh_public_keys: list[~azure.mgmt.networkcloud.models.SshPublicKey]
    :ivar storage_profile: The storage profile that specifies size and other parameters about the
     disks related to the virtual machine. Required.
    :vartype storage_profile: ~azure.mgmt.networkcloud.models.StorageProfile
    :ivar user_data: The Base64 encoded cloud-init user data.
    :vartype user_data: str
    :ivar virtio_interface: Field Deprecated, use virtualizationModel instead. The type of the
     virtio interface. Known values are: "Modern" and "Transitional".
    :vartype virtio_interface: str or
     ~azure.mgmt.networkcloud.models.VirtualMachineVirtioInterfaceType
    :ivar vm_device_model: The type of the device model to use. Known values are: "T1" and "T2".
    :vartype vm_device_model: str or ~azure.mgmt.networkcloud.models.VirtualMachineDeviceModelType
    :ivar vm_image: The virtual machine image that is currently provisioned to the OS disk, using
     the full url and tag notation used to pull the image. Required.
    :vartype vm_image: str
    :ivar vm_image_repository_credentials: The credentials used to login to the image repository
     that has access to the specified image.
    :vartype vm_image_repository_credentials:
     ~azure.mgmt.networkcloud.models.ImageRepositoryCredentials
    :ivar volumes: The resource IDs of volumes that are attached to the virtual machine.
    :vartype volumes: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "extended_location": {"required": True},
        "admin_username": {"required": True, "max_length": 32, "min_length": 1, "pattern": r"^[a-z_][a-z0-9_]{0,31}$"},
        "availability_zone": {"readonly": True},
        "bare_metal_machine_id": {"readonly": True},
        "cloud_services_network_attachment": {"required": True},
        "cluster_id": {"readonly": True},
        "cpu_cores": {"required": True, "minimum": 2},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "memory_size_gb": {"required": True, "minimum": 1},
        "power_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "storage_profile": {"required": True},
        "vm_image": {"required": True},
        "volumes": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "admin_username": {"key": "properties.adminUsername", "type": "str"},
        "availability_zone": {"key": "properties.availabilityZone", "type": "str"},
        "bare_metal_machine_id": {"key": "properties.bareMetalMachineId", "type": "str"},
        "boot_method": {"key": "properties.bootMethod", "type": "str"},
        "cloud_services_network_attachment": {
            "key": "properties.cloudServicesNetworkAttachment",
            "type": "NetworkAttachment",
        },
        "cluster_id": {"key": "properties.clusterId", "type": "str"},
        "cpu_cores": {"key": "properties.cpuCores", "type": "int"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "isolate_emulator_thread": {"key": "properties.isolateEmulatorThread", "type": "str"},
        "memory_size_gb": {"key": "properties.memorySizeGB", "type": "int"},
        "network_attachments": {"key": "properties.networkAttachments", "type": "[NetworkAttachment]"},
        "network_data": {"key": "properties.networkData", "type": "str"},
        "placement_hints": {"key": "properties.placementHints", "type": "[VirtualMachinePlacementHint]"},
        "power_state": {"key": "properties.powerState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "ssh_public_keys": {"key": "properties.sshPublicKeys", "type": "[SshPublicKey]"},
        "storage_profile": {"key": "properties.storageProfile", "type": "StorageProfile"},
        "user_data": {"key": "properties.userData", "type": "str"},
        "virtio_interface": {"key": "properties.virtioInterface", "type": "str"},
        "vm_device_model": {"key": "properties.vmDeviceModel", "type": "str"},
        "vm_image": {"key": "properties.vmImage", "type": "str"},
        "vm_image_repository_credentials": {
            "key": "properties.vmImageRepositoryCredentials",
            "type": "ImageRepositoryCredentials",
        },
        "volumes": {"key": "properties.volumes", "type": "[str]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        admin_username: str,
        cloud_services_network_attachment: "_models.NetworkAttachment",
        cpu_cores: int,
        memory_size_gb: int,
        storage_profile: "_models.StorageProfile",
        vm_image: str,
        tags: Optional[Dict[str, str]] = None,
        boot_method: Union[str, "_models.VirtualMachineBootMethod"] = "UEFI",
        isolate_emulator_thread: Union[str, "_models.VirtualMachineIsolateEmulatorThread"] = "True",
        network_attachments: Optional[List["_models.NetworkAttachment"]] = None,
        network_data: Optional[str] = None,
        placement_hints: Optional[List["_models.VirtualMachinePlacementHint"]] = None,
        ssh_public_keys: Optional[List["_models.SshPublicKey"]] = None,
        user_data: Optional[str] = None,
        virtio_interface: Union[str, "_models.VirtualMachineVirtioInterfaceType"] = "Modern",
        vm_device_model: Union[str, "_models.VirtualMachineDeviceModelType"] = "T2",
        vm_image_repository_credentials: Optional["_models.ImageRepositoryCredentials"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location of the cluster associated with the resource.
         Required.
        :paramtype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
        :keyword admin_username: The name of the administrator to which the ssh public keys will be
         added into the authorized keys. Required.
        :paramtype admin_username: str
        :keyword boot_method: Selects the boot method for the virtual machine. Known values are: "UEFI"
         and "BIOS".
        :paramtype boot_method: str or ~azure.mgmt.networkcloud.models.VirtualMachineBootMethod
        :keyword cloud_services_network_attachment: The cloud service network that provides
         platform-level services for the virtual machine. Required.
        :paramtype cloud_services_network_attachment: ~azure.mgmt.networkcloud.models.NetworkAttachment
        :keyword cpu_cores: The number of CPU cores in the virtual machine. Required.
        :paramtype cpu_cores: int
        :keyword isolate_emulator_thread: Field Deprecated, the value will be ignored if provided. The
         indicator of whether one of the specified CPU cores is isolated to run the emulator thread for
         this virtual machine. Known values are: "True" and "False".
        :paramtype isolate_emulator_thread: str or
         ~azure.mgmt.networkcloud.models.VirtualMachineIsolateEmulatorThread
        :keyword memory_size_gb: The memory size of the virtual machine. Allocations are measured in
         gibibytes. Required.
        :paramtype memory_size_gb: int
        :keyword network_attachments: The list of network attachments to the virtual machine.
        :paramtype network_attachments: list[~azure.mgmt.networkcloud.models.NetworkAttachment]
        :keyword network_data: The Base64 encoded cloud-init network data.
        :paramtype network_data: str
        :keyword placement_hints: The scheduling hints for the virtual machine.
        :paramtype placement_hints: list[~azure.mgmt.networkcloud.models.VirtualMachinePlacementHint]
        :keyword ssh_public_keys: The list of ssh public keys. Each key will be added to the virtual
         machine using the cloud-init ssh_authorized_keys mechanism for the adminUsername.
        :paramtype ssh_public_keys: list[~azure.mgmt.networkcloud.models.SshPublicKey]
        :keyword storage_profile: The storage profile that specifies size and other parameters about
         the disks related to the virtual machine. Required.
        :paramtype storage_profile: ~azure.mgmt.networkcloud.models.StorageProfile
        :keyword user_data: The Base64 encoded cloud-init user data.
        :paramtype user_data: str
        :keyword virtio_interface: Field Deprecated, use virtualizationModel instead. The type of the
         virtio interface. Known values are: "Modern" and "Transitional".
        :paramtype virtio_interface: str or
         ~azure.mgmt.networkcloud.models.VirtualMachineVirtioInterfaceType
        :keyword vm_device_model: The type of the device model to use. Known values are: "T1" and "T2".
        :paramtype vm_device_model: str or
         ~azure.mgmt.networkcloud.models.VirtualMachineDeviceModelType
        :keyword vm_image: The virtual machine image that is currently provisioned to the OS disk,
         using the full url and tag notation used to pull the image. Required.
        :paramtype vm_image: str
        :keyword vm_image_repository_credentials: The credentials used to login to the image repository
         that has access to the specified image.
        :paramtype vm_image_repository_credentials:
         ~azure.mgmt.networkcloud.models.ImageRepositoryCredentials
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.admin_username = admin_username
        self.availability_zone = None
        self.bare_metal_machine_id = None
        self.boot_method = boot_method
        self.cloud_services_network_attachment = cloud_services_network_attachment
        self.cluster_id = None
        self.cpu_cores = cpu_cores
        self.detailed_status = None
        self.detailed_status_message = None
        self.isolate_emulator_thread = isolate_emulator_thread
        self.memory_size_gb = memory_size_gb
        self.network_attachments = network_attachments
        self.network_data = network_data
        self.placement_hints = placement_hints
        self.power_state = None
        self.provisioning_state = None
        self.ssh_public_keys = ssh_public_keys
        self.storage_profile = storage_profile
        self.user_data = user_data
        self.virtio_interface = virtio_interface
        self.vm_device_model = vm_device_model
        self.vm_image = vm_image
        self.vm_image_repository_credentials = vm_image_repository_credentials
        self.volumes = None


class VirtualMachineList(_serialization.Model):
    """VirtualMachineList represents a list of virtual machines.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of virtual machines.
    :vartype value: list[~azure.mgmt.networkcloud.models.VirtualMachine]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[VirtualMachine]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.VirtualMachine"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of virtual machines.
        :paramtype value: list[~azure.mgmt.networkcloud.models.VirtualMachine]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class VirtualMachinePatchParameters(_serialization.Model):
    """VirtualMachinePatchParameters represents the body of the request to patch the virtual machine.

    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    :ivar vm_image_repository_credentials: The credentials used to login to the image repository
     that has access to the specified image.
    :vartype vm_image_repository_credentials:
     ~azure.mgmt.networkcloud.models.ImageRepositoryCredentials
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "vm_image_repository_credentials": {
            "key": "properties.vmImageRepositoryCredentials",
            "type": "ImageRepositoryCredentials",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        vm_image_repository_credentials: Optional["_models.ImageRepositoryCredentials"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        :keyword vm_image_repository_credentials: The credentials used to login to the image repository
         that has access to the specified image.
        :paramtype vm_image_repository_credentials:
         ~azure.mgmt.networkcloud.models.ImageRepositoryCredentials
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.vm_image_repository_credentials = vm_image_repository_credentials


class VirtualMachinePlacementHint(_serialization.Model):
    """VirtualMachinePlacementHint represents a single scheduling hint of the virtual machine.

    All required parameters must be populated in order to send to server.

    :ivar hint_type: The specification of whether this hint supports affinity or anti-affinity with
     the referenced resources. Required. Known values are: "Affinity" and "AntiAffinity".
    :vartype hint_type: str or ~azure.mgmt.networkcloud.models.VirtualMachinePlacementHintType
    :ivar resource_id: The resource ID of the target object that the placement hints will be
     checked against, e.g., the bare metal node to host the virtual machine. Required.
    :vartype resource_id: str
    :ivar scheduling_execution: The indicator of whether the hint is a hard or soft requirement
     during scheduling. Required. Known values are: "Hard" and "Soft".
    :vartype scheduling_execution: str or
     ~azure.mgmt.networkcloud.models.VirtualMachineSchedulingExecution
    :ivar scope: The scope for the virtual machine affinity or anti-affinity placement hint. It
     should always be "Machine" in the case of node affinity. Required. Known values are: "Rack" and
     "Machine".
    :vartype scope: str or
     ~azure.mgmt.networkcloud.models.VirtualMachinePlacementHintPodAffinityScope
    """

    _validation = {
        "hint_type": {"required": True},
        "resource_id": {"required": True},
        "scheduling_execution": {"required": True},
        "scope": {"required": True},
    }

    _attribute_map = {
        "hint_type": {"key": "hintType", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "scheduling_execution": {"key": "schedulingExecution", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(
        self,
        *,
        hint_type: Union[str, "_models.VirtualMachinePlacementHintType"],
        resource_id: str,
        scheduling_execution: Union[str, "_models.VirtualMachineSchedulingExecution"],
        scope: Union[str, "_models.VirtualMachinePlacementHintPodAffinityScope"],
        **kwargs: Any
    ) -> None:
        """
        :keyword hint_type: The specification of whether this hint supports affinity or anti-affinity
         with the referenced resources. Required. Known values are: "Affinity" and "AntiAffinity".
        :paramtype hint_type: str or ~azure.mgmt.networkcloud.models.VirtualMachinePlacementHintType
        :keyword resource_id: The resource ID of the target object that the placement hints will be
         checked against, e.g., the bare metal node to host the virtual machine. Required.
        :paramtype resource_id: str
        :keyword scheduling_execution: The indicator of whether the hint is a hard or soft requirement
         during scheduling. Required. Known values are: "Hard" and "Soft".
        :paramtype scheduling_execution: str or
         ~azure.mgmt.networkcloud.models.VirtualMachineSchedulingExecution
        :keyword scope: The scope for the virtual machine affinity or anti-affinity placement hint. It
         should always be "Machine" in the case of node affinity. Required. Known values are: "Rack" and
         "Machine".
        :paramtype scope: str or
         ~azure.mgmt.networkcloud.models.VirtualMachinePlacementHintPodAffinityScope
        """
        super().__init__(**kwargs)
        self.hint_type = hint_type
        self.resource_id = resource_id
        self.scheduling_execution = scheduling_execution
        self.scope = scope


class VirtualMachinePowerOffParameters(_serialization.Model):
    """VirtualMachinePowerOffParameters represents the body of the request to power off virtual
    machine.

    :ivar skip_shutdown: The indicator of whether to skip the graceful OS shutdown and power off
     the virtual machine immediately. Known values are: "True" and "False".
    :vartype skip_shutdown: str or ~azure.mgmt.networkcloud.models.SkipShutdown
    """

    _attribute_map = {
        "skip_shutdown": {"key": "skipShutdown", "type": "str"},
    }

    def __init__(self, *, skip_shutdown: Union[str, "_models.SkipShutdown"] = "False", **kwargs: Any) -> None:
        """
        :keyword skip_shutdown: The indicator of whether to skip the graceful OS shutdown and power off
         the virtual machine immediately. Known values are: "True" and "False".
        :paramtype skip_shutdown: str or ~azure.mgmt.networkcloud.models.SkipShutdown
        """
        super().__init__(**kwargs)
        self.skip_shutdown = skip_shutdown


class Volume(TrackedResource):
    """Volume represents storage made available for use by resources running on the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkcloud.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The extended location of the cluster associated with the resource.
     Required.
    :vartype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
    :ivar attached_to: The list of resource IDs that attach the volume. It may include virtual
     machines and Hybrid AKS clusters.
    :vartype attached_to: list[str]
    :ivar detailed_status: The more detailed status of the volume. Known values are: "Error",
     "Active", and "Provisioning".
    :vartype detailed_status: str or ~azure.mgmt.networkcloud.models.VolumeDetailedStatus
    :ivar detailed_status_message: The descriptive message about the current detailed status.
    :vartype detailed_status_message: str
    :ivar provisioning_state: The provisioning state of the volume. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.networkcloud.models.VolumeProvisioningState
    :ivar serial_number: The unique identifier of the volume.
    :vartype serial_number: str
    :ivar size_mi_b: The size of the allocation for this volume in Mebibytes. Required.
    :vartype size_mi_b: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "extended_location": {"required": True},
        "attached_to": {"readonly": True},
        "detailed_status": {"readonly": True},
        "detailed_status_message": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "serial_number": {"readonly": True},
        "size_mi_b": {"required": True, "minimum": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "attached_to": {"key": "properties.attachedTo", "type": "[str]"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "str"},
        "detailed_status_message": {"key": "properties.detailedStatusMessage", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "size_mi_b": {"key": "properties.sizeMiB", "type": "int"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        size_mi_b: int,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The extended location of the cluster associated with the resource.
         Required.
        :paramtype extended_location: ~azure.mgmt.networkcloud.models.ExtendedLocation
        :keyword size_mi_b: The size of the allocation for this volume in Mebibytes. Required.
        :paramtype size_mi_b: int
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.attached_to = None
        self.detailed_status = None
        self.detailed_status_message = None
        self.provisioning_state = None
        self.serial_number = None
        self.size_mi_b = size_mi_b


class VolumeList(_serialization.Model):
    """VolumeList represents a list of volumes.

    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    :ivar value: The list of volumes.
    :vartype value: list[~azure.mgmt.networkcloud.models.Volume]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Volume]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.Volume"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        :keyword value: The list of volumes.
        :paramtype value: list[~azure.mgmt.networkcloud.models.Volume]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class VolumePatchParameters(_serialization.Model):
    """VolumePatchParameters represents the body of the request to patch the volume resource.

    :ivar tags: The Azure resource tags that will replace the existing ones.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: The Azure resource tags that will replace the existing ones.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags
