# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DeviceConnectionStateEventProperties(Model):
    """Schema of the Data property of an EventGridEvent for a device connection
    state event (DeviceConnected, DeviceDisconnected).

    :param device_id: The unique identifier of the device. This case-sensitive
     string can be up to 128 characters long, and supports ASCII 7-bit
     alphanumeric characters plus the following special characters: - : . + % _
     &#35; * ? ! ( ) , = @ ; $ '.
    :type device_id: str
    :param module_id: The unique identifier of the module. This case-sensitive
     string can be up to 128 characters long, and supports ASCII 7-bit
     alphanumeric characters plus the following special characters: - : . + % _
     &#35; * ? ! ( ) , = @ ; $ '.
    :type module_id: str
    :param hub_name: Name of the IoT Hub where the device was created or
     deleted.
    :type hub_name: str
    :param device_connection_state_event_info: Information about the device
     connection state event.
    :type device_connection_state_event_info:
     ~azure.eventgrid.models.DeviceConnectionStateEventInfo
    """

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'module_id': {'key': 'moduleId', 'type': 'str'},
        'hub_name': {'key': 'hubName', 'type': 'str'},
        'device_connection_state_event_info': {'key': 'deviceConnectionStateEventInfo', 'type': 'DeviceConnectionStateEventInfo'},
    }

    def __init__(self, **kwargs):
        super(DeviceConnectionStateEventProperties, self).__init__(**kwargs)
        self.device_id = kwargs.get('device_id', None)
        self.module_id = kwargs.get('module_id', None)
        self.hub_name = kwargs.get('hub_name', None)
        self.device_connection_state_event_info = kwargs.get('device_connection_state_event_info', None)
