# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class ApplicationCreateObject(Model):
    """Properties for creating a new LUIS Application.

    All required parameters must be populated in order to send to Azure.

    :param culture: Required. The culture for the new application. It is the
     language that your app understands and speaks. E.g.: "en-us". Note: the
     culture cannot be changed after the app is created.
    :type culture: str
    :param domain: The domain for the new application. Optional. E.g.: Comics.
    :type domain: str
    :param description: Description of the new application. Optional.
    :type description: str
    :param initial_version_id: The initial version ID. Optional. Default value
     is: "0.1"
    :type initial_version_id: str
    :param usage_scenario: Defines the scenario for the new application.
     Optional. E.g.: IoT.
    :type usage_scenario: str
    :param name: Required. The name for the new application.
    :type name: str
    """

    _validation = {
        'culture': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'culture': {'key': 'culture', 'type': 'str'},
        'domain': {'key': 'domain', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'initial_version_id': {'key': 'initialVersionId', 'type': 'str'},
        'usage_scenario': {'key': 'usageScenario', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationCreateObject, self).__init__(**kwargs)
        self.culture = kwargs.get('culture', None)
        self.domain = kwargs.get('domain', None)
        self.description = kwargs.get('description', None)
        self.initial_version_id = kwargs.get('initial_version_id', None)
        self.usage_scenario = kwargs.get('usage_scenario', None)
        self.name = kwargs.get('name', None)


class ApplicationInfoResponse(Model):
    """Response containing the Application Info.

    :param id: The ID (GUID) of the application.
    :type id: str
    :param name: The name of the application.
    :type name: str
    :param description: The description of the application.
    :type description: str
    :param culture: The culture of the application. For example, "en-us".
    :type culture: str
    :param usage_scenario: Defines the scenario for the new application.
     Optional. For example, IoT.
    :type usage_scenario: str
    :param domain: The domain for the new application. Optional. For example,
     Comics.
    :type domain: str
    :param versions_count: Amount of model versions within the application.
    :type versions_count: int
    :param created_date_time: The version's creation timestamp.
    :type created_date_time: str
    :param endpoints: The Runtime endpoint URL for this model version.
    :type endpoints: object
    :param endpoint_hits_count: Number of calls made to this endpoint.
    :type endpoint_hits_count: int
    :param active_version: The version ID currently marked as active.
    :type active_version: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'culture': {'key': 'culture', 'type': 'str'},
        'usage_scenario': {'key': 'usageScenario', 'type': 'str'},
        'domain': {'key': 'domain', 'type': 'str'},
        'versions_count': {'key': 'versionsCount', 'type': 'int'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': 'object'},
        'endpoint_hits_count': {'key': 'endpointHitsCount', 'type': 'int'},
        'active_version': {'key': 'activeVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationInfoResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.culture = kwargs.get('culture', None)
        self.usage_scenario = kwargs.get('usage_scenario', None)
        self.domain = kwargs.get('domain', None)
        self.versions_count = kwargs.get('versions_count', None)
        self.created_date_time = kwargs.get('created_date_time', None)
        self.endpoints = kwargs.get('endpoints', None)
        self.endpoint_hits_count = kwargs.get('endpoint_hits_count', None)
        self.active_version = kwargs.get('active_version', None)


class ApplicationPublishObject(Model):
    """Object model for publishing a specific application version.

    :param version_id: The version ID to publish.
    :type version_id: str
    :param is_staging: Indicates if the staging slot should be used, instead
     of the Production one. Default value: False .
    :type is_staging: bool
    """

    _attribute_map = {
        'version_id': {'key': 'versionId', 'type': 'str'},
        'is_staging': {'key': 'isStaging', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ApplicationPublishObject, self).__init__(**kwargs)
        self.version_id = kwargs.get('version_id', None)
        self.is_staging = kwargs.get('is_staging', False)


class ApplicationSettings(Model):
    """The application settings.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The application ID.
    :type id: str
    :param is_public: Required. Setting your application as public allows
     other people to use your application's endpoint using their own keys for
     billing purposes.
    :type is_public: bool
    """

    _validation = {
        'id': {'required': True},
        'is_public': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'is_public': {'key': 'public', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ApplicationSettings, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.is_public = kwargs.get('is_public', None)


class ApplicationSettingUpdateObject(Model):
    """Object model for updating an application's settings.

    :param is_public: Setting your application as public allows other people
     to use your application's endpoint using their own keys.
    :type is_public: bool
    """

    _attribute_map = {
        'is_public': {'key': 'public', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ApplicationSettingUpdateObject, self).__init__(**kwargs)
        self.is_public = kwargs.get('is_public', None)


class ApplicationUpdateObject(Model):
    """Object model for updating the name or description of an application.

    :param name: The application's new name.
    :type name: str
    :param description: The application's new description.
    :type description: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationUpdateObject, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)


class AppVersionSettingObject(Model):
    """Object model of an application version setting.

    :param name: The application version setting name.
    :type name: str
    :param value: The application version setting value.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AppVersionSettingObject, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class AvailableCulture(Model):
    """Available culture for using in a new application.

    :param name: The language name.
    :type name: str
    :param code: The ISO value for the language.
    :type code: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AvailableCulture, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.code = kwargs.get('code', None)


class AvailablePrebuiltEntityModel(Model):
    """Available Prebuilt entity model for using in an application.

    :param name: The entity name.
    :type name: str
    :param description: The entity description and usage information.
    :type description: str
    :param examples: Usage examples.
    :type examples: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'examples': {'key': 'examples', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AvailablePrebuiltEntityModel, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.examples = kwargs.get('examples', None)


class AzureAccountInfoObject(Model):
    """Defines the Azure account information object.

    All required parameters must be populated in order to send to Azure.

    :param azure_subscription_id: Required. The id for the Azure subscription.
    :type azure_subscription_id: str
    :param resource_group: Required. The Azure resource group name.
    :type resource_group: str
    :param account_name: Required. The Azure account name.
    :type account_name: str
    """

    _validation = {
        'azure_subscription_id': {'required': True},
        'resource_group': {'required': True},
        'account_name': {'required': True},
    }

    _attribute_map = {
        'azure_subscription_id': {'key': 'azureSubscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureAccountInfoObject, self).__init__(**kwargs)
        self.azure_subscription_id = kwargs.get('azure_subscription_id', None)
        self.resource_group = kwargs.get('resource_group', None)
        self.account_name = kwargs.get('account_name', None)


class BatchLabelExample(Model):
    """Response when adding a batch of labeled example utterances.

    :param value:
    :type value:
     ~azure.cognitiveservices.language.luis.authoring.models.LabelExampleResponse
    :param has_error:
    :type has_error: bool
    :param error:
    :type error:
     ~azure.cognitiveservices.language.luis.authoring.models.OperationStatus
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'LabelExampleResponse'},
        'has_error': {'key': 'hasError', 'type': 'bool'},
        'error': {'key': 'error', 'type': 'OperationStatus'},
    }

    def __init__(self, **kwargs):
        super(BatchLabelExample, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.has_error = kwargs.get('has_error', None)
        self.error = kwargs.get('error', None)


class ChildEntity(Model):
    """The base child entity type.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID (GUID) belonging to a child entity.
    :type id: str
    :param name: The name of a child entity.
    :type name: str
    :param instance_of: Instance of Model.
    :type instance_of: str
    :param type_id: The type ID of the Entity Model.
    :type type_id: int
    :param readable_type: Possible values include: 'Entity Extractor', 'Child
     Entity Extractor', 'Hierarchical Entity Extractor', 'Hierarchical Child
     Entity Extractor', 'Composite Entity Extractor', 'List Entity Extractor',
     'Prebuilt Entity Extractor', 'Intent Classifier', 'Pattern.Any Entity
     Extractor', 'Closed List Entity Extractor', 'Regex Entity Extractor'
    :type readable_type: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    :param children: List of children
    :type children:
     list[~azure.cognitiveservices.language.luis.authoring.models.ChildEntity]
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'instance_of': {'key': 'instanceOf', 'type': 'str'},
        'type_id': {'key': 'typeId', 'type': 'int'},
        'readable_type': {'key': 'readableType', 'type': 'str'},
        'children': {'key': 'children', 'type': '[ChildEntity]'},
    }

    def __init__(self, **kwargs):
        super(ChildEntity, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.instance_of = kwargs.get('instance_of', None)
        self.type_id = kwargs.get('type_id', None)
        self.readable_type = kwargs.get('readable_type', None)
        self.children = kwargs.get('children', None)


class ChildEntityModelCreateObject(Model):
    """A child entity extractor create object.

    :param children: Child entities.
    :type children:
     list[~azure.cognitiveservices.language.luis.authoring.models.ChildEntityModelCreateObject]
    :param name: Entity name.
    :type name: str
    :param instance_of: The instance of model name
    :type instance_of: str
    """

    _attribute_map = {
        'children': {'key': 'children', 'type': '[ChildEntityModelCreateObject]'},
        'name': {'key': 'name', 'type': 'str'},
        'instance_of': {'key': 'instanceOf', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ChildEntityModelCreateObject, self).__init__(**kwargs)
        self.children = kwargs.get('children', None)
        self.name = kwargs.get('name', None)
        self.instance_of = kwargs.get('instance_of', None)


class ClosedList(Model):
    """Exported Model - A list entity.

    :param name: Name of the list entity.
    :type name: str
    :param sub_lists: Sublists for the list entity.
    :type sub_lists:
     list[~azure.cognitiveservices.language.luis.authoring.models.SubClosedList]
    :param roles:
    :type roles: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'sub_lists': {'key': 'subLists', 'type': '[SubClosedList]'},
        'roles': {'key': 'roles', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ClosedList, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.sub_lists = kwargs.get('sub_lists', None)
        self.roles = kwargs.get('roles', None)


class ClosedListEntityExtractor(Model):
    """List Entity Extractor.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the Entity Model.
    :type id: str
    :param name: Name of the Entity Model.
    :type name: str
    :param type_id: The type ID of the Entity Model.
    :type type_id: int
    :param readable_type: Required. Possible values include: 'Entity
     Extractor', 'Child Entity Extractor', 'Hierarchical Entity Extractor',
     'Hierarchical Child Entity Extractor', 'Composite Entity Extractor', 'List
     Entity Extractor', 'Prebuilt Entity Extractor', 'Intent Classifier',
     'Pattern.Any Entity Extractor', 'Closed List Entity Extractor', 'Regex
     Entity Extractor'
    :type readable_type: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    :param roles:
    :type roles:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityRole]
    :param sub_lists: List of sublists.
    :type sub_lists:
     list[~azure.cognitiveservices.language.luis.authoring.models.SubClosedListResponse]
    """

    _validation = {
        'id': {'required': True},
        'readable_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type_id': {'key': 'typeId', 'type': 'int'},
        'readable_type': {'key': 'readableType', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[EntityRole]'},
        'sub_lists': {'key': 'subLists', 'type': '[SubClosedListResponse]'},
    }

    def __init__(self, **kwargs):
        super(ClosedListEntityExtractor, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type_id = kwargs.get('type_id', None)
        self.readable_type = kwargs.get('readable_type', None)
        self.roles = kwargs.get('roles', None)
        self.sub_lists = kwargs.get('sub_lists', None)


class ClosedListModelCreateObject(Model):
    """Object model for creating a list entity.

    :param sub_lists: Sublists for the feature.
    :type sub_lists:
     list[~azure.cognitiveservices.language.luis.authoring.models.WordListObject]
    :param name: Name of the list entity.
    :type name: str
    """

    _attribute_map = {
        'sub_lists': {'key': 'subLists', 'type': '[WordListObject]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClosedListModelCreateObject, self).__init__(**kwargs)
        self.sub_lists = kwargs.get('sub_lists', None)
        self.name = kwargs.get('name', None)


class ClosedListModelPatchObject(Model):
    """Object model for adding a batch of sublists to an existing list entity.

    :param sub_lists: Sublists to add.
    :type sub_lists:
     list[~azure.cognitiveservices.language.luis.authoring.models.WordListObject]
    """

    _attribute_map = {
        'sub_lists': {'key': 'subLists', 'type': '[WordListObject]'},
    }

    def __init__(self, **kwargs):
        super(ClosedListModelPatchObject, self).__init__(**kwargs)
        self.sub_lists = kwargs.get('sub_lists', None)


class ClosedListModelUpdateObject(Model):
    """Object model for updating a list entity.

    :param sub_lists: The new sublists for the feature.
    :type sub_lists:
     list[~azure.cognitiveservices.language.luis.authoring.models.WordListObject]
    :param name: The new name of the list entity.
    :type name: str
    """

    _attribute_map = {
        'sub_lists': {'key': 'subLists', 'type': '[WordListObject]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClosedListModelUpdateObject, self).__init__(**kwargs)
        self.sub_lists = kwargs.get('sub_lists', None)
        self.name = kwargs.get('name', None)


class CollaboratorsArray(Model):
    """CollaboratorsArray.

    :param emails: The email address of the users.
    :type emails: list[str]
    """

    _attribute_map = {
        'emails': {'key': 'emails', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(CollaboratorsArray, self).__init__(**kwargs)
        self.emails = kwargs.get('emails', None)


class CompositeChildModelCreateObject(Model):
    """CompositeChildModelCreateObject.

    :param name:
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CompositeChildModelCreateObject, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class CompositeEntityExtractor(Model):
    """A Composite Entity Extractor.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the Entity Model.
    :type id: str
    :param name: Name of the Entity Model.
    :type name: str
    :param type_id: The type ID of the Entity Model.
    :type type_id: int
    :param readable_type: Required. Possible values include: 'Entity
     Extractor', 'Child Entity Extractor', 'Hierarchical Entity Extractor',
     'Hierarchical Child Entity Extractor', 'Composite Entity Extractor', 'List
     Entity Extractor', 'Prebuilt Entity Extractor', 'Intent Classifier',
     'Pattern.Any Entity Extractor', 'Closed List Entity Extractor', 'Regex
     Entity Extractor'
    :type readable_type: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    :param roles:
    :type roles:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityRole]
    :param children: List of child entities.
    :type children:
     list[~azure.cognitiveservices.language.luis.authoring.models.ChildEntity]
    """

    _validation = {
        'id': {'required': True},
        'readable_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type_id': {'key': 'typeId', 'type': 'int'},
        'readable_type': {'key': 'readableType', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[EntityRole]'},
        'children': {'key': 'children', 'type': '[ChildEntity]'},
    }

    def __init__(self, **kwargs):
        super(CompositeEntityExtractor, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type_id = kwargs.get('type_id', None)
        self.readable_type = kwargs.get('readable_type', None)
        self.roles = kwargs.get('roles', None)
        self.children = kwargs.get('children', None)


class CompositeEntityModel(Model):
    """A composite entity extractor.

    :param children: Child entities.
    :type children: list[str]
    :param name: Entity name.
    :type name: str
    """

    _attribute_map = {
        'children': {'key': 'children', 'type': '[str]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CompositeEntityModel, self).__init__(**kwargs)
        self.children = kwargs.get('children', None)
        self.name = kwargs.get('name', None)


class CustomPrebuiltModel(Model):
    """A Custom Prebuilt model.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the Entity Model.
    :type id: str
    :param name: Name of the Entity Model.
    :type name: str
    :param type_id: The type ID of the Entity Model.
    :type type_id: int
    :param readable_type: Required. Possible values include: 'Entity
     Extractor', 'Child Entity Extractor', 'Hierarchical Entity Extractor',
     'Hierarchical Child Entity Extractor', 'Composite Entity Extractor', 'List
     Entity Extractor', 'Prebuilt Entity Extractor', 'Intent Classifier',
     'Pattern.Any Entity Extractor', 'Closed List Entity Extractor', 'Regex
     Entity Extractor'
    :type readable_type: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    :param custom_prebuilt_domain_name: The domain name.
    :type custom_prebuilt_domain_name: str
    :param custom_prebuilt_model_name: The intent name or entity name.
    :type custom_prebuilt_model_name: str
    :param roles:
    :type roles:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityRole]
    """

    _validation = {
        'id': {'required': True},
        'readable_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type_id': {'key': 'typeId', 'type': 'int'},
        'readable_type': {'key': 'readableType', 'type': 'str'},
        'custom_prebuilt_domain_name': {'key': 'customPrebuiltDomainName', 'type': 'str'},
        'custom_prebuilt_model_name': {'key': 'customPrebuiltModelName', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[EntityRole]'},
    }

    def __init__(self, **kwargs):
        super(CustomPrebuiltModel, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type_id = kwargs.get('type_id', None)
        self.readable_type = kwargs.get('readable_type', None)
        self.custom_prebuilt_domain_name = kwargs.get('custom_prebuilt_domain_name', None)
        self.custom_prebuilt_model_name = kwargs.get('custom_prebuilt_model_name', None)
        self.roles = kwargs.get('roles', None)


class EndpointInfo(Model):
    """The base class "ProductionOrStagingEndpointInfo" inherits from.

    :param version_id: The version ID to publish.
    :type version_id: str
    :param is_staging: Indicates if the staging slot should be used, instead
     of the Production one.
    :type is_staging: bool
    :param endpoint_url: The Runtime endpoint URL for this model version.
    :type endpoint_url: str
    :param region: The target region that the application is published to.
    :type region: str
    :param assigned_endpoint_key: The endpoint key.
    :type assigned_endpoint_key: str
    :param endpoint_region: The endpoint's region.
    :type endpoint_region: str
    :param failed_regions: Regions where publishing failed.
    :type failed_regions: str
    :param published_date_time: Timestamp when was last published.
    :type published_date_time: str
    """

    _attribute_map = {
        'version_id': {'key': 'versionId', 'type': 'str'},
        'is_staging': {'key': 'isStaging', 'type': 'bool'},
        'endpoint_url': {'key': 'endpointUrl', 'type': 'str'},
        'region': {'key': 'region', 'type': 'str'},
        'assigned_endpoint_key': {'key': 'assignedEndpointKey', 'type': 'str'},
        'endpoint_region': {'key': 'endpointRegion', 'type': 'str'},
        'failed_regions': {'key': 'failedRegions', 'type': 'str'},
        'published_date_time': {'key': 'publishedDateTime', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EndpointInfo, self).__init__(**kwargs)
        self.version_id = kwargs.get('version_id', None)
        self.is_staging = kwargs.get('is_staging', None)
        self.endpoint_url = kwargs.get('endpoint_url', None)
        self.region = kwargs.get('region', None)
        self.assigned_endpoint_key = kwargs.get('assigned_endpoint_key', None)
        self.endpoint_region = kwargs.get('endpoint_region', None)
        self.failed_regions = kwargs.get('failed_regions', None)
        self.published_date_time = kwargs.get('published_date_time', None)


class EnqueueTrainingResponse(Model):
    """Response model when requesting to train the model.

    :param status_id: The train request status ID.
    :type status_id: int
    :param status: Possible values include: 'Queued', 'InProgress',
     'UpToDate', 'Fail', 'Success'
    :type status: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    """

    _attribute_map = {
        'status_id': {'key': 'statusId', 'type': 'int'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EnqueueTrainingResponse, self).__init__(**kwargs)
        self.status_id = kwargs.get('status_id', None)
        self.status = kwargs.get('status', None)


class EntitiesSuggestionExample(Model):
    """Predicted/suggested entity.

    :param text: The utterance. For example, "What's the weather like in
     seattle?"
    :type text: str
    :param tokenized_text: The utterance tokenized.
    :type tokenized_text: list[str]
    :param intent_predictions: Predicted/suggested intents.
    :type intent_predictions:
     list[~azure.cognitiveservices.language.luis.authoring.models.IntentPrediction]
    :param entity_predictions: Predicted/suggested entities.
    :type entity_predictions:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityPrediction]
    """

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'tokenized_text': {'key': 'tokenizedText', 'type': '[str]'},
        'intent_predictions': {'key': 'intentPredictions', 'type': '[IntentPrediction]'},
        'entity_predictions': {'key': 'entityPredictions', 'type': '[EntityPrediction]'},
    }

    def __init__(self, **kwargs):
        super(EntitiesSuggestionExample, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.tokenized_text = kwargs.get('tokenized_text', None)
        self.intent_predictions = kwargs.get('intent_predictions', None)
        self.entity_predictions = kwargs.get('entity_predictions', None)


class EntityExtractor(Model):
    """Entity Extractor.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the Entity Model.
    :type id: str
    :param name: Name of the Entity Model.
    :type name: str
    :param type_id: The type ID of the Entity Model.
    :type type_id: int
    :param readable_type: Required. Possible values include: 'Entity
     Extractor', 'Child Entity Extractor', 'Hierarchical Entity Extractor',
     'Hierarchical Child Entity Extractor', 'Composite Entity Extractor', 'List
     Entity Extractor', 'Prebuilt Entity Extractor', 'Intent Classifier',
     'Pattern.Any Entity Extractor', 'Closed List Entity Extractor', 'Regex
     Entity Extractor'
    :type readable_type: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    :param roles:
    :type roles:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityRole]
    :param custom_prebuilt_domain_name: The domain name.
    :type custom_prebuilt_domain_name: str
    :param custom_prebuilt_model_name: The intent name or entity name.
    :type custom_prebuilt_model_name: str
    """

    _validation = {
        'id': {'required': True},
        'readable_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type_id': {'key': 'typeId', 'type': 'int'},
        'readable_type': {'key': 'readableType', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[EntityRole]'},
        'custom_prebuilt_domain_name': {'key': 'customPrebuiltDomainName', 'type': 'str'},
        'custom_prebuilt_model_name': {'key': 'customPrebuiltModelName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EntityExtractor, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type_id = kwargs.get('type_id', None)
        self.readable_type = kwargs.get('readable_type', None)
        self.roles = kwargs.get('roles', None)
        self.custom_prebuilt_domain_name = kwargs.get('custom_prebuilt_domain_name', None)
        self.custom_prebuilt_model_name = kwargs.get('custom_prebuilt_model_name', None)


class EntityLabel(Model):
    """Defines the entity type and position of the extracted entity within the
    example.

    All required parameters must be populated in order to send to Azure.

    :param entity_name: Required. The entity type.
    :type entity_name: str
    :param start_token_index: Required. The index within the utterance where
     the extracted entity starts.
    :type start_token_index: int
    :param end_token_index: Required. The index within the utterance where the
     extracted entity ends.
    :type end_token_index: int
    :param role: The role of the predicted entity.
    :type role: str
    :param role_id: The role id for the predicted entity.
    :type role_id: str
    """

    _validation = {
        'entity_name': {'required': True},
        'start_token_index': {'required': True},
        'end_token_index': {'required': True},
    }

    _attribute_map = {
        'entity_name': {'key': 'entityName', 'type': 'str'},
        'start_token_index': {'key': 'startTokenIndex', 'type': 'int'},
        'end_token_index': {'key': 'endTokenIndex', 'type': 'int'},
        'role': {'key': 'role', 'type': 'str'},
        'role_id': {'key': 'roleId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EntityLabel, self).__init__(**kwargs)
        self.entity_name = kwargs.get('entity_name', None)
        self.start_token_index = kwargs.get('start_token_index', None)
        self.end_token_index = kwargs.get('end_token_index', None)
        self.role = kwargs.get('role', None)
        self.role_id = kwargs.get('role_id', None)


class EntityLabelObject(Model):
    """Defines the entity type and position of the extracted entity within the
    example.

    All required parameters must be populated in order to send to Azure.

    :param entity_name: Required. The entity type.
    :type entity_name: str
    :param start_char_index: Required. The index within the utterance where
     the extracted entity starts.
    :type start_char_index: int
    :param end_char_index: Required. The index within the utterance where the
     extracted entity ends.
    :type end_char_index: int
    :param role: The role the entity plays in the utterance.
    :type role: str
    """

    _validation = {
        'entity_name': {'required': True},
        'start_char_index': {'required': True},
        'end_char_index': {'required': True},
    }

    _attribute_map = {
        'entity_name': {'key': 'entityName', 'type': 'str'},
        'start_char_index': {'key': 'startCharIndex', 'type': 'int'},
        'end_char_index': {'key': 'endCharIndex', 'type': 'int'},
        'role': {'key': 'role', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EntityLabelObject, self).__init__(**kwargs)
        self.entity_name = kwargs.get('entity_name', None)
        self.start_char_index = kwargs.get('start_char_index', None)
        self.end_char_index = kwargs.get('end_char_index', None)
        self.role = kwargs.get('role', None)


class EntityModelCreateObject(Model):
    """An entity extractor create object.

    :param children: Child entities.
    :type children:
     list[~azure.cognitiveservices.language.luis.authoring.models.ChildEntityModelCreateObject]
    :param name: Entity name.
    :type name: str
    """

    _attribute_map = {
        'children': {'key': 'children', 'type': '[ChildEntityModelCreateObject]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EntityModelCreateObject, self).__init__(**kwargs)
        self.children = kwargs.get('children', None)
        self.name = kwargs.get('name', None)


class ModelInfo(Model):
    """Base type used in entity types.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the Entity Model.
    :type id: str
    :param name: Name of the Entity Model.
    :type name: str
    :param type_id: The type ID of the Entity Model.
    :type type_id: int
    :param readable_type: Required. Possible values include: 'Entity
     Extractor', 'Child Entity Extractor', 'Hierarchical Entity Extractor',
     'Hierarchical Child Entity Extractor', 'Composite Entity Extractor', 'List
     Entity Extractor', 'Prebuilt Entity Extractor', 'Intent Classifier',
     'Pattern.Any Entity Extractor', 'Closed List Entity Extractor', 'Regex
     Entity Extractor'
    :type readable_type: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    """

    _validation = {
        'id': {'required': True},
        'readable_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type_id': {'key': 'typeId', 'type': 'int'},
        'readable_type': {'key': 'readableType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ModelInfo, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type_id = kwargs.get('type_id', None)
        self.readable_type = kwargs.get('readable_type', None)


class EntityModelInfo(ModelInfo):
    """An Entity Extractor model info.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the Entity Model.
    :type id: str
    :param name: Name of the Entity Model.
    :type name: str
    :param type_id: The type ID of the Entity Model.
    :type type_id: int
    :param readable_type: Required. Possible values include: 'Entity
     Extractor', 'Child Entity Extractor', 'Hierarchical Entity Extractor',
     'Hierarchical Child Entity Extractor', 'Composite Entity Extractor', 'List
     Entity Extractor', 'Prebuilt Entity Extractor', 'Intent Classifier',
     'Pattern.Any Entity Extractor', 'Closed List Entity Extractor', 'Regex
     Entity Extractor'
    :type readable_type: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    :param roles:
    :type roles:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityRole]
    """

    _validation = {
        'id': {'required': True},
        'readable_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type_id': {'key': 'typeId', 'type': 'int'},
        'readable_type': {'key': 'readableType', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[EntityRole]'},
    }

    def __init__(self, **kwargs):
        super(EntityModelInfo, self).__init__(**kwargs)
        self.roles = kwargs.get('roles', None)


class EntityModelUpdateObject(Model):
    """An entity extractor update object.

    :param name: Entity name.
    :type name: str
    :param instance_of: The instance of model name
    :type instance_of: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'instance_of': {'key': 'instanceOf', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EntityModelUpdateObject, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.instance_of = kwargs.get('instance_of', None)


class EntityPrediction(Model):
    """A suggested entity.

    All required parameters must be populated in order to send to Azure.

    :param entity_name: Required. The entity's name
    :type entity_name: str
    :param start_token_index: Required. The index within the utterance where
     the extracted entity starts.
    :type start_token_index: int
    :param end_token_index: Required. The index within the utterance where the
     extracted entity ends.
    :type end_token_index: int
    :param phrase: Required. The actual token(s) that comprise the entity.
    :type phrase: str
    """

    _validation = {
        'entity_name': {'required': True},
        'start_token_index': {'required': True},
        'end_token_index': {'required': True},
        'phrase': {'required': True},
    }

    _attribute_map = {
        'entity_name': {'key': 'entityName', 'type': 'str'},
        'start_token_index': {'key': 'startTokenIndex', 'type': 'int'},
        'end_token_index': {'key': 'endTokenIndex', 'type': 'int'},
        'phrase': {'key': 'phrase', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EntityPrediction, self).__init__(**kwargs)
        self.entity_name = kwargs.get('entity_name', None)
        self.start_token_index = kwargs.get('start_token_index', None)
        self.end_token_index = kwargs.get('end_token_index', None)
        self.phrase = kwargs.get('phrase', None)


class EntityRole(Model):
    """Entity extractor role.

    :param id: The entity role ID.
    :type id: str
    :param name: The entity role name.
    :type name: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EntityRole, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)


class EntityRoleCreateObject(Model):
    """Object model for creating an entity role.

    :param name: The entity role name.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EntityRoleCreateObject, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class EntityRoleUpdateObject(Model):
    """Object model for updating an entity role.

    :param name: The entity role name.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EntityRoleUpdateObject, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class ErrorResponse(Model):
    """Error response when invoking an operation on the API.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param error_type:
    :type error_type: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'error_type': {'key': 'errorType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.error_type = kwargs.get('error_type', None)


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class ExampleLabelObject(Model):
    """A labeled example utterance.

    :param text: The example utterance.
    :type text: str
    :param entity_labels: The identified entities within the example
     utterance.
    :type entity_labels:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityLabelObject]
    :param intent_name: The identified intent representing the example
     utterance.
    :type intent_name: str
    """

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'entity_labels': {'key': 'entityLabels', 'type': '[EntityLabelObject]'},
        'intent_name': {'key': 'intentName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExampleLabelObject, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.entity_labels = kwargs.get('entity_labels', None)
        self.intent_name = kwargs.get('intent_name', None)


class ExplicitListItem(Model):
    """Explicit (exception) list item.

    :param id: The explicit list item ID.
    :type id: long
    :param explicit_list_item: The explicit list item value.
    :type explicit_list_item: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'long'},
        'explicit_list_item': {'key': 'explicitListItem', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExplicitListItem, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.explicit_list_item = kwargs.get('explicit_list_item', None)


class ExplicitListItemCreateObject(Model):
    """Object model for creating an explicit (exception) list item.

    :param explicit_list_item: The explicit list item.
    :type explicit_list_item: str
    """

    _attribute_map = {
        'explicit_list_item': {'key': 'explicitListItem', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExplicitListItemCreateObject, self).__init__(**kwargs)
        self.explicit_list_item = kwargs.get('explicit_list_item', None)


class ExplicitListItemUpdateObject(Model):
    """Model object for updating an explicit (exception) list item.

    :param explicit_list_item: The explicit list item.
    :type explicit_list_item: str
    """

    _attribute_map = {
        'explicit_list_item': {'key': 'explicitListItem', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExplicitListItemUpdateObject, self).__init__(**kwargs)
        self.explicit_list_item = kwargs.get('explicit_list_item', None)


class FeatureInfoObject(Model):
    """The base class Features-related response objects inherit from.

    :param id: A six-digit ID used for Features.
    :type id: int
    :param name: The name of the Feature.
    :type name: str
    :param is_active: Indicates if the feature is enabled.
    :type is_active: bool
    :param enabled_for_all_models: Indicates if the feature is enabled for all
     models in the application.
    :type enabled_for_all_models: bool
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'is_active': {'key': 'isActive', 'type': 'bool'},
        'enabled_for_all_models': {'key': 'enabledForAllModels', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(FeatureInfoObject, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.is_active = kwargs.get('is_active', None)
        self.enabled_for_all_models = kwargs.get('enabled_for_all_models', None)


class FeaturesResponseObject(Model):
    """Model Features, including Patterns and Phraselists.

    :param phraselist_features:
    :type phraselist_features:
     list[~azure.cognitiveservices.language.luis.authoring.models.PhraseListFeatureInfo]
    :param pattern_features:
    :type pattern_features:
     list[~azure.cognitiveservices.language.luis.authoring.models.PatternFeatureInfo]
    """

    _attribute_map = {
        'phraselist_features': {'key': 'phraselistFeatures', 'type': '[PhraseListFeatureInfo]'},
        'pattern_features': {'key': 'patternFeatures', 'type': '[PatternFeatureInfo]'},
    }

    def __init__(self, **kwargs):
        super(FeaturesResponseObject, self).__init__(**kwargs)
        self.phraselist_features = kwargs.get('phraselist_features', None)
        self.pattern_features = kwargs.get('pattern_features', None)


class HierarchicalChildEntity(ChildEntity):
    """A Hierarchical Child Entity.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID (GUID) belonging to a child entity.
    :type id: str
    :param name: The name of a child entity.
    :type name: str
    :param instance_of: Instance of Model.
    :type instance_of: str
    :param type_id: The type ID of the Entity Model.
    :type type_id: int
    :param readable_type: Possible values include: 'Entity Extractor', 'Child
     Entity Extractor', 'Hierarchical Entity Extractor', 'Hierarchical Child
     Entity Extractor', 'Composite Entity Extractor', 'List Entity Extractor',
     'Prebuilt Entity Extractor', 'Intent Classifier', 'Pattern.Any Entity
     Extractor', 'Closed List Entity Extractor', 'Regex Entity Extractor'
    :type readable_type: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    :param children: List of children
    :type children:
     list[~azure.cognitiveservices.language.luis.authoring.models.ChildEntity]
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'instance_of': {'key': 'instanceOf', 'type': 'str'},
        'type_id': {'key': 'typeId', 'type': 'int'},
        'readable_type': {'key': 'readableType', 'type': 'str'},
        'children': {'key': 'children', 'type': '[ChildEntity]'},
    }

    def __init__(self, **kwargs):
        super(HierarchicalChildEntity, self).__init__(**kwargs)


class HierarchicalChildModelUpdateObject(Model):
    """HierarchicalChildModelUpdateObject.

    :param name:
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(HierarchicalChildModelUpdateObject, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class HierarchicalEntityExtractor(Model):
    """Hierarchical Entity Extractor.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the Entity Model.
    :type id: str
    :param name: Name of the Entity Model.
    :type name: str
    :param type_id: The type ID of the Entity Model.
    :type type_id: int
    :param readable_type: Required. Possible values include: 'Entity
     Extractor', 'Child Entity Extractor', 'Hierarchical Entity Extractor',
     'Hierarchical Child Entity Extractor', 'Composite Entity Extractor', 'List
     Entity Extractor', 'Prebuilt Entity Extractor', 'Intent Classifier',
     'Pattern.Any Entity Extractor', 'Closed List Entity Extractor', 'Regex
     Entity Extractor'
    :type readable_type: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    :param roles:
    :type roles:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityRole]
    :param children: List of child entities.
    :type children:
     list[~azure.cognitiveservices.language.luis.authoring.models.ChildEntity]
    """

    _validation = {
        'id': {'required': True},
        'readable_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type_id': {'key': 'typeId', 'type': 'int'},
        'readable_type': {'key': 'readableType', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[EntityRole]'},
        'children': {'key': 'children', 'type': '[ChildEntity]'},
    }

    def __init__(self, **kwargs):
        super(HierarchicalEntityExtractor, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type_id = kwargs.get('type_id', None)
        self.readable_type = kwargs.get('readable_type', None)
        self.roles = kwargs.get('roles', None)
        self.children = kwargs.get('children', None)


class HierarchicalModel(Model):
    """HierarchicalModel.

    :param name:
    :type name: str
    :param children:
    :type children:
     list[~azure.cognitiveservices.language.luis.authoring.models.JsonChild]
    :param features:
    :type features:
     list[~azure.cognitiveservices.language.luis.authoring.models.JsonModelFeatureInformation]
    :param roles:
    :type roles: list[str]
    :param inherits:
    :type inherits:
     ~azure.cognitiveservices.language.luis.authoring.models.PrebuiltDomainObject
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'children': {'key': 'children', 'type': '[JsonChild]'},
        'features': {'key': 'features', 'type': '[JsonModelFeatureInformation]'},
        'roles': {'key': 'roles', 'type': '[str]'},
        'inherits': {'key': 'inherits', 'type': 'PrebuiltDomainObject'},
    }

    def __init__(self, **kwargs):
        super(HierarchicalModel, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.children = kwargs.get('children', None)
        self.features = kwargs.get('features', None)
        self.roles = kwargs.get('roles', None)
        self.inherits = kwargs.get('inherits', None)


class IntentClassifier(ModelInfo):
    """Intent Classifier.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the Entity Model.
    :type id: str
    :param name: Name of the Entity Model.
    :type name: str
    :param type_id: The type ID of the Entity Model.
    :type type_id: int
    :param readable_type: Required. Possible values include: 'Entity
     Extractor', 'Child Entity Extractor', 'Hierarchical Entity Extractor',
     'Hierarchical Child Entity Extractor', 'Composite Entity Extractor', 'List
     Entity Extractor', 'Prebuilt Entity Extractor', 'Intent Classifier',
     'Pattern.Any Entity Extractor', 'Closed List Entity Extractor', 'Regex
     Entity Extractor'
    :type readable_type: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    :param custom_prebuilt_domain_name: The domain name.
    :type custom_prebuilt_domain_name: str
    :param custom_prebuilt_model_name: The intent name or entity name.
    :type custom_prebuilt_model_name: str
    """

    _validation = {
        'id': {'required': True},
        'readable_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type_id': {'key': 'typeId', 'type': 'int'},
        'readable_type': {'key': 'readableType', 'type': 'str'},
        'custom_prebuilt_domain_name': {'key': 'customPrebuiltDomainName', 'type': 'str'},
        'custom_prebuilt_model_name': {'key': 'customPrebuiltModelName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IntentClassifier, self).__init__(**kwargs)
        self.custom_prebuilt_domain_name = kwargs.get('custom_prebuilt_domain_name', None)
        self.custom_prebuilt_model_name = kwargs.get('custom_prebuilt_model_name', None)


class IntentPrediction(Model):
    """A suggested intent.

    :param name: The intent's name
    :type name: str
    :param score: The intent's score, based on the prediction model.
    :type score: float
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'score': {'key': 'score', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(IntentPrediction, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.score = kwargs.get('score', None)


class IntentsSuggestionExample(Model):
    """Predicted/suggested intent.

    :param text: The utterance. For example, "What's the weather like in
     seattle?"
    :type text: str
    :param tokenized_text: The tokenized utterance.
    :type tokenized_text: list[str]
    :param intent_predictions: Predicted/suggested intents.
    :type intent_predictions:
     list[~azure.cognitiveservices.language.luis.authoring.models.IntentPrediction]
    :param entity_predictions: Predicted/suggested entities.
    :type entity_predictions:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityPrediction]
    """

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'tokenized_text': {'key': 'tokenizedText', 'type': '[str]'},
        'intent_predictions': {'key': 'intentPredictions', 'type': '[IntentPrediction]'},
        'entity_predictions': {'key': 'entityPredictions', 'type': '[EntityPrediction]'},
    }

    def __init__(self, **kwargs):
        super(IntentsSuggestionExample, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.tokenized_text = kwargs.get('tokenized_text', None)
        self.intent_predictions = kwargs.get('intent_predictions', None)
        self.entity_predictions = kwargs.get('entity_predictions', None)


class JsonChild(Model):
    """JsonChild.

    :param name:
    :type name: str
    :param instance_of:
    :type instance_of: str
    :param children:
    :type children:
     list[~azure.cognitiveservices.language.luis.authoring.models.JsonChild]
    :param features:
    :type features:
     list[~azure.cognitiveservices.language.luis.authoring.models.JsonModelFeatureInformation]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'instance_of': {'key': 'instanceOf', 'type': 'str'},
        'children': {'key': 'children', 'type': '[JsonChild]'},
        'features': {'key': 'features', 'type': '[JsonModelFeatureInformation]'},
    }

    def __init__(self, **kwargs):
        super(JsonChild, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.instance_of = kwargs.get('instance_of', None)
        self.children = kwargs.get('children', None)
        self.features = kwargs.get('features', None)


class JSONEntity(Model):
    """Exported Model - Extracted Entity from utterance.

    All required parameters must be populated in order to send to Azure.

    :param start_pos: Required. The index within the utterance where the
     extracted entity starts.
    :type start_pos: int
    :param end_pos: Required. The index within the utterance where the
     extracted entity ends.
    :type end_pos: int
    :param entity: Required. The entity name.
    :type entity: str
    :param role: The role the entity plays in the utterance.
    :type role: str
    """

    _validation = {
        'start_pos': {'required': True},
        'end_pos': {'required': True},
        'entity': {'required': True},
    }

    _attribute_map = {
        'start_pos': {'key': 'startPos', 'type': 'int'},
        'end_pos': {'key': 'endPos', 'type': 'int'},
        'entity': {'key': 'entity', 'type': 'str'},
        'role': {'key': 'role', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JSONEntity, self).__init__(**kwargs)
        self.start_pos = kwargs.get('start_pos', None)
        self.end_pos = kwargs.get('end_pos', None)
        self.entity = kwargs.get('entity', None)
        self.role = kwargs.get('role', None)


class JSONModelFeature(Model):
    """Exported Model - Phraselist Model Feature.

    :param activated: Indicates if the feature is enabled.
    :type activated: bool
    :param name: The Phraselist name.
    :type name: str
    :param words: List of comma-separated phrases that represent the
     Phraselist.
    :type words: str
    :param mode: An interchangeable phrase list feature serves as a list of
     synonyms for training. A non-exchangeable phrase list serves as separate
     features for training. So, if your non-interchangeable phrase list
     contains 5 phrases, they will be mapped to 5 separate features. You can
     think of the non-interchangeable phrase list as an additional bag of words
     to add to LUIS existing vocabulary features. It is used as a lexicon
     lookup feature where its value is 1 if the lexicon contains a given word
     or 0 if it doesn’t.  Default value is true.
    :type mode: bool
    :param enabled_for_all_models: Indicates if the Phraselist is enabled for
     all models in the application. Default value: True .
    :type enabled_for_all_models: bool
    """

    _attribute_map = {
        'activated': {'key': 'activated', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'words': {'key': 'words', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'bool'},
        'enabled_for_all_models': {'key': 'enabledForAllModels', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(JSONModelFeature, self).__init__(**kwargs)
        self.activated = kwargs.get('activated', None)
        self.name = kwargs.get('name', None)
        self.words = kwargs.get('words', None)
        self.mode = kwargs.get('mode', None)
        self.enabled_for_all_models = kwargs.get('enabled_for_all_models', True)


class JsonModelFeatureInformation(Model):
    """An object containing the model feature information either the model name or
    feature name.

    :param model_name: The name of the model used.
    :type model_name: str
    :param feature_name: The name of the feature used.
    :type feature_name: str
    """

    _attribute_map = {
        'model_name': {'key': 'modelName', 'type': 'str'},
        'feature_name': {'key': 'featureName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JsonModelFeatureInformation, self).__init__(**kwargs)
        self.model_name = kwargs.get('model_name', None)
        self.feature_name = kwargs.get('feature_name', None)


class JSONRegexFeature(Model):
    """Exported Model - A Pattern feature.

    :param pattern: The Regular Expression to match.
    :type pattern: str
    :param activated: Indicates if the Pattern feature is enabled.
    :type activated: bool
    :param name: Name of the feature.
    :type name: str
    """

    _attribute_map = {
        'pattern': {'key': 'pattern', 'type': 'str'},
        'activated': {'key': 'activated', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JSONRegexFeature, self).__init__(**kwargs)
        self.pattern = kwargs.get('pattern', None)
        self.activated = kwargs.get('activated', None)
        self.name = kwargs.get('name', None)


class JSONUtterance(Model):
    """Exported Model - Utterance that was used to train the model.

    :param text: The utterance.
    :type text: str
    :param intent: The matched intent.
    :type intent: str
    :param entities: The matched entities.
    :type entities:
     list[~azure.cognitiveservices.language.luis.authoring.models.JSONEntity]
    """

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'intent': {'key': 'intent', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[JSONEntity]'},
    }

    def __init__(self, **kwargs):
        super(JSONUtterance, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.intent = kwargs.get('intent', None)
        self.entities = kwargs.get('entities', None)


class LabeledUtterance(Model):
    """A prediction and label pair of an example.

    :param id: ID of Labeled Utterance.
    :type id: int
    :param text: The utterance. For example, "What's the weather like in
     seattle?"
    :type text: str
    :param tokenized_text: The utterance tokenized.
    :type tokenized_text: list[str]
    :param intent_label: The intent matching the example.
    :type intent_label: str
    :param entity_labels: The entities matching the example.
    :type entity_labels:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityLabel]
    :param intent_predictions: List of suggested intents.
    :type intent_predictions:
     list[~azure.cognitiveservices.language.luis.authoring.models.IntentPrediction]
    :param entity_predictions: List of suggested entities.
    :type entity_predictions:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityPrediction]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'int'},
        'text': {'key': 'text', 'type': 'str'},
        'tokenized_text': {'key': 'tokenizedText', 'type': '[str]'},
        'intent_label': {'key': 'intentLabel', 'type': 'str'},
        'entity_labels': {'key': 'entityLabels', 'type': '[EntityLabel]'},
        'intent_predictions': {'key': 'intentPredictions', 'type': '[IntentPrediction]'},
        'entity_predictions': {'key': 'entityPredictions', 'type': '[EntityPrediction]'},
    }

    def __init__(self, **kwargs):
        super(LabeledUtterance, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.text = kwargs.get('text', None)
        self.tokenized_text = kwargs.get('tokenized_text', None)
        self.intent_label = kwargs.get('intent_label', None)
        self.entity_labels = kwargs.get('entity_labels', None)
        self.intent_predictions = kwargs.get('intent_predictions', None)
        self.entity_predictions = kwargs.get('entity_predictions', None)


class LabelExampleResponse(Model):
    """Response when adding a labeled example utterance.

    :param utterance_text: The example utterance.
    :type utterance_text: str
    :param example_id: The newly created sample ID.
    :type example_id: int
    """

    _attribute_map = {
        'utterance_text': {'key': 'UtteranceText', 'type': 'str'},
        'example_id': {'key': 'ExampleId', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(LabelExampleResponse, self).__init__(**kwargs)
        self.utterance_text = kwargs.get('utterance_text', None)
        self.example_id = kwargs.get('example_id', None)


class LabelTextObject(Model):
    """An object containing the example utterance's text.

    :param id: The ID of the Label.
    :type id: int
    :param text: The text of the label.
    :type text: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'int'},
        'text': {'key': 'text', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LabelTextObject, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.text = kwargs.get('text', None)


class LuisApp(Model):
    """Exported Model - An exported LUIS Application.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param name: The name of the application.
    :type name: str
    :param version_id: The version ID of the application that was exported.
    :type version_id: str
    :param desc: The description of the application.
    :type desc: str
    :param culture: The culture of the application. E.g.: en-us.
    :type culture: str
    :param intents: List of intents.
    :type intents:
     list[~azure.cognitiveservices.language.luis.authoring.models.HierarchicalModel]
    :param entities: List of entities.
    :type entities:
     list[~azure.cognitiveservices.language.luis.authoring.models.HierarchicalModel]
    :param closed_lists: List of list entities.
    :type closed_lists:
     list[~azure.cognitiveservices.language.luis.authoring.models.ClosedList]
    :param composites: List of composite entities.
    :type composites:
     list[~azure.cognitiveservices.language.luis.authoring.models.HierarchicalModel]
    :param hierarchicals: List of hierarchical entities.
    :type hierarchicals:
     list[~azure.cognitiveservices.language.luis.authoring.models.HierarchicalModel]
    :param pattern_any_entities: List of Pattern.Any entities.
    :type pattern_any_entities:
     list[~azure.cognitiveservices.language.luis.authoring.models.PatternAny]
    :param regex_entities: List of regular expression entities.
    :type regex_entities:
     list[~azure.cognitiveservices.language.luis.authoring.models.RegexEntity]
    :param prebuilt_entities: List of prebuilt entities.
    :type prebuilt_entities:
     list[~azure.cognitiveservices.language.luis.authoring.models.PrebuiltEntity]
    :param regex_features: List of pattern features.
    :type regex_features:
     list[~azure.cognitiveservices.language.luis.authoring.models.JSONRegexFeature]
    :param phraselists: List of model features.
    :type phraselists:
     list[~azure.cognitiveservices.language.luis.authoring.models.JSONModelFeature]
    :param patterns: List of patterns.
    :type patterns:
     list[~azure.cognitiveservices.language.luis.authoring.models.PatternRule]
    :param utterances: List of example utterances.
    :type utterances:
     list[~azure.cognitiveservices.language.luis.authoring.models.JSONUtterance]
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'version_id': {'key': 'versionId', 'type': 'str'},
        'desc': {'key': 'desc', 'type': 'str'},
        'culture': {'key': 'culture', 'type': 'str'},
        'intents': {'key': 'intents', 'type': '[HierarchicalModel]'},
        'entities': {'key': 'entities', 'type': '[HierarchicalModel]'},
        'closed_lists': {'key': 'closedLists', 'type': '[ClosedList]'},
        'composites': {'key': 'composites', 'type': '[HierarchicalModel]'},
        'hierarchicals': {'key': 'hierarchicals', 'type': '[HierarchicalModel]'},
        'pattern_any_entities': {'key': 'patternAnyEntities', 'type': '[PatternAny]'},
        'regex_entities': {'key': 'regex_entities', 'type': '[RegexEntity]'},
        'prebuilt_entities': {'key': 'prebuiltEntities', 'type': '[PrebuiltEntity]'},
        'regex_features': {'key': 'regex_features', 'type': '[JSONRegexFeature]'},
        'phraselists': {'key': 'phraselists', 'type': '[JSONModelFeature]'},
        'patterns': {'key': 'patterns', 'type': '[PatternRule]'},
        'utterances': {'key': 'utterances', 'type': '[JSONUtterance]'},
    }

    def __init__(self, **kwargs):
        super(LuisApp, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.name = kwargs.get('name', None)
        self.version_id = kwargs.get('version_id', None)
        self.desc = kwargs.get('desc', None)
        self.culture = kwargs.get('culture', None)
        self.intents = kwargs.get('intents', None)
        self.entities = kwargs.get('entities', None)
        self.closed_lists = kwargs.get('closed_lists', None)
        self.composites = kwargs.get('composites', None)
        self.hierarchicals = kwargs.get('hierarchicals', None)
        self.pattern_any_entities = kwargs.get('pattern_any_entities', None)
        self.regex_entities = kwargs.get('regex_entities', None)
        self.prebuilt_entities = kwargs.get('prebuilt_entities', None)
        self.regex_features = kwargs.get('regex_features', None)
        self.phraselists = kwargs.get('phraselists', None)
        self.patterns = kwargs.get('patterns', None)
        self.utterances = kwargs.get('utterances', None)


class ModelCreateObject(Model):
    """Object model for creating a new entity extractor.

    :param name: Name of the new entity extractor.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ModelCreateObject, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class ModelFeatureInformation(Model):
    """An object containing the model feature information either the model name or
    feature name.

    :param model_name: The name of the model used.
    :type model_name: str
    :param feature_name: The name of the feature used.
    :type feature_name: str
    """

    _attribute_map = {
        'model_name': {'key': 'modelName', 'type': 'str'},
        'feature_name': {'key': 'featureName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ModelFeatureInformation, self).__init__(**kwargs)
        self.model_name = kwargs.get('model_name', None)
        self.feature_name = kwargs.get('feature_name', None)


class ModelInfoResponse(Model):
    """An application model info.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the Entity Model.
    :type id: str
    :param name: Name of the Entity Model.
    :type name: str
    :param type_id: The type ID of the Entity Model.
    :type type_id: int
    :param readable_type: Required. Possible values include: 'Entity
     Extractor', 'Child Entity Extractor', 'Hierarchical Entity Extractor',
     'Hierarchical Child Entity Extractor', 'Composite Entity Extractor', 'List
     Entity Extractor', 'Prebuilt Entity Extractor', 'Intent Classifier',
     'Pattern.Any Entity Extractor', 'Closed List Entity Extractor', 'Regex
     Entity Extractor'
    :type readable_type: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    :param roles:
    :type roles:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityRole]
    :param children: List of child entities.
    :type children:
     list[~azure.cognitiveservices.language.luis.authoring.models.ChildEntity]
    :param sub_lists: List of sublists.
    :type sub_lists:
     list[~azure.cognitiveservices.language.luis.authoring.models.SubClosedListResponse]
    :param custom_prebuilt_domain_name: The domain name.
    :type custom_prebuilt_domain_name: str
    :param custom_prebuilt_model_name: The intent name or entity name.
    :type custom_prebuilt_model_name: str
    :param regex_pattern: The Regular Expression entity pattern.
    :type regex_pattern: str
    :param explicit_list:
    :type explicit_list:
     list[~azure.cognitiveservices.language.luis.authoring.models.ExplicitListItem]
    """

    _validation = {
        'id': {'required': True},
        'readable_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type_id': {'key': 'typeId', 'type': 'int'},
        'readable_type': {'key': 'readableType', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[EntityRole]'},
        'children': {'key': 'children', 'type': '[ChildEntity]'},
        'sub_lists': {'key': 'subLists', 'type': '[SubClosedListResponse]'},
        'custom_prebuilt_domain_name': {'key': 'customPrebuiltDomainName', 'type': 'str'},
        'custom_prebuilt_model_name': {'key': 'customPrebuiltModelName', 'type': 'str'},
        'regex_pattern': {'key': 'regexPattern', 'type': 'str'},
        'explicit_list': {'key': 'explicitList', 'type': '[ExplicitListItem]'},
    }

    def __init__(self, **kwargs):
        super(ModelInfoResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type_id = kwargs.get('type_id', None)
        self.readable_type = kwargs.get('readable_type', None)
        self.roles = kwargs.get('roles', None)
        self.children = kwargs.get('children', None)
        self.sub_lists = kwargs.get('sub_lists', None)
        self.custom_prebuilt_domain_name = kwargs.get('custom_prebuilt_domain_name', None)
        self.custom_prebuilt_model_name = kwargs.get('custom_prebuilt_model_name', None)
        self.regex_pattern = kwargs.get('regex_pattern', None)
        self.explicit_list = kwargs.get('explicit_list', None)


class ModelTrainingDetails(Model):
    """Model Training Details.

    :param status_id: The train request status ID.
    :type status_id: int
    :param status: Possible values include: 'Queued', 'InProgress',
     'UpToDate', 'Fail', 'Success'
    :type status: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    :param example_count: The count of examples used to train the model.
    :type example_count: int
    :param training_date_time: When the model was trained.
    :type training_date_time: datetime
    :param failure_reason: Reason for the training failure.
    :type failure_reason: str
    """

    _attribute_map = {
        'status_id': {'key': 'statusId', 'type': 'int'},
        'status': {'key': 'status', 'type': 'str'},
        'example_count': {'key': 'exampleCount', 'type': 'int'},
        'training_date_time': {'key': 'trainingDateTime', 'type': 'iso-8601'},
        'failure_reason': {'key': 'failureReason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ModelTrainingDetails, self).__init__(**kwargs)
        self.status_id = kwargs.get('status_id', None)
        self.status = kwargs.get('status', None)
        self.example_count = kwargs.get('example_count', None)
        self.training_date_time = kwargs.get('training_date_time', None)
        self.failure_reason = kwargs.get('failure_reason', None)


class ModelTrainingInfo(Model):
    """Model Training Info.

    :param model_id: The ID (GUID) of the model.
    :type model_id: str
    :param details:
    :type details:
     ~azure.cognitiveservices.language.luis.authoring.models.ModelTrainingDetails
    """

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'details': {'key': 'details', 'type': 'ModelTrainingDetails'},
    }

    def __init__(self, **kwargs):
        super(ModelTrainingInfo, self).__init__(**kwargs)
        self.model_id = kwargs.get('model_id', None)
        self.details = kwargs.get('details', None)


class ModelUpdateObject(Model):
    """Object model for updating an intent classifier.

    :param name: The entity's new name.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ModelUpdateObject, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class NDepthEntityExtractor(Model):
    """N-Depth Entity Extractor.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the Entity Model.
    :type id: str
    :param name: Name of the Entity Model.
    :type name: str
    :param type_id: The type ID of the Entity Model.
    :type type_id: int
    :param readable_type: Required. Possible values include: 'Entity
     Extractor', 'Child Entity Extractor', 'Hierarchical Entity Extractor',
     'Hierarchical Child Entity Extractor', 'Composite Entity Extractor', 'List
     Entity Extractor', 'Prebuilt Entity Extractor', 'Intent Classifier',
     'Pattern.Any Entity Extractor', 'Closed List Entity Extractor', 'Regex
     Entity Extractor'
    :type readable_type: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    :param roles:
    :type roles:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityRole]
    :param custom_prebuilt_domain_name: The domain name.
    :type custom_prebuilt_domain_name: str
    :param custom_prebuilt_model_name: The intent name or entity name.
    :type custom_prebuilt_model_name: str
    :param children:
    :type children:
     list[~azure.cognitiveservices.language.luis.authoring.models.ChildEntity]
    """

    _validation = {
        'id': {'required': True},
        'readable_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type_id': {'key': 'typeId', 'type': 'int'},
        'readable_type': {'key': 'readableType', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[EntityRole]'},
        'custom_prebuilt_domain_name': {'key': 'customPrebuiltDomainName', 'type': 'str'},
        'custom_prebuilt_model_name': {'key': 'customPrebuiltModelName', 'type': 'str'},
        'children': {'key': 'children', 'type': '[ChildEntity]'},
    }

    def __init__(self, **kwargs):
        super(NDepthEntityExtractor, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type_id = kwargs.get('type_id', None)
        self.readable_type = kwargs.get('readable_type', None)
        self.roles = kwargs.get('roles', None)
        self.custom_prebuilt_domain_name = kwargs.get('custom_prebuilt_domain_name', None)
        self.custom_prebuilt_model_name = kwargs.get('custom_prebuilt_model_name', None)
        self.children = kwargs.get('children', None)


class OperationError(Model):
    """Operation error details when invoking an operation on the API.

    :param code:
    :type code: str
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class OperationStatus(Model):
    """Response of an Operation status.

    :param code: Status Code. Possible values include: 'Failed', 'FAILED',
     'Success'
    :type code: str or
     ~azure.cognitiveservices.language.luis.authoring.models.OperationStatusType
    :param message: Status details.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationStatus, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class PatternAny(Model):
    """Pattern.Any Entity Extractor.

    :param name:
    :type name: str
    :param explicit_list:
    :type explicit_list: list[str]
    :param roles:
    :type roles: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'explicit_list': {'key': 'explicitList', 'type': '[str]'},
        'roles': {'key': 'roles', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(PatternAny, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.explicit_list = kwargs.get('explicit_list', None)
        self.roles = kwargs.get('roles', None)


class PatternAnyEntityExtractor(Model):
    """Pattern.Any Entity Extractor.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the Entity Model.
    :type id: str
    :param name: Name of the Entity Model.
    :type name: str
    :param type_id: The type ID of the Entity Model.
    :type type_id: int
    :param readable_type: Required. Possible values include: 'Entity
     Extractor', 'Child Entity Extractor', 'Hierarchical Entity Extractor',
     'Hierarchical Child Entity Extractor', 'Composite Entity Extractor', 'List
     Entity Extractor', 'Prebuilt Entity Extractor', 'Intent Classifier',
     'Pattern.Any Entity Extractor', 'Closed List Entity Extractor', 'Regex
     Entity Extractor'
    :type readable_type: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    :param roles:
    :type roles:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityRole]
    :param explicit_list:
    :type explicit_list:
     list[~azure.cognitiveservices.language.luis.authoring.models.ExplicitListItem]
    """

    _validation = {
        'id': {'required': True},
        'readable_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type_id': {'key': 'typeId', 'type': 'int'},
        'readable_type': {'key': 'readableType', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[EntityRole]'},
        'explicit_list': {'key': 'explicitList', 'type': '[ExplicitListItem]'},
    }

    def __init__(self, **kwargs):
        super(PatternAnyEntityExtractor, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type_id = kwargs.get('type_id', None)
        self.readable_type = kwargs.get('readable_type', None)
        self.roles = kwargs.get('roles', None)
        self.explicit_list = kwargs.get('explicit_list', None)


class PatternAnyModelCreateObject(Model):
    """Model object for creating a Pattern.Any entity model.

    :param name: The model name.
    :type name: str
    :param explicit_list: The Pattern.Any explicit list.
    :type explicit_list: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'explicit_list': {'key': 'explicitList', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(PatternAnyModelCreateObject, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.explicit_list = kwargs.get('explicit_list', None)


class PatternAnyModelUpdateObject(Model):
    """Model object for updating a Pattern.Any entity model.

    :param name: The model name.
    :type name: str
    :param explicit_list: The Pattern.Any explicit list.
    :type explicit_list: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'explicit_list': {'key': 'explicitList', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(PatternAnyModelUpdateObject, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.explicit_list = kwargs.get('explicit_list', None)


class PatternFeatureInfo(FeatureInfoObject):
    """Pattern feature.

    :param id: A six-digit ID used for Features.
    :type id: int
    :param name: The name of the Feature.
    :type name: str
    :param is_active: Indicates if the feature is enabled.
    :type is_active: bool
    :param enabled_for_all_models: Indicates if the feature is enabled for all
     models in the application.
    :type enabled_for_all_models: bool
    :param pattern: The Regular Expression to match.
    :type pattern: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'is_active': {'key': 'isActive', 'type': 'bool'},
        'enabled_for_all_models': {'key': 'enabledForAllModels', 'type': 'bool'},
        'pattern': {'key': 'pattern', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PatternFeatureInfo, self).__init__(**kwargs)
        self.pattern = kwargs.get('pattern', None)


class PatternRule(Model):
    """Pattern.

    :param pattern: The pattern text.
    :type pattern: str
    :param intent: The intent's name where the pattern belongs to.
    :type intent: str
    """

    _attribute_map = {
        'pattern': {'key': 'pattern', 'type': 'str'},
        'intent': {'key': 'intent', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PatternRule, self).__init__(**kwargs)
        self.pattern = kwargs.get('pattern', None)
        self.intent = kwargs.get('intent', None)


class PatternRuleCreateObject(Model):
    """Object model for creating a pattern.

    :param pattern: The pattern text.
    :type pattern: str
    :param intent: The intent's name which the pattern belongs to.
    :type intent: str
    """

    _attribute_map = {
        'pattern': {'key': 'pattern', 'type': 'str'},
        'intent': {'key': 'intent', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PatternRuleCreateObject, self).__init__(**kwargs)
        self.pattern = kwargs.get('pattern', None)
        self.intent = kwargs.get('intent', None)


class PatternRuleInfo(Model):
    """Pattern rule.

    :param id: The pattern ID.
    :type id: str
    :param pattern: The pattern text.
    :type pattern: str
    :param intent: The intent's name where the pattern belongs to.
    :type intent: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'pattern': {'key': 'pattern', 'type': 'str'},
        'intent': {'key': 'intent', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PatternRuleInfo, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.pattern = kwargs.get('pattern', None)
        self.intent = kwargs.get('intent', None)


class PatternRuleUpdateObject(Model):
    """Object model for updating a pattern.

    :param id: The pattern ID.
    :type id: str
    :param pattern: The pattern text.
    :type pattern: str
    :param intent: The intent's name which the pattern belongs to.
    :type intent: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'pattern': {'key': 'pattern', 'type': 'str'},
        'intent': {'key': 'intent', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PatternRuleUpdateObject, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.pattern = kwargs.get('pattern', None)
        self.intent = kwargs.get('intent', None)


class PersonalAssistantsResponse(Model):
    """Response containing user's endpoint keys and the endpoint URLs of the
    prebuilt Cortana applications.

    :param endpoint_keys:
    :type endpoint_keys: list[str]
    :param endpoint_urls:
    :type endpoint_urls: dict[str, str]
    """

    _attribute_map = {
        'endpoint_keys': {'key': 'endpointKeys', 'type': '[str]'},
        'endpoint_urls': {'key': 'endpointUrls', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(PersonalAssistantsResponse, self).__init__(**kwargs)
        self.endpoint_keys = kwargs.get('endpoint_keys', None)
        self.endpoint_urls = kwargs.get('endpoint_urls', None)


class PhraselistCreateObject(Model):
    """Object model for creating a phraselist model.

    :param phrases: List of comma-separated phrases that represent the
     Phraselist.
    :type phrases: str
    :param name: The Phraselist name.
    :type name: str
    :param is_exchangeable: An interchangeable phrase list feature serves as a
     list of synonyms for training. A non-exchangeable phrase list serves as
     separate features for training. So, if your non-interchangeable phrase
     list contains 5 phrases, they will be mapped to 5 separate features. You
     can think of the non-interchangeable phrase list as an additional bag of
     words to add to LUIS existing vocabulary features. It is used as a lexicon
     lookup feature where its value is 1 if the lexicon contains a given word
     or 0 if it doesn’t.  Default value is true. Default value: True .
    :type is_exchangeable: bool
    :param enabled_for_all_models: Indicates if the Phraselist is enabled for
     all models in the application. Default value: True .
    :type enabled_for_all_models: bool
    """

    _attribute_map = {
        'phrases': {'key': 'phrases', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'is_exchangeable': {'key': 'isExchangeable', 'type': 'bool'},
        'enabled_for_all_models': {'key': 'enabledForAllModels', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(PhraselistCreateObject, self).__init__(**kwargs)
        self.phrases = kwargs.get('phrases', None)
        self.name = kwargs.get('name', None)
        self.is_exchangeable = kwargs.get('is_exchangeable', True)
        self.enabled_for_all_models = kwargs.get('enabled_for_all_models', True)


class PhraseListFeatureInfo(FeatureInfoObject):
    """Phraselist Feature.

    :param id: A six-digit ID used for Features.
    :type id: int
    :param name: The name of the Feature.
    :type name: str
    :param is_active: Indicates if the feature is enabled.
    :type is_active: bool
    :param enabled_for_all_models: Indicates if the feature is enabled for all
     models in the application.
    :type enabled_for_all_models: bool
    :param phrases: A list of comma-separated values.
    :type phrases: str
    :param is_exchangeable: An exchangeable phrase list feature are serves as
     single feature to the LUIS underlying training algorithm. It is used as a
     lexicon lookup feature where its value is 1 if the lexicon contains a
     given word or 0 if it doesn’t. Think of an exchangeable as a synonyms
     list. A non-exchangeable phrase list feature has all the phrases in the
     list serve as separate features to the underlying training algorithm. So,
     if you your phrase list feature contains 5 phrases, they will be mapped to
     5 separate features. You can think of the non-exchangeable phrase list
     feature as an additional bag of words that you are willing to add to LUIS
     existing vocabulary features. Think of a non-exchangeable as set of
     different words. Default value is true.
    :type is_exchangeable: bool
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'is_active': {'key': 'isActive', 'type': 'bool'},
        'enabled_for_all_models': {'key': 'enabledForAllModels', 'type': 'bool'},
        'phrases': {'key': 'phrases', 'type': 'str'},
        'is_exchangeable': {'key': 'isExchangeable', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(PhraseListFeatureInfo, self).__init__(**kwargs)
        self.phrases = kwargs.get('phrases', None)
        self.is_exchangeable = kwargs.get('is_exchangeable', None)


class PhraselistUpdateObject(Model):
    """Object model for updating a Phraselist.

    :param phrases: List of comma-separated phrases that represent the
     Phraselist.
    :type phrases: str
    :param name: The Phraselist name.
    :type name: str
    :param is_active: Indicates if the Phraselist is enabled. Default value:
     True .
    :type is_active: bool
    :param is_exchangeable: An exchangeable phrase list feature are serves as
     single feature to the LUIS underlying training algorithm. It is used as a
     lexicon lookup feature where its value is 1 if the lexicon contains a
     given word or 0 if it doesn’t. Think of an exchangeable as a synonyms
     list. A non-exchangeable phrase list feature has all the phrases in the
     list serve as separate features to the underlying training algorithm. So,
     if you your phrase list feature contains 5 phrases, they will be mapped to
     5 separate features. You can think of the non-exchangeable phrase list
     feature as an additional bag of words that you are willing to add to LUIS
     existing vocabulary features. Think of a non-exchangeable as set of
     different words. Default value is true. Default value: True .
    :type is_exchangeable: bool
    :param enabled_for_all_models: Indicates if the Phraselist is enabled for
     all models in the application. Default value: True .
    :type enabled_for_all_models: bool
    """

    _attribute_map = {
        'phrases': {'key': 'phrases', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'is_active': {'key': 'isActive', 'type': 'bool'},
        'is_exchangeable': {'key': 'isExchangeable', 'type': 'bool'},
        'enabled_for_all_models': {'key': 'enabledForAllModels', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(PhraselistUpdateObject, self).__init__(**kwargs)
        self.phrases = kwargs.get('phrases', None)
        self.name = kwargs.get('name', None)
        self.is_active = kwargs.get('is_active', True)
        self.is_exchangeable = kwargs.get('is_exchangeable', True)
        self.enabled_for_all_models = kwargs.get('enabled_for_all_models', True)


class PrebuiltDomain(Model):
    """Prebuilt Domain.

    :param name:
    :type name: str
    :param culture:
    :type culture: str
    :param description:
    :type description: str
    :param examples:
    :type examples: str
    :param intents:
    :type intents:
     list[~azure.cognitiveservices.language.luis.authoring.models.PrebuiltDomainItem]
    :param entities:
    :type entities:
     list[~azure.cognitiveservices.language.luis.authoring.models.PrebuiltDomainItem]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'culture': {'key': 'culture', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'examples': {'key': 'examples', 'type': 'str'},
        'intents': {'key': 'intents', 'type': '[PrebuiltDomainItem]'},
        'entities': {'key': 'entities', 'type': '[PrebuiltDomainItem]'},
    }

    def __init__(self, **kwargs):
        super(PrebuiltDomain, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.culture = kwargs.get('culture', None)
        self.description = kwargs.get('description', None)
        self.examples = kwargs.get('examples', None)
        self.intents = kwargs.get('intents', None)
        self.entities = kwargs.get('entities', None)


class PrebuiltDomainCreateBaseObject(Model):
    """A model object containing the name of the custom prebuilt entity and the
    name of the domain to which this model belongs.

    :param domain_name: The domain name.
    :type domain_name: str
    """

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrebuiltDomainCreateBaseObject, self).__init__(**kwargs)
        self.domain_name = kwargs.get('domain_name', None)


class PrebuiltDomainCreateObject(Model):
    """A prebuilt domain create object containing the name and culture of the
    domain.

    :param domain_name: The domain name.
    :type domain_name: str
    :param culture: The culture of the new domain.
    :type culture: str
    """

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'culture': {'key': 'culture', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrebuiltDomainCreateObject, self).__init__(**kwargs)
        self.domain_name = kwargs.get('domain_name', None)
        self.culture = kwargs.get('culture', None)


class PrebuiltDomainItem(Model):
    """PrebuiltDomainItem.

    :param name:
    :type name: str
    :param description:
    :type description: str
    :param examples:
    :type examples: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'examples': {'key': 'examples', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrebuiltDomainItem, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.examples = kwargs.get('examples', None)


class PrebuiltDomainModelCreateObject(Model):
    """A model object containing the name of the custom prebuilt intent or entity
    and the name of the domain to which this model belongs.

    :param domain_name: The domain name.
    :type domain_name: str
    :param model_name: The intent name or entity name.
    :type model_name: str
    """

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrebuiltDomainModelCreateObject, self).__init__(**kwargs)
        self.domain_name = kwargs.get('domain_name', None)
        self.model_name = kwargs.get('model_name', None)


class PrebuiltDomainObject(Model):
    """PrebuiltDomainObject.

    :param domain_name:
    :type domain_name: str
    :param model_name:
    :type model_name: str
    """

    _attribute_map = {
        'domain_name': {'key': 'domain_name', 'type': 'str'},
        'model_name': {'key': 'model_name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrebuiltDomainObject, self).__init__(**kwargs)
        self.domain_name = kwargs.get('domain_name', None)
        self.model_name = kwargs.get('model_name', None)


class PrebuiltEntity(Model):
    """Prebuilt Entity Extractor.

    :param name:
    :type name: str
    :param roles:
    :type roles: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(PrebuiltEntity, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.roles = kwargs.get('roles', None)


class PrebuiltEntityExtractor(Model):
    """Prebuilt Entity Extractor.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the Entity Model.
    :type id: str
    :param name: Name of the Entity Model.
    :type name: str
    :param type_id: The type ID of the Entity Model.
    :type type_id: int
    :param readable_type: Required. Possible values include: 'Entity
     Extractor', 'Child Entity Extractor', 'Hierarchical Entity Extractor',
     'Hierarchical Child Entity Extractor', 'Composite Entity Extractor', 'List
     Entity Extractor', 'Prebuilt Entity Extractor', 'Intent Classifier',
     'Pattern.Any Entity Extractor', 'Closed List Entity Extractor', 'Regex
     Entity Extractor'
    :type readable_type: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    :param roles:
    :type roles:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityRole]
    """

    _validation = {
        'id': {'required': True},
        'readable_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type_id': {'key': 'typeId', 'type': 'int'},
        'readable_type': {'key': 'readableType', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[EntityRole]'},
    }

    def __init__(self, **kwargs):
        super(PrebuiltEntityExtractor, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type_id = kwargs.get('type_id', None)
        self.readable_type = kwargs.get('readable_type', None)
        self.roles = kwargs.get('roles', None)


class ProductionOrStagingEndpointInfo(EndpointInfo):
    """ProductionOrStagingEndpointInfo.

    :param version_id: The version ID to publish.
    :type version_id: str
    :param is_staging: Indicates if the staging slot should be used, instead
     of the Production one.
    :type is_staging: bool
    :param endpoint_url: The Runtime endpoint URL for this model version.
    :type endpoint_url: str
    :param region: The target region that the application is published to.
    :type region: str
    :param assigned_endpoint_key: The endpoint key.
    :type assigned_endpoint_key: str
    :param endpoint_region: The endpoint's region.
    :type endpoint_region: str
    :param failed_regions: Regions where publishing failed.
    :type failed_regions: str
    :param published_date_time: Timestamp when was last published.
    :type published_date_time: str
    """

    _attribute_map = {
        'version_id': {'key': 'versionId', 'type': 'str'},
        'is_staging': {'key': 'isStaging', 'type': 'bool'},
        'endpoint_url': {'key': 'endpointUrl', 'type': 'str'},
        'region': {'key': 'region', 'type': 'str'},
        'assigned_endpoint_key': {'key': 'assignedEndpointKey', 'type': 'str'},
        'endpoint_region': {'key': 'endpointRegion', 'type': 'str'},
        'failed_regions': {'key': 'failedRegions', 'type': 'str'},
        'published_date_time': {'key': 'publishedDateTime', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProductionOrStagingEndpointInfo, self).__init__(**kwargs)


class PublishSettings(Model):
    """The application publish settings.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The application ID.
    :type id: str
    :param is_sentiment_analysis_enabled: Required. Setting sentiment analysis
     as true returns the sentiment of the input utterance along with the
     response
    :type is_sentiment_analysis_enabled: bool
    :param is_speech_enabled: Required. Enables speech priming in your app
    :type is_speech_enabled: bool
    :param is_spell_checker_enabled: Required. Enables spell checking of the
     utterance.
    :type is_spell_checker_enabled: bool
    """

    _validation = {
        'id': {'required': True},
        'is_sentiment_analysis_enabled': {'required': True},
        'is_speech_enabled': {'required': True},
        'is_spell_checker_enabled': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'is_sentiment_analysis_enabled': {'key': 'sentimentAnalysis', 'type': 'bool'},
        'is_speech_enabled': {'key': 'speech', 'type': 'bool'},
        'is_spell_checker_enabled': {'key': 'spellChecker', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(PublishSettings, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.is_sentiment_analysis_enabled = kwargs.get('is_sentiment_analysis_enabled', None)
        self.is_speech_enabled = kwargs.get('is_speech_enabled', None)
        self.is_spell_checker_enabled = kwargs.get('is_spell_checker_enabled', None)


class PublishSettingUpdateObject(Model):
    """Object model for updating an application's publish settings.

    :param sentiment_analysis: Setting sentiment analysis as true returns the
     Sentiment of the input utterance along with the response
    :type sentiment_analysis: bool
    :param speech: Setting speech as public enables speech priming in your app
    :type speech: bool
    :param spell_checker: Setting spell checker as public enables spell
     checking the input utterance.
    :type spell_checker: bool
    """

    _attribute_map = {
        'sentiment_analysis': {'key': 'sentimentAnalysis', 'type': 'bool'},
        'speech': {'key': 'speech', 'type': 'bool'},
        'spell_checker': {'key': 'spellChecker', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(PublishSettingUpdateObject, self).__init__(**kwargs)
        self.sentiment_analysis = kwargs.get('sentiment_analysis', None)
        self.speech = kwargs.get('speech', None)
        self.spell_checker = kwargs.get('spell_checker', None)


class RegexEntity(Model):
    """Regular Expression Entity Extractor.

    :param name:
    :type name: str
    :param regex_pattern:
    :type regex_pattern: str
    :param roles:
    :type roles: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'regex_pattern': {'key': 'regexPattern', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(RegexEntity, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.regex_pattern = kwargs.get('regex_pattern', None)
        self.roles = kwargs.get('roles', None)


class RegexEntityExtractor(Model):
    """Regular Expression Entity Extractor.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the Entity Model.
    :type id: str
    :param name: Name of the Entity Model.
    :type name: str
    :param type_id: The type ID of the Entity Model.
    :type type_id: int
    :param readable_type: Required. Possible values include: 'Entity
     Extractor', 'Child Entity Extractor', 'Hierarchical Entity Extractor',
     'Hierarchical Child Entity Extractor', 'Composite Entity Extractor', 'List
     Entity Extractor', 'Prebuilt Entity Extractor', 'Intent Classifier',
     'Pattern.Any Entity Extractor', 'Closed List Entity Extractor', 'Regex
     Entity Extractor'
    :type readable_type: str or
     ~azure.cognitiveservices.language.luis.authoring.models.enum
    :param roles:
    :type roles:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityRole]
    :param regex_pattern: The Regular Expression entity pattern.
    :type regex_pattern: str
    """

    _validation = {
        'id': {'required': True},
        'readable_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type_id': {'key': 'typeId', 'type': 'int'},
        'readable_type': {'key': 'readableType', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[EntityRole]'},
        'regex_pattern': {'key': 'regexPattern', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RegexEntityExtractor, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type_id = kwargs.get('type_id', None)
        self.readable_type = kwargs.get('readable_type', None)
        self.roles = kwargs.get('roles', None)
        self.regex_pattern = kwargs.get('regex_pattern', None)


class RegexModelCreateObject(Model):
    """Model object for creating a regular expression entity model.

    :param regex_pattern: The regular expression entity pattern.
    :type regex_pattern: str
    :param name: The model name.
    :type name: str
    """

    _attribute_map = {
        'regex_pattern': {'key': 'regexPattern', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RegexModelCreateObject, self).__init__(**kwargs)
        self.regex_pattern = kwargs.get('regex_pattern', None)
        self.name = kwargs.get('name', None)


class RegexModelUpdateObject(Model):
    """Model object for updating a regular expression entity model.

    :param regex_pattern: The regular expression entity pattern.
    :type regex_pattern: str
    :param name: The model name.
    :type name: str
    """

    _attribute_map = {
        'regex_pattern': {'key': 'regexPattern', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RegexModelUpdateObject, self).__init__(**kwargs)
        self.regex_pattern = kwargs.get('regex_pattern', None)
        self.name = kwargs.get('name', None)


class SubClosedList(Model):
    """Sublist of items for a list entity.

    :param canonical_form: The standard form that the list represents.
    :type canonical_form: str
    :param list: List of synonym words.
    :type list: list[str]
    """

    _attribute_map = {
        'canonical_form': {'key': 'canonicalForm', 'type': 'str'},
        'list': {'key': 'list', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(SubClosedList, self).__init__(**kwargs)
        self.canonical_form = kwargs.get('canonical_form', None)
        self.list = kwargs.get('list', None)


class SubClosedListResponse(SubClosedList):
    """Sublist of items for a list entity.

    :param canonical_form: The standard form that the list represents.
    :type canonical_form: str
    :param list: List of synonym words.
    :type list: list[str]
    :param id: The sublist ID
    :type id: int
    """

    _attribute_map = {
        'canonical_form': {'key': 'canonicalForm', 'type': 'str'},
        'list': {'key': 'list', 'type': '[str]'},
        'id': {'key': 'id', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(SubClosedListResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class TaskUpdateObject(Model):
    """Object model for cloning an application's version.

    :param version: The new version for the cloned model.
    :type version: str
    """

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TaskUpdateObject, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)


class UserAccessList(Model):
    """List of user permissions.

    :param owner: The email address of owner of the application.
    :type owner: str
    :param emails:
    :type emails: list[str]
    """

    _attribute_map = {
        'owner': {'key': 'owner', 'type': 'str'},
        'emails': {'key': 'emails', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(UserAccessList, self).__init__(**kwargs)
        self.owner = kwargs.get('owner', None)
        self.emails = kwargs.get('emails', None)


class UserCollaborator(Model):
    """UserCollaborator.

    :param email: The email address of the user.
    :type email: str
    """

    _attribute_map = {
        'email': {'key': 'email', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UserCollaborator, self).__init__(**kwargs)
        self.email = kwargs.get('email', None)


class VersionInfo(Model):
    """Object model of an application version.

    All required parameters must be populated in order to send to Azure.

    :param version: Required. The version ID. E.g.: "0.1"
    :type version: str
    :param created_date_time: The version's creation timestamp.
    :type created_date_time: datetime
    :param last_modified_date_time: Timestamp of the last update.
    :type last_modified_date_time: datetime
    :param last_trained_date_time: Timestamp of the last time the model was
     trained.
    :type last_trained_date_time: datetime
    :param last_published_date_time: Timestamp when was last published.
    :type last_published_date_time: datetime
    :param endpoint_url: The Runtime endpoint URL for this model version.
    :type endpoint_url: str
    :param assigned_endpoint_key: The endpoint key.
    :type assigned_endpoint_key: dict[str, str]
    :param external_api_keys: External keys.
    :type external_api_keys: object
    :param intents_count: Number of intents in this model.
    :type intents_count: int
    :param entities_count: Number of entities in this model.
    :type entities_count: int
    :param endpoint_hits_count: Number of calls made to this endpoint.
    :type endpoint_hits_count: int
    :param training_status: Required. The current training status. Possible
     values include: 'NeedsTraining', 'InProgress', 'Trained'
    :type training_status: str or
     ~azure.cognitiveservices.language.luis.authoring.models.TrainingStatus
    """

    _validation = {
        'version': {'required': True},
        'training_status': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_modified_date_time': {'key': 'lastModifiedDateTime', 'type': 'iso-8601'},
        'last_trained_date_time': {'key': 'lastTrainedDateTime', 'type': 'iso-8601'},
        'last_published_date_time': {'key': 'lastPublishedDateTime', 'type': 'iso-8601'},
        'endpoint_url': {'key': 'endpointUrl', 'type': 'str'},
        'assigned_endpoint_key': {'key': 'assignedEndpointKey', 'type': '{str}'},
        'external_api_keys': {'key': 'externalApiKeys', 'type': 'object'},
        'intents_count': {'key': 'intentsCount', 'type': 'int'},
        'entities_count': {'key': 'entitiesCount', 'type': 'int'},
        'endpoint_hits_count': {'key': 'endpointHitsCount', 'type': 'int'},
        'training_status': {'key': 'trainingStatus', 'type': 'TrainingStatus'},
    }

    def __init__(self, **kwargs):
        super(VersionInfo, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)
        self.created_date_time = kwargs.get('created_date_time', None)
        self.last_modified_date_time = kwargs.get('last_modified_date_time', None)
        self.last_trained_date_time = kwargs.get('last_trained_date_time', None)
        self.last_published_date_time = kwargs.get('last_published_date_time', None)
        self.endpoint_url = kwargs.get('endpoint_url', None)
        self.assigned_endpoint_key = kwargs.get('assigned_endpoint_key', None)
        self.external_api_keys = kwargs.get('external_api_keys', None)
        self.intents_count = kwargs.get('intents_count', None)
        self.entities_count = kwargs.get('entities_count', None)
        self.endpoint_hits_count = kwargs.get('endpoint_hits_count', None)
        self.training_status = kwargs.get('training_status', None)


class WordListBaseUpdateObject(Model):
    """Object model for updating one of the list entity's sublists.

    :param canonical_form: The standard form that the list represents.
    :type canonical_form: str
    :param list: List of synonym words.
    :type list: list[str]
    """

    _attribute_map = {
        'canonical_form': {'key': 'canonicalForm', 'type': 'str'},
        'list': {'key': 'list', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(WordListBaseUpdateObject, self).__init__(**kwargs)
        self.canonical_form = kwargs.get('canonical_form', None)
        self.list = kwargs.get('list', None)


class WordListObject(Model):
    """Sublist of items for a list entity.

    :param canonical_form: The standard form that the list represents.
    :type canonical_form: str
    :param list: List of synonym words.
    :type list: list[str]
    """

    _attribute_map = {
        'canonical_form': {'key': 'canonicalForm', 'type': 'str'},
        'list': {'key': 'list', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(WordListObject, self).__init__(**kwargs)
        self.canonical_form = kwargs.get('canonical_form', None)
        self.list = kwargs.get('list', None)
