# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ClusterUpgradeDeltaHealthPolicy(Model):
    """Delta health policy for the cluster.

    :param max_percent_delta_unhealthy_nodes: Additional unhealthy nodes
     percentage
    :type max_percent_delta_unhealthy_nodes: int
    :param max_percent_upgrade_domain_delta_unhealthy_nodes: Additional
     unhealthy nodes percentage per upgrade domain
    :type max_percent_upgrade_domain_delta_unhealthy_nodes: int
    :param max_percent_delta_unhealthy_applications: Additional unhealthy
     applications percentage
    :type max_percent_delta_unhealthy_applications: int
    """

    _validation = {
        'max_percent_delta_unhealthy_nodes': {'required': True, 'maximum': 100, 'minimum': 0},
        'max_percent_upgrade_domain_delta_unhealthy_nodes': {'required': True, 'maximum': 100, 'minimum': 0},
        'max_percent_delta_unhealthy_applications': {'required': True, 'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'max_percent_delta_unhealthy_nodes': {'key': 'maxPercentDeltaUnhealthyNodes', 'type': 'int'},
        'max_percent_upgrade_domain_delta_unhealthy_nodes': {'key': 'maxPercentUpgradeDomainDeltaUnhealthyNodes', 'type': 'int'},
        'max_percent_delta_unhealthy_applications': {'key': 'maxPercentDeltaUnhealthyApplications', 'type': 'int'},
    }

    def __init__(self, max_percent_delta_unhealthy_nodes, max_percent_upgrade_domain_delta_unhealthy_nodes, max_percent_delta_unhealthy_applications):
        self.max_percent_delta_unhealthy_nodes = max_percent_delta_unhealthy_nodes
        self.max_percent_upgrade_domain_delta_unhealthy_nodes = max_percent_upgrade_domain_delta_unhealthy_nodes
        self.max_percent_delta_unhealthy_applications = max_percent_delta_unhealthy_applications
