"""Test code generation command."""
import os
import sys
import textwrap

from pytest_bdd.scripts import main

PATH = os.path.dirname(__file__)


def test_generate(monkeypatch, capsys):
    """Test if the code is generated by a given feature."""
    monkeypatch.setattr(sys, 'argv', ['', 'generate', os.path.join(PATH, 'generate.feature')])
    main()
    out, err = capsys.readouterr()
    assert out == textwrap.dedent('''
    # coding=utf-8
    """Code generation feature tests."""

    from pytest_bdd import (
        given,
        scenario,
        then,
        when,
    )


    @scenario('scripts/generate.feature', 'Given and when using the same fixture should not evaluate it twice')
    def test_given_and_when_using_the_same_fixture_should_not_evaluate_it_twice():
        """Given and when using the same fixture should not evaluate it twice."""


    @given('1 have a fixture (appends 1 to a list) in reuse syntax')
    def have_a_fixture_appends_1_to_a_list_in_reuse_syntax():
        """1 have a fixture (appends 1 to a list) in reuse syntax."""


    @given('I have an empty list')
    def i_have_an_empty_list():
        """I have an empty list."""


    @when('I use this fixture')
    def i_use_this_fixture():
        """I use this fixture."""


    @then('my list should be [1]')
    def my_list_should_be_1():
        """my list should be [1]."""

    '''[1:].replace(u"'", u"'"))
