'''OpenGL extension QCOM.texture_foveated2

This module customises the behaviour of the 
OpenGL.raw.GLES2.QCOM.texture_foveated2 to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds a new texture parameter that specifies a pixel density
	below which rendering can be discarded during foveated rendering.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/QCOM/texture_foveated2.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.QCOM.texture_foveated2 import *
from OpenGL.raw.GLES2.QCOM.texture_foveated2 import _EXTENSION_NAME

def glInitTextureFoveated2QCOM():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION