/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.info.MethodOptimizationInfo;

public class CatchExceptionMarker
extends SimplifiedVisitor
implements AttributeVisitor {
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (codeAttribute.u2exceptionTableLength > 0) {
            CatchExceptionMarker.markCatchException(method);
        }
    }

    private static void markCatchException(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.setCatchesExceptions();
        }
    }

    public static boolean catchesExceptions(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return methodOptimizationInfo == null || methodOptimizationInfo.catchesExceptions();
    }
}

