# Getting Help

If you need help or troubleshooting tips or just have a question:

* If applicable, go through our [debugging guide](https://github.com/polybar/polybar/wiki/Debugging-your-Config).
* Read the [Known Issues page](https://github.com/polybar/polybar/wiki/Known-Issues), maybe others had the same issue before.
* Read the [Wiki page](https://github.com/polybar/polybar/wiki) for the thing you have problems with.
* Ask your question on [GitHub Discussions](https://github.com/polybar/polybar/discussions)
* Join our Gitter room at [`gitter.im/polybar/polybar`](https://gitter.im/polybar/polybar)
* Ask in our reddit community at [`r/polybar`](https://www.reddit.com/r/polybar)
* Join the official IRC channel `#polybar` on the [`irc.libera.chat:6697`](https://libera.chat/) network. This is IRC, you will need to be connected to receive answers.
* Ask on [Unix & Linux StackExchange](https://unix.stackexchange.com/). Though not all questions may be suited over there, make sure you're [on topic](https://unix.stackexchange.com/help/on-topic).

**Do not** use the GitHub issue tracker to ask for help or if you have questions, it is meant for bug reports.
Issues will be closed and you will be referred to the above resources.

## Asking Quality Questions

Spending some time to precisely frame your question will save a lot of time.
You will better understand your problem and may be able to solve it yourself
and other will be able to better understand what you are asking.
Here are some tips:

* Be explicit and precise:
  * What are you trying to achieve?
  * What problems have you encountered while trying to achieve this?
  * What is stopping you from overcoming these problems?
* If a problem is difficult to describe, screenshots can help. Do not make
  screenshots of your config file or error messages, copy-paste them as text.
* Provide as much context as possible. In most cases this includes at least the following:
  * Window Manager
  * Polybar version
  * Relevant portions of your config file. If you are not sure what is relevant, provide the whole thing.
  * How you start polybar
