/*
 * window_main_cat.h
 * Copyright (C) Martin Singer 2009-2013 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PDFCHAIN_WINDOW_MAIN_CAT_H__
#define __PDFCHAIN_WINDOW_MAIN_CAT_H__

#include "pdfchain.h"
#include "store.h"
#include "store_cat.h"


/*** Combobox : Output ID *****************************************************/

class
cCBox_OutputId : public Gtk::ComboBox
{
	friend class cSection_Cat;

	public:
		         cCBox_OutputId();
		virtual ~cCBox_OutputId();
		
		void clear();
		
	protected:

		guchar vOutputId;
		
		Glib::RefPtr<cLStore_OutputId> rLStore;
		Gtk::CellRendererText          mCRText;
		cTMCRecord_Selection*          pTMCRecord;
		
		void onFileNumber_changed( guint );
};



/*** Tree View : Cat **********************************************************/

class cTView_Cat : public Gtk::TreeView
{
	friend class cToolbar_Cat;
	friend class cSection_Cat;
	
	public:
		         cTView_Cat( Gtk::Window& );
		virtual ~cTView_Cat();

		void clear();

	protected:

		Glib::RefPtr<cLStore_Cat>      rLStore_Cat;
		Glib::RefPtr<cLStore_EvenOdd>  rLStore_EvenOdd;
		Glib::RefPtr<cLStore_Rotation> rLStore_Rotation;

		cTMCRecord_Cat* pTMCRecord_Cat;

		Gtk::TreeViewColumn		mTVColumn_Add,
								mTVColumn_Pages,
								mTVColumn_Rotation,
								mTVColumn_SourceFile,
								mTVColumn_SourcePath,
								mTVColumn_Password,
								mTVColumn_PageNumbers;
		
		Gtk::CellRendererToggle	mCRToggle_Add;
		Gtk::CellRendererCombo	mCRCombo_EvenOdd,
								mCRCombo_Rotation;
		Gtk::CellRendererText	mCRText_Pages,
								mCRText_SourceFile,
								mCRText_SourcePath,
								mCRText_Password,
								mCRText_PageNumbers;
#ifdef PDFCHAIN_TEMP
		Gtk::TreeViewColumn		mTVColumn_Id,					//TEMP
								mTVColumn_Tooltip,				//TEMP
								mTVColumn_Commands,				//TEMP
								mTVColumn_Colors;				//TEMP

		Gtk::CellRendererText	mCRText_Id,						//TEMP
								mCRText_Tooltip,				//TEMP
								mCRText_Cmd_Handle,				//TEMP
								mCRText_Cmd_EvenOdd,			//TEMP
								mCRText_Cmd_Rotation;			//TEMP
		Gtk::CellRendererPixbuf	mCRPixbuf_Color_Pages,			//TEMP
								mCRPixbuf_Color_PageNumbers;	//TEMP
#endif

		void onCRToggle_Add_toggled( const Glib::ustring& str_path ) {
			rLStore_Cat->toggleAdd( Gtk::TreePath( str_path ) );
			return;
		}
		
		void onCRText_Pages_edited(
			const Glib::ustring& str_path ,
			const Glib::ustring& str_pages )
		{
			rLStore_Cat->editPages( Gtk::TreePath( str_path ) , str_pages );
			return;
		}
		
		void onCRCombo_EvenOdd_changed(
			const Glib::ustring& str_path ,
			const Gtk::TreeModel::iterator& iter_combo )
		{
			cTMCRecord_Selection* pt_record = rLStore_EvenOdd->getTMCRecord();
			rLStore_Cat->changeEvenOdd( Gtk::TreePath( str_path ) ,
				static_cast<Glib::ustring>( (*iter_combo)[pt_record->mTMColumn_Label] ) ,
				static_cast<Glib::ustring>( (*iter_combo)[pt_record->mTMColumn_Command] ) );
			return;
		}
		
		void onCRCombo_Rotation_changed(
			const Glib::ustring& str_path ,
			const Gtk::TreeModel::iterator& iter_combo )
		{
			cTMCRecord_Selection* pt_record = rLStore_Rotation->getTMCRecord();
			rLStore_Cat->changeRotation( Gtk::TreePath( str_path ),
				static_cast<Glib::ustring>( (*iter_combo)[pt_record->mTMColumn_Label] ) ,
				static_cast<Glib::ustring>( (*iter_combo)[pt_record->mTMColumn_Command] ) );
			return;
		}
		
		void onCRText_Password_edited(
			const Glib::ustring& str_path ,
			const Glib::ustring& str_password )
		{
			rLStore_Cat->editPassword( Gtk::TreePath( str_path ) , str_password );
			return;
		}

		void onToolButton_Up_clicked() {
			rLStore_Cat->moveRowsUp( get_selection() );	
			return;
		}
		
		void onToolButton_Down_clicked() {
			rLStore_Cat->moveRowsDown( get_selection() );
			return;
		}
		
		void onToolButton_Add_clicked() {
			rLStore_Cat->addRows( get_selection() );
			return;
		}
		
		void onToolButton_Remove_clicked() {
			rLStore_Cat->removeRows( get_selection() );
			return;
		}
		
		void onToolButton_Copy_clicked() {
			rLStore_Cat->copyRows( get_selection() );
			return;
		}
};



/*** Toolbar : Cat ************************************************************/

class
cToolbar_Cat : public Gtk::Toolbar
{
	friend class cSection_Cat;

	public:
		         cToolbar_Cat( cTView_Cat* );
		virtual ~cToolbar_Cat();
		
		void clear();

	protected:

		cCBox_OutputId         mCBox_OutputId;
		Gtk::ToolButton        mToolButton_Add,
		                       mToolButton_Remove,
		                       mToolButton_Copy,
		                       mToolButton_Up,
		                       mToolButton_Down;
		Gtk::ToggleToolButton  mTToolButton_Shuffle;
		Gtk::ToolItem          mToolItem_OutputId;
		Gtk::SeparatorToolItem mSeparator_A,
		                       mSeparator_B,
		                       mSeparator_C;
};



/*** Section : Cat ************************************************************/

class
cSection_Cat : public Gtk::VBox
{
	public:
		         cSection_Cat( Gtk::Window& );
		virtual ~cSection_Cat();

		void clear();
		std::string createCommand();

	protected:

		Gtk::ScrolledWindow  mSWindow;
		cTView_Cat   mTView;
		cToolbar_Cat mToolbar;
		cFCDialog_SaveAs_Pdf mFCDialog_SaveAs;
		
		//void init();
};

#endif

